/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.script.IInsertionRule;
import com.sonicsw.xqimpl.script.IVariableValue;
import com.sonicsw.xqimpl.script.InsertionHelper;
import com.sonicsw.xqimpl.script.Namespaces;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.ScriptObject;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.script.Variable;
import com.sonicsw.xqimpl.script.VariableDirection;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.util.xml.Namespace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class InsertionRules {
    private static final short INSERT_MESSAGE_PART = 0;
    private static final short REPLACE_MESSAGE_PART = 1;
    private static final short INSERT_LAST_CHILD = 2;
    private static final short ASSIGN_VALUE = 3;
    private static final short INSERT_ELEMENT = 4;
    private List m_insertList = new ArrayList();
    private Namespaces m_namespaces = null;
    private ScriptObject m_script = null;
    private static XQLog log = XQLogImpl.getCategoryLog((int)64);

    public InsertionRules(ScriptObject script, Namespaces nspaces, Element rulesElement) throws ScriptEngineException {
        this.m_script = script;
        this.m_namespaces = nspaces;
        this.deserializeInsertionRules(rulesElement);
    }

    private void deserializeInsertionRules(Element rulesElement) throws ScriptEngineException {
        NodeList tempNl = rulesElement.getChildNodes();
        for (int i = 0; i < tempNl.getLength(); ++i) {
            Node n = tempNl.item(i);
            if (!(n instanceof Element) || !n.getLocalName().equals("insertionRule")) continue;
            Element insertionRuleElement = (Element)n;
            Element variableNameElement = DOMUtils.getImmediateChildElementByName((Element)insertionRuleElement, (String)"variablename");
            if (variableNameElement == null) {
                throw new ScriptEngineException("insertionrule-variable-name-element-not-found", 1);
            }
            Text variableNameText = DOMUtils.getFirstTextChild((Element)variableNameElement);
            if (variableNameText == null) {
                throw new ScriptEngineException("insertionrule-variable-name-text-not-found", 1);
            }
            String variableName = variableNameText.getData().trim();
            IInsertionRule rule = this.createRule(insertionRuleElement, variableName);
            if (rule == null) continue;
            this.m_insertList.add(rule);
        }
    }

    public void insertVariables(Map variableMap, XQMessage msg) throws ScriptEngineException, XQMessageException {
        for (IInsertionRule rule : this.m_insertList) {
            IVariableValue value = (IVariableValue)variableMap.get(rule.getVariableName());
            if (value == null) {
                throw new ScriptEngineException("output-variable-not-found", new Object[]{rule.getVariableName()}, 1);
            }
            rule.insert(msg, value);
        }
    }

    public boolean hasInsertionRules() {
        return this.m_insertList.size() > 0;
    }

    void validateVariables(Map scriptVariables) throws ScriptEngineException {
        for (IInsertionRule rule : this.m_insertList) {
            String variableName = rule.getVariableName();
            Variable v = (Variable)scriptVariables.get(variableName);
            if (v == null) {
                throw new ScriptEngineException("variable-undefined", new Object[]{variableName}, 1);
            }
            if (v.getDirection() == VariableDirection.OUT) continue;
            throw new ScriptEngineException("insertion-rule-for-out-variable", 1);
        }
    }

    private IInsertionRule createRule(Element e, String variableName) throws ScriptEngineException {
        int type = 0;
        Element insertRuleCommand = DOMUtils.getImmediateChildElementByName((Element)e, (String)"insertMessagePart");
        type = 0;
        if (insertRuleCommand == null) {
            insertRuleCommand = DOMUtils.getImmediateChildElementByName((Element)e, (String)"insertLastChild");
            type = 2;
            if (insertRuleCommand == null) {
                insertRuleCommand = DOMUtils.getImmediateChildElementByName((Element)e, (String)"replaceMessagePart");
                type = 1;
                if (insertRuleCommand == null) {
                    insertRuleCommand = DOMUtils.getImmediateChildElementByName((Element)e, (String)"assignValue");
                    type = 3;
                    if (insertRuleCommand == null) {
                        insertRuleCommand = DOMUtils.getImmediateChildElementByName((Element)e, (String)"insertElement");
                        type = 4;
                        if (insertRuleCommand == null) {
                            throw new ScriptEngineException("invalid-insertion-rule", 1);
                        }
                    }
                }
            }
        }
        IInsertionRule rule = null;
        switch (type) {
            case 0: {
                rule = this.createInsertMessagePartRule(insertRuleCommand, variableName);
                break;
            }
            case 1: {
                rule = this.createReplaceMessagePartRule(insertRuleCommand, variableName);
                break;
            }
            case 2: {
                rule = this.createInsertLastChildRule(insertRuleCommand, variableName);
                break;
            }
            case 3: {
                rule = this.createAssignValueRule(insertRuleCommand, variableName);
                break;
            }
            case 4: {
                rule = this.createInsertElementRule(insertRuleCommand, variableName);
            }
        }
        return rule;
    }

    private IInsertionRule createInsertElementRule(Element ruleElem, String variableName) throws ScriptEngineException {
        Element elemElem;
        Element targetElem = DOMUtils.getImmediateChildElementByName((Element)ruleElem, (String)"target");
        if (targetElem == null) {
            throw new ScriptEngineException("no-target-for-insert-last-child", 1);
        }
        String xpathExpr = DOMUtils.getFirstTextValueOfImmediateChild((Element)targetElem, (String)"xpath");
        if (xpathExpr != null) {
            xpathExpr = xpathExpr.trim();
        }
        if ((elemElem = DOMUtils.getImmediateChildElementByName((Element)targetElem, (String)"elem")) == null) {
            throw new ScriptEngineException("insertionrule-elem-tag-not-found", 1);
        }
        Text elemElemValue = DOMUtils.getFirstTextChild((Element)elemElem);
        if (elemElemValue == null) {
            throw new ScriptEngineException("insertionrule-elem-value-not-found", 1);
        }
        String elementName = elemElemValue.getData().trim();
        String removeAttr = elemElem.getAttribute("remove");
        Map vars = this.m_script.getVariableMap();
        Variable var = (Variable)vars.get(variableName);
        if (var == null) {
            throw new ScriptEngineException("variable-undefined", new Object[]{variableName}, 1);
        }
        if (var.isDocument()) {
            throw new ScriptEngineException("document-variable-insert-element", 1);
        }
        String index = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElem, (String)"messagePartIndex");
        if (index != null) {
            index = index.trim();
        }
        String contentID = null;
        if (index == null) {
            contentID = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElem, (String)"messageContentId");
            if (contentID == null) {
                String header = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElem, (String)"messageHeaderProperty");
                if (header == null) {
                    throw new ScriptEngineException("no-insert-element-criteria", 1);
                }
                return new InsertElementRule(variableName, header, xpathExpr, elementName, !"".equals(removeAttr), this.m_namespaces, true);
            }
            contentID = contentID.trim();
            return new InsertElementRule(variableName, contentID, xpathExpr, elementName, !"".equals(removeAttr), this.m_namespaces, false);
        }
        return new InsertElementRule(variableName, Integer.parseInt(index), xpathExpr, elementName, Boolean.valueOf(removeAttr), this.m_namespaces);
    }

    private IInsertionRule createInsertMessagePartRule(Element ruleElm, String variableName) throws ScriptEngineException {
        String contentType;
        String index = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElm, (String)"messagePartIndex");
        if (index == null) {
            throw new ScriptEngineException("no-index-on-insert-message-part", 1);
        }
        index = index.trim();
        String contentID = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElm, (String)"messageContentId");
        if (contentID != null) {
            contentID = contentID.trim();
        }
        if ((contentType = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElm, (String)"messageContentType")) != null) {
            contentType = contentType.trim();
        }
        return new InsertMessagePartRule(variableName, Integer.parseInt(index), contentID, contentType);
    }

    private IInsertionRule createReplaceMessagePartRule(Element ruleElm, String variableName) throws ScriptEngineException {
        String index = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElm, (String)"messagePartIndex");
        if (index != null) {
            index = index.trim();
        }
        String contentType = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElm, (String)"messageContentType");
        String contentID = null;
        if (index == null) {
            contentID = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElm, (String)"messageContentId");
            if (contentID == null) {
                throw new ScriptEngineException("no-criteria-on-replace-message-part", 1);
            }
            return new ReplaceMessagePartRule(variableName, contentID, contentType);
        }
        return new ReplaceMessagePartRule(variableName, Integer.parseInt(index), contentType);
    }

    private IInsertionRule createInsertLastChildRule(Element ruleElem, String variableName) throws ScriptEngineException {
        Map vars;
        Variable var;
        Element targetElem = DOMUtils.getImmediateChildElementByName((Element)ruleElem, (String)"target");
        if (targetElem == null) {
            throw new ScriptEngineException("no-target-for-insert-last-child", 1);
        }
        String xpathExpr = DOMUtils.getFirstTextValueOfImmediateChild((Element)targetElem, (String)"xpath");
        if (xpathExpr != null) {
            xpathExpr = xpathExpr.trim();
        }
        Element elemElem = DOMUtils.getImmediateChildElementByName((Element)targetElem, (String)"elem");
        String elementName = null;
        boolean bRemove = false;
        if (elemElem != null) {
            elementName = DOMUtils.getFirstTextChild((Element)elemElem).getData().trim();
            String removeAttr = elemElem.getAttribute("remove");
            bRemove = Boolean.valueOf(removeAttr);
        }
        if ((var = (Variable)(vars = this.m_script.getVariableMap()).get(variableName)) == null) {
            throw new ScriptEngineException("variable-undefined", new Object[]{variableName}, 1);
        }
        if (!var.isDocument()) {
            throw new ScriptEngineException("value-variable-insert-last-child-invalid", 1);
        }
        String index = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElem, (String)"messagePartIndex");
        if (index != null) {
            index = index.trim();
        }
        String contentID = null;
        if (index == null) {
            contentID = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElem, (String)"messageContentId");
            if (contentID == null) {
                String header = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElem, (String)"messageHeaderProperty");
                if (header == null) {
                    throw new ScriptEngineException("no-insert-last-child-criteria", 1);
                }
                return new InsertLastChildRule(variableName, header, xpathExpr, elementName, bRemove, this.m_namespaces, true);
            }
            contentID = contentID.trim();
            return new InsertLastChildRule(variableName, contentID, xpathExpr, elementName, bRemove, this.m_namespaces, false);
        }
        return new InsertLastChildRule(variableName, Integer.parseInt(index), xpathExpr, elementName, bRemove, this.m_namespaces);
    }

    private IInsertionRule createAssignValueRule(Element ruleElem, String variableName) throws ScriptEngineException {
        boolean isForMsgPart = false;
        Element parentElem = null;
        Element msgPartElem = DOMUtils.getImmediateChildElementByName((Element)ruleElem, (String)"messagePart");
        if (msgPartElem != null) {
            isForMsgPart = true;
            parentElem = msgPartElem;
        } else {
            Element msgHeaderElem = DOMUtils.getImmediateChildElementByName((Element)ruleElem, (String)"messageHeaderProperty");
            if (msgHeaderElem != null) {
                isForMsgPart = false;
                parentElem = msgHeaderElem;
            } else {
                throw new ScriptEngineException("insertionrule-unknown-assign-value-type", 1);
            }
        }
        AssignValueTargetInfo avi = this.getTargetInfo(parentElem);
        if (avi == null && isForMsgPart) {
            throw new ScriptEngineException("no-target-for-assign-value", 1);
        }
        Map vars = this.m_script.getVariableMap();
        Variable var = (Variable)vars.get(variableName);
        if (var == null) {
            throw new ScriptEngineException("variable-undefined", new Object[]{variableName}, 1);
        }
        if (isForMsgPart) {
            String index = DOMUtils.getFirstTextValueOfImmediateChild((Element)msgPartElem, (String)"messagePartIndex");
            if (index != null) {
                index = index.trim();
            }
            String contentID = null;
            if (index == null) {
                contentID = DOMUtils.getFirstTextValueOfImmediateChild((Element)msgPartElem, (String)"messageContentId");
                if (contentID != null) {
                    contentID = contentID.trim();
                }
                if (contentID == null) {
                    throw new ScriptEngineException("no-criteria-on-assign-value", 1);
                }
                return new AssignValueToXMLRule(contentID, avi.m_xpath, avi.m_name, variableName, this.m_namespaces, false);
            }
            return new AssignValueToXMLRule(Integer.parseInt(index), avi.m_xpath, avi.m_name, variableName, this.m_namespaces);
        }
        String headerPropName = DOMUtils.getFirstTextValueOfImmediateChild((Element)ruleElem, (String)"messageHeaderProperty");
        if (headerPropName != null) {
            headerPropName = headerPropName.trim();
        }
        if (avi != null) {
            return new AssignValueToXMLRule(headerPropName, avi.m_xpath, avi.m_name, variableName, this.m_namespaces, true);
        }
        return new AssignValueToPropertyRule(headerPropName, variableName);
    }

    private AssignValueTargetInfo getTargetInfo(Element parentElem) throws ScriptEngineException {
        Element targetElem = DOMUtils.getImmediateChildElementByName((Element)parentElem, (String)"target");
        if (targetElem == null) {
            return null;
        }
        String xpathExpr = DOMUtils.getFirstTextValueOfImmediateChild((Element)targetElem, (String)"xpath");
        if (xpathExpr != null) {
            xpathExpr = xpathExpr.trim();
        }
        String nameAttr = targetElem.getAttribute("name");
        AssignValueTargetInfo avi = new AssignValueTargetInfo();
        avi.m_xpath = xpathExpr;
        avi.m_name = nameAttr;
        return avi;
    }

    private String getXMLFromPart(XQPart part, String target) throws ScriptEngineException {
        if (part == null) {
            throw new ScriptEngineException("insertion-rule-part-not-found", new Object[]{target}, 1);
        }
        if (part.getContentType().equals("application/octet-stream")) {
            throw new ScriptEngineException("insertionrule-binary-part-invalid", 1);
        }
        return part.getContent().toString();
    }

    private String getXMLFromSource(String target, boolean isTargetHeader, XQMessage msg) throws ScriptEngineException {
        try {
            if (!isTargetHeader) {
                XQPart part = msg.getPart(target);
                String xml = this.getXMLFromPart(part, target);
                return xml;
            }
            if (msg.containsHeader(target)) {
                if (Util.isJMSCorrelationID(target)) {
                    return msg.getCorrelationId();
                }
                return msg.getStringHeader(target);
            }
            throw new ScriptEngineException("insertionrule-header-not-found", 1);
        }
        catch (XQMessageException xqme) {
            ScriptEngineException see = new ScriptEngineException(xqme.getMessage(), 1);
            see.setLinkedException(xqme);
            throw see;
        }
    }

    private String getXMLFromSource(int index, XQMessage msg) throws ScriptEngineException {
        try {
            XQPart part = msg.getPart(index);
            String xml = this.getXMLFromPart(part, "" + index);
            return xml;
        }
        catch (XQMessageException xqme) {
            ScriptEngineException see = new ScriptEngineException(xqme.getMessage(), 1);
            see.setLinkedException(xqme);
            throw see;
        }
    }

    private void replaceXML(String value, String target, boolean isTargetHeader, XQMessage msg) throws ScriptEngineException {
        try {
            if (!isTargetHeader) {
                XQPart newPart = msg.createPart((Object)value, "text/xml");
                msg.replacePart(newPart, target);
            } else {
                msg.setHeaderValue(target, (Object)value);
            }
        }
        catch (XQMessageException xqme) {
            ScriptEngineException see = new ScriptEngineException(xqme.getMessage(), 1);
            see.setLinkedException(xqme);
            throw see;
        }
    }

    private void replaceXML(String value, int index, XQMessage msg) throws ScriptEngineException {
        try {
            XQPart newPart = msg.createPart((Object)value, "text/xml");
            msg.replacePart(newPart, index);
        }
        catch (XQMessageException xqme) {
            ScriptEngineException see = new ScriptEngineException(xqme.getMessage(), 1);
            see.setLinkedException(xqme);
            throw see;
        }
    }

    private XQPart createPart(XQMessage msg, IVariableValue variable, String contentType) throws XQMessageException, ScriptEngineException {
        XQPart part = null;
        part = variable.isByteArray() ? msg.createPart((Object)variable.getAsByteArray(), contentType) : msg.createPart((Object)variable.getAsStringIncludeXMLHeader(), contentType);
        return part;
    }

    class ReplaceMessagePartRule
    implements IInsertionRule {
        private int m_index;
        private String m_contentID;
        private String m_contentType;
        private String m_variableName;
        private boolean m_replaceByContentID = false;

        ReplaceMessagePartRule(String variableName, String contentID, String contentType) {
            this.m_contentType = contentType;
            this.m_contentID = contentID;
            this.m_replaceByContentID = true;
            this.m_variableName = variableName;
        }

        @Override
        public String getVariableName() {
            return this.m_variableName;
        }

        ReplaceMessagePartRule(String variableName, int index, String contentType) {
            this.m_index = index;
            this.m_contentType = contentType;
            this.m_replaceByContentID = false;
            this.m_variableName = variableName;
        }

        @Override
        public void insert(XQMessage msg, IVariableValue variable) throws XQMessageException, ScriptEngineException {
            XQPart part = null;
            if (this.m_contentType == null) {
                this.m_contentType = variable.isByteArray() ? "application/octet-stream" : "text/plain";
            }
            part = InsertionRules.this.createPart(msg, variable, this.m_contentType);
            if (this.m_replaceByContentID) {
                log.logDebug("Replacing part at id=" + this.m_contentID);
                part.setContentId(this.m_contentID);
                msg.replacePart(part, this.m_contentID);
            } else {
                log.logDebug("Replacing part at index=" + this.m_index);
                msg.replacePart(part, this.m_index);
            }
        }
    }

    private class InsertMessagePartRule
    implements IInsertionRule {
        private int m_index;
        private String m_contentID;
        private String m_contentType;
        private String m_variableName;

        InsertMessagePartRule(String variableName, int index, String contentID, String contentType) {
            this.m_index = index;
            this.m_contentID = contentID;
            this.m_contentType = contentType;
            this.m_variableName = variableName;
        }

        @Override
        public String getVariableName() {
            return this.m_variableName;
        }

        @Override
        public void insert(XQMessage msg, IVariableValue variable) throws XQMessageException, ScriptEngineException {
            XQPart part = null;
            if (this.m_contentType == null) {
                this.m_contentType = variable.isByteArray() ? "application/octet-stream" : "text/plain";
            }
            part = InsertionRules.this.createPart(msg, variable, this.m_contentType);
            if (this.m_contentID != null) {
                part.setContentId(this.m_contentID);
            }
            log.logDebug("Inserting part at index=" + this.m_index);
            if (this.m_index >= 0) {
                msg.addPartAt(part, this.m_index);
            } else {
                msg.addPart(part);
            }
        }
    }

    private class AssignValueToXMLRule
    implements IInsertionRule {
        private int m_index;
        private String m_target;
        private boolean m_isTargetHeader;
        private String m_xpath;
        private boolean m_useTarget = false;
        private String m_attrName = null;
        private String m_varName = null;
        private Namespaces m_namespaces;

        AssignValueToXMLRule(String target, String xpath, String attrName, String varName, Namespaces nspaces, boolean isTargetHeader) {
            this.m_target = target;
            this.m_attrName = attrName;
            this.m_varName = varName;
            this.m_namespaces = nspaces;
            this.m_xpath = xpath;
            this.m_useTarget = true;
            this.m_isTargetHeader = isTargetHeader;
        }

        AssignValueToXMLRule(int index, String xpath, String attrName, String varName, Namespaces nspaces) {
            this.m_index = index;
            this.m_xpath = xpath;
            this.m_attrName = attrName;
            this.m_varName = varName;
            this.m_useTarget = false;
            this.m_namespaces = nspaces;
        }

        @Override
        public String getVariableName() {
            return this.m_varName;
        }

        @Override
        public void insert(XQMessage msg, IVariableValue variable) throws XQMessageException, ScriptEngineException {
            if (this.m_useTarget) {
                if (!this.m_isTargetHeader) {
                    log.logDebug("Assigning value to part at id=" + this.m_target + ", value=" + variable.toString());
                } else {
                    log.logDebug("Assigning value to part header=" + this.m_target + ", value=" + variable.toString());
                }
            } else {
                log.logDebug("Assigning value to part at index=" + this.m_index + ", value=" + variable.toString());
            }
            String xmlTarget = null;
            xmlTarget = !this.m_useTarget ? InsertionRules.this.getXMLFromSource(this.m_index, msg) : InsertionRules.this.getXMLFromSource(this.m_target, this.m_isTargetHeader, msg);
            try {
                List<Namespace> nspaces = this.m_namespaces == null ? null : this.m_namespaces.getNamespaceList();
                String result = this.m_attrName != "" ? InsertionHelper.setAttribute(xmlTarget, this.m_xpath, this.m_attrName, variable.getAsString(), nspaces) : InsertionHelper.insertTextChild(xmlTarget, this.m_xpath, variable.getAsString(), nspaces);
                if (this.m_useTarget) {
                    InsertionRules.this.replaceXML(result, this.m_target, this.m_isTargetHeader, msg);
                } else {
                    InsertionRules.this.replaceXML(result, this.m_index, msg);
                }
            }
            catch (TransformerException e) {
                throw new XQMessageException((Throwable)e);
            }
        }
    }

    private class AssignValueToPropertyRule
    implements IInsertionRule {
        private String m_propName = null;
        private String m_varName = null;

        AssignValueToPropertyRule(String propName, String varName) {
            this.m_propName = propName;
            this.m_varName = varName;
        }

        @Override
        public void insert(XQMessage msg, IVariableValue variable) throws XQMessageException, ScriptEngineException {
            log.logDebug("Assigning value to property name=" + this.m_propName + ", value=" + variable.toString());
            msg.setHeaderValue(this.m_propName, (Object)variable.getAsStringIncludeXMLHeader());
        }

        @Override
        public String getVariableName() {
            return this.m_varName;
        }
    }

    private class InsertElementRule
    implements IInsertionRule {
        private int m_index;
        private String m_target;
        private boolean m_isTargetHeader;
        private String m_xpath;
        private boolean m_useTarget = false;
        private boolean m_bRemove;
        private String m_varName;
        private String m_elementName;
        private Namespaces m_namespaces;

        InsertElementRule(String varName, String target, String xpath, String elementName, boolean bRemove, Namespaces nspaces, boolean isTargetHeader) {
            this.m_target = target;
            this.m_isTargetHeader = isTargetHeader;
            this.m_xpath = xpath;
            this.m_bRemove = bRemove;
            this.m_useTarget = true;
            this.m_varName = varName;
            this.m_elementName = elementName;
            this.m_namespaces = nspaces;
        }

        InsertElementRule(String varName, int index, String xpath, String elementName, boolean bRemove, Namespaces nspaces) {
            this.m_index = index;
            this.m_xpath = xpath;
            this.m_bRemove = bRemove;
            this.m_varName = varName;
            this.m_elementName = elementName;
            this.m_namespaces = nspaces;
        }

        @Override
        public String getVariableName() {
            return this.m_varName;
        }

        @Override
        public void insert(XQMessage msg, IVariableValue variable) throws XQMessageException, ScriptEngineException {
            if (!this.m_useTarget) {
                log.logDebug("Inserting element at index: " + this.m_index);
            } else if (!this.m_isTargetHeader) {
                log.logDebug("Inserting element at id: " + this.m_target);
            } else {
                log.logDebug("Inserting element in header: " + this.m_target);
            }
            String xmlTarget = null;
            xmlTarget = !this.m_useTarget ? InsertionRules.this.getXMLFromSource(this.m_index, msg) : InsertionRules.this.getXMLFromSource(this.m_target, this.m_isTargetHeader, msg);
            try {
                List<Namespace> nspaces = this.m_namespaces == null ? null : this.m_namespaces.getNamespaceList();
                String result = InsertionHelper.assignChildElement(xmlTarget, this.m_xpath, this.m_elementName, variable.getAsString(), this.m_bRemove, nspaces);
                log.logDebug(result);
                if (this.m_useTarget) {
                    InsertionRules.this.replaceXML(result, this.m_target, this.m_isTargetHeader, msg);
                } else {
                    InsertionRules.this.replaceXML(result, this.m_index, msg);
                }
            }
            catch (TransformerException e) {
                throw new XQMessageException((Throwable)e);
            }
        }
    }

    private class InsertLastChildRule
    implements IInsertionRule {
        private int m_index;
        private String m_target;
        private boolean m_isTargetHeader;
        private String m_xpath;
        private boolean m_useTarget = false;
        private boolean m_bRemove;
        private String m_varName;
        private String m_elementName;
        private Namespaces m_namespaces;

        InsertLastChildRule(String varName, String target, String xpath, String elementName, boolean bRemove, Namespaces nspaces, boolean isTargetHeader) {
            this.m_target = target;
            this.m_xpath = xpath;
            this.m_bRemove = bRemove;
            this.m_useTarget = true;
            this.m_varName = varName;
            this.m_elementName = elementName;
            this.m_namespaces = nspaces;
            this.m_isTargetHeader = isTargetHeader;
        }

        InsertLastChildRule(String varName, int index, String xpath, String elementName, boolean bRemove, Namespaces nspaces) {
            this.m_index = index;
            this.m_xpath = xpath;
            this.m_bRemove = bRemove;
            this.m_varName = varName;
            this.m_elementName = elementName;
            this.m_namespaces = nspaces;
        }

        @Override
        public String getVariableName() {
            return this.m_varName;
        }

        @Override
        public void insert(XQMessage msg, IVariableValue variable) throws XQMessageException, ScriptEngineException {
            if (!this.m_useTarget) {
                log.logDebug("Inserting as last child of part at index: " + this.m_index);
            } else if (!this.m_isTargetHeader) {
                log.logDebug("Inserting as last child of part at id: " + this.m_target);
            } else {
                log.logDebug("Inserting as last child of header: " + this.m_target);
            }
            if (variable.isByteArray()) {
                throw new ScriptEngineException("insertionrule-binary-part-invalid", 1);
            }
            String xmlTarget = null;
            xmlTarget = !this.m_useTarget ? InsertionRules.this.getXMLFromSource(this.m_index, msg) : InsertionRules.this.getXMLFromSource(this.m_target, this.m_isTargetHeader, msg);
            try {
                List<Namespace> nspaces = this.m_namespaces == null ? null : this.m_namespaces.getNamespaceList();
                String variableStr = DOMUtils.stripXmlDeclaration((String)variable.getAsString());
                String result = this.m_bRemove ? InsertionHelper.removeChildrenAndInsert(xmlTarget, this.m_xpath, this.m_elementName, variableStr, nspaces) : InsertionHelper.insertLastChild(xmlTarget, this.m_xpath, variableStr, false, nspaces);
                log.logDebug(result);
                if (this.m_useTarget) {
                    InsertionRules.this.replaceXML(result, this.m_target, this.m_isTargetHeader, msg);
                } else {
                    InsertionRules.this.replaceXML(result, this.m_index, msg);
                }
            }
            catch (TransformerException e) {
                throw new XQMessageException((Throwable)e);
            }
        }
    }

    private class AssignValueTargetInfo {
        String m_xpath;
        String m_name;

        private AssignValueTargetInfo() {
        }
    }
}

