/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xqimpl.config.IXQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.script.ScriptUtil;
import com.sonicsw.xqimpl.service.wsinvk.WSInvocationScriptEngine;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import java.util.Hashtable;

public class WsScriptUtil
extends ScriptUtil {
    public WsScriptUtil(String url, String domain, String username, String password) throws Exception {
        if (TRACE) {
            System.out.println("TRACE(WsScriptUtil): connect to " + domain + " @ " + url + " user=" + username);
        }
        DirectoryServiceProxy ds = this.getDSProxy();
        Hashtable<String, String> inputTable = new Hashtable<String, String>();
        inputTable.put("java.naming.provider.url", url);
        inputTable.put("DOMAIN_NAME", domain);
        inputTable.put("java.naming.security.principal", username);
        inputTable.put("java.naming.security.credentials", password);
        inputTable.put("java.naming.factory.initial", "com.sonicsw.xqimpl.jndi.spi.XQTNSContextFactory");
        XQConfigManager xqmgr = XQConfigManager.getInstance(null);
        XQConnectionConfig xqConnConfig = new XQConnectionConfig((IXQConfigManager)xqmgr);
        xqConnConfig.setConnectionType("JMSType");
        xqConnConfig.setName("InternalStylusWSInvocationScriptEngineJMSConnection");
        XQParametersImpl xqParams = new XQParametersImpl();
        xqParams.setParameter("url", 1, url);
        xqParams.setParameter("user", 1, username);
        xqParams.setParameter("password", 1, password);
        xqParams.setIntParameter("MAX_RECEIVE_SESSIONS_PER_CONNECTION", 1, 0);
        xqParams.setIntParameter("MAX_SESSIONS_BEST_EFFORT_POOL", 1, 3);
        xqParams.setIntParameter("MAX_SESSIONS_AT_LEAST_ONCE_POOL", 1, 3);
        xqParams.setIntParameter("MAX_SESSIONS_AT_LEAST_ONCE_FAST_POOL", 1, 3);
        xqParams.setIntParameter("MAX_SESSIONS_EXACTLY_ONCE_POOL", 1, 3);
        xqConnConfig.setParameters(xqParams);
        this.setEngine(new WSInvocationScriptEngine(inputTable, ds, xqConnConfig));
    }
}

