/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.esb.ws.invocation.ESBWSException;
import com.sonicsw.esb.ws.invocation.ESBWSGenerator;
import com.sonicsw.esb.ws.invocation.ESBWSService;
import com.sonicsw.esb.ws.invocation.ESBWSTypeLibrary;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import com.sonicsw.xqimpl.script.wsdl.TypeHelper;
import com.sonicsw.xqimpl.script.wsdl.WSDLConstants;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.script.wsdl.WSDLServiceHelper;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.util.WSIFUtils;

public class WSDLHelper
implements ESBWSGenerator {
    public static final String DEFAULT_SERVICE_URI = "http://www.sonicxq.com";
    public static final String DEFAULT_SERVICE_LOCALNAME = "ESB-Default";
    public static final QName DEFAULT_SERVICE_QNAME = new QName("http://www.sonicxq.com", "ESB-Default");
    protected Definition m_def = null;
    private HashMap m_serviceMap = null;
    protected String m_wsdlLocation = null;
    private TypeHelper m_typeHelper = null;
    private boolean m_bUsingPolicy = false;
    private HashMap m_prefixToURIMap = null;
    private HashMap m_URItoPrefixMap = null;

    public static ESBWSGenerator createInstance(String wsdlURL) throws WSDLHelperException {
        return new WSDLHelper(wsdlURL);
    }

    public static ESBWSGenerator createInstance(URL wsdlURL) throws WSDLHelperException {
        return new WSDLHelper(wsdlURL.toString());
    }

    public static ESBWSGenerator createInstance(String locationPath, String wsdl) throws WSDLHelperException {
        return new WSDLHelper(locationPath, wsdl);
    }

    public static ESBWSGenerator createInstance(String locationPath, Reader reader) throws WSDLHelperException {
        return new WSDLHelper(locationPath, reader);
    }

    protected WSDLHelper(String wsdlURL) throws WSDLHelperException {
        this.m_wsdlLocation = wsdlURL;
        try {
            this.m_def = WSIFUtils.readWSDL(null, (String)wsdlURL);
        }
        catch (WSDLException e) {
            throw new WSDLHelperException(e);
        }
        this.initialize(wsdlURL);
    }

    private void initialize(String wsdlLocation) throws WSDLHelperException {
        this.m_typeHelper = new TypeHelper(this.m_def);
        this.m_typeHelper.initializeFromURL(wsdlLocation);
        this.m_bUsingPolicy = this.getUsingPolicy();
    }

    protected WSDLHelper(String locationPath, String wsdl) throws WSDLHelperException {
        this.m_wsdlLocation = locationPath;
        try {
            this.m_def = WSIFUtils.readWSDL((String)locationPath, (Reader)new StringReader(wsdl));
        }
        catch (WSDLException e) {
            throw new WSDLHelperException(e);
        }
        this.initialize(locationPath);
    }

    protected WSDLHelper(String locationPath, Reader reader) throws WSDLHelperException {
        this.m_wsdlLocation = locationPath;
        try {
            this.m_def = WSIFUtils.readWSDL((String)locationPath, (Reader)reader);
        }
        catch (WSDLException e) {
            throw new WSDLHelperException(e);
        }
        this.initialize(locationPath);
    }

    @Override
    public List getServices() throws ESBWSException {
        if (this.m_serviceMap == null) {
            this.m_serviceMap = new HashMap();
            Map services = this.m_def.getServices();
            if (services.isEmpty()) {
                WSDLServiceHelper svcHelper = new WSDLServiceHelper(this, this.m_wsdlLocation, null);
                this.m_serviceMap.put(DEFAULT_SERVICE_QNAME, svcHelper);
            } else {
                for (Service svc : services.values()) {
                    WSDLServiceHelper svcHelper = new WSDLServiceHelper(this, this.m_wsdlLocation, svc);
                    this.m_serviceMap.put(svc.getQName(), svcHelper);
                }
            }
        }
        return new ArrayList(this.m_serviceMap.values());
    }

    @Override
    public ESBWSService getService(String uri, String localName) throws ESBWSException {
        QName target;
        WSDLServiceHelper svcHelper;
        if (this.m_serviceMap == null) {
            this.getServices();
        }
        if ((svcHelper = (WSDLServiceHelper)this.m_serviceMap.get(target = uri == null || localName == null ? DEFAULT_SERVICE_QNAME : new QName(uri, localName))) == null) {
            throw new WSDLHelperException("service-not-found", new Object[]{target.toString()});
        }
        return svcHelper;
    }

    @Override
    public Map getNamespaces() {
        if (this.m_prefixToURIMap == null) {
            this.m_prefixToURIMap = new HashMap();
            this.m_URItoPrefixMap = new HashMap();
            Map nspaces = this.m_def.getNamespaces();
            if (nspaces.isEmpty()) {
                return this.m_prefixToURIMap;
            }
            for (String prefix : nspaces.keySet()) {
                String uri = (String)nspaces.get(prefix);
                this.m_prefixToURIMap.put(prefix, uri);
                this.m_URItoPrefixMap.put(uri, prefix);
            }
        }
        return this.m_prefixToURIMap;
    }

    @Override
    public String getPrefixForURI(String uri) {
        if (this.m_URItoPrefixMap == null) {
            this.getNamespaces();
        }
        return (String)this.m_URItoPrefixMap.get(uri);
    }

    @Override
    public String getBaseTypeName(QName qname) throws WSDLHelperException {
        return this.m_typeHelper.getBaseTypeName(qname);
    }

    public boolean isSimpleType(String prefixedType) throws WSDLHelperException {
        String prefix = XMLTypeUtils.getTypePrefix(prefixedType);
        String localName = XMLTypeUtils.getTypeName(prefixedType);
        String namespace = this.m_def.getNamespace(prefix);
        QName qname = new QName(namespace, localName);
        return this.m_typeHelper.isSimpleType(qname);
    }

    @Override
    public String getTargetNamespace() {
        return this.m_def.getTargetNamespace();
    }

    @Override
    public ESBWSTypeLibrary getTypeLibrary() {
        return this.m_typeHelper;
    }

    Definition getDefinition() {
        return this.m_def;
    }

    @Override
    public boolean isUsingPolicy() {
        return this.m_bUsingPolicy;
    }

    private boolean getUsingPolicy() {
        List extElems = this.m_def.getExtensibilityElements();
        for (ExtensibilityElement elem : extElems) {
            if (!elem.getElementType().equals(WSDLConstants.WS_USING_POLICY_QNAME)) continue;
            return true;
        }
        return false;
    }
}

