/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.mgmtapi.runtime.ESBArtifactInfo;
import com.sonicsw.esb.mgmtapi.runtime.IContainerRuntimeAPI;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQState;
import com.sonicsw.xqimpl.config.XQServiceTypeHelper;
import com.sonicsw.xqimpl.service.LifeCycleManagerBase;
import com.sonicsw.xqimpl.service.ServiceLifeCycleManager;
import com.sonicsw.xqimpl.service.XQAppManager;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQServiceApplication;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;

class ContainerLifeCycleManager
extends LifeCycleManagerBase
implements IContainerRuntimeAPI {
    private XQContainer m_xqContainer;
    private boolean m_containerAborting;
    private Hashtable m_esbArtifacts = new Hashtable();
    private boolean m_firstRequest = true;
    private static final int SERVICE_TYPE = 1;
    private static final int PROCESS_TYPE = 2;

    ContainerLifeCycleManager(XQContainer container, XQLog log) {
        super(log);
        this.m_xqContainer = container;
    }

    void clearStateVariables() {
        this.m_containerAborting = false;
    }

    public synchronized boolean stopContainer() {
        return this.stopContainerInternal(1);
    }

    public synchronized boolean abortContainer() {
        return this.stopContainerInternal(2);
    }

    private synchronized boolean stopContainerInternal(int performAction) {
        XQState containerState = this.m_xqContainer.getXQState();
        if (containerState == XQState.STOPPING) {
            this.ignoreTransientState(XQState.STOPPING, "Container", 1);
        } else if (containerState == XQState.STOPPED) {
            this.ignoreSameState(XQState.STOPPING, "Container", 1);
        } else {
            this.clearStateVariables();
            this.m_xqContainer.setXQState(XQState.STOPPING);
            this.m_containerAborting = performAction == 2;
            Thread stopContainerThread = new Thread(new StopContainer(performAction));
            stopContainerThread.start();
            return true;
        }
        return false;
    }

    @Override
    public boolean isContainerAborting() {
        XQState containerState = this.m_xqContainer.getXQState();
        return containerState == XQState.STOPPING && this.m_containerAborting;
    }

    public XQState getCurrentContainerState() {
        return this.m_xqContainer.getXQState();
    }

    public boolean abortService() {
        throw new UnsupportedOperationException("Not supported by ContainerLifeCycleManager");
    }

    public boolean startService() {
        throw new UnsupportedOperationException("Not supported by ContainerLifeCycleManager");
    }

    public boolean stopService() {
        throw new UnsupportedOperationException("Not supported by ContainerLifeCycleManager");
    }

    public XQState getCurrentServiceState() {
        throw new UnsupportedOperationException("Not supported by ContainerLifeCycleManager");
    }

    public void setLastError(String error) {
        throw new UnsupportedOperationException("Not supported by ContainerLifeCycleManager");
    }

    public ESBArtifactInfo[] abortProcesses(String[] processNames) {
        return this.changeState(processNames, 2, 2);
    }

    public ESBArtifactInfo[] abortServices(String[] serviceNames) {
        return this.changeState(serviceNames, 1, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESBArtifactInfo[] getArtifacts() {
        XQAppManager appMgr = this.m_xqContainer.getXQAppManager();
        if (this.m_firstRequest) {
            ContainerLifeCycleManager containerLifeCycleManager = this;
            synchronized (containerLifeCycleManager) {
                if (this.m_firstRequest) {
                    this.m_firstRequest = false;
                    String[][] serviceInfos = appMgr.getServicesInfo();
                    for (int i = 0; i < serviceInfos.length; ++i) {
                        String serviceType = serviceInfos[i][1];
                        boolean isProcess = XQServiceTypeHelper.isBPEServiceType((String)serviceType);
                        if (XQContainer.isHiddenComponentType(serviceType) && !isProcess) continue;
                        String artifactName = serviceInfos[i][0];
                        int artifactType = isProcess ? 2 : 1;
                        ESBArtifactInfoImpl esbArtifact = null;
                        XQServiceApplication serviceApp = appMgr.getServiceApplication(artifactName);
                        if (serviceApp != null) {
                            esbArtifact = this.newESBArtifactInfo(artifactName, artifactType, serviceType);
                            ServiceLifeCycleManager svcLCMgr = (ServiceLifeCycleManager)serviceApp.getLifeCycleManager();
                            esbArtifact.setCurrentState(svcLCMgr.getCurrentServiceState().getState());
                            esbArtifact.setLastError(svcLCMgr.getLastError());
                            continue;
                        }
                        esbArtifact = this.getESBArtifactInfo(artifactName, artifactType);
                        if (esbArtifact != null) continue;
                        esbArtifact = this.newESBArtifactInfo(artifactName, artifactType, serviceType);
                        esbArtifact.setCurrentState(XQState.UNINITIALIZED.getState());
                    }
                }
            }
        } else {
            for (String key : this.m_esbArtifacts.keySet()) {
                this.updateCachedArtifact(key);
            }
        }
        int i = 0;
        ESBArtifactInfo[] result = new ESBArtifactInfo[this.m_esbArtifacts.size()];
        Iterator iter = this.m_esbArtifacts.entrySet().iterator();
        while (iter.hasNext()) {
            result[i++] = (ESBArtifactInfo)iter.next().getValue();
        }
        return result;
    }

    private ESBArtifactInfo updateCachedArtifact(String key) {
        XQServiceApplication serviceApp;
        XQAppManager appMgr = this.m_xqContainer.getXQAppManager();
        ESBArtifactInfoImpl esbArtifact = (ESBArtifactInfoImpl)this.m_esbArtifacts.get(key);
        if (esbArtifact != null && (serviceApp = appMgr.getServiceApplication(key.substring(0, key.lastIndexOf(58)))) != null) {
            ServiceLifeCycleManager serviceLifecycleMgr = (ServiceLifeCycleManager)serviceApp.getLifeCycleManager();
            esbArtifact.setCurrentState(serviceLifecycleMgr.getCurrentServiceState().getState());
            esbArtifact.setLastError(serviceLifecycleMgr.getLastError());
        }
        return esbArtifact;
    }

    public ESBArtifactInfo getServiceInfo(String serviceName) {
        ESBArtifactInfoImpl esbArtifact = null;
        if (this.m_firstRequest) {
            this.getArtifacts();
            esbArtifact = this.getESBArtifactInfo(serviceName, 1);
        } else {
            esbArtifact = this.updateCachedArtifact(serviceName + ':' + 1);
        }
        if (esbArtifact == null) {
            throw new IllegalArgumentException("ESB service " + serviceName + " is not deployed in this container");
        }
        return esbArtifact;
    }

    public ESBArtifactInfo getProcessInfo(String processName) {
        ESBArtifactInfoImpl esbArtifact = null;
        if (this.m_firstRequest) {
            this.getArtifacts();
            esbArtifact = this.getESBArtifactInfo(processName, 2);
        } else {
            esbArtifact = this.updateCachedArtifact(processName + ':' + 2);
        }
        if (esbArtifact == null) {
            throw new IllegalArgumentException("ESB process " + processName + " is not deployed in this container");
        }
        return esbArtifact;
    }

    public ESBArtifactInfo[] reloadProcesses(String[] processNames) {
        return new ESBArtifactInfo[0];
    }

    public ESBArtifactInfo[] reloadServices(String[] serviceNames) {
        return new ESBArtifactInfo[0];
    }

    public ESBArtifactInfo[] startProcesses(String[] processNames) {
        return this.changeState(processNames, 2, 0);
    }

    public ESBArtifactInfo[] startServices(String[] serviceNames) {
        return this.changeState(serviceNames, 1, 0);
    }

    public ESBArtifactInfo[] stopProcesses(String[] processNames) {
        return this.changeState(processNames, 2, 1);
    }

    public ESBArtifactInfo[] stopServices(String[] serviceNames) {
        return this.changeState(serviceNames, 1, 1);
    }

    private synchronized ESBArtifactInfo[] changeState(String[] artifacts, int artifactType, int operation) {
        if (this.m_firstRequest) {
            this.getArtifacts();
        }
        ESBArtifactInfo[] result = new ESBArtifactInfoImpl[artifacts.length];
        XQAppManager appMgr = this.m_xqContainer.getXQAppManager();
        for (int i = 0; i < artifacts.length; ++i) {
            ESBArtifactInfoImpl esbArtifact = this.getESBArtifactInfo(artifacts[i], artifactType);
            if (esbArtifact == null) {
                ContainerLifeCycleManager containerLifeCycleManager = this;
                ContainerLifeCycleManager containerLifeCycleManager2 = this;
                throw new IllegalArgumentException("ESB artifact " + artifacts[i] + " is not deployed in " + containerLifeCycleManager.m_xqContainer.getMFContainerName() + "/" + containerLifeCycleManager2.m_xqContainer.getXQContainerName());
            }
            XQServiceApplication serviceApp = appMgr.getServiceApplication(artifacts[i]);
            if (serviceApp != null) {
                ServiceLifeCycleManager serviceLifecycleMgr = (ServiceLifeCycleManager)serviceApp.getLifeCycleManager();
                if (operation == 0) {
                    serviceLifecycleMgr.startService();
                } else if (operation == 1) {
                    serviceLifecycleMgr.stopService();
                } else if (operation == 2) {
                    serviceLifecycleMgr.abortService();
                } else {
                    throw new AssertionError((Object)"Invalid operation specified");
                }
                esbArtifact.setCurrentState(serviceLifecycleMgr.getCurrentServiceState().getState());
                esbArtifact.setLastError(serviceLifecycleMgr.getLastError());
            } else {
                this.throwInvalidState(XQState.UNINITIALIZED, artifacts[i], operation);
            }
            result[i] = esbArtifact;
        }
        return result;
    }

    void registerInitError(XQServiceApplication serviceApp, Throwable thrown) {
        ESBArtifactInfoImpl esbArtifact = new ESBArtifactInfoImpl(serviceApp.getName(), serviceApp.getServiceType());
        this.cacheESBArtifactInfo(esbArtifact);
        if (thrown != null) {
            if (serviceApp.getLifeCycleManager() != null) {
                ServiceLifeCycleManager svcLCMgr = (ServiceLifeCycleManager)serviceApp.getLifeCycleManager();
                svcLCMgr.setLastError(thrown);
            }
            esbArtifact.setLastError(thrown.toString());
        }
    }

    public boolean wasContainerAborted() {
        return this.m_containerAborting;
    }

    private ESBArtifactInfoImpl newESBArtifactInfo(String artifactName, int artifactType, String serviceType) {
        ESBArtifactInfoImpl esbArtifact = new ESBArtifactInfoImpl(artifactName, artifactType, serviceType);
        this.cacheESBArtifactInfo(esbArtifact);
        return esbArtifact;
    }

    private void cacheESBArtifactInfo(ESBArtifactInfoImpl esbArtifact) {
        this.m_esbArtifacts.put(esbArtifact.getName() + ':' + esbArtifact.getType(), esbArtifact);
    }

    private ESBArtifactInfoImpl getESBArtifactInfo(String artifactName, int artifactType) {
        return (ESBArtifactInfoImpl)this.m_esbArtifacts.get(artifactName + ':' + artifactType);
    }

    private class StopContainer
    implements Runnable {
        private int m_operation;

        private StopContainer(int operation) {
            this.m_operation = operation;
        }

        @Override
        public void run() {
            try {
                ContainerLifeCycleManager.this.m_log.logDebug("Container is being " + LifeCycleManagerBase.OPS[this.m_operation] + "ed ...");
                ContainerLifeCycleManager.this.m_xqContainer.stop();
            }
            catch (Throwable t) {
                ContainerLifeCycleManager.this.m_xqContainer.getLog().logWarning("Got following exception while performing " + LifeCycleManagerBase.OPS[this.m_operation] + " the container");
                ContainerLifeCycleManager.this.m_xqContainer.getLog().logWarning(t);
            }
        }
    }

    public static class ESBArtifactInfoImpl
    implements ESBArtifactInfo,
    Serializable {
        private static final long serialVersionUID = 2945336094740699765L;
        private int m_currentState;
        private int m_type;
        private String m_lastError;
        private String m_name;
        private String m_artifactType;

        public ESBArtifactInfoImpl(String name, int type) {
            this.m_name = name;
            this.m_type = type;
        }

        public ESBArtifactInfoImpl(String name, String serviceType) {
            this(name, 1);
            if (serviceType != null && XQServiceTypeHelper.isBPEServiceType((String)serviceType)) {
                this.m_type = 2;
            }
            this.calculateTypeInfo(serviceType);
        }

        public ESBArtifactInfoImpl(String name, int type, String serviceType) {
            this(name, type);
            this.calculateTypeInfo(serviceType);
        }

        private void calculateTypeInfo(String serviceType) {
            this.m_artifactType = this.m_type == 1 ? serviceType : this.m_name;
        }

        public int getCurrentState() {
            return this.m_currentState;
        }

        void setCurrentState(int currentState) {
            this.m_currentState = currentState;
        }

        public String getLastError() {
            return this.m_lastError;
        }

        public void setLastError(String lastError) {
            this.m_lastError = lastError;
        }

        public String getName() {
            return this.m_name;
        }

        public int getType() {
            return this.m_type;
        }

        public String getTypeAsString() {
            if (this.m_type == 1) {
                return "Service";
            }
            if (this.m_type == 2) {
                return "Process";
            }
            return null;
        }

        void setType(int type) {
            this.m_type = type;
        }

        public String getESBTypeInfo() {
            return this.m_artifactType;
        }

        void setESBTypeInfo(String artifactType) {
            this.m_artifactType = artifactType;
        }
    }
}

