/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service.wsinvk;

import com.sonicsw.esb.service.common.impl.MessageVariableResolver;
import com.sonicsw.esb.service.common.impl.core.FileChangeManager;
import com.sonicsw.esb.service.common.impl.core.FileChangeManagerImpl;
import com.sonicsw.esb.service.common.util.variables.PropertiesURLVariableResolver;
import com.sonicsw.esb.service.common.util.variables.SystemPropertyVariableResolver;
import com.sonicsw.esb.service.common.util.variables.VariableParser;
import com.sonicsw.esb.service.common.util.variables.VariableParserImpl;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import com.sonicsw.esb.service.common.util.variables.VariableResolverFactory;
import com.sonicsw.esb.service.common.util.variables.VariableResolverFactoryImpl;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.esb.ws.rm.IWSEndpointReference;
import com.sonicsw.esb.ws.rm.IWSRMEngine;
import com.sonicsw.esb.ws.rm.IWSRMSequence;
import com.sonicsw.esb.ws.rm.IWSRMSequenceContext;
import com.sonicsw.esb.ws.rm.IWSReliableInvocation;
import com.sonicsw.esb.ws.rm.WSRMException;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.invk.ESBEndpoint;
import com.sonicsw.xqimpl.invk.ESBException;
import com.sonicsw.xqimpl.invk.ESBInvkException;
import com.sonicsw.xqimpl.invk.ESBMessage;
import com.sonicsw.xqimpl.invk.ESBMessageContext;
import com.sonicsw.xqimpl.invk.ESBOperation;
import com.sonicsw.xqimpl.invk.ESBReturnParam;
import com.sonicsw.xqimpl.invk.ESBService;
import com.sonicsw.xqimpl.invk.ESBServiceFactory;
import com.sonicsw.xqimpl.script.BaseScriptCommand;
import com.sonicsw.xqimpl.script.ICommand;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.IScriptCommand;
import com.sonicsw.xqimpl.script.ParameterDirection;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.ScriptObject;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import com.sonicsw.xqimpl.script.wsdl.IWSInvocationParamValue;
import com.sonicsw.xqimpl.script.wsdl.WSDLScriptCommand;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.wsinvk.WSExecutionFaultException;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.util.xml.Namespace;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import com.sonicsw.xqimpl.ws.addressing.WSAHeaders;
import com.sonicsw.xqimpl.ws.addressing.WSEndpointReferenceImpl;
import com.sonicsw.xqimpl.ws.rm.SequenceContext;
import com.sonicsw.xqimpl.ws.rm.WSRMEngineFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WSInvocationScriptObject
extends ScriptObject {
    protected boolean m_runningInContainer = true;
    protected DirectoryServiceProxy m_dsProxy = null;
    protected Hashtable m_envProps = null;
    private XQConnectionConfig m_xqConnConfig = null;
    private String m_defaultJMSInternalConnName = null;
    private String m_defaultHTTPInternalConnName = null;
    private VariableParser m_variableParser = null;
    private MessageVariableResolver m_messageVariableResolver = null;
    private VariableResolverFactoryImpl m_variableResolverFactory = null;
    private static XQLog m_categoryLog = XQLogImpl.getCategoryLog((int)32);
    private static XQLog m_RMLog = XQLogImpl.getCategoryLog((int)16384);
    private static Object m_endpointManagerLock = new Object();
    private static boolean m_endpointManagerInitialized = false;
    private static String[] s_variableParameterNames = new String[]{"com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_PORT_ADDRESS_URL", "X-HTTP-AuthUser", "X-HTTP-AuthPassword"};

    public WSInvocationScriptObject(boolean runningInContainer, DirectoryServiceProxy dsProxy, Hashtable envProps, XQConnectionConfig xqConnConfig) throws ScriptEngineException {
        this.initVariableParser();
        this.initialize(runningInContainer, dsProxy, envProps, xqConnConfig);
    }

    public WSInvocationScriptObject(Element script, boolean runningInContainer, DirectoryServiceProxy dsProxy, Hashtable envProps, XQConnectionConfig xqConnConfig) throws ScriptEngineException {
        super(script);
        this.initVariableParser();
        this.initialize(runningInContainer, dsProxy, envProps, xqConnConfig);
    }

    public void reinitialize(boolean runningInContainer, DirectoryServiceProxy dsProxy, Hashtable envProps, XQConnectionConfig xqConnConfig) throws ScriptEngineException {
        this.initialize(runningInContainer, dsProxy, envProps, xqConnConfig);
    }

    private void initialize(boolean runningInContainer, DirectoryServiceProxy dsProxy, Hashtable envProps, XQConnectionConfig xqConnConfig) throws ScriptEngineException {
        this.m_dsProxy = dsProxy;
        this.m_envProps = envProps;
        this.m_xqConnConfig = xqConnConfig;
        this.m_runningInContainer = runningInContainer;
        if (this.m_runningInContainer) {
            this.m_defaultJMSInternalConnName = XQContainer.getJMSDefaultConnection();
            this.m_defaultHTTPInternalConnName = XQContainer.getHTTPDefaultConnection();
            this.logDebug("m_defaultJMSInternalConnName: " + this.m_defaultJMSInternalConnName + " m_defaultHTTPInternalConnName: " + this.m_defaultHTTPInternalConnName);
        } else if (this.m_xqConnConfig == null) {
            throw new ScriptEngineException("calls-outside-container-require-xqconnectionconfig", 1);
        }
    }

    private void initVariableParser() {
        this.m_variableResolverFactory = new VariableResolverFactoryImpl();
        this.m_messageVariableResolver = new MessageVariableResolver();
        FileChangeManagerImpl fmi = new FileChangeManagerImpl();
        PropertiesURLVariableResolver puvr = new PropertiesURLVariableResolver();
        puvr.setFileChangeManager((FileChangeManager)fmi);
        SystemPropertyVariableResolver spvr = new SystemPropertyVariableResolver();
        this.m_variableResolverFactory.registerResolver(puvr.getScheme(), (VariableResolver)puvr);
        this.m_variableResolverFactory.registerResolver(this.m_messageVariableResolver.getScheme(), (VariableResolver)this.m_messageVariableResolver);
        this.m_variableResolverFactory.registerResolver(spvr.getScheme(), (VariableResolver)spvr);
        this.m_variableParser = new VariableParserImpl();
        this.m_variableParser.setVariableResolverFactory((VariableResolverFactory)this.m_variableResolverFactory);
    }

    private void logDebug(String content) {
        m_categoryLog.logDebug(content);
    }

    @Override
    public IScriptCommand createScriptCommand(Element element) throws ScriptEngineException {
        return new WSInvocationScriptCommand(element);
    }

    @Override
    public String getScriptType() {
        return "http://www.sonicsw.com/esb/service/invocationinvocationType";
    }

    public class WSInvocationScriptCommand
    extends BaseScriptCommand {
        private WSDLScriptCommand m_scriptCommand;
        private String m_portAddressURL;
        private String m_internalConnName;
        private int m_faultOption;
        private boolean m_forceRequestResponse;

        WSInvocationScriptCommand(Element scriptElement) throws ScriptEngineException {
            super(scriptElement);
            this.m_scriptCommand = null;
            this.m_portAddressURL = null;
            this.m_internalConnName = null;
            this.m_forceRequestResponse = false;
            Element command = DOMUtils.getImmediateChildElementByName((Element)scriptElement, (String)"command");
            this.m_scriptCommand = new WSDLScriptCommand(command);
            WSInvocationScriptObject.this.logDebug("WSInvocationScriptCommand constructor done..");
        }

        public WSDLScriptCommand getScriptCommand() {
            return this.m_scriptCommand;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List execute(List myParameters, Map parameterConstants) throws Exception {
            WSInvocationScriptObject.this.logDebug("WSInvocationScriptCommand execute called..");
            XQMessageInternal msg = (XQMessageInternal)WSInvocationScriptObject.this.getXQMessage();
            ESBVisitor visitor = null;
            HashMap<String, Object> visitorParams = null;
            if (msg != null && (visitor = msg.getVisitor()) != null) {
                visitorParams = new HashMap<String, Object>();
                visitorParams.put("ESBVisitor.PARAM_ESBWS_COMMAND", this.m_scriptCommand);
                visitorParams.put("ESBVisitor.PARAM_XQ_PARAMETERS", WSInvocationScriptObject.this.getXQParameters());
                visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", msg);
                visitorParams.put("Actional.EndSI", "true");
                visitor.receivedByStep(visitorParams);
            }
            List outputIParamValueList = null;
            ESBServiceFactory factory = null;
            this.rewriteVariableParameters(parameterConstants, msg);
            if (WSInvocationScriptObject.this.m_runningInContainer) {
                factory = new ESBServiceFactory();
            } else {
                factory = new ESBServiceFactory(WSInvocationScriptObject.this.m_envProps, WSInvocationScriptObject.this.m_dsProxy);
                Object object = m_endpointManagerLock;
                synchronized (object) {
                    if (!m_endpointManagerInitialized) {
                        EndpointManager.getInstance().init(null, null, WSInvocationScriptObject.this.m_envProps);
                        m_endpointManagerInitialized = false;
                    }
                }
            }
            IWSRMSequence sequence = this.beforeCallRMIntercept(parameterConstants);
            ESBEndpoint endpoint = null;
            XQConfigManager configManager = null;
            try {
                boolean isRequestResponse;
                configManager = XQConfigManager.getInstance((Hashtable)WSInvocationScriptObject.this.m_envProps);
                if (WSInvocationScriptObject.this.m_runningInContainer) {
                    XQConnectionConfig defaultHTTPConnConfig;
                    XQConnectionConfig defaultJMSConnConfig = XQContainer.getJMSDefaultConnConfig();
                    if (defaultJMSConnConfig == null) {
                        defaultJMSConnConfig = (XQConnectionConfig)configManager.lookup(WSInvocationScriptObject.this.m_defaultJMSInternalConnName, "connection");
                    }
                    if ((defaultHTTPConnConfig = XQContainer.getHTTPDefaultConnConfig()) == null) {
                        defaultHTTPConnConfig = (XQConnectionConfig)configManager.lookup(WSInvocationScriptObject.this.m_defaultHTTPInternalConnName, "connection");
                    }
                    factory.setDefaultConnections(defaultJMSConnConfig, defaultHTTPConnConfig);
                } else if (WSInvocationScriptObject.this.m_xqConnConfig == null) {
                    throw new ScriptEngineException("calls-outside-container-require-xqconnectionconfig", 1);
                }
                Map customParameterConstants = this.handleParameterConstants(parameterConstants);
                this.addCurrentMessageProperties(customParameterConstants);
                if (this.m_internalConnName != null && !"".equals(this.m_internalConnName)) {
                    WSInvocationScriptObject.this.m_xqConnConfig = (XQConnectionConfig)configManager.lookup(this.m_internalConnName, "connection");
                }
                ESBService service = factory.getService(this.m_scriptCommand.getWSDLLocation(), this.m_scriptCommand.getServiceName());
                if (this.m_portAddressURL != null) {
                    WSInvocationScriptObject.this.logDebug("calling getEndpoint with m_portAddressURL: " + this.m_portAddressURL + " and connection config");
                    endpoint = service.getEndpoint(this.m_portAddressURL, this.m_scriptCommand.getBindingName(), this.m_scriptCommand.getPortType(), WSInvocationScriptObject.this.m_xqConnConfig);
                } else {
                    WSInvocationScriptObject.this.logDebug("calling getEndpoint with m_portName: " + this.m_scriptCommand.getPortName() + " and connection config");
                    endpoint = service.getEndpoint(this.m_scriptCommand.getPortName(), WSInvocationScriptObject.this.m_xqConnConfig);
                }
                ESBOperation operation = endpoint.getOperation(this.m_scriptCommand.getOperationName());
                ESBMessageContext context = operation.createESBMessageContext();
                this.setCustomProperties(context, customParameterConstants);
                context.setProperty("ScriptCommand", this.m_scriptCommand);
                context.setProperty("WSA_NAMESPACE", this.chooseWSANamespace());
                ESBMessage input = context.createInputMessage();
                ESBMessage output = context.createOutputMessage();
                this.m_scriptCommand.setParameterValues(myParameters);
                Iterator it = this.m_scriptCommand.getParameters().iterator();
                IWSInvocationParamValue iWSParamValue = null;
                HashMap<String, Object> inSoapHeaderMap = new HashMap<String, Object>();
                while (it.hasNext()) {
                    iWSParamValue = (IWSInvocationParamValue)it.next();
                    String paramName = null;
                    if (iWSParamValue.getDirection() != ParameterDirection.IN && iWSParamValue.getDirection() != ParameterDirection.INOUT || iWSParamValue.isDiscard()) continue;
                    paramName = iWSParamValue.getParamName();
                    String paramBaseType = iWSParamValue.getBaseType();
                    String paramString = iWSParamValue.getAsString();
                    if (iWSParamValue.isSoapHeader()) {
                        WSInvocationScriptObject.this.logDebug("soapheader paramName: " + paramName + " paramString: " + paramString + " paramBaseType: " + paramBaseType);
                        if (iWSParamValue.isComplexType()) {
                            inSoapHeaderMap.put(paramName, iWSParamValue.getAsElement());
                            continue;
                        }
                        XMLTypeUtils.validateParameterValue(iWSParamValue);
                        inSoapHeaderMap.put(paramName, iWSParamValue.getAsString());
                        continue;
                    }
                    WSInvocationScriptObject.this.logDebug("paramNam: " + paramName + " paramString: " + paramString + " paramBaseType: " + paramBaseType);
                    if (iWSParamValue.isComplexType()) {
                        input.setPart(paramName, iWSParamValue.getAsElement(), paramBaseType);
                        continue;
                    }
                    XMLTypeUtils.validateParameterValue(iWSParamValue);
                    input.setPart(paramName, iWSParamValue.getAsString(), paramBaseType);
                }
                if (!inSoapHeaderMap.isEmpty()) {
                    WSInvocationScriptObject.this.logDebug("Setting context property (soap headers): ESBRequestSOAPHeaders");
                    context.setProperty("ESBRequestSOAPHeaders", inSoapHeaderMap);
                }
                context.addInputMessage(null, input);
                context.addOutputMessage(null, output);
                boolean bl = isRequestResponse = this.m_scriptCommand.isRequestResponse() || this.m_forceRequestResponse;
                if (visitor != null) {
                    context.setProperty("com.sonicsw.esb.visitor", visitor);
                    visitorParams.put("ESBVisitor.PARAM_IS_REQUEST_RESPONSE", new Boolean(isRequestResponse));
                    visitor.sentToWebService(visitorParams);
                    String lgHeader = (String)visitorParams.get("LG_Header");
                    if (lgHeader != null) {
                        WSInvocationScriptObject.this.logDebug("Setting the LG_Header header to: " + lgHeader);
                        context.setProperty("LG_Header", lgHeader);
                    }
                    if (msg.getSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT") != null) {
                        context.setProperty("com.sonicsw.esb.visitor.ActionalContext", msg.getSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT"));
                    }
                }
                if (isRequestResponse) {
                    operation.call(context);
                } else {
                    operation.send(context);
                }
                this.afterCallRMIntercept(context, parameterConstants, sequence, isRequestResponse);
                outputIParamValueList = this.processOutput(context, output);
            }
            catch (ESBInvkException esbInvkException) {
                m_categoryLog.logDebug((Throwable)esbInvkException);
                WSExecutionFaultException ex = new WSExecutionFaultException(esbInvkException, this.m_faultOption);
                throw ex;
            }
            catch (XQConfigurationException xqce) {
                throw xqce;
            }
            catch (ScriptEngineException see) {
                throw see;
            }
            catch (ESBException ex1) {
                throw ex1;
            }
            finally {
                if (endpoint != null) {
                    endpoint.close();
                }
                this.m_scriptCommand.resetParameterValues();
            }
            return outputIParamValueList;
        }

        private void rewriteVariableParameters(Map parameterConstants, XQMessageInternal msg) {
            for (int i = 0; i < s_variableParameterNames.length; ++i) {
                this.rewriteVariableParameter(parameterConstants, s_variableParameterNames[i], msg);
            }
        }

        private void rewriteVariableParameter(Map parameterConstants, String name, XQMessageInternal msg) {
            String pRaw = (String)parameterConstants.get(name);
            if (pRaw != null) {
                WSInvocationScriptObject.this.m_messageVariableResolver.setMessage((XQMessage)msg);
                String pResolved = WSInvocationScriptObject.this.m_variableParser.replaceAllVariables(pRaw);
                if (!WSInvocationScriptObject.this.m_variableParser.containsVariables(pResolved)) {
                    parameterConstants.put(name, pResolved);
                } else {
                    parameterConstants.remove(name);
                }
            }
        }

        private IWSRMSequence beforeCallRMIntercept(Map parameterConstants) throws Exception {
            if (this.m_scriptCommand.getEffectivePolicy() != null) {
                this.addWSAProperties(parameterConstants);
                if (this.m_scriptCommand.isReliableMessagingEnabled()) {
                    IWSRMSequence sequence = this.initializeSequence(parameterConstants);
                    return sequence;
                }
            }
            return null;
        }

        private IWSRMSequence initializeSequence(Map runtimeParameterConstants) throws Exception {
            WSEndpointReferenceImpl sequenceKey;
            IWSRMSequence seqCapsule;
            if (WSInvocationScriptObject.this.getXQParameters() == null) {
                return null;
            }
            IWSRMSequence seq = this.initializeOfferedSequence(runtimeParameterConstants);
            if (seq != null) {
                WSInvocationScriptObject.this.logDebug("Sequence initialized from OfferID (OServer scenario), returning sequence: " + seq.toString());
                return seq;
            }
            String processName = WSInvocationScriptObject.this.getXQParameters().getParameter("SonicXQ.ProcessName", 1);
            String serializedEngine = (String)WSInvocationScriptObject.this.getXQParameters().getParameterObject("SonicESB.RM.SequenceMap", 1);
            IWSRMEngine rmEngine = WSRMEngineFactory.create(serializedEngine);
            String seqURL = this.m_scriptCommand.getSOAPInfo().getEndpointURL();
            String portAddressURL = (String)runtimeParameterConstants.get("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_PORT_ADDRESS_URL");
            if (portAddressURL != null) {
                seqURL = portAddressURL;
            }
            boolean useReplyTo = false;
            Boolean prop = Boolean.valueOf((String)runtimeParameterConstants.get("UseReplyTo"));
            if (prop != null) {
                useReplyTo = prop;
            }
            int esbwsType = this.m_scriptCommand.getESBWSType();
            WSAHeaders wsaHdrs = (WSAHeaders)WSInvocationScriptObject.this.getXQParameters().getParameterObject("SonicESB.RM.WSAHeaders", 3);
            if (wsaHdrs != null && (useReplyTo || esbwsType == 1)) {
                if (wsaHdrs.getEffectiveReplyTo() != null) {
                    seqURL = wsaHdrs.getEffectiveReplyTo().getAddress().toString();
                }
            } else if (wsaHdrs != null && esbwsType == 2 && wsaHdrs.getEffectiveFaultTo() != null) {
                seqURL = wsaHdrs.getEffectiveFaultTo().getAddress().toString();
            }
            if ((seqCapsule = rmEngine.getSequence((IWSEndpointReference)(sequenceKey = new WSEndpointReferenceImpl(seqURL)))) != null) {
                m_categoryLog.logDebug("WSInvoObject Found seqId=" + seqCapsule.getSequenceID() + " for seqKey=" + seqURL);
            }
            if (!(this.m_scriptCommand instanceof IWSReliableInvocation)) {
                throw new WSRMException("Invocation is not an instance of IWSReliableInvocation");
            }
            m_RMLog.logDebug("InitializeSequence: seqCapsule=" + seqCapsule);
            if (seqCapsule == null) {
                runtimeParameterConstants.put("IsCreateSequenceForResponse", "true");
                seqCapsule = rmEngine.createSequence((IWSEndpointReference)sequenceKey, (IWSReliableInvocation)this.m_scriptCommand, runtimeParameterConstants);
                runtimeParameterConstants.remove("IsCreateSequenceForResponse");
                seqCapsule.setSequenceContext((IWSRMSequenceContext)new SequenceContext(processName));
                m_RMLog.logDebug("CreateSequence returned: " + seqCapsule.toString());
                WSInvocationScriptObject.this.getXQParameters().setParameterObject("SonicESB.RM.SequenceMap", 1, (Object)rmEngine.serialize());
            }
            return seqCapsule;
        }

        private void afterCallRMIntercept(ESBMessageContext context, Map parameterConstants, IWSRMSequence sequence, boolean isRequestResponse) throws WSRMException {
            String updatedRMEngine = null;
            boolean isLastOfferMsg = false;
            boolean isAsync = false;
            boolean forceTerminate = false;
            IWSRMEngine rmEngine = null;
            try {
                updatedRMEngine = (String)context.getProperty("SonicESB.RM.SequenceMap");
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (updatedRMEngine == null) {
                m_RMLog.logDebug("After send, no RMEngine update");
                return;
            }
            try {
                isLastOfferMsg = context.getBooleanProperty("JMS_SonicMQ_lastMessageInGroup");
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                Object p = parameterConstants.get("AsyncReplyTo");
                if (p != null) {
                    isAsync = p instanceof Boolean ? ((Boolean)p).booleanValue() : Boolean.valueOf(p.toString()).booleanValue();
                }
            }
            catch (Exception e3) {
                // empty catch block
            }
            forceTerminate = parameterConstants.containsKey("com_sonicsw_xqimpl_service_wsinvk.FORCE_TERMINATE_SEQUENCE");
            if (m_RMLog.isDebugLoggingEnabled()) {
                m_RMLog.logDebug("afterSend=" + updatedRMEngine);
                m_RMLog.logDebug("FORCE_TERMINATE_SEQUENCE=" + forceTerminate);
                m_RMLog.logDebug("isAsync=" + isAsync);
                m_RMLog.logDebug("isRequestResponse=" + isRequestResponse);
                m_RMLog.logDebug("isLastOfferMsg=" + isLastOfferMsg);
            }
            rmEngine = WSRMEngineFactory.create(updatedRMEngine);
            if ((forceTerminate || isRequestResponse && !isAsync && isLastOfferMsg) && rmEngine != null && sequence != null) {
                m_RMLog.logInformation("Calling terminateSequence for sequence:" + sequence.toString());
                rmEngine.incrementSequence(sequence);
                rmEngine.terminateSequence(sequence);
            }
            if (WSInvocationScriptObject.this.getXQParameters() == null) {
                return;
            }
            if (m_RMLog.isDebugLoggingEnabled()) {
                m_RMLog.logDebug("setRMInfoInXQParams rmengine=" + rmEngine.serialize());
            }
            WSInvocationScriptObject.this.getXQParameters().setParameterObject("SonicESB.RM.SequenceMap", 1, (Object)rmEngine.serialize());
        }

        private List processOutput(ESBMessageContext context, ESBMessage output) throws ESBException, ScriptEngineException {
            ArrayList<IParameterValue> outputIParamValueArrayList = new ArrayList<IParameterValue>();
            if (output != null) {
                Iterator it = this.m_scriptCommand.getParameters().iterator();
                IWSInvocationParamValue iWSParamValue = null;
                while (it.hasNext()) {
                    iWSParamValue = (IWSInvocationParamValue)it.next();
                    String paramName = null;
                    Map outputSoapHeaderMap = null;
                    if (iWSParamValue.getDirection() != ParameterDirection.OUT && iWSParamValue.getDirection() != ParameterDirection.INOUT || (paramName = iWSParamValue.getParamName()).equals("RawSoapRequest") || paramName.equals("RawSoapResponse") || paramName.equals("RawSoap")) continue;
                    IParameterValue outParamValue = null;
                    if (iWSParamValue.isSoapHeader()) {
                        Object outputHeaderObj;
                        WSInvocationScriptObject.this.logDebug("Retrieving OUT or INOUT soap header paramName: " + paramName);
                        if (outputSoapHeaderMap == null) {
                            outputSoapHeaderMap = (Map)context.getProperty("ESBResponseSOAPHeaders");
                        }
                        if ((outputHeaderObj = outputSoapHeaderMap.get(paramName)) != null) {
                            if (outputHeaderObj instanceof Element) {
                                outParamValue = this.getParameterValueFactory().createParameterValue(paramName, iWSParamValue.getBaseType(), (Element)outputHeaderObj);
                            } else if (outputHeaderObj instanceof String) {
                                outParamValue = this.getParameterValueFactory().createParameterValue(paramName, iWSParamValue.getBaseType(), (String)outputHeaderObj);
                            }
                        }
                    } else {
                        try {
                            ESBReturnParam returnParam = (ESBReturnParam)output.getPart(paramName);
                            outParamValue = this.createParamValueFromESBReturn(paramName, returnParam, iWSParamValue.getBaseType(), iWSParamValue.getDisplayType());
                        }
                        catch (ESBException e) {
                            // empty catch block
                        }
                    }
                    if (outParamValue == null) {
                        if (!this.hasOutputParameterMapping(paramName)) continue;
                        throw new ESBException("Output param: " + paramName + " was not found in response", 5);
                    }
                    WSInvocationScriptObject.this.logDebug("Adding outParamValue.getAsString(): " + outParamValue.getAsString() + " \n outParamValue.getBaseType(): " + outParamValue.getBaseType() + " outParamValue.getDisplayType(): " + outParamValue.getDisplayType());
                    outputIParamValueArrayList.add(outParamValue);
                }
            }
            if (!WSInvocationScriptObject.this.m_runningInContainer || this.hasOutputParameterMapping("RawSoapRequest")) {
                this.handleRequestParameter(context, outputIParamValueArrayList, "RawSoapRequest");
            }
            if (this.hasOutputParameterMapping("RawSoap")) {
                this.handleRequestParameter(context, outputIParamValueArrayList, "RawSoap");
            }
            if (!WSInvocationScriptObject.this.m_runningInContainer || this.hasOutputParameterMapping("RawSoapResponse")) {
                ESBReturnParam response = context.getRawResponse();
                if (response != null) {
                    IParameterValue outParamValue = this.createParamValueFromESBReturn("RawSoapResponse", response, "xsd:anyType", "xsd:anyType");
                    outputIParamValueArrayList.add(outParamValue);
                } else if (this.hasOutputParameterMapping("RawSoapResponse")) {
                    throw new ESBException("Output param: RawSoapResponse was not found in response", 5);
                }
            }
            return outputIParamValueArrayList;
        }

        private void handleRequestParameter(ESBMessageContext context, ArrayList outputIParamValueArrayList, String paramType) throws ESBException, ScriptEngineException {
            ESBReturnParam request = context.getRawRequest();
            if (request != null) {
                IParameterValue outParamValue = this.createParamValueFromESBReturn(paramType, request, "xsd:anyType", null);
                outputIParamValueArrayList.add(outParamValue);
            } else if (this.hasOutputParameterMapping(paramType)) {
                throw new ESBException("Output param: " + paramType + " was not found in response", 5);
            }
        }

        private IParameterValue createParamValueFromESBReturn(String paramName, ESBReturnParam returnParam, String baseType, String displayType) throws ESBException, ScriptEngineException {
            if (returnParam.isNode()) {
                Node outputNode = returnParam.getNode();
                short nodeType = outputNode.getNodeType();
                WSInvocationScriptObject.this.logDebug("Retrieving OUT or INOUT node paramName: " + paramName + " nodeType: " + nodeType);
                switch (nodeType) {
                    case 1: {
                        Element outParamElement = (Element)outputNode;
                        return this.getParameterValueFactory().createParameterValue(paramName, baseType, outParamElement);
                    }
                    case 3: {
                        Text outParamText = (Text)outputNode;
                        return this.getParameterValueFactory().createParameterValue(paramName, baseType, outParamText.getData());
                    }
                }
                WSInvocationScriptObject.this.logDebug("ERROR: unsupported return param: " + paramName + " type: nodeType:" + nodeType);
                return null;
            }
            return this.getParameterValueFactory().createParameterValue(paramName, baseType, returnParam.getString());
        }

        private void setCustomProperties(ESBMessageContext context, Map customParameterMap) throws ESBException {
            Iterator cpcIt = null;
            if (customParameterMap != null && customParameterMap.keySet() != null) {
                for (String propertyName : customParameterMap.keySet()) {
                    Object propertyValue = customParameterMap.get(propertyName);
                    if (propertyValue != null) {
                        context.setProperty(propertyName, propertyValue);
                    }
                    WSInvocationScriptObject.this.logDebug("Set custom property into ESBMessageContext propertyName: " + propertyName + " = " + customParameterMap.get(propertyName));
                }
            }
        }

        private Map handleParameterConstants(Map parameterConstants) throws Exception {
            if (parameterConstants == null || parameterConstants.isEmpty()) {
                return null;
            }
            this.m_portAddressURL = this.handleURLOverride(parameterConstants);
            WSInvocationScriptObject.this.logDebug("Found m_portAddressURL: " + this.m_portAddressURL);
            this.m_internalConnName = (String)parameterConstants.remove("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_INTERNAL_CONNECTION_NAME");
            WSInvocationScriptObject.this.logDebug("Found m_internalConnName: " + this.m_internalConnName);
            String forceString = (String)parameterConstants.get("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FORCE_REQUEST_RESPONSE_OP");
            if (forceString != null && forceString.length() > 0) {
                this.m_forceRequestResponse = Boolean.valueOf(forceString);
                WSInvocationScriptObject.this.logDebug("Found m_forceRequestResponse: " + forceString);
            } else {
                this.m_forceRequestResponse = false;
            }
            String includeOrigMsgString = (String)parameterConstants.remove("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FAULT_MSG_MODE");
            if (includeOrigMsgString != null && includeOrigMsgString.length() > 0) {
                this.m_faultOption = Integer.parseInt(includeOrigMsgString);
            }
            this.addWSRMParameterConstants(parameterConstants);
            return parameterConstants;
        }

        private String handleURLOverride(Map parameterConstants) {
            String retval;
            XQMessage msg;
            String urlOverride = null;
            ICommand cmd = (ICommand)parameterConstants.remove("com_sonicsw_xqimpl_invk_ESBConstants_Command");
            if (cmd != null && (msg = cmd.getXQMessage()) != null) {
                try {
                    urlOverride = msg.getStringHeader("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_PORT_ADDRESS_URL");
                    m_categoryLog.logDebug("URL override from message header:" + urlOverride);
                }
                catch (XQMessageException e) {
                    m_categoryLog.logDebug((Throwable)e);
                }
            }
            String urlParam = (String)parameterConstants.remove("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_PORT_ADDRESS_URL");
            m_categoryLog.logDebug("URL override from parameter constants:" + urlParam);
            String string = retval = urlOverride != null ? urlOverride : urlParam;
            if (retval != null) {
                WSInvocationScriptObject.this.logDebug("handleURLOverride: setting scriptCommand SOAPEndpointURL=" + retval);
                this.m_scriptCommand.setSOAPEndpointURL(retval);
            }
            return retval;
        }

        private void addWSRMParameterConstants(Map parameterConstants) throws Exception {
            String faultPolicy;
            String responsePolicy;
            if (parameterConstants == null) {
                return;
            }
            String policy = this.m_scriptCommand.getEffectivePolicy();
            if (policy != null) {
                parameterConstants.put("SonicESB.RM.WSPolicy", policy);
            }
            if ((responsePolicy = this.m_scriptCommand.getResponsePolicy()) != null) {
                parameterConstants.put("SonicESB.RM.WSResponsePolicy", responsePolicy);
            }
            if ((faultPolicy = this.m_scriptCommand.getFaultPolicy()) != null) {
                parameterConstants.put("SonicESB.RM.WSFaultPolicy", faultPolicy);
            }
            this.addWSAProperties(parameterConstants);
        }

        private IWSRMSequence initializeOfferedSequence(Map parameterConstants) throws Exception {
            String serializedRMEngine = null;
            IWSRMSequence sequence = null;
            XQParameters params = WSInvocationScriptObject.this.getXQParameters();
            if (params != null) {
                serializedRMEngine = (String)params.getParameterObject("SonicESB.RM.SequenceMap", 1);
            }
            if (serializedRMEngine == null) {
                WSInvocationScriptObject.this.logDebug("No serialized engine, checking for offered sequence");
                serializedRMEngine = (String)parameterConstants.get("SonicESB.RM.SequenceMap");
                if (serializedRMEngine == null) {
                    WSInvocationScriptObject.this.logDebug("No serialized engine, checking for WSA headers");
                    WSAHeaders wsaHeaders = (WSAHeaders)parameterConstants.get("SonicESB.RM.WSAHeaders");
                    if (wsaHeaders != null) {
                        WSInvocationScriptObject.this.logDebug("WSA headers found, checking for OfferID");
                        Object offerID = parameterConstants.get("SonicESB.RM.Param.OfferID");
                        if (offerID != null) {
                            WSInvocationScriptObject.this.logDebug("Got OfferID and WSA-Headers, creating sequence from OfferID");
                            IWSRMEngine rmEngine = WSRMEngineFactory.create(null);
                            WSInvocationScriptObject.this.logDebug("wsaHeaders.getEffectiveReplyTo()=" + wsaHeaders.getEffectiveReplyTo());
                            WSInvocationScriptObject.this.logDebug("wsaHeaders.getEffectiveFaultTo()=" + wsaHeaders.getEffectiveFaultTo());
                            WSEndpointReferenceImpl endpointRef = new WSEndpointReferenceImpl(wsaHeaders.getEffectiveReplyTo());
                            sequence = rmEngine.createSequence((IWSEndpointReference)endpointRef, (String)offerID);
                            rmEngine.incrementSequence(sequence);
                            WSInvocationScriptObject.this.logDebug("Offered sequence id=" + sequence.getSequenceID() + " number=" + sequence.getSequenceNumber());
                            serializedRMEngine = rmEngine.serialize();
                        }
                    }
                }
                if (serializedRMEngine != null) {
                    WSInvocationScriptObject.this.logDebug("Serializing RM engine:" + serializedRMEngine);
                    parameterConstants.put("SonicESB.RM.SequenceMap", serializedRMEngine);
                }
            }
            return sequence;
        }

        private String chooseWSANamespace() {
            String deflt = this.m_scriptCommand.getWSANamespace();
            if (deflt != null) {
                return deflt;
            }
            deflt = !WSInvocationScriptObject.this.m_runningInContainer ? AddressingUtils.getDefaultNS() : XQContainer.getDefaultWSANamespace();
            if (WSInvocationScriptObject.this.m_namespaces == null) {
                return deflt;
            }
            List<Namespace> l = WSInvocationScriptObject.this.m_namespaces.getNamespaceList();
            for (Namespace na : l) {
                String n = na.getNamespaceUri();
                if (AddressingUtils.isAddressingNS(n)) {
                    return n;
                }
                if (!AddressingUtils.isAddressingBindingNS(n)) continue;
                return AddressingUtils.addressingNSFromBindingNS(n);
            }
            return deflt;
        }

        private void addCurrentMessageProperties(Map params) {
            String corrId = null;
            XQMessage msg = WSInvocationScriptObject.this.getXQMessage();
            if (msg == null) {
                return;
            }
            try {
                corrId = msg.getCorrelationId();
            }
            catch (XQMessageException e) {
                m_categoryLog.logWarning((Throwable)e);
            }
            params.put("JMSCorrelationID", corrId);
        }

        private void addWSAProperties(Map parameterConstants) {
            WSAHeaders WSAHeaders2;
            if (parameterConstants == null) {
                return;
            }
            if (WSInvocationScriptObject.this.getXQParameters() == null) {
                return;
            }
            String serializedEngine = (String)WSInvocationScriptObject.this.getXQParameters().getParameterObject("SonicESB.RM.SequenceMap", 1);
            if (serializedEngine != null) {
                parameterConstants.put("SonicESB.RM.SequenceMap", serializedEngine);
            }
            if ((WSAHeaders2 = (WSAHeaders)WSInvocationScriptObject.this.getXQParameters().getParameterObject("SonicESB.RM.WSAHeaders", 3)) != null) {
                parameterConstants.put("SonicESB.RM.WSAHeaders", WSAHeaders2);
            }
            parameterConstants.put("SonicESB.RM.ESBWSType", this.m_scriptCommand.getESBWSTypeName());
            try {
                XQAddress jmsReplyTo = WSInvocationScriptObject.this.getXQMessage().getReplyTo();
                if (jmsReplyTo != null) {
                    parameterConstants.put("SonicESB.RM.JMSReplyTo", jmsReplyTo.toString());
                }
            }
            catch (Exception ex) {
                m_categoryLog.logError((Throwable)ex);
            }
        }
    }
}

