/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.ws.rm;

import com.sonicsw.esb.ws.rm.IWSEndpointReference;
import com.sonicsw.esb.ws.rm.IWSRMEngine;
import com.sonicsw.esb.ws.rm.IWSRMSequence;
import com.sonicsw.esb.ws.rm.IWSRMSequenceContext;
import com.sonicsw.esb.ws.rm.IWSReliableInvocation;
import com.sonicsw.esb.ws.rm.WSRMException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.ParameterDirection;
import com.sonicsw.xqimpl.script.ParameterMap;
import com.sonicsw.xqimpl.script.ParameterValueFactory;
import com.sonicsw.xqimpl.script.VariableDirection;
import com.sonicsw.xqimpl.script.XMLParameterValue;
import com.sonicsw.xqimpl.service.wsinvk.WSInvocationScriptEngine;
import com.sonicsw.xqimpl.service.wsinvk.WSInvocationScriptObject;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import com.sonicsw.xqimpl.ws.rm.RMScriptCommand;
import com.sonicsw.xqimpl.ws.rm.SequenceCapsule;
import com.sonicsw.xqimpl.ws.rm.SequenceMap;
import com.sonicsw.xqimpl.ws.rm.WSRMConstants;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpression;
import net.sf.saxon.value.Value;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSRMEngineImpl
implements IWSRMEngine {
    private static XQLog log = XQLogImpl.getCategoryLog((int)16384);
    private static XMLUtils m_xmlUtils;
    private static ThreadLocal m_rmScripts;
    private WSInvocationScriptEngine m_scriptEngine = null;
    private SequenceMap m_sequenceMap = null;

    public WSRMEngineImpl() {
        this.setScriptEngine(new WSInvocationScriptEngine(null));
    }

    public void setSequenceMap(SequenceMap map) {
        this.m_sequenceMap = map;
    }

    public SequenceMap getSequenceMap() {
        return this.m_sequenceMap;
    }

    public final void setScriptEngine(WSInvocationScriptEngine engine) {
        this.m_scriptEngine = engine;
    }

    public IWSRMSequence incrementSequence(IWSRMSequence sequence) throws WSRMException {
        IWSEndpointReference mapKey = this.getKeyForSequence(sequence);
        IWSRMSequence nextCapsule = this.m_sequenceMap.getSequence(mapKey).getNext();
        log.logDebug("IncrementSequence(Seq): Next sequence number for id: " + nextCapsule.getSequenceID() + "=" + nextCapsule.getSequenceNumber());
        this.m_sequenceMap.put(mapKey, nextCapsule);
        return nextCapsule;
    }

    private IWSEndpointReference getKeyForSequence(IWSRMSequence sequence) throws WSRMException {
        Set sequences = this.m_sequenceMap.keySet();
        for (Object keyObj : sequences) {
            Object mapSequence = this.m_sequenceMap.get(keyObj);
            if (!sequence.equals(mapSequence)) continue;
            return (IWSEndpointReference)keyObj;
        }
        throw new WSRMException("Sequence not found: " + sequence);
    }

    public IWSRMSequence getSequence(IWSEndpointReference sequenceKey) {
        IWSRMSequence sequence = this.m_sequenceMap.getSequence(sequenceKey);
        return sequence;
    }

    public IWSRMSequence createSequence(IWSEndpointReference sequenceKey, String offerID) throws WSRMException {
        SequenceCapsule sequence = new SequenceCapsule(offerID, sequenceKey.getAddressURL());
        this.m_sequenceMap.putSequence(sequenceKey, sequence);
        return sequence;
    }

    public IWSRMSequence createSequence(IWSEndpointReference sequenceKey, IWSReliableInvocation targetInvocation, Map runtimeParams) throws WSRMException {
        String id = this.createSequenceIdentifier(targetInvocation, runtimeParams);
        SequenceCapsule sequence = new SequenceCapsule(id, targetInvocation, runtimeParams);
        this.m_sequenceMap.putSequence(sequenceKey, sequence);
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSequenceIdentifier(IWSReliableInvocation targetInvocation, Map runtimeParams) throws WSRMException {
        log.logDebug("Creating sequence identifier for invocation: " + targetInvocation.getSOAPEndpointURL());
        try {
            XPathExpression expr;
            List results;
            RMScriptCommand rc = this.getRMScriptFromCache("com/sonicsw/xqimpl/ws/rm/CreateSequence_ScriptCommand.xml");
            WSInvocationScriptObject scriptObj = rc.getScript();
            WSInvocationScriptObject.WSInvocationScriptCommand scriptCmd = rc.getCommand();
            scriptCmd.getScriptCommand().setEffectivePolicy(targetInvocation.getEffectivePolicy());
            scriptCmd.getScriptCommand().setResponsePolicy(targetInvocation.getResponsePolicy());
            scriptCmd.getScriptCommand().setSOAPEndpointURL(targetInvocation.getSOAPEndpointURL());
            ParameterValueFactory pvf = new ParameterValueFactory(false);
            ArrayList<IParameterValue> parameters = new ArrayList<IParameterValue>();
            String msgBody = WSRMEngineImpl.generateCreateSequenceRequestBody(targetInvocation);
            IParameterValue p = pvf.createParameterValue("create", "xsd:anyType", msgBody);
            p.setDisplayType("xsd:anyType");
            p.setDirection(ParameterDirection.IN);
            parameters.add(p);
            p = pvf.createParameterValue("createResponse", "xsd:anyType", "<dummy/>");
            p.setDirection(ParameterDirection.OUT);
            p.setDisplayType("xsd:anyType");
            parameters.add(p);
            p = pvf.createParameterValue("RawSoapResponse", "xsd:anyType", "<dummy/>");
            p.setDirection(ParameterDirection.OUT);
            p.setDisplayType("xsd:anyType");
            parameters.add(p);
            p = pvf.createParameterValue("RawSoapRequest", "xsd:anyType", "<dummy/>");
            p.setDirection(ParameterDirection.OUT);
            p.setDisplayType("xsd:anyType");
            parameters.add(p);
            HashMap<Object, Object> parameterConstants = new HashMap<Object, Object>();
            if (runtimeParams != null) {
                parameterConstants.putAll(runtimeParams);
            }
            parameterConstants.put(WSRMConstants.SOAP_ACTION, WSRMConstants.CREATE_SEQUENCE_SOAPACTION);
            parameterConstants.put("X-HTTP-ReplyAsSOAP", Boolean.TRUE);
            String policy = targetInvocation.getEffectivePolicy();
            parameterConstants.put("X-WS-MessagePolicy", policy);
            if (!parameterConstants.containsKey("X-WS-SequenceFaultDestination")) {
                parameterConstants.put("X-WS-SequenceFaultDestination", "SonicESB.AsynchronousWSFault");
            }
            if ((results = scriptCmd.execute(parameters, parameterConstants)) == null || results.isEmpty()) {
                throw new WSRMException("CreateSequence command returned no results.");
            }
            boolean RESULT_INDEX = false;
            String resultXML = ((XMLParameterValue)results.get(0)).getAsString();
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(resultXML);
            }
            XMLUtils u = WSRMEngineImpl.getXMLUtils();
            String id = null;
            String RESULT_XPATH = "/wsrm:CreateSequenceResponse/wsrm:Identifier";
            XPathExpression xPathExpression = expr = u.retrieveExpression(RESULT_XPATH);
            synchronized (xPathExpression) {
                Value v = u.computeXPath(resultXML, expr);
                id = v.toString();
            }
            log.logDebug("Created sequence identifier: " + id + " for invocation: " + targetInvocation.getSOAPEndpointURL());
            return id;
        }
        catch (WSRMException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new WSRMException((Throwable)e2);
        }
    }

    private boolean terminateSequenceInternal(IWSEndpointReference sequenceKey, IWSRMSequenceContext context) throws WSRMException {
        log.logDebug("Terminating sequence for key: " + sequenceKey);
        IWSRMSequence sequence = this.m_sequenceMap.getSequence(sequenceKey);
        if (sequence == null) {
            throw new WSRMException("Sequence not found for key: " + sequenceKey.toString());
        }
        if (sequence.getSequenceContext() != null && !sequence.getSequenceContext().equals(context)) {
            return false;
        }
        sequence = sequence.getNext();
        this.terminateSequenceInternal(sequenceKey, sequence);
        return true;
    }

    public void terminateSequence(IWSRMSequence sequence) throws WSRMException {
        IWSEndpointReference mapKey = this.getKeyForSequence(sequence);
        IWSRMSequence mapSequence = this.m_sequenceMap.getSequence(mapKey);
        this.terminateSequenceInternal(mapKey, mapSequence);
        this.m_sequenceMap.remove(mapKey);
    }

    public void removeSequence(IWSRMSequence sequence) throws WSRMException {
        log.logDebug("removeSequence: Sequence=" + sequence);
        IWSEndpointReference sequenceKey = this.getKeyForSequence(sequence);
        this.m_sequenceMap.remove(sequenceKey);
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("After removeSequence: map=" + this.serialize());
        }
    }

    private static synchronized XMLUtils getXMLUtils() throws Exception {
        if (m_xmlUtils != null) {
            return m_xmlUtils;
        }
        boolean cacheEnabled = true;
        Hashtable<String, String> nspaces = new Hashtable<String, String>();
        nspaces.put("soapenv", WSRMConstants.NAMESPACEURI_SOAP_ENVELOPE);
        nspaces.put("wsrm", WSRMConstants.NAMESPACEURI_WSRM_FEB2005);
        nspaces.put("wsa", WSRMConstants.NAMESPACEURI_WSA_AUG2004);
        m_xmlUtils = new XMLUtils(nspaces, cacheEnabled);
        return m_xmlUtils;
    }

    private void terminateSequenceInternal(IWSEndpointReference sequenceKey, IWSRMSequence sequence) throws WSRMException {
        log.logDebug("Terminating sequence: id=" + sequence.getSequenceID() + "number=" + sequence.getSequenceNumber() + " targetURL=" + sequence.getRMEndpointURL());
        try {
            List results;
            RMScriptCommand rc = this.getRMScriptFromCache("com/sonicsw/xqimpl/ws/rm/TerminateSequence_ScriptCommand.xml");
            WSInvocationScriptObject scriptObj = rc.getScript();
            WSInvocationScriptObject.WSInvocationScriptCommand scriptCmd = rc.getCommand();
            scriptCmd.getScriptCommand().setEffectivePolicy(sequence.getPolicy());
            if (sequenceKey != null) {
                scriptCmd.getScriptCommand().setSOAPEndpointURL(sequenceKey.getAddressURL());
            } else {
                scriptCmd.getScriptCommand().setSOAPEndpointURL(sequence.getRMEndpointURL());
            }
            ParameterMap paramMap = new ParameterMap(null, scriptObj);
            paramMap.add("RawSoapRequest", VariableDirection.OUT, null);
            scriptObj.setParameterMap(paramMap);
            scriptCmd.setScriptObject(scriptObj);
            ParameterValueFactory pvf = new ParameterValueFactory(false);
            ArrayList<IParameterValue> parameters = new ArrayList<IParameterValue>();
            IParameterValue p = pvf.createParameterValue("RawSoapRequest", "xsd:anyType", "<dummy/>");
            p.setDirection(ParameterDirection.OUT);
            p.setDisplayType("xsd:anyType");
            parameters.add(p);
            HashMap<String, Object> parameterConstants = new HashMap<String, Object>();
            Map runtimeParams = sequence.getRuntimeParameters();
            if (runtimeParams != null) {
                parameterConstants.putAll(runtimeParams);
            }
            parameterConstants.put("X-HTTP-ReplyAsSOAP", Boolean.TRUE);
            parameterConstants.put("JMSXGroupID", sequence.getSequenceID());
            parameterConstants.put("JMSXGroupSeq", new Integer(sequence.getSequenceNumber()).toString());
            parameterConstants.put("JMS_SonicMQ_lastMessageInGroup", "true");
            parameterConstants.put("X-WS-MessagePolicy", sequence.getPolicy());
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("terminateSequenceInternal: using policy from sequence=" + sequence.getPolicy());
                log.logDebug("terminateSequenceInternal: url=" + sequence.getRMEndpointURL());
                log.logDebug("terminateSequenceInternal:  id=" + sequence.getSequenceID());
                log.logDebug("terminateSequenceInternal: num=" + sequence.getSequenceNumber());
            }
            if ((results = scriptCmd.execute(parameters, parameterConstants)) == null) {
                throw new WSRMException("No results from TerminateSequence");
            }
            if (results.size() != 1) {
                throw new WSRMException("Unexpected results from TerminateSequence, result size=" + results.size());
            }
            log.logDebug("terminateSequenceInternal: RawSoapRequest=" + ((XMLParameterValue)results.get(0)).getAsString());
        }
        catch (WSRMException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new WSRMException((Throwable)e2);
        }
    }

    public void terminateAllSequences(IWSRMSequenceContext context) throws WSRMException {
        log.logDebug("TerminateAllSequences for context: " + context.toString());
        Iterator iter = this.m_sequenceMap.keySet().iterator();
        while (iter.hasNext()) {
            IWSEndpointReference key = (IWSEndpointReference)iter.next();
            log.logDebug("Terminating Sequence for key=" + key);
            if (!this.terminateSequenceInternal(key, context)) continue;
            iter.remove();
        }
        log.logDebug("TerminateAllSequences: done");
    }

    public static String generateCreateSequenceRequestBody(IWSReliableInvocation invocation) {
        String wsaURI = invocation.getWSANamespace();
        if (wsaURI == null) {
            wsaURI = WSRMConstants.NAMESPACEURI_WSA_AUG2004;
        }
        String xml = "<wsrm:CreateSequence  xmlns:wsrm=\"" + WSRMConstants.NAMESPACEURI_WSRM_FEB2005 + "\"" + "  xmlns:wsa=\"" + wsaURI + "\">";
        if (invocation.isRequestResponse()) {
            xml = xml + "   <wsrm:Offer>     <wsrm:Identifier>REQUEST_SYSTEM_ASSIGNED</wsrm:Identifier>   </wsrm:Offer>";
        }
        xml = xml + "</wsrm:CreateSequence>";
        return xml;
    }

    private Element getResourceAsElement(String resourceName) throws WSRMException {
        try {
            InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            InputSource inSource = new InputSource(inStream);
            Element doc = DOMUtils.getDocumentBuilder().parse(inSource).getDocumentElement();
            return doc;
        }
        catch (Exception e) {
            throw new WSRMException("Error retrieving resource:" + resourceName);
        }
    }

    public String serialize() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.m_sequenceMap.serialize());
        return buff.toString();
    }

    private RMScriptCommand getRMScriptFromCache(String path) throws Exception {
        RMScriptCommand script;
        HashMap<String, RMScriptCommand> scriptCache = (HashMap<String, RMScriptCommand>)m_rmScripts.get();
        if (scriptCache == null) {
            scriptCache = new HashMap<String, RMScriptCommand>();
            m_rmScripts.set(scriptCache);
        }
        if ((script = (RMScriptCommand)scriptCache.get(path)) == null) {
            script = this.createScript(path);
            scriptCache.put(path, script);
        }
        return script;
    }

    public RMScriptCommand createScript(String path) throws Exception {
        Element doc = this.getResourceAsElement(path);
        WSInvocationScriptObject scriptObj = (WSInvocationScriptObject)this.m_scriptEngine.createScriptObject();
        WSInvocationScriptObject.WSInvocationScriptCommand scriptCmd = (WSInvocationScriptObject.WSInvocationScriptCommand)scriptObj.createScriptCommand(doc);
        return new RMScriptCommand(scriptObj, scriptCmd);
    }

    static {
        m_rmScripts = new ThreadLocal();
    }
}

