/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import modelobjects.expr.Expression;
import modelobjects.expr.PostEvalConverter;
import modelobjects.util.ObjectWrapper;

class CallExpression
extends Expression {
    protected Expression baseExpr;
    protected String methodName;
    protected Vector argExprs;
    protected boolean isStatic;
    protected transient Method method;

    CallExpression(Expression baseExpr, String methodName, Vector argExprs) {
        this(baseExpr, methodName, argExprs, false);
    }

    CallExpression(Expression baseExpr, String methodName, Vector argExprs, boolean isStaticMethod) {
        this.baseExpr = baseExpr;
        this.methodName = methodName;
        this.argExprs = argExprs;
        this.isStatic = isStaticMethod;
    }

    @Override
    protected Object eval1(Object rootObject, PostEvalConverter cvtr, int rule) throws Exception {
        Method m2;
        Object base = this.baseExpr.eval(rootObject, cvtr, rule);
        if (base instanceof ObjectWrapper) {
            base = ((ObjectWrapper)base).getWrappedObject();
        }
        Class<?> targetClass = base.getClass();
        int nargs = this.argExprs.size();
        Object[] args = new Object[nargs];
        for (int i = 0; i < nargs; ++i) {
            Expression argExpr = (Expression)this.argExprs.elementAt(i);
            args[i] = argExpr.eval(rootObject, cvtr, rule);
        }
        if (this.method == null) {
            this.method = this.findMethod(base, this.methodName, args);
        }
        if (this.method == null) {
            throw new NoSuchMethodException("no method " + this.methodName + " in " + base.getClass());
        }
        if (!this.isStatic && !Modifier.isPublic(targetClass.getModifiers()) && (m2 = this.findInPublicClass(targetClass, this.method, true)) != null) {
            this.method = m2;
        }
        return this.method.invoke(this.isStatic ? null : base, args);
    }

    protected Method findMethod(Object base, String methodName, Object[] args) {
        Class<?> baseCl = base.getClass();
        if (this.isStatic) {
            try {
                baseCl = Class.forName((String)base);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        Method[] methods = baseCl.getMethods();
        int nargs = args.length;
        Object result = null;
        block2: for (int i = methods.length - 1; i >= 0; --i) {
            boolean isStatic;
            Class<?>[] paramTypes;
            Method m = methods[i];
            boolean match = false;
            if (!m.getName().equals(methodName) || (paramTypes = m.getParameterTypes()).length != nargs) continue;
            for (int j = 0; j < nargs; ++j) {
                Class<?> t = paramTypes[j];
                Object arg = args[j];
                if (t.isPrimitive() ? arg == null || !this.primTypeMatch(arg.getClass(), t) : arg != null && !t.isInstance(arg)) continue block2;
            }
            boolean bl = isStatic = (m.getModifiers() & 8) != 0;
            if (isStatic != this.isStatic) {
                return null;
            }
            return m;
        }
        return null;
    }

    Method findInPublicClass(Class cl, Method method, boolean searchSuperclasses) {
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        Method publicMethod = null;
        Class<?>[] ifaces = cl.getInterfaces();
        int numIfaces = ifaces == null ? 0 : ifaces.length;
        for (int i = 0; i < numIfaces; ++i) {
            Class<?> iface = ifaces[i];
            if (Modifier.isPublic(iface.getModifiers())) {
                try {
                    return iface.getMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
            }
            if ((publicMethod = this.findInPublicClass(iface, method, false)) == null) continue;
            return publicMethod;
        }
        if (searchSuperclasses && cl != Object.class) {
            Class supercl = cl.getSuperclass();
            if (Modifier.isPublic(supercl.getModifiers())) {
                try {
                    return supercl.getMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
            }
            if ((publicMethod = this.findInPublicClass(supercl, method, true)) != null) {
                return publicMethod;
            }
        }
        return null;
    }

    boolean primTypeMatch(Class objClass, Class primClass) {
        if (objClass == Boolean.class) {
            return primClass == Boolean.TYPE;
        }
        if (objClass == Integer.class) {
            return primClass == Integer.TYPE;
        }
        if (objClass == Long.class) {
            return primClass == Long.TYPE;
        }
        if (objClass == Character.class) {
            return primClass == Character.TYPE;
        }
        if (objClass == Byte.class) {
            return primClass == Byte.TYPE;
        }
        if (objClass == Double.class) {
            return primClass == Double.TYPE;
        }
        if (objClass == Float.class) {
            return primClass == Float.TYPE;
        }
        if (objClass == Short.class) {
            return primClass == Short.TYPE;
        }
        return false;
    }

    public String toString() {
        int nargs = this.argExprs.size();
        StringBuilder argsBuf = new StringBuilder();
        for (int i = 0; i < nargs; ++i) {
            argsBuf.append(this.argExprs.elementAt(i));
            if (i >= nargs - 1) continue;
            argsBuf.append(",");
        }
        String baseString = "?UnknownClass?";
        try {
            baseString = this.isStatic ? (String)this.baseExpr.eval(null, null, JAVA_EVAL) : this.baseExpr.toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        return "(" + baseString + "." + this.methodName + "(" + argsBuf + "))";
    }
}

