/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import java.lang.reflect.Constructor;
import java.util.Vector;
import modelobjects.expr.Expression;
import modelobjects.expr.PostEvalConverter;

class CtorExpression
extends Expression {
    protected String ctorClassName;
    protected Vector argExprs;
    protected transient Class ctorClass;
    protected transient Constructor ctor;

    CtorExpression(String ctorClassName, Vector argExprs) {
        this.ctorClassName = ctorClassName;
        this.argExprs = argExprs;
    }

    @Override
    protected Object eval1(Object rootObject, PostEvalConverter cvtr, int rule) throws Exception {
        int nargs = this.argExprs.size();
        Object[] args = new Object[nargs];
        for (int i = 0; i < nargs; ++i) {
            Expression argExpr = (Expression)this.argExprs.elementAt(i);
            args[i] = argExpr.eval(rootObject, cvtr, rule);
        }
        if (this.ctorClass == null) {
            this.ctorClass = Class.forName(this.ctorClassName);
        }
        if (this.ctor == null) {
            this.ctor = this.findConstructor(this.ctorClass, args);
        }
        if (this.ctor == null) {
            throw new NoSuchMethodException("no matching constructor for " + this.ctorClass);
        }
        return this.ctor.newInstance(args);
    }

    protected Constructor findConstructor(Class ctorClass, Object[] args) {
        Constructor<?>[] ctors = ctorClass.getConstructors();
        int numCtors = ctors == null ? 0 : ctors.length;
        int nargs = args.length;
        Object result = null;
        block0: for (int i = numCtors - 1; i >= 0; --i) {
            Constructor<?> ctor = ctors[i];
            boolean match = false;
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != nargs) continue;
            for (int j = 0; j < nargs; ++j) {
                Class<?> t = paramTypes[j];
                Object arg = args[j];
                if (t.isPrimitive() ? arg == null || !this.primTypeMatch(arg.getClass(), t) : arg != null && !t.isInstance(arg)) continue block0;
            }
            return ctor;
        }
        return null;
    }

    boolean primTypeMatch(Class objClass, Class primClass) {
        if (objClass == Boolean.class) {
            return primClass == Boolean.TYPE;
        }
        if (objClass == Integer.class) {
            return primClass == Integer.TYPE;
        }
        if (objClass == Long.class) {
            return primClass == Long.TYPE;
        }
        if (objClass == Character.class) {
            return primClass == Character.TYPE;
        }
        if (objClass == Byte.class) {
            return primClass == Byte.TYPE;
        }
        if (objClass == Double.class) {
            return primClass == Double.TYPE;
        }
        if (objClass == Float.class) {
            return primClass == Float.TYPE;
        }
        if (objClass == Short.class) {
            return primClass == Short.TYPE;
        }
        return false;
    }

    public String toString() {
        int nargs = this.argExprs.size();
        StringBuilder argsBuf = new StringBuilder();
        for (int i = 0; i < nargs; ++i) {
            argsBuf.append(this.argExprs.elementAt(i));
            if (i >= nargs - 1) continue;
            argsBuf.append(",");
        }
        return "(new " + this.ctorClassName + "(" + argsBuf + "))";
    }
}

