/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import java.awt.Button;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import modelobjects.expr.ArithmeticExpression;
import modelobjects.expr.ArrayIndexExpression;
import modelobjects.expr.CallExpression;
import modelobjects.expr.ComparisonExpression;
import modelobjects.expr.CtorExpression;
import modelobjects.expr.Expression;
import modelobjects.expr.LiteralExpression;
import modelobjects.expr.ParseException;
import modelobjects.expr.PropertyExpression;
import modelobjects.expr.RootObjectReference;
import modelobjects.expr.ShortCircuitExpression;
import modelobjects.expr.UnaryExpression;
import modelobjects.util.Lexer;
import modelobjects.util.LexerTokenTypes;

public class ExprParser
implements LexerTokenTypes {
    private static final boolean DEBUG = false;
    private Lexer lexer;
    private int tokenType = 0;
    private boolean caseSensitive;
    private Vector importedClasses;

    public ExprParser() {
        this.lexer = null;
        this.caseSensitive = true;
    }

    public ExprParser(String inString) {
        this(new StringReader(inString));
    }

    public ExprParser(Reader reader) {
        this.caseSensitive = true;
        this.initLexer(reader);
    }

    public Vector getImportedClasses() {
        return this.importedClasses;
    }

    public void setImportedClasses(Vector classes) {
        this.importedClasses = classes;
    }

    public void addImportedClasses(Vector classes) {
        if (this.importedClasses == null) {
            this.importedClasses = classes;
        } else {
            int num = classes == null ? 0 : classes.size();
            for (int i = 0; i < num; ++i) {
                this.importedClasses.addElement(classes.elementAt(i));
            }
        }
    }

    public void addImportedClass(Class aClass) {
        if (this.importedClasses == null) {
            this.importedClasses = new Vector();
        }
        this.importedClasses.addElement(aClass);
    }

    public boolean getPropertyNamesAreCaseSensitive() {
        return this.caseSensitive;
    }

    public void setPropertyNamesAreCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Expression parse(String inString) throws ParseException {
        this.initLexer(new StringReader(inString));
        return this.parse();
    }

    public Expression parse() throws ParseException {
        try {
            Expression result = this.expression(this.getToken());
            if (this.tokenType == 0) {
                this.getToken();
            }
            if (this.tokenType != -1 && this.tokenType != 65535) {
                throw new ParseException("Syntax error after " + result.toString() + " starting with " + this.currentTokenString(this.tokenType) + " (type " + this.tokenType + " )" + " on line " + this.lexer.getTokenLineNumber());
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseException("Error: " + e);
        }
    }

    private static String opName(int op) {
        return Lexer.getOperatorName(op);
    }

    private void initLexer(Reader reader) {
        this.lexer = new Lexer(reader);
        this.lexer.setIdStyle(1);
        this.lexer.setLexSlashSlashComments(false);
        this.lexer.setLexSlashStarComments(false);
        this.lexer.setUseBackslashEscapes(true);
    }

    private void debug(String s) {
    }

    int getToken() throws IOException {
        int ttype;
        this.tokenType = ttype = this.lexer.getToken();
        return ttype;
    }

    void ungetToken() throws IOException {
        this.lexer.pushBack();
        this.tokenType = 0;
    }

    boolean equiv(String s1, String s2) {
        if (s1 == s2 || s1.equals(s2)) {
            return true;
        }
        if (this.caseSensitive) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    String currentTokenString(int ttype) {
        return this.lexer.getTokenString(ttype);
    }

    Expression expression(int ttype) throws IOException {
        Expression e = this.logicalOrExpression(ttype);
        return e;
    }

    Expression logicalOrExpression(int ttype) throws IOException {
        Expression e1 = this.logicalAndExpression(ttype);
        while ((ttype = this.getToken()) == -63) {
            Expression e2 = this.logicalAndExpression(this.getToken());
            e1 = new ShortCircuitExpression(-63, e1, e2);
        }
        this.ungetToken();
        return e1;
    }

    Expression logicalAndExpression(int ttype) throws IOException {
        Expression e1 = this.equalityExpression(ttype);
        while ((ttype = this.getToken()) == -62) {
            Expression e2 = this.equalityExpression(this.getToken());
            e1 = new ShortCircuitExpression(-62, e1, e2);
        }
        this.ungetToken();
        return e1;
    }

    Expression equalityExpression(int ttype) throws IOException {
        Expression e1 = this.relationalExpression(ttype);
        while ((ttype = this.getToken()) == -21 || ttype == -22) {
            Expression e2 = this.relationalExpression(this.getToken());
            e1 = new ComparisonExpression(ttype, e1, e2);
        }
        this.ungetToken();
        return e1;
    }

    Expression relationalExpression(int ttype) throws IOException {
        Expression e1 = this.additiveExpression(ttype);
        block3: while (true) {
            ttype = this.getToken();
            switch (ttype) {
                case -26: 
                case -25: 
                case -24: 
                case -23: {
                    Expression e2 = this.additiveExpression(this.getToken());
                    e1 = new ComparisonExpression(ttype, e1, e2);
                    continue block3;
                }
            }
            break;
        }
        this.ungetToken();
        return e1;
    }

    Expression additiveExpression(int ttype) throws IOException {
        Expression e1 = this.multiplicativeExpression(ttype);
        while ((ttype = this.getToken()) == -30 || ttype == -31) {
            Expression e2 = this.multiplicativeExpression(this.getToken());
            e1 = new ArithmeticExpression(ttype, e1, e2);
        }
        this.ungetToken();
        return e1;
    }

    Expression multiplicativeExpression(int ttype) throws IOException {
        Expression e1 = this.unaryExpression(ttype);
        while ((ttype = this.getToken()) == -32 || ttype == -33 || ttype == -57) {
            Expression e2 = this.unaryExpression(this.getToken());
            e1 = new ArithmeticExpression(ttype, e1, e2);
        }
        this.ungetToken();
        return e1;
    }

    Expression unaryExpression(int ttype) throws IOException {
        switch (ttype) {
            case -64: 
            case -31: 
            case -30: {
                return new UnaryExpression(ttype, this.unaryExpression(this.getToken()));
            }
        }
        return this.postfixExpression(ttype);
    }

    Expression postfixExpression(int ttype) throws IOException {
        Expression e1;
        block6: {
            e1 = this.primaryExpression(ttype);
            while (true) {
                if ((ttype = this.getToken()) == -50) {
                    ttype = this.getToken();
                    if (ttype == -10) {
                        e1 = new PropertyExpression(this.lexer.getTokenSource(), e1, this.caseSensitive);
                        continue;
                    }
                    throw new ParseException("Syntax error: expected property name after dot: " + this.currentTokenString(ttype));
                }
                if (ttype == -40) {
                    Vector argExprs = this.expressionList(this.getToken());
                    if (e1 instanceof PropertyExpression) {
                        PropertyExpression propExpr = (PropertyExpression)e1;
                        Expression base = propExpr.getBaseExpression();
                        String methodName = propExpr.getPropertyName();
                        String staticMethodClassName = this.findClassForStaticCall(methodName, base);
                        if (staticMethodClassName != null) {
                            base = new LiteralExpression(staticMethodClassName);
                            e1 = new CallExpression(base, methodName, argExprs, true);
                            continue;
                        }
                        e1 = new CallExpression(base, methodName, argExprs, false);
                        continue;
                    }
                    throw new ParseException("illegal base for call expression");
                }
                if (ttype != -44) break block6;
                Expression e2 = this.expression(this.getToken());
                ttype = this.getToken();
                if (ttype != -45) break;
                e1 = new ArrayIndexExpression(e1, e2);
            }
            throw new ParseException("Syntax error in index expression");
        }
        this.ungetToken();
        return e1;
    }

    String findClassForStaticCall(String methodName, Expression exprBase) {
        block10: {
            Vector classes;
            block9: {
                classes = this.importedClasses;
                if (exprBase != null && !(exprBase instanceof RootObjectReference)) break block9;
                int num = classes == null ? 0 : classes.size();
                for (int i = 0; i < num; ++i) {
                    Class cl = (Class)classes.elementAt(i);
                    for (Method method : cl.getMethods()) {
                        int mods;
                        String name = method.getName();
                        if (!this.equiv(name, methodName) || !Modifier.isStatic(mods = method.getModifiers()) || !Modifier.isPublic(mods)) continue;
                        return cl.getName();
                    }
                }
                break block10;
            }
            if (!(exprBase instanceof PropertyExpression)) break block10;
            String name = exprBase.toString();
            int lastDotPos = name.lastIndexOf(46);
            if (lastDotPos != -1) {
                try {
                    Class<?> cl = Class.forName(name);
                    if (cl != null) {
                        return cl.getName();
                    }
                }
                catch (ClassNotFoundException noSuchClass) {
                }
                catch (RuntimeException badClassNameFormat) {
                    // empty catch block
                }
            }
            int num = classes == null ? 0 : classes.size();
            for (int i = 0; i < num; ++i) {
                Class cl = (Class)classes.elementAt(i);
                String className = cl.getName();
                if (lastDotPos == -1) {
                    String clName;
                    int p2 = className.lastIndexOf(46);
                    String string = clName = p2 == -1 ? className : className.substring(p2 + 1);
                    if (!this.equiv(clName, name)) continue;
                    return className;
                }
                if (!this.equiv(className, name)) continue;
                return className;
            }
        }
        return null;
    }

    Vector expressionList(int ttype) throws IOException {
        Vector<Expression> result = new Vector<Expression>();
        block4: while (ttype != -41) {
            Expression arg = this.expression(ttype);
            result.addElement(arg);
            ttype = this.getToken();
            switch (ttype) {
                case -51: {
                    ttype = this.getToken();
                    continue block4;
                }
                case -41: {
                    continue block4;
                }
            }
            throw new ParseException("Syntax error in argument list");
        }
        return result;
    }

    String findClassForCtor(String ctorClassName) {
        int dotPos = ctorClassName.lastIndexOf(46);
        if (dotPos != -1) {
            try {
                Class<?> ctorClass = Class.forName(ctorClassName);
                if (ctorClass != null) {
                    return ctorClass.getName();
                }
            }
            catch (ClassNotFoundException noSuchClass) {
            }
            catch (RuntimeException badClassNameFormat) {
                // empty catch block
            }
            return null;
        }
        String qualifiedClassNameSuffix = "." + ctorClassName;
        Vector importedClasses = this.importedClasses;
        int num = importedClasses == null ? 0 : importedClasses.size();
        for (int i = 0; i < num; ++i) {
            Class cl = (Class)importedClasses.elementAt(i);
            if (!cl.getName().endsWith(qualifiedClassNameSuffix)) continue;
            return cl.getName();
        }
        return null;
    }

    Expression primaryExpression(int ttype) throws IOException {
        switch (ttype) {
            case -10: {
                String s = this.lexer.getTokenSource();
                if ("true".equals(s)) {
                    return new LiteralExpression(Boolean.TRUE);
                }
                if ("false".equals(s)) {
                    return new LiteralExpression(Boolean.FALSE);
                }
                if ("null".equals(s)) {
                    return new LiteralExpression(null);
                }
                if ("this".equals(s)) {
                    return new RootObjectReference();
                }
                if ("new".equals(s)) {
                    ttype = this.getToken();
                    StringBuilder ctorClassNameBuffer = new StringBuilder();
                    boolean classNameOK = false;
                    if (ttype == -10) {
                        classNameOK = true;
                        ctorClassNameBuffer.append(this.lexer.getTokenSource());
                        while ((ttype = this.getToken()) == -50) {
                            ttype = this.getToken();
                            if (ttype == -10) {
                                ctorClassNameBuffer.append('.');
                                ctorClassNameBuffer.append(this.lexer.getTokenSource());
                                continue;
                            }
                            classNameOK = false;
                            break;
                        }
                    }
                    if (!classNameOK) {
                        throw new ParseException("Bad class name for 'new' expression");
                    }
                    String ctorClassName = ctorClassNameBuffer.toString();
                    if ((ctorClassName = this.findClassForCtor(ctorClassName)) == null) {
                        throw new ParseException("unknown class for 'new' expression: " + ctorClassName);
                    }
                    if (ttype == -40) {
                        Vector argExprs = this.expressionList(this.getToken());
                        return new CtorExpression(ctorClassName, argExprs);
                    }
                    throw new ParseException("Syntax error in 'new' expression");
                }
                return new PropertyExpression(s, null, this.caseSensitive);
            }
            case -13: {
                return new LiteralExpression(new Integer(this.lexer.getTokenSource()));
            }
            case -15: {
                String hexDigits = this.lexer.getTokenSource().substring(2);
                return new LiteralExpression(Long.valueOf(hexDigits, 16));
            }
            case -14: {
                return new LiteralExpression(new Double(this.lexer.getTokenSource()));
            }
            case -11: {
                return new LiteralExpression(this.lexer.getTokenSource());
            }
            case -12: {
                return new LiteralExpression(this.lexer.getTokenSource());
            }
            case -40: {
                Expression e1 = this.expression(this.getToken());
                ttype = this.getToken();
                if (ttype == -41) {
                    return e1;
                }
                throw new ParseException("Expected closing parentheses");
            }
        }
        throw new ParseException("Syntax error starting with " + this.currentTokenString(ttype));
    }

    public static void main(String[] args) {
        StringBuilder inputBuf = new StringBuilder(100);
        for (int i = 0; i < args.length; ++i) {
            inputBuf.append(args[i]);
            inputBuf.append(' ');
        }
        String input = inputBuf.toString();
        System.out.println("Parsing string '" + input + "'");
        ExprParser p = new ExprParser();
        p.addImportedClass(Math.class);
        p.addImportedClass(Character.class);
        p.addImportedClass(Integer.class);
        p.addImportedClass(ExprParser.class);
        try {
            Expression e = p.parse(input);
            System.out.println(e.toString());
            Button sampleObj = new Button("Fred");
            System.out.println("Value = " + e.eval(sampleObj, Expression.SCRIPT_EVAL));
        }
        catch (ParseException err) {
            System.out.println(err.getMessage());
        }
        catch (Exception bug) {
            System.out.println("Bug: " + bug.getMessage());
            bug.printStackTrace();
        }
        System.exit(0);
    }
}

