/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;

public class ParsedTemplate {
    private static Map parsedTemplateCache = new Hashtable();
    private String templateSourceFileName;
    private char[] templateSource;
    private TemplateFragment[] templateFragments;
    private long templateModTime;

    public static ParsedTemplate getParsedTemplate(File templateFile) {
        ParsedTemplate cached = (ParsedTemplate)parsedTemplateCache.get(templateFile);
        if (cached != null && cached.getTemplateModTime() != templateFile.lastModified()) {
            parsedTemplateCache.remove(templateFile);
            cached = null;
        }
        return cached;
    }

    public ParsedTemplate(File templateFile, Class[] staticMethodClasses) throws IOException {
        this(templateFile, staticMethodClasses, true, true);
    }

    public ParsedTemplate(File templateFile, Class[] staticMethodClasses, boolean caseSensitive) throws IOException {
        this(templateFile, staticMethodClasses, caseSensitive, true);
    }

    public ParsedTemplate(File templateFile, Class[] staticMethodClasses, boolean caseSensitive, boolean useCache) throws IOException {
        FileReader reader = new FileReader(templateFile);
        this.templateSourceFileName = templateFile.getPath();
        this.templateModTime = templateFile.lastModified();
        int fileSize = (int)templateFile.length();
        this.templateSource = new char[fileSize];
        reader.read(this.templateSource, 0, fileSize);
        reader.close();
        this.templateFragments = TemplateParser.defaultParseTemplateSource(this.templateSource, staticMethodClasses, caseSensitive);
        if (useCache) {
            parsedTemplateCache.put(templateFile, this);
        }
    }

    public ParsedTemplate(URL templateURL, Class[] staticMethodClasses, boolean caseSensitive) throws IOException {
        int c;
        InputStream inStream = templateURL.openStream();
        InputStreamReader reader = new InputStreamReader(inStream);
        StringWriter writer = new StringWriter();
        while ((c = ((Reader)reader).read()) != -1) {
            writer.write((char)c);
        }
        writer.flush();
        writer.close();
        ((Reader)reader).close();
        this.templateSource = writer.toString().toCharArray();
        this.templateSourceFileName = templateURL.getFile();
        this.templateFragments = TemplateParser.defaultParseTemplateSource(this.templateSource, staticMethodClasses, caseSensitive);
    }

    public ParsedTemplate(String classLoaderResourceName) throws IOException {
        this(classLoaderResourceName, new Class[0], true);
    }

    public ParsedTemplate(String classLoaderResourceName, Class[] staticMethodClasses, boolean caseSensitive) throws IOException {
        int c;
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(classLoaderResourceName);
        if (inStream == null) {
            throw new FileNotFoundException(classLoaderResourceName);
        }
        InputStreamReader reader = new InputStreamReader(inStream);
        StringWriter writer = new StringWriter();
        while ((c = ((Reader)reader).read()) != -1) {
            writer.write((char)c);
        }
        writer.flush();
        writer.close();
        ((Reader)reader).close();
        this.templateSource = writer.toString().toCharArray();
        this.templateSourceFileName = "resource:" + classLoaderResourceName;
        this.templateFragments = TemplateParser.defaultParseTemplateSource(this.templateSource, staticMethodClasses, caseSensitive);
    }

    public String getTemplateSourceFileName() {
        return this.templateSourceFileName;
    }

    public char[] getTemplateSource() {
        return this.templateSource;
    }

    public TemplateFragment[] getTemplateFragments() {
        return this.templateFragments;
    }

    public long getTemplateModTime() {
        return this.templateModTime;
    }
}

