/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.expr.EvaluationResult;
import modelobjects.expr.Expression;
import modelobjects.template.ElseFragment;
import modelobjects.template.EndIfFragment;
import modelobjects.template.TemplateException;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;
import modelobjects.template.TemplateProcessor;

class StartIfFragment
extends TemplateFragment {
    private int endFragIndex;
    private int elseFragIndex;
    private String exprString;
    private Expression expression;

    StartIfFragment(int startPos, int endPos, String exprString, Expression expression) {
        super(startPos, endPos);
        this.exprString = exprString;
        this.expression = expression;
        this.endFragIndex = -1;
        this.elseFragIndex = -1;
    }

    int getEndFragIndex() {
        return this.endFragIndex;
    }

    void setEndFragIndex(int index) {
        this.endFragIndex = index;
    }

    boolean hasMatchingEndTag() {
        return this.endFragIndex >= 0;
    }

    int getElseFragIndex() {
        return this.elseFragIndex;
    }

    void setElseFragIndex(int index) {
        this.elseFragIndex = index;
    }

    boolean hasMatchingElseTag() {
        return this.elseFragIndex >= 0;
    }

    @Override
    void processFragment(TemplateProcessor processor) throws TemplateException {
        Object objValue;
        boolean testVal;
        EvaluationResult evalResult = this.expression.evaluate(processor, processor.getPostEvalConverter(), Expression.SCRIPT_EVAL);
        if (evalResult.getException() != null) {
            String message = "expr = '" + this.expression.toString() + "'";
            processor.reportError(this, evalResult.getException(), message);
        }
        boolean bl = testVal = (objValue = evalResult.getValue()) != null && !objValue.equals(Boolean.FALSE);
        if (!testVal) {
            if (this.hasMatchingElseTag()) {
                processor.setCurrentFragmentIndex(this.getElseFragIndex() + 1);
            } else if (this.hasMatchingEndTag()) {
                processor.setCurrentFragmentIndex(this.getEndFragIndex() + 1);
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("<IF");
        buf.append(" [" + this.startPos + ".." + this.endPos + "]");
        buf.append(" TEST=");
        buf.append("'");
        buf.append(this.expression);
        buf.append("'");
        buf.append(">");
        return buf.toString();
    }

    @Override
    void postParseAnalyze(char[] templateSource, TemplateFragment[] parsedTemplate, int fragmentIndex) {
        int templateLength = parsedTemplate.length;
        int nesting = 0;
        for (int i = fragmentIndex; i < templateLength; ++i) {
            ElseFragment elseFrag;
            TemplateFragment frag = parsedTemplate[i];
            if (frag instanceof StartIfFragment) {
                ++nesting;
            }
            if (frag instanceof ElseFragment && nesting == 1) {
                elseFrag = (ElseFragment)frag;
                this.setElseFragIndex(i);
            }
            if (!(frag instanceof EndIfFragment) || --nesting != 0) continue;
            if (this.hasMatchingElseTag()) {
                elseFrag = (ElseFragment)parsedTemplate[this.elseFragIndex];
                elseFrag.setEndFragIndex(i);
            }
            this.setEndFragIndex(i);
            return;
        }
        System.err.println("Warning: missing </IF> tag for <IF...> tag on line " + TemplateParser.lineNumber(templateSource, this.startPos));
    }
}

