/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.expr.Expression;
import modelobjects.template.StartIfFragment;
import modelobjects.template.TagParser;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;
import modelobjects.template.TemplateProcessor;

class StartIfTagParser
extends TagParser {
    protected static final String tagStart = "<IF";
    protected static final int tagStartLength = "<IF".length();
    private String exprString;
    private Expression expression;

    StartIfTagParser() {
    }

    @Override
    TemplateFragment extractFragment(TemplateParser parser, int startPos) {
        int sourceLen;
        char[] source = parser.getTemplateSource();
        if (!this.tagNameMatches(source, startPos, sourceLen = source.length, "IF", "if")) {
            return null;
        }
        int endPos = StartIfTagParser.tagEndPos(startPos + tagStartLength, source, source.length);
        this.collectTagInfo(parser, source, startPos, endPos);
        return new StartIfFragment(startPos, endPos, this.exprString, this.expression);
    }

    private void collectTagInfo(TemplateParser parser, char[] source, int startPos, int endPos) {
        this.exprString = null;
        this.expression = null;
        String attributesString = new String(source, startPos + tagStartLength, endPos - startPos - tagStartLength);
        TagParser.TagAttribute[] attributes = this.collectAttributes(attributesString, source, startPos);
        int n = attributes.length;
        for (int i = 0; i < n; ++i) {
            String attrName = attributes[i].getAttrName();
            String attrValue = attributes[i].getAttrValue();
            if ("".equals(attrName) || "test".equalsIgnoreCase(attrName)) {
                this.exprString = attrValue.equals(parser.getTopLevelId()) ? TemplateProcessor.TOP_LEVEL_OBJ_ID : attrValue;
                continue;
            }
            System.err.println("Unrecognized <IF> tag attibute: " + attrName + " on line " + TemplateParser.lineNumber(source, startPos));
        }
        if (this.exprString == null) {
            System.err.println("Missing TEST attribute in <IF> tag at " + TemplateParser.lineNumber(source, startPos));
            this.exprString = "\"???\"";
        } else {
            try {
                this.expression = parser.getExpressionParser().parse(this.exprString);
            }
            catch (Exception e) {
                System.err.println("Syntax error in <IF> expression: '" + this.exprString + "' on line " + TemplateParser.lineNumber(source, startPos));
            }
        }
        if (this.expression == null) {
            this.expression = parser.getExpressionParser().parse("\"???\"");
        }
    }
}

