/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.expr.EvaluationResult;
import modelobjects.expr.Expression;
import modelobjects.template.TemplateException;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateProcessor;

class SubstFragment
extends TemplateFragment {
    private String exprString;
    private Expression expression;
    private String defaultValue;

    SubstFragment(int startPos, int endPos, String exprString, Expression expression, String defaultValue) {
        super(startPos, endPos);
        this.exprString = exprString;
        this.expression = expression;
        this.defaultValue = defaultValue;
    }

    @Override
    boolean ignorePrecedingWhitespace() {
        return false;
    }

    @Override
    void processFragment(TemplateProcessor processor) throws TemplateException {
        Object objValue;
        EvaluationResult evalResult = this.expression.evaluate(processor, processor.getPostEvalConverter(), Expression.SCRIPT_EVAL);
        if (evalResult.getException() != null) {
            String message = "expr = '" + this.expression.toString() + "'";
            processor.reportError(this, evalResult.getException(), message);
        }
        if ((objValue = evalResult.getValue()) != null) {
            processor.writeString(objValue.toString());
        } else if (this.defaultValue != null) {
            processor.writeString(this.defaultValue);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("<SUBST");
        buf.append(" [" + this.startPos + ".." + this.endPos + "] ");
        buf.append("'");
        buf.append(this.expression);
        buf.append("'");
        buf.append(">");
        if (this.defaultValue != null) {
            buf.append(this.defaultValue);
        }
        buf.append("</SUBST>");
        return buf.toString();
    }
}

