/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.expr.Expression;
import modelobjects.template.SubstFragment;
import modelobjects.template.TagParser;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateParser;
import modelobjects.template.TemplateProcessor;

class SubstTagParser
extends TagParser {
    protected static final String tagStart = "<SUBST";
    protected static final int tagStartLength = "<SUBST".length();
    private Expression expression;
    private String exprString;
    private String defaultValue;

    SubstTagParser() {
    }

    @Override
    TemplateFragment extractFragment(TemplateParser parser, int startPos) {
        int sourceLen;
        char[] source = parser.getTemplateSource();
        if (!this.tagNameMatches(source, startPos, sourceLen = source.length, "SUBST", "subst")) {
            return null;
        }
        int endPos = SubstTagParser.tagEndPos(startPos + tagStartLength, source, sourceLen);
        if (endPos == -1) {
            System.err.println("unterminated <SUBST> tag on line " + TemplateParser.lineNumber(source, startPos));
            return null;
        }
        if (source[endPos - 1] == '/') {
            this.collectTagInfo(parser, source, startPos, endPos - 1);
        } else {
            this.collectTagInfo(parser, source, startPos, endPos);
        }
        if (source[endPos - 1] != '/') {
            int endTagStartPos = SubstTagParser.nextTagPos(endPos + 1, source, source.length);
            while (endTagStartPos != -1 && !this.isEndSubstTag(source, endTagStartPos)) {
                endTagStartPos = SubstTagParser.nextTagPos(endTagStartPos + 1, source, source.length);
            }
            if (endTagStartPos == -1) {
                System.err.println("No matching </SUBST> tag for <SUBST> tag on line " + TemplateParser.lineNumber(source, startPos));
            } else {
                this.defaultValue = new String(source, endPos + 1, endTagStartPos - (endPos + 1));
                endPos = SubstTagParser.tagEndPos(endTagStartPos + 1, source, source.length);
            }
        }
        return new SubstFragment(startPos, endPos, this.exprString, this.expression, this.defaultValue);
    }

    private void collectTagInfo(TemplateParser parser, char[] source, int startPos, int endPos) {
        this.exprString = null;
        this.expression = null;
        this.defaultValue = null;
        String attributesString = new String(source, startPos + tagStartLength, endPos - startPos - tagStartLength);
        TagParser.TagAttribute[] attributes = this.collectAttributes(attributesString, source, startPos);
        int n = attributes.length;
        for (int i = 0; i < n; ++i) {
            String attrName = attributes[i].getAttrName();
            String attrValue = attributes[i].getAttrValue();
            if ("".equals(attrName) || "value".equalsIgnoreCase(attrName)) {
                this.exprString = attrValue.equals(parser.getTopLevelId()) ? TemplateProcessor.TOP_LEVEL_OBJ_ID : attrValue;
                continue;
            }
            System.err.println("Unrecognized <SUBST> attibute: " + attrName + " on line " + TemplateParser.lineNumber(source, startPos));
        }
        if (this.exprString == null) {
            System.err.println("Missing VALUE attribute in <SUBST> tag at " + TemplateParser.lineNumber(source, startPos));
            this.exprString = "\"???\"";
        } else {
            try {
                this.expression = parser.getExpressionParser().parse(this.exprString);
            }
            catch (Exception e) {
                System.err.println("Syntax error in <SUBST> expression: '" + this.exprString + "' on line " + TemplateParser.lineNumber(source, startPos));
            }
        }
        if (this.expression == null) {
            this.expression = parser.getExpressionParser().parse("\"???\"");
        }
    }

    private boolean isEndSubstTag(char[] source, int startPos) {
        return this.tagNameMatches(source, startPos, source.length, "/SUBST", "/subst");
    }
}

