/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import modelobjects.util.LexerTokenTypes;

public class Lexer
implements LexerTokenTypes {
    public static final int JAVA_ID_STYLE = 1;
    public static final int HTML_ID_STYLE = 2;
    public static final int SQL_ID_STYLE = 3;
    public static final int ALPHA_ID_STYLE = 4;
    public static final int ALPHANUM_ID_STYLE = 5;
    private int lastTokenType;
    private boolean tokenPushedBack;
    private PushbackReader reader;
    private StringBuilder tokenSource;
    private StringBuilder tokenWhiteSpace;
    private int tokenPosition;
    private int tokenLineNumber;
    private int position;
    private int lineNumber;
    private boolean done;
    private boolean slashSlashComments;
    private boolean slashStarComments;
    private boolean useBackslashEscapes;
    private int idStyle;
    private boolean internmentEnabled;
    private Map stringPool;

    public Lexer(String stringSource) {
        this(new StringReader(stringSource));
    }

    public Lexer(Reader source) {
        this.reader = new PushbackReader(source);
        this.lineNumber = 1;
        this.position = 0;
        this.tokenLineNumber = 1;
        this.tokenPosition = 0;
        this.done = false;
        this.tokenSource = new StringBuilder();
        this.tokenWhiteSpace = new StringBuilder();
        this.idStyle = 5;
        this.stringPool = new Hashtable();
        this.internmentEnabled = true;
    }

    public String getTokenSource() {
        return this.internString(this.tokenSource.toString());
    }

    public String getTokenString(int tokenType) {
        switch (tokenType) {
            case -15: 
            case -14: 
            case -13: 
            case -12: 
            case -11: 
            case -10: 
            case -2: {
                return this.getTokenSource();
            }
        }
        return Lexer.getOperatorName(tokenType);
    }

    public static String getOperatorName(int tokenType) {
        switch (tokenType) {
            case -20: {
                return "=";
            }
            case -21: {
                return "==";
            }
            case -22: {
                return "!=";
            }
            case -23: {
                return "<";
            }
            case -24: {
                return ">";
            }
            case -25: {
                return "<=";
            }
            case -26: {
                return ">=";
            }
            case -27: {
                return "<>";
            }
            case -34: {
                return "<<";
            }
            case -35: {
                return ">>";
            }
            case -30: {
                return "+";
            }
            case -31: {
                return "-";
            }
            case -32: {
                return "*";
            }
            case -33: {
                return "/";
            }
            case -40: {
                return "(";
            }
            case -41: {
                return ")";
            }
            case -42: {
                return "{";
            }
            case -43: {
                return "}";
            }
            case -44: {
                return "[";
            }
            case -45: {
                return "]";
            }
            case -50: {
                return ".";
            }
            case -51: {
                return ",";
            }
            case -52: {
                return ":";
            }
            case -53: {
                return ";";
            }
            case -54: {
                return "@";
            }
            case -55: {
                return "?";
            }
            case -56: {
                return "#";
            }
            case -57: {
                return "%";
            }
            case -59: {
                return "$";
            }
            case -60: {
                return "&";
            }
            case -61: {
                return "|";
            }
            case -62: {
                return "&&";
            }
            case -63: {
                return "||";
            }
            case -64: {
                return "!";
            }
            case -65: {
                return "~";
            }
            case -58: {
                return "^";
            }
            case -1: {
                return "";
            }
        }
        return "" + (char)tokenType;
    }

    public String getWhiteSpaceBeforeToken() {
        String w = this.tokenWhiteSpace.toString();
        if (w.length() <= 16) {
            return this.internString(w);
        }
        return w;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getTokenPosition() {
        return this.tokenPosition;
    }

    public int getTokenLineNumber() {
        return this.tokenLineNumber;
    }

    public int getIdStyle() {
        return this.idStyle;
    }

    public void setIdStyle(int style) {
        this.idStyle = style;
    }

    public boolean getLexSlashSlashComments() {
        return this.slashSlashComments;
    }

    public void setLexSlashSlashComments(boolean val) {
        this.slashSlashComments = val;
    }

    public boolean getLexSlashStarComments() {
        return this.slashStarComments;
    }

    public void setLexSlashStarComments(boolean val) {
        this.slashStarComments = val;
    }

    public boolean getUseBackslashEscapes() {
        return this.useBackslashEscapes;
    }

    public void setUseBackslashEscapes(boolean val) {
        this.useBackslashEscapes = val;
    }

    public boolean isInternmentEnabled() {
        return this.internmentEnabled;
    }

    public void setInternmentEnabled(boolean enabled) {
        this.internmentEnabled = enabled;
    }

    public int getToken() throws IOException {
        if (this.tokenPushedBack) {
            this.tokenPushedBack = false;
        } else {
            this.lastTokenType = this.getToken(true);
        }
        return this.lastTokenType;
    }

    public String readCurrentLine() throws IOException {
        if (this.done) {
            return null;
        }
        this.tokenWhiteSpace.setLength(0);
        this.tokenSource.setLength(0);
        this.tokenLineNumber = this.lineNumber;
        this.tokenPosition = this.position;
        this.lastTokenType = -2;
        int n = this.read();
        while (n != -1) {
            char c = (char)n;
            if (c == '\n') {
                ++this.lineNumber;
                break;
            }
            if (c != '\r') {
                this.tokenSource.append(c);
            }
            n = this.read();
        }
        return this.tokenSource.toString();
    }

    public void pushBack() {
        this.tokenPushedBack = true;
    }

    private int read() throws IOException {
        ++this.position;
        return this.reader.read();
    }

    private void unread(int c) throws IOException {
        --this.position;
        this.reader.unread(c);
    }

    private int endOfFile() throws IOException {
        this.done = true;
        this.reader.close();
        this.tokenPosition = this.position;
        this.tokenLineNumber = this.lineNumber;
        return -1;
    }

    private boolean isIdentifierStart(char c) {
        switch (this.idStyle) {
            default: {
                return Character.isJavaIdentifierStart(c);
            }
            case 2: {
                return Character.isLetter(c) || c == '_' || c == '-' || c == '.';
            }
            case 3: {
                return Character.isLetter(c) || c == '_';
            }
            case 4: 
            case 5: 
        }
        return Character.isLetter(c);
    }

    private boolean isIdentifierPart(char c) {
        switch (this.idStyle) {
            default: {
                return Character.isJavaIdentifierPart(c);
            }
            case 2: {
                return Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.';
            }
            case 3: {
                return Character.isLetterOrDigit(c) || c == '_';
            }
            case 4: {
                return Character.isLetter(c);
            }
            case 5: 
        }
        return Character.isLetterOrDigit(c);
    }

    private int getToken(boolean clearBuffers) throws IOException {
        int n;
        if (this.done) {
            return this.endOfFile();
        }
        if (clearBuffers) {
            this.tokenWhiteSpace.setLength(0);
            this.tokenSource.setLength(0);
        }
        if ((n = this.read()) == -1) {
            return this.endOfFile();
        }
        char c1 = (char)n;
        while (Character.isWhitespace(c1) || Character.isISOControl(c1)) {
            this.tokenWhiteSpace.append(c1);
            if (c1 == '\n') {
                ++this.lineNumber;
            }
            if ((n = this.read()) == -1) {
                return this.endOfFile();
            }
            c1 = (char)n;
        }
        this.tokenPosition = this.position - 1;
        this.tokenLineNumber = this.lineNumber;
        if (Character.isDigit(c1)) {
            return this.lexNumber(c1);
        }
        if (this.isIdentifierStart(c1)) {
            return this.lexIdentifier(c1);
        }
        switch (c1) {
            case '+': {
                return -30;
            }
            case '-': {
                return -31;
            }
            case '*': {
                return -32;
            }
            case '(': {
                return -40;
            }
            case ')': {
                return -41;
            }
            case '{': {
                return -42;
            }
            case '}': {
                return -43;
            }
            case '[': {
                return -44;
            }
            case ']': {
                return -45;
            }
            case ',': {
                return -51;
            }
            case ':': {
                return -52;
            }
            case ';': {
                return -53;
            }
            case '@': {
                return -54;
            }
            case '?': {
                return -55;
            }
            case '#': {
                return -56;
            }
            case '%': {
                return -57;
            }
            case '~': {
                return -65;
            }
            case '^': {
                return -58;
            }
            case '$': {
                return -59;
            }
            case '.': {
                return this.lexDOT();
            }
            case '=': {
                return this.lexEQ();
            }
            case '!': {
                return this.lexNOT();
            }
            case '<': {
                return this.lexLT();
            }
            case '>': {
                return this.lexGT();
            }
            case '&': {
                return this.lexAND();
            }
            case '|': {
                return this.lexOR();
            }
            case '/': {
                if (this.slashSlashComments || this.slashStarComments) {
                    return this.lexSLASH();
                }
                return -33;
            }
            case '\'': {
                return this.lexQuotedString(c1);
            }
            case '\"': {
                return this.lexQuotedString(c1);
            }
        }
        return c1;
    }

    private int lexDOT() throws IOException {
        int c = this.read();
        if (Character.isDigit((char)c)) {
            return this.lexFraction(c);
        }
        this.unread(c);
        return -50;
    }

    private int lexEQ() throws IOException {
        int c = this.read();
        if (c == 61) {
            return -21;
        }
        this.unread(c);
        return -20;
    }

    private int lexNOT() throws IOException {
        int c = this.read();
        if (c == 61) {
            return -22;
        }
        this.unread(c);
        return -64;
    }

    private int lexLT() throws IOException {
        int c = this.read();
        if (c == 61) {
            return -25;
        }
        if (c == 60) {
            return -34;
        }
        if (c == 62) {
            return -27;
        }
        this.unread(c);
        return -23;
    }

    private int lexGT() throws IOException {
        int c = this.read();
        if (c == 61) {
            return -26;
        }
        if (c == 62) {
            return -35;
        }
        this.unread(c);
        return -24;
    }

    private int lexAND() throws IOException {
        int c = this.read();
        if (c == 38) {
            return -62;
        }
        this.unread(c);
        return -60;
    }

    private int lexOR() throws IOException {
        int c = this.read();
        if (c == 124) {
            return -63;
        }
        this.unread(c);
        return -61;
    }

    private int lexSLASH() throws IOException {
        int c = this.read();
        if (this.slashSlashComments && c == 47) {
            this.tokenWhiteSpace.append('/');
            while (c != -1) {
                this.tokenWhiteSpace.append((char)c);
                if (c == 10) {
                    ++this.lineNumber;
                    break;
                }
                c = this.read();
            }
            if (c == -1) {
                this.done = true;
            }
            return this.getToken(false);
        }
        if (this.slashStarComments && c == 42) {
            this.tokenWhiteSpace.append('/');
            int prevc = 0;
            while (c != -1) {
                this.tokenWhiteSpace.append((char)c);
                if (prevc == 42 && c == 47) break;
                if (c == 10) {
                    ++this.lineNumber;
                }
                prevc = c;
                c = this.read();
            }
            if (c == -1) {
                this.done = true;
            }
            return this.getToken(false);
        }
        this.unread(c);
        return -33;
    }

    private int lexQuotedString(char quoteChar) throws IOException {
        int c = this.read();
        while (c != -1 && c != quoteChar) {
            if (c == 10) {
                ++this.lineNumber;
            } else if (c == 92 && this.useBackslashEscapes) {
                c = this.read();
                switch (c) {
                    case 39: {
                        break;
                    }
                    case 34: {
                        break;
                    }
                    case 92: {
                        break;
                    }
                    case 10: {
                        ++this.lineNumber;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 117: {
                        c = this.readUnicode();
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        c = this.readOctal(c);
                    }
                }
            }
            this.tokenSource.append((char)c);
            c = this.read();
        }
        if (c == -1) {
            this.done = true;
        }
        if (quoteChar == '\"') {
            return -11;
        }
        return -12;
    }

    private char readUnicode() throws IOException {
        int c1 = Character.digit((char)this.read(), 16);
        int c2 = Character.digit((char)this.read(), 16);
        int c3 = Character.digit((char)this.read(), 16);
        int c4 = Character.digit((char)this.read(), 16);
        if (c1 < 0 || c2 < 0 || c3 < 0 || c4 < 0) {
            System.err.println("invalid unicode escape sequence on line " + this.lineNumber);
            return '?';
        }
        return (char)((c1 << 12) + (c2 << 8) + (c3 << 4) + c4);
    }

    private char readOctal(int c) throws IOException {
        int c1 = Character.digit((char)c, 8);
        c = this.read();
        int c2 = Character.digit((char)c, 8);
        if (c == 39) {
            this.unread(c);
            return (char)c1;
        }
        if (c < 0) {
            System.err.println("invalid octal digit '" + (char)c + "' on line " + this.lineNumber);
        }
        int c3 = Character.digit((char)this.read(), 8);
        if (c == 39) {
            this.unread(c);
            return (char)((c1 << 3) + c2);
        }
        if (c < 0) {
            System.err.println("invalid octal digit '" + (char)c + "' on line " + this.lineNumber);
        }
        return (char)((c1 << 6) + (c2 << 3) + c3);
    }

    private int lexNumber(int n) throws IOException {
        char c = (char)n;
        if (n == 48) {
            this.tokenSource.append(c);
            n = this.read();
            c = (char)n;
            if (c == 'x' || c == 'X') {
                this.tokenSource.append(c);
                return this.lexHexNumber(this.read());
            }
        }
        while (Character.isDigit(c)) {
            this.tokenSource.append(c);
            n = this.read();
            c = (char)n;
        }
        if (c == '.') {
            this.tokenSource.append(c);
            return this.lexFraction(this.read());
        }
        if (c == 'e' || c == 'E') {
            this.tokenSource.append(c);
            n = this.read();
            c = (char)n;
            if (c == '-' || c == '+') {
                this.tokenSource.append(c);
                n = this.read();
                c = (char)n;
            }
            while (Character.isDigit(c)) {
                this.tokenSource.append(c);
                n = this.read();
                c = (char)n;
            }
            this.unread(n);
            return -14;
        }
        this.unread(n);
        return -13;
    }

    private int lexHexNumber(int n) throws IOException {
        char c = (char)n;
        while (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
            this.tokenSource.append(c);
            n = this.read();
            c = (char)n;
        }
        this.unread(n);
        return -15;
    }

    private int lexFraction(int n) throws IOException {
        char c = (char)n;
        while (Character.isDigit(c)) {
            this.tokenSource.append(c);
            n = this.read();
            c = (char)n;
        }
        if (c == 'e' || c == 'E') {
            this.tokenSource.append(c);
            n = this.read();
            c = (char)n;
            if (c == '-' || c == '+') {
                this.tokenSource.append(c);
                n = this.read();
                c = (char)n;
            }
            while (Character.isDigit(c)) {
                this.tokenSource.append(c);
                n = this.read();
                c = (char)n;
            }
        }
        this.unread(n);
        return -14;
    }

    private int lexIdentifier(int n) throws IOException {
        char c = (char)n;
        while (this.isIdentifierPart(c)) {
            this.tokenSource.append(c);
            n = this.read();
            c = (char)n;
        }
        this.unread(c);
        return -10;
    }

    private String internString(String s) {
        if (!this.internmentEnabled) {
            return s;
        }
        String result = (String)this.stringPool.get(s);
        if (result == null) {
            this.stringPool.put(s, s);
            result = s;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            int ttype;
            FileReader reader = new FileReader(args[0]);
            Lexer lexer = new Lexer(reader);
            lexer.setLexSlashSlashComments(true);
            lexer.setLexSlashStarComments(true);
            lexer.setUseBackslashEscapes(true);
            lexer.setIdStyle(1);
            do {
                ttype = lexer.getToken();
                System.err.println(lexer.getTokenLineNumber() + "\t" + lexer.getTokenPosition() + "\t" + lexer.getTokenString(ttype));
                String tokString = lexer.getTokenString(ttype);
                Lexer.showToken(lexer, tokString);
            } while (ttype != -1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    static void showToken(Lexer lexer, String tokenString) {
        String whiteSpace = lexer.getWhiteSpaceBeforeToken();
        System.out.print(whiteSpace);
        System.out.print(tokenString);
        System.out.flush();
    }
}

