/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class JMSURLHelper {
    private URL url;
    private String destination;
    private Map properties;
    private List requiredProperties;
    private List appProperties;

    public JMSURLHelper(URL url) throws MalformedURLException {
        this(url, null);
    }

    public JMSURLHelper(URL url, String[] requiredProperties) throws MalformedURLException {
        this.url = url;
        this.properties = new HashMap();
        this.appProperties = new Vector();
        this.destination = url.getPath();
        if (this.destination.startsWith("/")) {
            this.destination = this.destination.substring(1);
        }
        if (this.destination == null || this.destination.trim().length() < 1) {
            throw new MalformedURLException("Missing destination in URL");
        }
        String query = url.getQuery();
        StringTokenizer st = new StringTokenizer(query, "&;");
        while (st.hasMoreTokens()) {
            String keyValue = st.nextToken();
            int eqIndex = keyValue.indexOf("=");
            if (eqIndex <= 0) continue;
            String key = keyValue.substring(0, eqIndex);
            String value = keyValue.substring(eqIndex + 1);
            if (key.startsWith("msgProp.")) {
                key = key.substring("msgProp.".length());
                this.addApplicationProperty(key);
            }
            this.properties.put(key, value);
        }
        this.addRequiredProperties(requiredProperties);
        this.validateURL();
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getVendor() {
        return this.getPropertyValue("vendor");
    }

    public String getDomain() {
        return this.getPropertyValue("domain");
    }

    public HashMap getProperties() {
        return (HashMap)this.properties;
    }

    public String getPropertyValue(String property) {
        return (String)this.properties.get(property);
    }

    public void addRequiredProperties(String[] properties) {
        if (properties == null) {
            return;
        }
        for (int i = 0; i < properties.length; ++i) {
            this.addRequiredProperty(properties[i]);
        }
    }

    public void addRequiredProperty(String property) {
        if (property == null) {
            return;
        }
        if (this.requiredProperties == null) {
            this.requiredProperties = new Vector();
        }
        ((Vector)this.requiredProperties).addElement(property);
    }

    public Vector getRequiredProperties() {
        return (Vector)this.requiredProperties;
    }

    public void addApplicationProperty(String property) {
        if (property == null) {
            return;
        }
        if (this.appProperties == null) {
            this.appProperties = new Vector();
        }
        ((Vector)this.appProperties).addElement(property);
    }

    public void addApplicationProperty(String property, String value) {
        if (property == null) {
            return;
        }
        if (this.appProperties == null) {
            this.appProperties = new Vector();
        }
        this.properties.put(property, value);
        ((Vector)this.appProperties).addElement(property);
    }

    public Vector getApplicationProperties() {
        return (Vector)this.appProperties;
    }

    public String getURLString() {
        StringBuilder text = new StringBuilder("jms:/");
        text.append(this.getDestination());
        text.append("?");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        boolean firstEntry = true;
        for (String string : props.keySet()) {
            if (!firstEntry) {
                text.append("&");
            }
            if (this.appProperties.contains(string)) {
                text.append("msgProp.");
            }
            text.append(string);
            text.append("=");
            text.append(props.get(string));
            firstEntry = false;
        }
        return text.toString();
    }

    public String toString() {
        return this.getURLString();
    }

    private void validateURL() throws MalformedURLException {
        Vector required = this.getRequiredProperties();
        if (required == null) {
            return;
        }
        for (int i = 0; i < required.size(); ++i) {
            String key = (String)required.elementAt(i);
            if (this.properties.get(key) != null) continue;
            throw new MalformedURLException();
        }
    }
}

