/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.esbdl;

import com.sonicsw.esb.esbdl.Interface;
import com.sonicsw.esb.esbdl.impl.EsbdlDOMProcessor;
import com.sonicsw.esb.esbdl.locator.InterfaceLocator;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class EsbdlHelper {
    public Interface getInterfaceFromElement(Element element, boolean isEsbp) {
        EsbdlDOMProcessor processor = new EsbdlDOMProcessor(isEsbp);
        List<Interface> intfs = processor.parse(element);
        if (intfs.size() > 0) {
            return intfs.get(0);
        }
        return null;
    }

    public Interface getInterfaceFromProcessConfig(XQProcessConfig procCfg) {
        List<Interface> intfs;
        Interface intf = null;
        EsbdlDOMProcessor processor = new EsbdlDOMProcessor(true);
        Element interfaceElem = procCfg.getInterfaceDefinitionElement();
        if (interfaceElem != null && (intfs = processor.parse(interfaceElem)).size() > 0) {
            intf = intfs.get(0);
        }
        return intf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Interface> getInterfacesFromProcessConfig(XQProcessConfig procCfg) throws Exception {
        EsbdlDOMProcessor processor = new EsbdlDOMProcessor(true);
        Element interfaceElem = procCfg.getInterfaceDefinitionElement();
        InputStream inputStream = null;
        if (interfaceElem != null) {
            return processor.parse(interfaceElem);
        }
        String interfaceRef = procCfg.getInterfaceRef();
        if (interfaceRef == null) {
            return new ArrayList<Interface>();
        }
        try {
            URL u = new URL(interfaceRef);
            interfaceElem = DOMUtils.getDocumentBuilder().parse(u.openStream()).getDocumentElement();
            List<Interface> list = processor.parse(interfaceElem);
            return list;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean hasInterfaces(XQProcessConfig processCfg) {
        Element interfaceElem = processCfg.getInterfaceDefinitionElement();
        String interfaceRef = processCfg.getInterfaceRef();
        return interfaceRef != null || interfaceElem != null;
    }

    public List<Interface> getInterfacesFromServiceConfig(XQServiceConfig svcCfg) throws Exception {
        InterfaceLocator intfl = svcCfg.getServiceTypeConfig().getInterfaceLocator();
        return intfl.locate(svcCfg);
    }

    public boolean hasInterfaces(XQServiceConfig svcCfg) {
        InterfaceLocator intfl = svcCfg.getServiceTypeConfig().getInterfaceLocator();
        return intfl.hasInterfaces(svcCfg);
    }
}

