/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.ExpressionException;
import com.sonicsw.esb.expression.def.EsbpExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;
import com.sonicsw.esb.expression.def.el.IndexConstructProcessor;

public class EsbpExpressionDefProcessor
extends ExpressionDefProcessorBase
implements ExpressionDefProcessor,
IndexConstructProcessor.Callback {
    private EsbpExpressionDef m_expressionDef;
    private boolean m_isInflightPropsPattern;
    private boolean m_isInflightProps;

    public EsbpExpressionDefProcessor() {
    }

    public EsbpExpressionDefProcessor(String remaining) {
        super(remaining);
        this.m_expressionDef = new EsbpExpressionDef();
    }

    @Override
    public ExpressionDef getExpressionDef(String strExpression, boolean isRValue) {
        this.m_expressionDef.setRValue(isRValue);
        int dotIndex = this.m_remaining.indexOf("selectInflightProperties");
        if (dotIndex != -1) {
            this.m_isInflightPropsPattern = true;
            IndexConstructProcessor.processIndexConstruct(this.m_remaining, this);
        } else {
            dotIndex = this.m_remaining.indexOf("inflightProperties");
            if (dotIndex != -1) {
                this.m_isInflightProps = true;
                IndexConstructProcessor.processIndexConstruct(this.m_remaining, this);
            } else {
                dotIndex = this.m_remaining.indexOf("params");
                if (dotIndex != -1) {
                    IndexConstructProcessor.processIndexConstruct(this.m_remaining, this);
                } else {
                    this.m_expressionDef.setAttributeName(this.m_remaining);
                }
            }
        }
        return this.m_expressionDef;
    }

    @Override
    public String getStringRepresentation(ExpressionDef expressionDef) {
        assert (expressionDef instanceof EsbpExpressionDef);
        EsbpExpressionDef esbpExpression = (EsbpExpressionDef)expressionDef;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("${esbp.");
        Object exprComponent = null;
        exprComponent = esbpExpression.getInflightPropertyName();
        if (this.isDefined(exprComponent)) {
            sbuf.append("inflightProperties[");
            if (exprComponent instanceof String) {
                sbuf.append('\'');
            }
            sbuf.append(EsbpExpressionDefProcessor.getString(exprComponent));
            if (exprComponent instanceof String) {
                sbuf.append('\'');
            }
            sbuf.append("]}");
        } else {
            exprComponent = esbpExpression.getInflightPropertyPattern();
            if (this.isDefined(exprComponent)) {
                sbuf.append("selectInflightProperties[");
                if (exprComponent instanceof String) {
                    sbuf.append('\'');
                }
                sbuf.append(EsbpExpressionDefProcessor.getString(exprComponent));
                if (exprComponent instanceof String) {
                    sbuf.append('\'');
                }
                sbuf.append("].each}");
            } else {
                exprComponent = esbpExpression.getParameterName();
                if (this.isDefined(exprComponent)) {
                    sbuf.append("params[");
                    if (exprComponent instanceof String) {
                        sbuf.append('\'');
                    }
                    sbuf.append(EsbpExpressionDefProcessor.getString(exprComponent));
                    if (exprComponent instanceof String) {
                        sbuf.append('\'');
                    }
                    sbuf.append("]}");
                } else {
                    exprComponent = esbpExpression.getAttributeName();
                    if (this.isDefined(exprComponent)) {
                        sbuf.append(EsbpExpressionDefProcessor.getString(exprComponent));
                        sbuf.append("}");
                    } else {
                        throw new ExpressionException("Required information has not been populated to generate a valid ESBP expression");
                    }
                }
            }
        }
        return sbuf.toString();
    }

    @Override
    public void setIndex(int index) {
    }

    @Override
    public void setIndex(String indexName) {
        if (this.m_isInflightPropsPattern) {
            this.m_expressionDef.setInflightPropertyPattern(EsbpExpressionDefProcessor.getExpressionObjOrStr(indexName));
        } else if (this.m_isInflightProps) {
            this.m_expressionDef.setInflightPropertyName(EsbpExpressionDefProcessor.getExpressionObjOrStr(indexName));
        } else {
            this.m_expressionDef.setParameterName(EsbpExpressionDefProcessor.getExpressionObjOrStr(indexName));
        }
    }

    @Override
    public void setSource(String source) {
        if (source.endsWith(".each")) {
            this.m_expressionDef.setCollectionType(true);
        }
    }

    @Override
    public void setFunction(String function) {
        if (this.m_isInflightPropsPattern) {
            this.m_expressionDef.setInflightPropertyPattern(EsbpExpressionDefProcessor.getExpressionObjOrStr(function));
        } else if (this.m_isInflightProps) {
            this.m_expressionDef.setInflightPropertyName(EsbpExpressionDefProcessor.getExpressionObjOrStr(function));
        } else {
            this.m_expressionDef.setParameterName(EsbpExpressionDefProcessor.getExpressionObjOrStr(function));
        }
    }

    @Override
    public void setEmbeddedExpression(String expression) {
        String fullExpression = "${" + expression + "}";
        ExpressionDef expressionDef = s_expressionDefProcessorFactory.getExpressionDefProcessor(fullExpression).getExpressionDef(fullExpression, false);
        if (this.m_isInflightPropsPattern) {
            this.m_expressionDef.setInflightPropertyPattern(expressionDef);
        } else if (this.m_isInflightProps) {
            this.m_expressionDef.setInflightPropertyName(expressionDef);
        } else {
            this.m_expressionDef.setParameterName(expressionDef);
        }
    }
}

