/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import com.sonicsw.esb.expression.el.BaseELResolver;
import com.sonicsw.esb.expression.el.XQMessageELResolver;
import com.sonicsw.esb.expression.model.XQMessageParts;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.esb.process.mapping.MappingException;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.script.InsertionHelper;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.xml.Namespace;
import java.util.ArrayList;
import java.util.Map;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.xml.transform.TransformerException;

public class XQPartELResolver
extends BaseELResolver {
    public XQPartELResolver() {
    }

    public XQPartELResolver(boolean readOnly) {
        super(readOnly);
    }

    @Override
    protected boolean isResolvable(Object base) {
        return base instanceof XQPart;
    }

    @Override
    protected boolean isResolvable(ELContext context, Object base, Object property) {
        return this.isResolvable(base) && property instanceof XQMessageParts.XQPartProperties;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (this.isResolvable(context, base, property)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("Resolver is read-only.");
            }
            XQMessage msg = XQMessageELResolver.getMessage(context);
            XQMessageParts.XQPartProperties props = (XQMessageParts.XQPartProperties)property;
            Object partId = context.getContext(XQPartELResolver.class);
            try {
                XQPart newPart = this.createPart(context, msg, value, props, partId);
                if (props.isContentIDDefined()) {
                    newPart.setContentId(props.contentId);
                }
                if (partId instanceof Number) {
                    msg.replacePart(newPart, ((Number)partId).intValue());
                } else if (partId instanceof String) {
                    msg.replacePart(newPart, (String)partId);
                } else {
                    msg.replacePart(newPart, newPart.getContentId());
                }
                context.setPropertyResolved(true);
            }
            catch (XQMessageException e) {
                throw new PropertyNotWritableException("Failed to replace part: " + property, (Throwable)e);
            }
            catch (TransformerException e) {
                throw new PropertyNotWritableException("Failed to replace part: " + property, (Throwable)e);
            }
        }
    }

    private XQPart createPart(ELContext context, XQMessage msg, Object value, XQMessageParts.XQPartProperties props, Object partId) throws XQMessageException, TransformerException {
        XQPart newPart = null;
        if (props.targetElementXPath != null) {
            ArrayList<Namespace> nspaces;
            if (!(value instanceof String)) {
                throw new RuntimeException("Value should be a string to be inserted as XML");
            }
            String variableStr = DOMUtils.stripXmlDeclaration((String)((String)value));
            XQPart part = this.getPartFromMsg(partId, msg);
            String xmlTarget = (String)part.getContent();
            String result = null;
            MappingContext mapCtx = (MappingContext)context.getContext(MappingContext.class);
            MessageMapper msgMapper = (MessageMapper)mapCtx.getObject(MessageMapper.class, true);
            Map<String, Namespace> nsMap = msgMapper.getNamespaceMap();
            ArrayList<Object> arrayList = nspaces = nsMap != null ? new ArrayList<Namespace>(nsMap.values()) : new ArrayList();
            result = props.newElemName != null ? InsertionHelper.assignChildElement(xmlTarget, props.targetElementXPath, props.newElemName, variableStr, props.removeChildElems, nspaces) : (props.attributeName != null ? InsertionHelper.setAttribute(xmlTarget, props.targetElementXPath, props.attributeName, variableStr, nspaces) : InsertionHelper.insertLastChild(xmlTarget, props.targetElementXPath, variableStr, false, nspaces));
            newPart = msg.createPart((Object)result, part.getContentType());
            newPart.setContentId(part.getContentId());
        } else {
            newPart = msg.createPart(value, props.contentType);
        }
        return newPart;
    }

    private XQPart getPartFromMsg(Object partId, XQMessage msg) throws XQMessageException {
        XQPart part = null;
        if (partId instanceof Number) {
            part = msg.getPart(((Number)partId).intValue());
        } else if (partId instanceof String) {
            part = msg.getPart((String)partId);
        }
        if (part == null) {
            throw new MappingException("Cannot find part[" + partId + "]");
        }
        if (part.getContentType().equals("application/octet-stream")) {
            throw new MappingException("Cannot handle part[" + partId + "] of content type " + "application/octet-stream");
        }
        if (!(part.getContent() instanceof String)) {
            throw new MappingException("Cannot handle not string part contents for part[" + partId + "]");
        }
        return part;
    }
}

