/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.framework;

import com.sonicsw.esb.framework.MessageExchange;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQCloneable;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.endpoint.container.EndpointContextContainer;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.envelope.XQMessageFactoryImpl;
import com.sonicsw.xqimpl.service.MessageHandler;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.XQDispatcher;
import java.util.HashMap;
import java.util.Map;

public class EsbMessageExchange
implements MessageExchange,
XQCloneable {
    private boolean m_inProcess;
    private XQAddress m_destAddr;
    private XQMessage m_inputMsg;
    private Map<String, Object> m_transProps;
    private XQAddress m_rmeAddress;
    private EndpointContextContainer m_endpointContext;
    private XQMessageFactory m_messageFactory;
    private EnvelopeFactory m_envelopeFactory;
    private XQParameters m_xqParams;
    private String m_sessionName;
    private XQQualityofService m_qos;
    private boolean m_commitFlag;
    private IEndpointRegistry m_endpointRegistry;
    private MessageHandler.SendBox m_sendBox;
    private boolean m_isImmediate;
    private HashMap<String, Object> m_connectionMap;
    private boolean m_isResponseToReplyTo;
    private RMEMessage m_rmeMessage;
    private XQDispatcher m_xqDispatcher;
    private Throwable m_immediateThrowable;
    private boolean m_inFaultProcess;

    public EsbMessageExchange(XQMessage inMsg, XQAddress destinationAddr) {
        this.m_inputMsg = inMsg;
        this.m_destAddr = destinationAddr;
    }

    @Override
    public XQAddress getDestinationAddress() {
        return this.m_destAddr;
    }

    @Override
    public void setDestinationAddress(XQAddress xqAddress) {
        this.m_destAddr = xqAddress;
    }

    @Override
    public XQMessage getInputMessage() {
        return this.m_inputMsg;
    }

    @Override
    public void setInputMessage(XQMessage msg) {
        this.m_inputMsg = msg;
    }

    public XQMessage createMessage() {
        return this.m_messageFactory == null ? null : this.m_messageFactory.createMessage();
    }

    @Override
    public Object getTransientProperty(String transProp) {
        return this.m_transProps == null ? null : this.m_transProps.get(transProp);
    }

    public Object removeTransientProperty(String transProp) {
        return this.m_transProps == null ? null : this.m_transProps.remove(transProp);
    }

    @Override
    public void setTransientProperty(String transProp, Object value) {
        if (this.m_transProps == null) {
            this.m_transProps = new HashMap<String, Object>(3);
        }
        this.m_transProps.put(transProp, value);
    }

    @Override
    public void setRMEAddress(XQAddress rmeAddress) {
        this.m_rmeAddress = rmeAddress;
    }

    @Override
    public XQAddress getRMEAddress() {
        return this.m_rmeAddress;
    }

    public void setEndpointContext(EndpointContextContainer endpointContext) {
        this.m_endpointContext = endpointContext;
    }

    public EndpointContextContainer getEndpointContext() {
        return this.m_endpointContext;
    }

    public void setMessageFactory(XQMessageFactory messageFactory) {
        this.m_messageFactory = messageFactory;
    }

    @Override
    public XQMessageFactory getMessageFactory() {
        return this.m_messageFactory;
    }

    public void setEnvelopeFactory(EnvelopeFactory envelopeFactory) {
        this.m_envelopeFactory = envelopeFactory;
    }

    public EnvelopeFactory getEnvelopeFactory() {
        return this.m_envelopeFactory;
    }

    public void setXQParameters(XQParameters params) {
        this.m_xqParams = params;
    }

    public XQParameters getXQParameters() {
        return this.m_xqParams;
    }

    public static EsbMessageExchange create(XQMessage message, XQAddress destinationAddress, XQParameters params, EnvelopeFactory envelopeFactory, XQMessageFactory messageFactory, EndpointContextContainer endpointContext, XQAddress rmeAddress) {
        EsbMessageExchange esbMex = new EsbMessageExchange(message, destinationAddress);
        esbMex.setXQParameters(params);
        esbMex.setEnvelopeFactory(envelopeFactory);
        esbMex.setMessageFactory(messageFactory);
        esbMex.setEndpointContext(endpointContext);
        esbMex.setRMEAddress(rmeAddress);
        esbMex.setQOS(endpointContext.getQualityofService());
        esbMex.setEndpointRegistry(endpointContext.getEndpointRegistry());
        return esbMex;
    }

    public static EsbMessageExchange createImmediate(String sessionName, XQAddress address, XQMessageFactory messageFactory, XQMessage message, XQParameters environment, XQQualityofService qos, boolean commit, IEndpointRegistry er) {
        EsbMessageExchange esbMex = new EsbMessageExchange(message, address);
        esbMex.setSessionName(sessionName);
        esbMex.setMessageFactory(messageFactory);
        esbMex.setXQParameters(environment);
        esbMex.setQOS(qos);
        esbMex.setCommitFlag(commit);
        esbMex.setEndpointRegistry(er);
        esbMex.setExchangeImmediate(true);
        return esbMex;
    }

    public String getSessionName() {
        return this.m_sessionName;
    }

    public void setSessionName(String sessionName) {
        this.m_sessionName = sessionName;
    }

    public XQQualityofService getQOS() {
        return this.m_qos;
    }

    public void setQOS(XQQualityofService qos) {
        this.m_qos = qos;
    }

    public boolean getCommitFlag() {
        return this.m_commitFlag;
    }

    public void setCommitFlag(boolean commitFlag) {
        this.m_commitFlag = commitFlag;
    }

    public IEndpointRegistry getEndpointRegistry() {
        return this.m_endpointRegistry;
    }

    public void setEndpointRegistry(IEndpointRegistry endpointRegistry) {
        this.m_endpointRegistry = endpointRegistry;
    }

    public MessageHandler.SendBox getSendBox() {
        return this.m_sendBox;
    }

    public void setSendBox(MessageHandler.SendBox sendBox) {
        this.m_sendBox = sendBox;
    }

    public boolean isInProcess() {
        return this.m_inProcess;
    }

    public void setInProcess(boolean inProcess) {
        this.m_inProcess = inProcess;
    }

    @Override
    public boolean isExchangeImmediate() {
        return this.m_isImmediate;
    }

    public void setExchangeImmediate(boolean isImmediate) {
        this.m_isImmediate = isImmediate;
    }

    public HashMap<String, Object> getConnectionMap() {
        return this.m_connectionMap;
    }

    public void setConnectionMap(HashMap<String, Object> connectionMap) {
        this.m_connectionMap = connectionMap;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void populate(XQParameters params, EnvelopeFactory envelopeFactory, XQMessageFactoryImpl messageFactory, XQAddress rmeAddress, boolean inProcess) {
        if (inProcess) {
            if (this.m_envelopeFactory == null) {
                this.m_envelopeFactory = envelopeFactory;
            }
            this.m_messageFactory = messageFactory;
            if (this.m_rmeAddress == null) {
                this.m_rmeAddress = rmeAddress;
            }
        } else {
            this.m_xqParams = params;
            this.m_envelopeFactory = envelopeFactory;
            this.m_messageFactory = messageFactory;
            this.m_rmeAddress = rmeAddress;
        }
    }

    public void setResponseToReplyTo(boolean responseToReplyTo) {
        this.m_isResponseToReplyTo = responseToReplyTo;
    }

    public boolean isResponseToReplyTo() {
        return this.m_isResponseToReplyTo;
    }

    public void setRMEMessage(RMEMessage rmeMessage) {
        this.m_rmeMessage = rmeMessage;
    }

    public RMEMessage getRMEMessage() {
        return this.m_rmeMessage;
    }

    public void setImmediateThrowable(Throwable t) {
        if (this.m_isImmediate) {
            this.m_immediateThrowable = t;
        }
    }

    public Throwable getImmediateThrowable() {
        return this.m_immediateThrowable;
    }

    public void setXQDispatcher(XQDispatcher dispatcher) {
        this.m_xqDispatcher = dispatcher;
    }

    public XQDispatcher getXQDispatcher() {
        return this.m_xqDispatcher;
    }

    public boolean isInFaultProcess() {
        return this.m_inFaultProcess;
    }

    public void setInFaultProcess(boolean inFaultProc) {
        this.m_inFaultProcess = inFaultProc;
    }
}

