/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.continuation;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.continuation.FaultItineraryContinuation;
import com.sonicsw.esb.itinerary.continuation.ItineraryContinuation;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceGenerator;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceSerializer;
import com.sonicsw.esb.process.engine.ProcessContinuationSupport;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQFaultProcessContinuation;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQProcessContinuation;
import com.sonicsw.xq.XQRuntimeProcess;
import com.sonicsw.xqimpl.envelope.XQMessageFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQProcessStepRoutingAddressImpl;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class ItineraryContinuationSupport
implements ProcessContinuationSupport {
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);
    private static XQMessageFactory s_msgFactory = new XQMessageFactoryImpl();

    @Override
    public XQProcessContinuation generateContinuation(Token token, XQProcessContinuation.Level level) {
        try {
            XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
            return this.generateContinuation(token, procInst, level);
        }
        catch (Throwable e) {
            throw new ItineraryException(e, "Cannot passivate itinerary due to exception .. ", token);
        }
    }

    private ItineraryContinuation generateContinuation(Token token, XQProcessInstance procInst, XQProcessContinuation.Level level) throws Throwable {
        ItineraryContinuation continuation = null;
        if (procInst instanceof FaultProcessInstance) {
            continuation = new FaultItineraryContinuation(procInst, level);
            XQProcessInstance origProcInst = ((FaultProcessInstance)procInst).getOriginalProcessInstance();
            ItineraryContinuation origProcContinuation = this.generateContinuation(token, origProcInst, level);
            ((XQFaultProcessContinuation)continuation).setOriginalProcessContinuation((XQProcessContinuation)origProcContinuation);
        } else {
            continuation = new ItineraryContinuation(procInst, level);
        }
        if (level == XQProcessContinuation.Level.ITINERARY) {
            this.setProcessInstanceData(token, continuation, procInst);
        }
        return continuation;
    }

    private void setProcessInstanceData(Token token, XQProcessContinuation continuation, XQProcessInstance procInst) throws Throwable {
        ItineraryEngine pe = (ItineraryEngine)XQContainer.getProcessEngine();
        XQMessage origMessage = ((EsbMessageExchange)token.getData()).getInputMessage();
        XQMessage newMessage = s_msgFactory.createMessage();
        ((EsbMessageExchange)token.getData()).setInputMessage(newMessage);
        ActivityNode node = ((XQProcessInstance)token.getProcessInstance()).getActiveEsbNode(token);
        XQProcessInstanceSerializer procInstSerializer = (XQProcessInstanceSerializer)pe.getProcessInstanceSerializerFactory().createProcessInstanceSerializer();
        procInstSerializer.setIncludeCurrentStep(true);
        procInstSerializer.serialize(node, token);
        continuation.setProcessInstanceData((Object)newMessage);
        ((EsbMessageExchange)token.getData()).setInputMessage(origMessage);
    }

    @Override
    public void resumeContinuation(XQProcessContinuation continuation, Token token) {
        String rootProcessName = continuation.getRootProcessName();
        String stepName = continuation.getCompositeStepName();
        if (rootProcessName == null) {
            throw new ItineraryException("The root process name cannot be null in the continuation `" + continuation.getID() + "`", token);
        }
        if (stepName == null) {
            throw new ItineraryException("The step name cannot be null in the continuation `" + continuation.getID() + "`", token);
        }
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        try {
            XQProcessStepRoutingAddressImpl address = new XQProcessStepRoutingAddressImpl(rootProcessName, stepName, rootProcessName, stepName);
            mex.setDestinationAddress((XQAddress)address);
            ItineraryEngine itinEngine = (ItineraryEngine)XQContainer.getProcessEngine();
            if (continuation.getLevel() == XQProcessContinuation.Level.ITINERARY) {
                if (continuation.getProcessInstanceData() == null) {
                    System.out.println("Ignoring ProcessInstance data as it is missing from Level 2 continuation `" + continuation.getID() + "`");
                } else if (!(continuation.getProcessInstanceData() instanceof XQMessage)) {
                    System.out.println("Ignoring processInstance data as it is not an instance of XQMessage for Level 2 continuation `" + continuation.getID() + "`");
                } else {
                    System.out.println("RESUMING level 2 continuation");
                    this.populateFromProcessInstanceData(itinEngine, token, (XQMessage)continuation.getProcessInstanceData());
                    System.out.println("RESUMED level 2 continuation");
                }
            } else {
                if (continuation instanceof XQFaultProcessContinuation) {
                    XQProcessContinuation origProcContinuation = ((XQFaultProcessContinuation)continuation).getOriginalProcessContinuation();
                    this.resumeContinuation(origProcContinuation, token);
                    mex.setDestinationAddress((XQAddress)address);
                }
                itinEngine.processContinuationTokenForStep(token, rootProcessName, stepName);
            }
            if (continuation.getLevel().isGreaterThan(XQProcessContinuation.Level.STATELESS)) {
                ((XQMessageInternal)mex.getInputMessage()).addSidebandProperty("TokenWithActivationInfo", token);
                XQProcessInstance newInstance = (XQProcessInstance)token.getProcessInstance();
                this.inheritProcessContextFromContinuation(newInstance, continuation);
            }
        }
        catch (ItineraryException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ItineraryException(e, "Error resuming continuation `" + continuation.getID() + "` for process =`" + rootProcessName + "` Step = `" + stepName, token);
        }
        if (s_log.isDebugLoggingEnabled()) {
            s_log.logDebug("Populated information related to continuation `" + continuation.getID() + "` level `" + continuation.getLevel() + "`");
        }
    }

    private void inheritProcessContextFromContinuation(XQProcessInstance newInstance, XQProcessContinuation continuation) {
        long ttl;
        int trackingLevel;
        String trackingID;
        ProcessInstanceProps procInstProps = newInstance.getProcessInstanceProperties();
        XQRuntimeProcess processContext = continuation.getProcessRuntime();
        if (processContext == null) {
            return;
        }
        XQAddress address = processContext.getEventAddress();
        if (address != null) {
            procInstProps.setTrackingEndpoint(address == XQProcessContinuation.NULL_ADDRESS ? null : address);
        }
        if ((address = processContext.getFaultAddress()) != null) {
            procInstProps.setFaultAddress(address == XQProcessContinuation.NULL_ADDRESS ? null : address);
        }
        if ((address = processContext.getRMEAddress()) != null) {
            procInstProps.setRMEAddress(address == XQProcessContinuation.NULL_ADDRESS ? null : address);
        }
        this.overrideExitEndpoints(procInstProps, processContext);
        Properties inflightProps = processContext.getInflightProperties();
        if (inflightProps != null) {
            procInstProps.setInflightProperties(inflightProps);
        }
        if ((trackingID = processContext.getTrackingID()) != null) {
            procInstProps.setTrackingId(trackingID);
        }
        if ((trackingLevel = processContext.getTrackingLevel()) >= 0) {
            procInstProps.setTrackingLevel(trackingLevel);
        }
        if ((ttl = processContext.getTTL()) >= 0L) {
            procInstProps.setTTL(ttl);
        }
    }

    private void overrideExitEndpoints(ProcessInstanceProps procInstProps, XQRuntimeProcess processContext) {
        HashSet<XQAddress> exitAddresses = null;
        Iterator exitEndpoints = processContext.getExitEndpoints();
        boolean setNull = false;
        if (exitEndpoints != null) {
            exitAddresses = new HashSet<XQAddress>();
            while (exitEndpoints.hasNext()) {
                XQAddress address = (XQAddress)exitEndpoints.next();
                if (address == XQProcessContinuation.NULL_ADDRESS) {
                    setNull = true;
                    exitAddresses.clear();
                    break;
                }
                exitAddresses.add(address);
            }
        }
        if (exitAddresses != null && exitAddresses.size() > 0) {
            procInstProps.setExitAddresses(exitAddresses);
        } else if (setNull) {
            procInstProps.setExitAddresses(null);
        }
    }

    public void populateFromProcessInstanceData(ItineraryEngine engine, Token token, XQMessage msgWithProcInstInfo) throws Throwable {
        XQMessage origMessage = ((EsbMessageExchange)token.getData()).getInputMessage();
        ((EsbMessageExchange)token.getData()).setInputMessage(msgWithProcInstInfo);
        XQProcessInstanceGenerator procInstGenerator = (XQProcessInstanceGenerator)engine.getProcessInstanceGeneratorFactory().createProcessInstanceGenerator();
        procInstGenerator.setInsertFirstStep(false);
        token.setProcessInstance(procInstGenerator.retrieveProcessInstance(token));
        ((EsbMessageExchange)token.getData()).setInputMessage(origMessage);
    }
}

