/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.def;

import com.sonicsw.esb.itinerary.def.Common;
import com.sonicsw.esb.itinerary.def.Itinerary;
import com.sonicsw.esb.itinerary.def.XQProcess;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.ForkNode;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.MergeNode;
import com.sonicsw.esb.process.model.impl.DefaultActivityEdge;
import com.sonicsw.esb.process.model.impl.DefaultForkNode;
import com.sonicsw.esb.process.model.impl.DefaultMergeNode;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Fanout {
    public static final String FANOUT = "fanout";
    public static final String PATH = "path";
    static int count = 0;

    public static ActivityNode[] parse(Element fanoutElem, MainProcess parentProcess) {
        assert (fanoutElem.getLocalName().equals(FANOUT));
        String name = fanoutElem.getAttribute("name");
        if (name == null || "".equals(name.trim())) {
            name = "Fanout-" + ++count;
        }
        DefaultForkNode forkNode = new DefaultForkNode(name, parentProcess);
        parentProcess.addActivityNode(forkNode);
        DefaultMergeNode mergeNode = new DefaultMergeNode("merge." + name, parentProcess);
        parentProcess.addActivityNode(mergeNode);
        NodeList childNodes = fanoutElem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            if (PATH.equals(childNode.getLocalName())) {
                Element pathElem = (Element)childNode;
                ActivityNode lastNode = Itinerary.parseSteps(pathElem, parentProcess, (ActivityNode)forkNode);
                if (lastNode instanceof FlowTerminationNode) continue;
                DefaultActivityEdge edge = new DefaultActivityEdge(lastNode, mergeNode);
                parentProcess.addActivityEdge(edge);
                continue;
            }
            throw new Error("Invalid element in the esb process schema");
        }
        ActivityNode[] nodes = new ActivityNode[]{forkNode, mergeNode};
        return nodes;
    }

    public static ActivityNode[] parse(XMLStreamReader xsr, MainProcess parentProcess) throws XMLStreamException {
        String name = xsr.getAttributeValue(null, "name");
        if (name == null || "".equals(name.trim())) {
            name = "Fanout-" + ++count;
        }
        DefaultForkNode forkNode = new DefaultForkNode(name, parentProcess);
        parentProcess.addActivityNode(forkNode);
        DefaultMergeNode mergeNode = new DefaultMergeNode("merge." + name, parentProcess);
        parentProcess.addActivityNode(mergeNode);
        while (xsr.hasNext()) {
            String stepElemName;
            int eventType = xsr.next();
            if (eventType == 1) {
                stepElemName = xsr.getLocalName();
                if (PATH.equals(stepElemName)) {
                    ActivityNode lastNode = Itinerary.parseSteps(xsr, parentProcess, (ActivityNode)forkNode);
                    if (lastNode instanceof FlowTerminationNode) continue;
                    DefaultActivityEdge edge = new DefaultActivityEdge(lastNode, mergeNode);
                    parentProcess.addActivityEdge(edge);
                    continue;
                }
                throw new Error("Invalid element in the esb process schema");
            }
            if (eventType != 2 || !FANOUT.equals(stepElemName = xsr.getLocalName())) continue;
            break;
        }
        ActivityNode[] nodes = new ActivityNode[]{forkNode, mergeNode};
        return nodes;
    }

    public static MergeNode serialize(ForkNode node, Writer writer) throws IOException {
        MergeNode mergeResultNode = null;
        writer.write("<xq:fanout");
        Common.marshallAttribute("name", node.getId(), writer);
        writer.write(">");
        ActivityEdge[] edges = node.getOutgoingEdges();
        for (int i = 0; i < edges.length; ++i) {
            writer.write("<xq:path>");
            MergeNode mergeNode = Fanout.serializeBranch(edges[i], writer);
            if (mergeNode != null) {
                mergeResultNode = mergeNode;
            }
            writer.write("</xq:path>");
        }
        writer.write("</xq:fanout>");
        return mergeResultNode;
    }

    static MergeNode serializeBranch(ActivityEdge edge, Writer writer) throws IOException {
        ActivityNode next = null;
        while (edge != null) {
            next = edge.getDestination();
            assert (next != null);
            if (next instanceof MergeNode) {
                return (MergeNode)next;
            }
            next = XQProcess.marshallActivityNode(next, writer);
            edge = null;
            ActivityEdge[] outgoingEdges = null;
            if (next != null) {
                outgoingEdges = next.getOutgoingEdges();
            }
            if (outgoingEdges == null || outgoingEdges.length <= 0) continue;
            edge = outgoingEdges[0];
        }
        return null;
    }
}

