/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceGenerator;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.process.engine.ProcessInstanceGenerator;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.FaultHandler;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.XQContainer;
import java.util.List;

public class FaultProcessInstance
extends XQProcessInstance {
    private XQProcessInstance m_origProcInst;
    private ProcessInstanceProps m_origProcInstProps;
    private RMEMessage m_origRMEMsg;

    protected FaultProcessInstance() {
    }

    protected FaultProcessInstance(ProcessInstanceGenerator instGenerator, MainProcess process, XQProcessConfig procCfg, Token token) {
        this.init(instGenerator, token, process, procCfg);
    }

    public FaultProcessInstance(ProcessInstanceGenerator instGen, List<XQPart> procParts, ProcessInstanceProps procInstProps, Token token, boolean insertFirstStep) throws Throwable {
        super(instGen, procParts, procInstProps, token, insertFirstStep);
        this.parseFaultHandlingInfo(instGen, token);
        this.m_origProcInst.setFaultHandlerProcessInstance(this);
        this.m_origProcInstProps = this.m_origProcInst.getProcessInstanceProperties();
        this.m_procInstProps.tagAsFaultHandler(true);
    }

    protected FaultProcessInstance(ProcessInstanceGenerator instGen, ESBProcess process, XQProcessConfig procCfg, XQProcessInstance parentProcInst) {
        super(instGen, process, procCfg, parentProcInst);
        this.m_origRMEMsg = ((FaultProcessInstance)parentProcInst).m_origRMEMsg;
        this.m_origProcInst = ((FaultProcessInstance)parentProcInst).m_origProcInst;
        this.m_origProcInstProps = this.m_origProcInst.getProcessInstanceProperties();
        this.m_origProcInst.setFaultHandlerProcessInstance(this);
        this.m_procInstProps.tagAsFaultHandler(true);
    }

    protected final void init(ProcessInstanceGenerator instGenerator, Token token, MainProcess process, XQProcessConfig procCfg) {
        super.init(instGenerator, process, procCfg, (EsbMessageExchange)token.getData());
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        RMEMessage rmeMsg = mex.getRMEMessage();
        this.setOriginalRMEMsg(rmeMsg);
        if (rmeMsg != null) {
            rmeMsg.serializeHeaders(mex.getInputMessage());
        } else {
            this.addFaultHeaders(mex.getInputMessage(), mex.getXQParameters());
        }
        mex.setRMEMessage(null);
        this.m_origProcInst = (XQProcessInstance)token.getProcessInstance();
        this.m_origProcInstProps = this.m_origProcInst.getProcessInstanceProperties();
        this.m_procInstProps.inherit(this.m_origProcInstProps);
        mex.setRMEAddress(this.m_procInstProps.getRMEAddress());
        this.setProcessTracker(this.m_origProcInst.getprocessTracker());
        this.setFaultHandlingInfo(token);
        this.m_origProcInst.setFaultHandlerProcessInstance(this);
        this.m_procInstProps.tagAsFaultHandler(true);
    }

    protected FaultProcessInstance(ProcessInstanceGenerator instGen, FaultHandler fh, Token token) {
        ActivityNode faultHandlerNode = fh.getFaultHandlerActivityNode("*", token);
        ESBProcess faultHandlerProc = (ESBProcess)faultHandlerNode;
        XQProcessConfig procConfig = ((ItineraryEngine)XQContainer.getProcessEngine()).lookupProcessConfig(faultHandlerProc.getProcessName(), token);
        this.init(instGen, token, faultHandlerProc, procConfig);
    }

    protected FaultProcessInstance(ProcessInstanceGenerator instGen, FaultProcessInstance childInstance, Token token, int index) {
        super(instGen, childInstance, token, index);
        this.m_origProcInst = childInstance.getOriginalProcessInstance();
        this.m_origProcInstProps = childInstance.getOriginalProcessInstanceProps();
        this.m_origRMEMsg = childInstance.getOriginalRMEMsg();
        this.m_procInstProps.tagAsFaultHandler(true);
    }

    @Override
    public FaultProcessInstance clone() {
        FaultProcessInstance newInstance = new FaultProcessInstance();
        this.clone(newInstance);
        newInstance.m_origProcInst = this.m_origProcInst;
        newInstance.m_origProcInstProps = this.m_origProcInstProps;
        newInstance.m_origRMEMsg = this.m_origRMEMsg;
        return newInstance;
    }

    private void parseFaultHandlingInfo(ProcessInstanceGenerator instGen, Token token) throws Throwable {
        XQPart rmePart;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQMessage inputMessage = mex.getInputMessage();
        List<XQPart> origProcessParts = XQProcessInstanceGenerator.getProcessMetadataParts(inputMessage, "application/x-sonicxq-faultheader; version=2.0");
        if (origProcessParts.size() == 0) {
            throw new ItineraryException("Fault handling information is missing in the message", token);
        }
        ProcessInstanceProps origProcInstProps = ProcessInstanceProps.create(origProcessParts.get(0), token);
        origProcessParts.remove(0);
        if (origProcessParts.size() > 1 && "Orig.RMEMessage".equals((rmePart = origProcessParts.get(origProcessParts.size() - 1)).getContentId())) {
            this.setOriginalRMEMsg(new RMEMessage(rmePart, inputMessage));
            origProcessParts.remove(rmePart);
        }
        this.m_origProcInst = new XQProcessInstance(instGen, origProcessParts, origProcInstProps, token, false);
    }

    public void setFaultHandlingInfo(Token token) {
        ActivityNode node = (ActivityNode)token.getProperty("TargetNode");
        this.m_origProcInstProps.setFaultHandlerTargetNode(token, node);
    }

    public XQProcessInstance getOriginalProcessInstance() {
        return this.m_origProcInst;
    }

    public ProcessInstanceProps getOriginalProcessInstanceProps() {
        return this.m_origProcInstProps;
    }

    public void setOriginalRMEMsg(RMEMessage rmeMsg) {
        this.m_origRMEMsg = rmeMsg;
    }

    public RMEMessage getOriginalRMEMsg() {
        return this.m_origRMEMsg;
    }

    public int getFaultHandlerRetryCount() {
        int retryCount = 0;
        String retryCountStr = (String)this.m_procInstProps.createInflightPropsIfNull().get("SonicXQ.process.FaultHandlerRetryCount");
        if (retryCountStr != null) {
            try {
                retryCount = Integer.parseInt(retryCountStr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return retryCount;
    }

    public void setFaultHandlerRetryCount(int count) {
        this.m_procInstProps.createInflightPropsIfNull().put("SonicXQ.process.FaultHandlerRetryCount", count + "");
    }

    @Override
    public ActivityNode unwind(Token token, int unWindCount) {
        ActivityNode parentNode = super.unwind(token, unWindCount);
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (!(procInst instanceof FaultProcessInstance)) {
            throw new ItineraryException("The parent instance of a fault handler instance shoudl also be of type fault handler", token);
        }
        FaultProcessInstance fhInst = (FaultProcessInstance)procInst;
        fhInst.getOriginalProcessInstance().setFaultHandlerProcessInstance(fhInst);
        return parentNode;
    }

    public void addFaultHeaders(XQMessage message, XQParameters params) {
        if (params == null) {
            return;
        }
        try {
            message.setStringHeader("SonicESB.RME.Process", params.getParameter("SonicXQ.ProcessName", 1));
            message.setStringHeader("SonicESB.RME.TopProcess", params.getParameter("SonicXQ.TopLevelProcessName", 1));
            message.setStringHeader("SonicESB.RME.Step", params.getParameter("SonicXQ.ProcessStep", 1));
            message.setStringHeader("SonicESB.RME.Host", XQContainer.getLocation());
            message.setStringHeader("SonicESB.RME.XQContainer", params.getParameter("SonicXQ.ContainerName", 1));
            message.setStringHeader("SonicESB.RME.XQService", params.getParameter("SonicXQ.ServiceName", 1));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeFaultHeaders(XQMessage message) {
        try {
            message.removeHeader("SonicESB.RME.Process");
            message.removeHeader("SonicESB.RME.TopProcess");
            message.removeHeader("SonicESB.RME.Step");
            message.removeHeader("SonicESB.RME.Host");
            message.removeHeader("SonicESB.RME.XQContainer");
            message.removeHeader("SonicESB.RME.XQService");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

