/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.CannotDetermineRME;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessTracker;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQTrackingDetailsConfig;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQAddressImpl;
import com.sonicsw.xqimpl.ws.addressing.WSAHeaders;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ProcessInstanceProps
implements Cloneable {
    private Map m_props;
    private Map m_inflightProps;
    private XQAddress m_faultAddress;
    private XQAddress m_rmeAddress;
    private XQAddress m_trackingEndpoint;
    private Set<XQAddress> m_exitAddresses;
    private ProcessTracker m_tracker;
    private XQAddress m_customFaultAddress;
    private String m_stepBreadcrumb;
    private static final String PREFIX = "SonicXQ.process.InflightProps.";

    ProcessInstanceProps(XQProcessInstance procInst, EsbMessageExchange mex) {
        this.m_props = new Properties();
        this.setAllValues(procInst, mex);
    }

    public ProcessInstanceProps(Properties props, Token token) throws IOException {
        this.m_props = props;
        if (token != null) {
            this.validate(token);
        }
        this.handleCustomProperties();
        this.calculateStepNameBreadcrumpTrail();
    }

    public ProcessInstanceProps(Properties props) throws IOException {
        this(props, null);
    }

    private void validate(Token token) {
        if (this.getRMEAddress() == null) {
            if (this.getRootProcessName() == null) {
                throw new CannotDetermineRME("The top level process name property is missing in the process properties part", token);
            }
            if (this.getStepName() == null) {
                throw new CannotDetermineRME("The current step name property is missing in the process properties part", token);
            }
        }
    }

    final void setAllValues(XQProcessInstance procInst, EsbMessageExchange mex) {
        ESBProcess process = (ESBProcess)procInst.getProcessDefinition();
        this.setProcessName(process.getProcessName());
        try {
            XQProcessConfig procCfg = procInst.getProcessConfig();
            if (procCfg != null) {
                this.setRMEAddress(procCfg.getRejectedMessageEndpoint());
                mex.setRMEAddress(this.m_rmeAddress);
                this.setExitAddresses(procCfg.getExitEndpoints());
                this.setFaultAddress(procCfg.getFaultEndpoint());
                XQTrackingDetailsConfig trackingDetails = procCfg.getTrackingDetails();
                if (trackingDetails != null && trackingDetails.getTrackingLevel() > 0) {
                    this.m_tracker = new ProcessTracker(procCfg, trackingDetails, mex);
                    this.setTrackingId(this.m_tracker.getTrackingID());
                    this.setTrackingLevel(trackingDetails.getTrackingLevel());
                    this.setTrackingEndpoint(trackingDetails.getEventEndpoint());
                }
                this.setQualityOfService(procCfg.getQOS());
                this.setTTL(procCfg.getTimeToLive());
            }
            this.setTimeStamp(procInst.getTimestamp());
            this.setRootProcessName(process.getProcessName());
            if (mex.getDestinationAddress() instanceof XQProcessAddress) {
                this.m_inflightProps = ((XQProcessAddress)mex.getDestinationAddress()).getInflightProperties();
            }
            this.calculateStepNameBreadcrumpTrail();
        }
        catch (ItineraryException e) {
            e.setProcessName(this.getProcessName());
            throw e;
        }
    }

    public void overrideValues(XQProcessInstance procInst, EsbMessageExchange mex) {
        if (procInst.isSubProcess()) {
            ESBProcess process = (ESBProcess)procInst.getProcessDefinition();
            this.setProcessName(process.getProcessName());
            this.calculateStepNameBreadcrumpTrail();
        } else {
            this.setAllValues(procInst, mex);
        }
    }

    private void calculateStepNameBreadcrumpTrail() {
        int index;
        String currentStepName = this.getStepName();
        if (currentStepName != null && (index = currentStepName.lastIndexOf(58)) > 0) {
            this.m_stepBreadcrumb = currentStepName.substring(0, index);
        }
    }

    private ProcessInstanceProps() {
    }

    public ProcessInstanceProps clone() {
        ProcessInstanceProps newProps = new ProcessInstanceProps();
        newProps.m_props = (Properties)((Properties)this.m_props).clone();
        if (this.m_inflightProps != null) {
            newProps.m_inflightProps = (Properties)((Properties)this.m_inflightProps).clone();
        }
        newProps.m_faultAddress = this.m_faultAddress;
        newProps.m_rmeAddress = this.m_rmeAddress;
        newProps.m_trackingEndpoint = this.m_trackingEndpoint;
        newProps.m_tracker = this.m_tracker;
        newProps.m_customFaultAddress = this.m_customFaultAddress;
        newProps.m_stepBreadcrumb = this.m_stepBreadcrumb;
        return newProps;
    }

    public void clearAll() {
        this.m_props.clear();
    }

    public Properties getAllProcessProps() {
        return (Properties)this.m_props;
    }

    public Properties getInflightProps() {
        return (Properties)this.m_inflightProps;
    }

    public Properties createInflightPropsIfNull() {
        if (this.m_inflightProps == null) {
            this.m_inflightProps = new Properties();
        }
        return (Properties)this.m_inflightProps;
    }

    public String getProcessName() {
        return ((Properties)this.m_props).getProperty("SonicXQ.ProcessName");
    }

    public void setProcessName(String processName) {
        if (processName != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.ProcessName", processName);
        }
    }

    public String getStepName() {
        return ((Properties)this.m_props).getProperty("SonicXQ.ProcessStep");
    }

    public String getParentStepsTrail() {
        return this.m_stepBreadcrumb;
    }

    public void setParentStepsTrail(String parentStepTrail) {
        this.m_stepBreadcrumb = parentStepTrail;
    }

    public void pushParentStepName() {
        String stepName = this.getStepName();
        if (stepName != null) {
            this.m_stepBreadcrumb = stepName;
        }
    }

    public void popParentStepName() {
        if (this.m_stepBreadcrumb != null) {
            int index = this.m_stepBreadcrumb.lastIndexOf(58);
            this.m_stepBreadcrumb = index != -1 ? this.m_stepBreadcrumb.substring(0, index) : "";
        }
    }

    public void setStepName(String stepName, XQProcessInstance procInst) {
        String completeStepName = procInst.getCompleteStepName(stepName);
        ((Properties)this.m_props).setProperty("SonicXQ.ProcessStep", completeStepName);
    }

    public void setStepName(String stepName) {
        ((Properties)this.m_props).setProperty("SonicXQ.ProcessStep", stepName);
    }

    public String getContentsAsString() throws IOException {
        Properties props = new Properties();
        this.insertInflightProps(props);
        props.putAll(this.m_props);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, "SonicXQ business process properties");
        String content = baos.toString();
        baos.close();
        return content;
    }

    public String getRootProcessName() {
        return ((Properties)this.m_props).getProperty("SonicXQ.TopLevelProcessName");
    }

    public void setRootProcessName(String rootProcName) {
        ((Properties)this.m_props).setProperty("SonicXQ.TopLevelProcessName", rootProcName);
    }

    public XQAddress getTrackingEndpoint() {
        String param;
        if (this.m_trackingEndpoint == null && (param = ((Properties)this.m_props).getProperty("SonicXQ.process.eventAddress")) != null) {
            this.m_trackingEndpoint = new XQAddressImpl(param);
        }
        return this.m_trackingEndpoint;
    }

    public void setTrackingEndpoint(XQAddress trackingEndpoint) {
        if (trackingEndpoint != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.eventAddress", trackingEndpoint.toString());
        }
        this.m_trackingEndpoint = trackingEndpoint;
    }

    public String getTrackingId() {
        return ((Properties)this.m_props).getProperty("SonicXQ.process.trackingID");
    }

    public void setTrackingId(String trackingID) {
        if (trackingID != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.trackingID", trackingID);
        }
    }

    public int getTrackingLevel() {
        String param = ((Properties)this.m_props).getProperty("SonicXQ.process.trackingLevel");
        if (param != null) {
            return Integer.parseInt(param);
        }
        return 0;
    }

    public void setTrackingLevel(int tLevel) {
        ((Properties)this.m_props).setProperty("SonicXQ.process.trackingLevel", tLevel + "");
    }

    public Set<XQAddress> getExitAddresses() {
        if (this.m_exitAddresses == null) {
            this.m_exitAddresses = new HashSet<XQAddress>();
            String param = ((Properties)this.m_props).getProperty("SonicXQ.process.exitEndpoints");
            if (param != null) {
                String[] st;
                for (String strAddr : st = param.split("[\\[\\]]|(, )")) {
                    if (strAddr.length() <= 0) continue;
                    XQAddress address = ProcessInstanceProps.fromXQAddressString(strAddr);
                    this.m_exitAddresses.add(address);
                }
            }
        }
        return this.m_exitAddresses;
    }

    public void setExitAddresses(Set<XQAddress> exitAddresses) {
        if (exitAddresses != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.exitEndpoints", exitAddresses.toString());
        }
        this.m_exitAddresses = exitAddresses;
    }

    public XQAddress getFaultAddress() {
        String faultAddress;
        if (this.m_faultAddress == null && (faultAddress = ((Properties)this.m_props).getProperty("SonicXQ.process.faultAddress")) != null) {
            this.m_faultAddress = ProcessInstanceProps.fromXQAddressString(faultAddress);
        }
        return this.m_faultAddress;
    }

    public void setFaultAddress(XQAddress faultAddress) {
        if (faultAddress != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.faultAddress", faultAddress.toString());
        }
        this.m_faultAddress = faultAddress;
    }

    public XQAddress getUserDefinedFaultAddress() {
        String faultAddress;
        if (this.m_customFaultAddress == null && (faultAddress = ((Properties)this.m_props).getProperty("SonicXQ.process.customFaultAddress")) != null) {
            this.m_customFaultAddress = ProcessInstanceProps.fromXQAddressString(faultAddress);
        }
        return this.m_customFaultAddress;
    }

    public void setUserDefinedFaultAddress(XQAddress faultAddress) {
        if (faultAddress != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.customFaultAddress", faultAddress.toString());
        }
        this.m_customFaultAddress = faultAddress;
    }

    public XQAddress getRMEAddress() {
        String rmeAddress;
        if (this.m_rmeAddress == null && (rmeAddress = ((Properties)this.m_props).getProperty("SonicXQ.process.RMEAddress")) != null) {
            this.m_rmeAddress = ProcessInstanceProps.fromXQAddressString(rmeAddress);
        }
        return this.m_rmeAddress;
    }

    public void setRMEAddress(XQAddress rmeAddress) {
        if (rmeAddress != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.RMEAddress", rmeAddress.toString());
        }
        this.m_rmeAddress = rmeAddress;
    }

    public long getTimeStamp() {
        return this.getLong("SonicXQ.process.timestamp");
    }

    public void setTimeStamp(long timeStamp) {
        ((Properties)this.m_props).setProperty("SonicXQ.process.timestamp", timeStamp + "");
    }

    public long getTTL() {
        return this.getLong("SonicXQ.process.TTL");
    }

    public void setTTL(long ttl) {
        ((Properties)this.m_props).setProperty("SonicXQ.process.TTL", ttl + "");
    }

    public XQQualityofService getQualityOfService() {
        String intQosStr = ((Properties)this.m_props).getProperty("SonicXQ.process.qos");
        XQQualityofService qos = XQQualityofService.BEST_EFFORT;
        if (intQosStr != null) {
            int iQos = 0;
            try {
                iQos = Integer.parseInt(intQosStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            qos = XQQualityofService.valueOf((int)iQos);
        }
        return qos;
    }

    private void setQualityOfService(String qosStr) {
        XQQualityofService qos = XQQualityofService.valueOf((String)qosStr);
        if (qos != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.qos", qos.intValueStr());
        }
    }

    private long getLong(String propertyName) {
        String timeStampStr = ((Properties)this.m_props).getProperty(propertyName);
        if (timeStampStr != null) {
            return Long.valueOf(timeStampStr);
        }
        return 0L;
    }

    public String getCurrentProcessStepName() {
        String stepProp = this.getStepName();
        return ProcessInstanceProps.getCurrentProcessStepName(stepProp);
    }

    public static String getCurrentProcessStepName(String stepProp) {
        int index = stepProp.lastIndexOf(58);
        if (index == -1) {
            return stepProp;
        }
        return stepProp.substring(index + 1);
    }

    public void setFromEnvironment(XQParameters environment) {
        WSAHeaders wsaParam;
        HashSet setParam;
        XQAddress addrParam;
        String param = environment.getParameter("SonicXQ.ProcessStep", 1);
        if (param != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.ProcessStep", param);
        }
        if ((param = environment.getParameter("SonicXQ.process.qos", 1)) != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.qos", param);
        }
        if ((addrParam = (XQAddress)environment.getParameterObject("SonicXQ.process.RMEAddress", 3)) != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.RMEAddress", addrParam.toString());
            this.m_rmeAddress = addrParam;
        }
        if ((addrParam = (XQAddress)environment.getParameterObject("SonicXQ.process.faultAddress", 3)) != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.faultAddress", addrParam.toString());
            this.m_faultAddress = addrParam;
        }
        if ((addrParam = (XQAddress)environment.getParameterObject("SonicXQ.process.eventAddress", 3)) != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.eventAddress", addrParam.toString());
            this.m_trackingEndpoint = addrParam;
        }
        if ((param = environment.getParameter("SonicXQ.process.trackingLevel", 1)) != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.trackingLevel", param);
        }
        if ((param = environment.getParameter("SonicXQ.process.trackingID", 1)) != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.trackingID", param);
        }
        if ((param = environment.getParameter("SonicXQ.process.TTL", 1)) != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.TTL", param);
        }
        if ((param = environment.getParameter("SonicXQ.process.timestamp", 1)) != null) {
            ((Properties)this.m_props).setProperty("SonicXQ.process.timestamp", param);
        }
        if ((setParam = (HashSet)environment.getParameterObject("SonicXQ.process.exitEndpoints", 3)) != null) {
            if (setParam != null) {
                ((Properties)this.m_props).setProperty("SonicXQ.process.exitEndpoints", ((Object)setParam).toString());
            }
            this.m_exitAddresses = setParam;
        }
        this.m_inflightProps = (Properties)environment.getParameterObject("SonicXQ.process.InflightProps", 3);
        param = (String)environment.getParameterObject("SonicESB.RM.SequenceMap", 1);
        if (param != null) {
            ((Properties)this.m_props).setProperty("SonicESB.RM.SequenceMap", param);
        }
        if ((wsaParam = (WSAHeaders)environment.getParameterObject("SonicESB.RM.WSAHeaders", 3)) != null) {
            ((Properties)this.m_props).setProperty("SonicESB.RM.WSAHeaders", wsaParam.getSOAPEnvelope());
        }
    }

    public void addToEnvironment(XQParameters environment) {
        Set<XQAddress> exitAddresses;
        XQAddress address;
        String param = ((Properties)this.m_props).getProperty("SonicXQ.ProcessStep");
        if (param != null) {
            environment.setParameter("SonicXQ.ProcessStep", 1, param);
        }
        if ((param = ((Properties)this.m_props).getProperty("SonicXQ.process.qos")) != null) {
            environment.setParameter("SonicXQ.process.qos", 1, param);
        }
        if ((address = this.getRMEAddress()) != null) {
            environment.setParameterObject("SonicXQ.process.RMEAddress", 3, (Object)address);
        }
        if ((address = this.getFaultAddress()) != null) {
            environment.setParameterObject("SonicXQ.process.faultAddress", 3, (Object)address);
        }
        if ((address = this.getTrackingEndpoint()) != null) {
            environment.setParameterObject("SonicXQ.process.eventAddress", 3, (Object)address);
        }
        if ((param = ((Properties)this.m_props).getProperty("SonicXQ.process.trackingLevel")) != null) {
            environment.setParameter("SonicXQ.process.trackingLevel", 1, param);
        }
        if ((param = ((Properties)this.m_props).getProperty("SonicXQ.process.trackingID")) != null) {
            environment.setParameter("SonicXQ.process.trackingID", 1, param);
        }
        if ((param = ((Properties)this.m_props).getProperty("SonicXQ.process.TTL")) != null) {
            environment.setParameter("SonicXQ.process.TTL", 1, param);
        }
        if ((param = ((Properties)this.m_props).getProperty("SonicXQ.process.timestamp")) != null) {
            environment.setParameter("SonicXQ.process.timestamp", 1, param);
        }
        if ((exitAddresses = this.getExitAddresses()) != null) {
            environment.setParameterObject("SonicXQ.process.exitEndpoints", 3, exitAddresses);
        }
        if (this.m_inflightProps != null) {
            environment.setParameterObject("SonicXQ.process.InflightProps", 3, (Object)this.m_inflightProps);
        }
        if ((param = ((Properties)this.m_props).getProperty("SonicESB.RM.SequenceMap")) != null) {
            environment.setParameterObject("SonicESB.RM.SequenceMap", 1, (Object)param);
        }
        if ((param = ((Properties)this.m_props).getProperty("SonicESB.RM.WSAHeaders")) != null) {
            try {
                environment.setParameterObject("SonicESB.RM.WSAHeaders", 3, (Object)new WSAHeaders(param));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ProcessTracker getTracker() {
        return this.m_tracker;
    }

    public void tagAsFaultHandler(boolean isFH) {
        ((Properties)this.m_props).setProperty("SonicXQ.process.isFaultHandler", isFH + "");
    }

    public boolean getFaultHandlerTag() {
        String faultHandlerTag = ((Properties)this.m_props).getProperty("SonicXQ.process.isFaultHandler");
        return faultHandlerTag != null ? Boolean.valueOf(faultHandlerTag) : false;
    }

    public void overrideProcessAddr(XQProcessAddress processAddr) {
        processAddr.removeAllExitEndpoints();
        Set<XQAddress> exitEndpoints = this.getExitAddresses();
        if (exitEndpoints != null && exitEndpoints.size() > 0) {
            for (XQAddress address : exitEndpoints) {
                processAddr.addExitEndpoint(address);
            }
        }
        processAddr.setEventAddress(this.getTrackingEndpoint());
        processAddr.setFaultAddress(this.getFaultAddress());
        processAddr.setRMEAddress(this.getRMEAddress());
        processAddr.setTrackingID(this.getTrackingId());
        processAddr.setTrackingLevel(this.getTrackingLevel());
        processAddr.setTTL(this.getTTL());
        if (this.m_inflightProps != null && this.m_inflightProps.size() > 0) {
            Properties props = new Properties();
            props.putAll(this.m_inflightProps);
            processAddr.setInflightProperties(props);
        }
    }

    public void setFaultHandlerTargetNode(Token token, ActivityNode node) {
        if (node == null) {
            this.m_props.remove("SonicXQ.process.FaultHandlerTargetNodeName");
            this.m_props.remove("SonicXQ.process.FaultHandlerTargetNodeType");
        } else {
            ((Properties)this.m_props).setProperty("SonicXQ.process.FaultHandlerTargetNodeName", node.toString());
            ((Properties)this.m_props).setProperty("SonicXQ.process.FaultHandlerTargetNodeType", Boolean.toString(node instanceof ESBProcess));
        }
    }

    public String getFaultHandlerTargetNodeName() {
        return ((Properties)this.m_props).getProperty("SonicXQ.process.FaultHandlerTargetNodeName");
    }

    public boolean isFaultHandlerTargetProcessNode() {
        return Boolean.valueOf(((Properties)this.m_props).getProperty("SonicXQ.process.FaultHandlerTargetNodeType"));
    }

    public void insertInflightProps(Properties props) {
        if (this.m_inflightProps != null && this.m_inflightProps.size() > 0) {
            props.setProperty("SonicXQ.process.InflightProps", "true");
            for (Map.Entry entry : this.m_inflightProps.entrySet()) {
                props.setProperty(PREFIX + (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void handleCustomProperties() {
        if (((Properties)this.m_props).getProperty("SonicXQ.process.InflightProps") != null) {
            Iterator propNameIter = this.m_props.entrySet().iterator();
            ArrayList replacePropsList = new ArrayList();
            while (propNameIter.hasNext()) {
                Map.Entry prop = propNameIter.next();
                if (!((String)prop.getKey()).startsWith(PREFIX)) continue;
                replacePropsList.add(prop);
            }
            for (int i = 0; i < replacePropsList.size(); ++i) {
                if (i == 0) {
                    this.m_inflightProps = new Properties();
                }
                Map.Entry prop = (Map.Entry)replacePropsList.get(i);
                String propName = (String)prop.getKey();
                if (this.m_props.get(propName = propName.substring(PREFIX.length())) == null) {
                    this.m_inflightProps.put(propName, prop.getValue());
                }
                this.m_props.remove(prop.getKey());
            }
        }
    }

    public void inherit(ProcessInstanceProps origProcessProps) {
        this.setRMEAddress(origProcessProps.getRMEAddress());
        this.setExitAddresses(origProcessProps.getExitAddresses());
        this.setFaultAddress(origProcessProps.getFaultAddress());
        this.setTrackingEndpoint(origProcessProps.getTrackingEndpoint());
        this.setTrackingId(origProcessProps.getTrackingId());
        this.setTrackingLevel(origProcessProps.getTrackingLevel());
        this.setTTL(origProcessProps.getTTL());
        this.setQualityOfService(origProcessProps.getQualityOfService().toString());
        this.setTimeStamp(origProcessProps.getTimeStamp());
        this.m_inflightProps = origProcessProps.getInflightProps();
    }

    public void setInflightProperties(Properties inflightProps) {
        this.m_inflightProps = inflightProps;
    }

    public static XQAddress fromXQAddressString(String address) {
        XQAbstractAddressImpl xqAddr = new XQAbstractAddressImpl(address);
        if (xqAddr.getType() == 2) {
            try {
                return new XQAddressFactoryImpl(null, -1).createProcessAddress(xqAddr.getName());
            }
            catch (XQAddressNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return xqAddr;
    }

    public static ProcessInstanceProps create(XQPart part, Token token) throws IOException {
        Object partContent = part.getContent();
        if (partContent instanceof String) {
            try {
                String content = (String)part.getContent();
                ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes());
                Properties props = new Properties();
                props.load(bais);
                ProcessInstanceProps procInstProps = new ProcessInstanceProps(props, token);
                bais.close();
                return procInstProps;
            }
            catch (Throwable e) {
                throw new CannotDetermineRME(e, "Error reading itinerary properties from part 0 of the message", token);
            }
        }
        throw new CannotDetermineRME("The properties part for the process instance should contain string content", token);
    }
}

