/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQHeader;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.config.XQTrackingDetailsConfig;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.service.MessageSendingHelper;
import com.sonicsw.xqimpl.service.SOAPEventMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jms.Message;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TrackingMessage
extends SOAPEventMessage {
    public static final String PROCESS_ENTRY = "PROCESS_ENTRY";
    public static final String PROCESS_EXIT = "PROCESS_EXIT";
    public static final String PROCESS_TERMINATED = "PROCESS_TERMINATED";
    public static final String SERVICE_ENTRY = "SERVICE_ENTRY";
    public static final String SERVICE_EXIT = "SERVICE_EXIT";
    public static final String SERVICE_ERROR = "SERVICE_ERROR";
    private static final String TRACKING_BODY_NAME = "trackingMessageInfo";
    private static final String TRACKING_LOCATION_NAME = "trackingLocation";
    private static final String XQ_MESSAGE_HEADERS_ELEMENT_NAME = "xqMessageHeaders";
    private static final String XQ_MESSAGE_HEADER_ELEMENT_NAME = "header";
    private static final String XQ_MESSAGE_HEADER_ATTRIBUTE_NAME = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String EVENT_ATTRIBUTE = "event";
    private static final String TIMESTAMP_ATTRIBUTE = "timestamp";
    private static final String DESTINATION_ATTRIBUTE = "destination";
    private String m_event;
    private XQParameters m_params;
    private String m_id;
    private XQMessage m_trackedMessage;
    private XQAddress m_trackedMessageDestination;
    private int m_trackingLevel;

    TrackingMessage(String trackingId, XQTrackingDetailsConfig trackingDetails, XQParameters environment, String event, XQMessage trackedMessage, XQAddress trackedMessageDestination, XQMessageFactory messageFactory) throws ParserConfigurationException, XQMessageException {
        super(trackingDetails.getEventEndpoint(), messageFactory);
        if (this.m_address == null) {
            throw new XQMessageException("Error creating Tracking message as the Tracking event endpoint address is null");
        }
        this.m_event = event;
        this.m_params = environment;
        this.m_id = trackingId;
        if (this.m_id == null && this.m_params != null) {
            this.m_id = this.m_params.getParameter("SonicXQ.process.trackingID", 1);
        }
        this.m_trackedMessage = trackedMessage;
        this.m_trackedMessageDestination = trackedMessageDestination;
        this.m_trackingLevel = trackingDetails.getTrackingLevel();
        try {
            if (this.m_message != null && this.m_message.getReplyTo() != null) {
                this.m_message.setReplyTo(null);
            }
        }
        catch (XQMessageException e) {
            // empty catch block
        }
    }

    @Override
    protected Element buildBody() {
        Element bodyElement = this.m_document.createElementNS("http://www.sonicsw.com/sonicxq", "xq:trackingMessageInfo");
        bodyElement.setAttribute(ID_ATTRIBUTE, this.m_id);
        bodyElement.setAttribute(EVENT_ATTRIBUTE, this.m_event);
        bodyElement.setAttribute(TIMESTAMP_ATTRIBUTE, Long.toString(System.currentTimeMillis()));
        Element trackingLocation = this.m_document.createElement(TRACKING_LOCATION_NAME);
        TrackingMessage.buildLocation(trackingLocation, this.m_params);
        if (this.m_trackedMessageDestination != null) {
            trackingLocation.setAttribute(DESTINATION_ATTRIBUTE, this.m_trackedMessageDestination.toString());
        }
        bodyElement.appendChild(trackingLocation);
        if (this.m_trackingLevel >= 3 && this.m_trackedMessage != null) {
            Element messageHeaders = this.m_document.createElement(XQ_MESSAGE_HEADERS_ELEMENT_NAME);
            try {
                Iterator headerNames = this.m_trackedMessage.getHeaderNames();
                TreeSet<String> sortedNames = new TreeSet<String>();
                TreeSet<String> sortedJMSNames = new TreeSet<String>();
                while (headerNames.hasNext()) {
                    String name = (String)headerNames.next();
                    if (TrackingMessageExclusions.excludeHeader(name)) continue;
                    if (name.startsWith("JMS")) {
                        sortedJMSNames.add(name);
                        continue;
                    }
                    sortedNames.add(name);
                }
                this.addHeadersToMessage(sortedJMSNames.iterator(), messageHeaders);
                this.addHeadersToMessage(sortedNames.iterator(), messageHeaders);
            }
            catch (XQMessageException e) {
                Text valueNode = this.m_document.createTextNode(e.getMessage());
                messageHeaders.appendChild(valueNode);
            }
            bodyElement.appendChild(messageHeaders);
        }
        return bodyElement;
    }

    @Override
    public void send(String sender, XQParameters environment, XQQualityofService qos, IEndpointRegistry er) throws Throwable {
        this.buildMessage();
        if (this.m_trackingLevel >= 4 && this.m_trackedMessage != null) {
            this.m_message.setBooleanHeader("JMS_SonicMQ_XQ.isMultipart", true);
            XQPart mp0 = this.m_message.getPart(0);
            mp0.setContentId("TrackingMessage");
            this.m_message.replacePart(mp0, 0);
            for (int i = 0; i < this.m_trackedMessage.getPartCount(); ++i) {
                String contentType;
                XQPart mp = this.m_trackedMessage.getPart(i);
                String contentID = mp.getContentId();
                if (TrackingMessageExclusions.excludeContentID(contentID) || TrackingMessageExclusions.excludeContentType(contentType = mp.getContentType())) continue;
                Object content = mp.getContent();
                XQPart newPart = this.m_message.createPart(content, mp.getContentType());
                newPart.setContentId(mp.getContentId());
                XQHeader oHdr = mp.getHeader();
                XQHeader nHdr = newPart.getHeader();
                Iterator headers = oHdr.getKeys();
                while (headers.hasNext()) {
                    String key = (String)headers.next();
                    nHdr.setValue(key, oHdr.getValue(key));
                }
                this.m_message.addPart(newPart);
            }
        }
        EsbMessageExchange mex = EsbMessageExchange.createImmediate(null, this.m_address, this.m_messageFactory, this.m_message, environment, qos, true, er);
        MessageSendingHelper.sendToAddress(mex, sender);
    }

    private void addHeadersToMessage(Iterator headerNames, Element messageHeaders) throws XQMessageException {
        while (headerNames.hasNext()) {
            String name = (String)headerNames.next();
            Object o = this.m_trackedMessage.getHeaderValue(name);
            if (TrackingMessageExclusions.isStandardJMSHeader(name) && (o == null || o instanceof String && ((String)o).length() == 0)) continue;
            String value = o == null ? "" : (o instanceof String ? (String)o : o.toString());
            Element messageHeader = this.m_document.createElement(XQ_MESSAGE_HEADER_ELEMENT_NAME);
            messageHeader.setAttribute(XQ_MESSAGE_HEADER_ATTRIBUTE_NAME, name);
            Text valueNode = this.m_document.createTextNode(value);
            messageHeader.appendChild(valueNode);
            messageHeaders.appendChild(messageHeader);
        }
    }

    public static class TrackingMessageExclusions {
        private static String[] excludedHeaders;
        private static String[] excludedContentIDs;
        private static String[] excludedContentTypes;
        private static String[] standardJMSHeaders;
        public static String defaultExcludedHeaders;
        public static String defaultExcludedContentIDs;
        public static String defaultExcludedContentTypes;
        public static final String EXCLUDED_HEADERS_PROPERTY_NAME = "com.sonicsw.xqimpl.service.tracking.excluded.headers";
        public static final String EXCLUDED_CONTENTIDS_PROPERTY_NAME = "com.sonicsw.xqimpl.service.tracking.excluded.contentids";
        public static final String EXCLUDED_CONTENTTYPES_PROPERTY_NAME = "com.sonicsw.xqimpl.service.tracking.excluded.contenttypes";

        public static boolean excludeHeader(String header) {
            boolean result = false;
            if (header != null) {
                for (int i = 0; i < excludedHeaders.length && !result; ++i) {
                    String excludedHeader = excludedHeaders[i];
                    result = header.matches(excludedHeader);
                }
            }
            return result;
        }

        public static boolean isStandardJMSHeader(String header) {
            boolean result = false;
            if (header != null) {
                for (int i = 0; i < standardJMSHeaders.length && !result; ++i) {
                    String excludedHeader = standardJMSHeaders[i];
                    result = header.matches(excludedHeader);
                }
            }
            return result;
        }

        public static boolean excludeContentID(String contentID) {
            boolean result = false;
            if (contentID != null) {
                for (int i = 0; i < excludedContentIDs.length && !result; ++i) {
                    String excludedContentID = excludedContentIDs[i];
                    result = contentID.matches(excludedContentID);
                }
            }
            return result;
        }

        public static boolean excludeContentType(String contentType) {
            boolean result = false;
            if (contentType != null) {
                for (int i = 0; i < excludedContentTypes.length && !result; ++i) {
                    String excludedContentType = excludedContentTypes[i];
                    result = contentType.matches(excludedContentType);
                }
            }
            return result;
        }

        public static String[] getExcludedContentIDs() {
            return Arrays.copyOf(excludedContentIDs, excludedContentIDs.length);
        }

        public static String[] getExcludedContentTypes() {
            return Arrays.copyOf(excludedContentTypes, excludedContentTypes.length);
        }

        public static String[] getExcludedHeaders() {
            return Arrays.copyOf(excludedHeaders, excludedHeaders.length);
        }

        static {
            defaultExcludedHeaders = "JMSDestination:JMSDeliveryMode:JMSMessageID:JMSTimestamp:JMSExpiration:JMSPriority:JMS_SonicMQ_preservedUndelivered:JMS_SonicMQ_undeliveredReasonCode";
            defaultExcludedContentIDs = "SonicESB.RUN_SERVICE_PROPS:SonicESB.RUN_CONTEXT_PART_CONTENT_ID";
            defaultExcludedContentTypes = "application/x-sonicxq-bpheader; version=2.0:application/x-sonicxq-faultheader; version=2.0:application/x-sonicxq-bpheader";
            String hdrs = System.getProperty(EXCLUDED_HEADERS_PROPERTY_NAME, defaultExcludedHeaders);
            String ids = System.getProperty(EXCLUDED_CONTENTIDS_PROPERTY_NAME, defaultExcludedContentIDs);
            String types = System.getProperty(EXCLUDED_CONTENTTYPES_PROPERTY_NAME, defaultExcludedContentTypes);
            excludedHeaders = hdrs.split(":");
            excludedContentIDs = ids.split(":");
            excludedContentTypes = types.split(":");
            Class<Message> messageClass = Message.class;
            String excludedPrefix = "getJMS";
            ArrayList<String> tempNames = new ArrayList<String>();
            Method[] methods = messageClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                String name = method.getName();
                if (!name.startsWith(excludedPrefix)) continue;
                String headerName = name.substring(3);
                tempNames.add(headerName);
            }
            standardJMSHeaders = new String[tempNames.size()];
            standardJMSHeaders = tempNames.toArray(standardJMSHeaders);
        }
    }
}

