/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.framework.MessageExchange;
import com.sonicsw.esb.itinerary.def.Caching;
import com.sonicsw.esb.itinerary.def.FaultHandlerSerializer;
import com.sonicsw.esb.itinerary.def.MessageMapperSerializer;
import com.sonicsw.esb.itinerary.def.Params;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.InvalidItineraryMessageException;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.ItineraryStartNode;
import com.sonicsw.esb.process.def.ProcessResource;
import com.sonicsw.esb.process.engine.EngineException;
import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.engine.ProcessInstanceGenerator;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.model.ExecutableNode;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.config.AddressUtility;
import com.sonicsw.xqimpl.config.ProcessSchemaVersionException;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQTrackingDetailsConfig;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.SOAPUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;

public class XQProcessInstanceGenerator
implements ProcessInstanceGenerator {
    private boolean m_staxEnabled;
    private boolean m_insertFirstStep = true;
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);

    @Override
    public boolean hasProcessState(MessageExchange mex) {
        return XQProcessInstanceGenerator.isBPMessage(mex.getInputMessage());
    }

    @Override
    public ProcessInstance newProcessInstance(Token token, MainProcess process, Object additionalConfig) {
        XQProcessConfig procConfig = (XQProcessConfig)additionalConfig;
        if (procConfig.isFaultHandlerProcess()) {
            return new FaultProcessInstance((ProcessInstanceGenerator)this, process, procConfig, token);
        }
        return new XQProcessInstance(this, process, procConfig, (EsbMessageExchange)token.getData());
    }

    @Override
    public ProcessInstance newChildProcessInstance(Token token, MainProcess process, ProcessInstance parentInst, Object additionalConfig) {
        if (parentInst instanceof FaultProcessInstance) {
            return new FaultProcessInstance((ProcessInstanceGenerator)this, (ESBProcess)process, (XQProcessConfig)additionalConfig, (XQProcessInstance)parentInst);
        }
        return new XQProcessInstance((ProcessInstanceGenerator)this, (ESBProcess)process, (XQProcessConfig)additionalConfig, (XQProcessInstance)parentInst);
    }

    @Override
    public ProcessInstance retrieveProcessInstance(Token token) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        List<XQPart> procParts = null;
        try {
            procParts = XQProcessInstanceGenerator.getBPMetadataParts(mex.getInputMessage());
            ProcessInstanceProps procInstProps = ProcessInstanceProps.create(procParts.get(0), token);
            procParts.remove(0);
            if (procInstProps.getFaultHandlerTag()) {
                return new FaultProcessInstance(this, procParts, procInstProps, token, this.m_insertFirstStep);
            }
            return new XQProcessInstance(this, procParts, procInstProps, token, this.m_insertFirstStep);
        }
        catch (InvalidItineraryMessageException e) {
            this.reAddProcessMetadataParts(token, procParts);
            throw e;
        }
        catch (EngineException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ItineraryException(e, "Error creating process instance", token);
        }
    }

    void reAddProcessMetadataParts(Token token, List<XQPart> procParts) {
        XQMessage msgInput = ((EsbMessageExchange)token.getData()).getInputMessage();
        int count = 0;
        for (XQPart part : procParts) {
            try {
                msgInput.addPartAt(part, count++);
            }
            catch (XQMessageException ex) {}
        }
    }

    public void setInsertFirstStep(boolean insertFirstStep) {
        this.m_insertFirstStep = insertFirstStep;
    }

    public boolean isInsertFirstStep() {
        return this.m_insertFirstStep;
    }

    public static boolean isBPMessage(XQMessage msg) {
        try {
            if (msg != null && msg.getPartCount() > 0) {
                return XQProcessInstanceGenerator.isBPPart(msg.getPart(0));
            }
        }
        catch (XQMessageException xQMessageException) {
            // empty catch block
        }
        return false;
    }

    static List<XQPart> getBPMetadataParts(XQMessage message) throws XQMessageException {
        return XQProcessInstanceGenerator.getProcessMetadataParts(message, "application/x-sonicxq-bpheader; version=2.0");
    }

    static List<XQPart> getProcessMetadataParts(XQMessage message, String desiredContentType) throws XQMessageException {
        XQPart nextPart = message.getPart(0);
        ArrayList<XQPart> processHeaders = new ArrayList<XQPart>();
        while (nextPart != null && XQProcessInstanceGenerator.isPartOfType(nextPart, desiredContentType)) {
            processHeaders.add(nextPart);
            message.removePart(0);
            nextPart = null;
            if (message.getPartCount() <= 0) continue;
            nextPart = message.getPart(0);
        }
        return processHeaders;
    }

    private static boolean isBPPart(XQPart part) {
        return XQProcessInstanceGenerator.isPartOfType(part, "application/x-sonicxq-bpheader; version=2.0");
    }

    private static boolean isPartOfType(XQPart part, String desiredContentType) {
        if (part != null) {
            String contentType = part.getContentType();
            return desiredContentType.equals(contentType);
        }
        return false;
    }

    ESBProcess getESBProcess(XQProcessInstance procInst, Token token, XQAddress topMostStepEndpointRef, List<XQPart> procParts, int index) throws Throwable {
        EsbStepNode topmostNode = null;
        if (topMostStepEndpointRef != null) {
            ProcessInstanceProps processProps = procInst.getProcessInstanceProperties();
            topmostNode = XQProcessInstanceGenerator.createCurrentStepNode(processProps.getCurrentProcessStepName(), topMostStepEndpointRef);
        }
        ESBProcess currentProcess = this.getProcessDefFromPart(procParts, index, token, procInst, topmostNode);
        if (topmostNode != null) {
            topmostNode.setParent(currentProcess);
            procInst.insertNewNode(currentProcess, topmostNode);
        }
        return currentProcess;
    }

    ESBProcess getProcessDefFromPart(List<XQPart> procParts, int index, Token token, XQProcessInstance procInst, EsbStepNode topmostNode) throws Throwable {
        XQPart part = procParts.get(index);
        Object partContent = part.getContent();
        try {
            if (partContent instanceof String) {
                String processDefContents = (String)part.getContent();
                ESBProcess esbProc = null;
                try {
                    if (this.m_staxEnabled) {
                        esbProc = XQProcessInstanceGenerator.getESBProcess(procInst, processDefContents, topmostNode);
                    } else {
                        Element soapEnvelope = SOAPUtils.readSOAPEnvelope((String)processDefContents);
                        Element processElement = (Element)soapEnvelope.getElementsByTagNameNS("http://www.sonicsw.com/sonicxq", "process").item(0);
                        esbProc = XQProcessInstanceGenerator.getESBProcess(procInst, processElement, topmostNode);
                    }
                    ((ItineraryStartNode)esbProc.getInitialNode()).setContinuation(true);
                }
                catch (Throwable e) {
                    StringBuffer errorMsg = new StringBuffer();
                    errorMsg.append("Error ");
                    errorMsg.append("`");
                    errorMsg.append(e.getMessage());
                    errorMsg.append("`");
                    errorMsg.append(" while creating a process definition from part[");
                    errorMsg.append(part.getContentId());
                    errorMsg.append("] contents `");
                    errorMsg.append(processDefContents);
                    errorMsg.append("`");
                    this.reAddProcessMetadataParts(token, procParts);
                    InvalidItineraryMessageException iime = new InvalidItineraryMessageException(e, errorMsg.toString(), token);
                    if (e instanceof ProcessSchemaVersionException) {
                        iime.setProcessName(((ProcessSchemaVersionException)e).getProcessName());
                    }
                    throw iime;
                }
                ESBProcess eSBProcess = esbProc;
                return eSBProcess;
            }
            this.reAddProcessMetadataParts(token, procParts);
            throw new InvalidItineraryMessageException("The process metadata part[" + part.getContentId() + "] should of type String", token);
        }
        finally {
            procParts.remove(index);
        }
    }

    private static EsbStepNode createCurrentStepNode(String stepName, XQAddress topMostStepEndpointRef) {
        EsbStepNode currentNode = new EsbStepNode(stepName, null);
        currentNode.setEndpointRef(topMostStepEndpointRef);
        return currentNode;
    }

    public static ESBProcess getESBProcess(XQProcessInstance procInst, Element processElement, EsbStepNode topmostNode) {
        ESBProcess processDef = null;
        XQConfigManager mgr = XQConfigManager.getInstance(null);
        XQProcessConfig processConfig = new XQProcessConfig(mgr);
        String processName = processElement.getAttribute("name");
        processConfig.setName(processName);
        String description = processElement.getAttribute("description");
        processConfig.setDescription(description);
        String processModelVersion = processElement.getAttribute("processModelVersion");
        boolean isValid = XQProcessConfig.verifyProcessSchemaVersion((String)processName, (String)processModelVersion);
        if (isValid) {
            processConfig.setProcessModelVersion(processModelVersion);
        }
        Element paramsElem = null;
        Element faultHandlerElem = null;
        Element messageMapperElem = null;
        Element cachingElem = null;
        long timestamp = 0L;
        List childElements = DOMUtils.getImmediateChildElements((Element)processElement);
        for (int i = 0; i < childElements.size(); ++i) {
            Element elem = (Element)childElements.get(i);
            String elemName = elem.getLocalName();
            if (elemName.equals("qualityOfService")) {
                if (processConfig.getQOS() != null) continue;
                processConfig.setQOS(DOMUtils.getFirstTextChildValue((Element)elem));
                continue;
            }
            if (elemName.equals("faultEndpoint")) {
                if (processConfig.getFaultEndpoint() != null) continue;
                processConfig.setFaultEndpoint(AddressUtility.getAddressFromElement((Element)elem));
                continue;
            }
            if (elemName.equals("rejectEndpoint")) {
                if (processConfig.getRejectedMessageEndpoint() != null) continue;
                processConfig.setRejectedMessageEndpoint(AddressUtility.getAddressFromElement((Element)elem));
                continue;
            }
            if (elemName.equals("faultHandler")) {
                if (processConfig.getFaultHandler() != null) continue;
                processConfig.setFaultHandler(AddressUtility.getAddressFromElement((Element)elem));
                continue;
            }
            if (elemName.equals("trackingDetails")) {
                if (processConfig.getTrackingDetails() != null) continue;
                processConfig.setTrackingDetails(XQProcessInstanceGenerator.unmarshallTrackingDetails(elem));
                continue;
            }
            if (elemName.equals("timeToLive")) {
                String timeToLive;
                if (processConfig.getTimeToLive() != 0L || (timeToLive = DOMUtils.getFirstTextChildValue((Element)elem)) == null) continue;
                processConfig.setTimeToLive(Long.parseLong(timeToLive));
                continue;
            }
            if (elemName.equals("itinerary")) {
                ProcessResource procRes = XQContainer.getProcessEngine().getProcessResourceFactory().createProcessResource(processName, null, elem);
                processDef = (ESBProcess)XQContainer.getProcessEngine().getParserFactory().getProcessDefParser().parse(procRes);
                FaultHandlerSerializer.setFaultHandler(processDef, processConfig);
                procInst.setProcessConfig(processConfig);
                continue;
            }
            if (elemName.equals("exitEndpoint_list")) {
                Set<XQAddress> exits;
                if (processConfig.getExitEndpoints() != null && processConfig.getExitEndpoints().size() != 0 || (exits = XQProcessInstanceGenerator.unmarshallExitEndpoints(elem)) == null) continue;
                processConfig.setExitEndpoints(exits);
                continue;
            }
            if (elemName.equals("params")) {
                if (paramsElem != null) continue;
                paramsElem = elem;
                continue;
            }
            if (elemName.equals("messageMapping")) {
                messageMapperElem = elem;
                continue;
            }
            if (elemName.equals("stepFaultHandler")) {
                faultHandlerElem = elem;
                continue;
            }
            if (elemName.equals("timestamp")) {
                String timestampStr;
                if (timestamp != 0L || (timestampStr = DOMUtils.getFirstTextChildValue((Element)elem)) == null) continue;
                timestamp = Long.parseLong(timestampStr);
                continue;
            }
            if (!elemName.equals("caching")) continue;
            cachingElem = elem;
        }
        if (topmostNode != null) {
            if (paramsElem != null) {
                XQParameters params = Params.parse(paramsElem);
                topmostNode.setXQParameters(params);
            }
            if (messageMapperElem != null) {
                MessageMapper msgMapper = MessageMapperSerializer.parse(messageMapperElem);
                topmostNode.setMessageMapper(msgMapper);
            }
            if (faultHandlerElem != null) {
                FaultHandlerSerializer.parse((ExecutableNode)topmostNode, faultHandlerElem);
            }
            if (cachingElem != null) {
                Caching.parse(cachingElem, topmostNode);
            }
        }
        procInst.setTimestamp(timestamp);
        return processDef;
    }

    private static Set<XQAddress> unmarshallExitEndpoints(Element exitElem) {
        HashSet<XQAddress> exitSet = null;
        if (exitElem != null) {
            exitSet = new HashSet<XQAddress>();
            List exitElements = DOMUtils.getImmediateChildElements((Element)exitElem);
            Iterator exits = exitElements.iterator();
            while (exits.hasNext()) {
                exitSet.add(AddressUtility.getAddressFromElement((Element)((Element)exits.next())));
            }
        }
        return exitSet;
    }

    private static Set<XQAddress> unmarshallExitEndpoints(XMLStreamReader xsr) throws XMLStreamException {
        HashSet<XQAddress> exitSet = null;
        while (xsr.hasNext()) {
            String stepElemName;
            int eventType = xsr.next();
            if (eventType == 1 && (stepElemName = xsr.getLocalName()).equals("exitEndpoint")) {
                if (exitSet == null) {
                    exitSet = new HashSet<XQAddress>();
                }
                exitSet.add(AddressUtility.getAddressFromStream((XMLStreamReader)xsr));
            }
            if (eventType != 2 || !(stepElemName = xsr.getLocalName()).equals("exitEndpoint_list")) continue;
            break;
        }
        return exitSet;
    }

    private static XQTrackingDetailsConfig unmarshallTrackingDetails(Element details) {
        XQTrackingDetailsConfig trackingDetails = new XQTrackingDetailsConfig();
        Element event = DOMUtils.getElementByTagName((Element)details, (String)"eventEndpoint");
        trackingDetails.setEventEndpoint(AddressUtility.getAddressFromElement((Element)event));
        String trackingLevel = details.getAttribute("trackingLevel");
        trackingDetails.setTrackingLevel(Integer.parseInt(trackingLevel));
        String trackingId = details.getAttribute("trackingId");
        trackingDetails.setTrackingId(trackingId);
        return trackingDetails;
    }

    private static XQTrackingDetailsConfig unmarshallTrackingDetails(XMLStreamReader xsr) throws XMLStreamException {
        XQTrackingDetailsConfig trackingDetails = new XQTrackingDetailsConfig();
        String trackingLevel = xsr.getAttributeValue(null, "trackingLevel");
        trackingDetails.setTrackingLevel(Integer.parseInt(trackingLevel));
        String trackingId = xsr.getAttributeValue(null, "trackingId");
        trackingDetails.setTrackingId(trackingId);
        while (xsr.hasNext()) {
            String stepElemName;
            int eventType = xsr.next();
            if (eventType == 1 && (stepElemName = xsr.getLocalName()).equals("eventEndpoint")) {
                trackingDetails.setEventEndpoint(AddressUtility.getAddressFromStream((XMLStreamReader)xsr));
            }
            if (eventType != 2 || !(stepElemName = xsr.getLocalName()).equals("trackingDetails")) continue;
            break;
        }
        return trackingDetails;
    }

    public static ESBProcess getESBProcess(XQProcessInstance procInst, String processDefContents, EsbStepNode topmostNode) throws XMLStreamException {
        ESBProcess processDef = null;
        XQConfigManager mgr = XQConfigManager.getInstance(null);
        XQProcessConfig processConfig = new XQProcessConfig(mgr);
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(processDefContents));
        String processName = null;
        while (xsr.hasNext()) {
            int eventType = xsr.next();
            if (eventType != 1) continue;
            String elemName = xsr.getLocalName();
            if (elemName.equals("process")) {
                processName = xsr.getAttributeValue(null, "name");
                processConfig.setName(processName);
                String description = xsr.getAttributeValue(null, "description");
                processConfig.setDescription(description);
                String processModelVersion = xsr.getAttributeValue(null, "processModelVersion");
                boolean isValid = XQProcessConfig.verifyProcessSchemaVersion((String)processName, (String)processModelVersion);
                if (!isValid) continue;
                processConfig.setProcessModelVersion(processModelVersion);
                continue;
            }
            if (elemName.equals("qualityOfService")) {
                if (processConfig.getQOS() != null) continue;
                processConfig.setQOS(xsr.getElementText());
                continue;
            }
            if (elemName.equals("faultEndpoint")) {
                if (processConfig.getFaultEndpoint() != null) continue;
                processConfig.setFaultEndpoint(AddressUtility.getAddressFromStream((XMLStreamReader)xsr));
                continue;
            }
            if (elemName.equals("rejectEndpoint")) {
                if (processConfig.getRejectedMessageEndpoint() != null) continue;
                processConfig.setFaultEndpoint(AddressUtility.getAddressFromStream((XMLStreamReader)xsr));
                continue;
            }
            if (elemName.equals("faultHandler")) {
                if (processConfig.getFaultHandler() != null) continue;
                processConfig.setFaultHandler(AddressUtility.getAddressFromStream((XMLStreamReader)xsr));
                continue;
            }
            if (elemName.equals("trackingDetails")) {
                if (processConfig.getTrackingDetails() != null) continue;
                processConfig.setTrackingDetails(XQProcessInstanceGenerator.unmarshallTrackingDetails(xsr));
                continue;
            }
            if (elemName.equals("timeToLive")) {
                String timeToLive;
                if (processConfig.getTimeToLive() != 0L || (timeToLive = xsr.getElementText()) == null || timeToLive.trim().length() <= 0) continue;
                processConfig.setTimeToLive(Long.parseLong(timeToLive));
                continue;
            }
            if (elemName.equals("itinerary")) {
                ProcessResource procRes = XQContainer.getProcessEngine().getProcessResourceFactory().createProcessResource(processName, null, xsr);
                processDef = (ESBProcess)XQContainer.getProcessEngine().getParserFactory().getProcessDefParser().parse(procRes);
                FaultHandlerSerializer.setFaultHandler(processDef, processConfig);
                procInst.setProcessConfig(processConfig);
                continue;
            }
            if (elemName.equals("exitEndpoint_list")) {
                Set<XQAddress> exits;
                if (processConfig.getExitEndpoints() != null && processConfig.getExitEndpoints().size() != 0 || (exits = XQProcessInstanceGenerator.unmarshallExitEndpoints(xsr)) == null) continue;
                processConfig.setExitEndpoints(exits);
                continue;
            }
            if (elemName.equals("params")) {
                if (topmostNode == null) continue;
                XQParameters params = Params.parse(xsr, elemName);
                topmostNode.setXQParameters(params);
                continue;
            }
            if (elemName.equals("messageMapping") && topmostNode != null) {
                MessageMapper msgMapper = MessageMapperSerializer.parse(xsr);
                topmostNode.setMessageMapper(msgMapper);
                topmostNode.setMessageMapper(msgMapper);
                continue;
            }
            if (elemName.equals("stepFaultHandler") && topmostNode != null) {
                FaultHandlerSerializer.parse((ExecutableNode)topmostNode, xsr);
                continue;
            }
            if (elemName.equals("timestamp")) {
                String timestampStr = xsr.getElementText();
                if (timestampStr == null) continue;
                long timestamp = Long.parseLong(timestampStr);
                procInst.setTimestamp(timestamp);
                continue;
            }
            if (!elemName.equals("caching")) continue;
            Caching.parse(xsr, topmostNode);
        }
        return processDef;
    }

    public void setProcessConfig(XQProcessConfig procConfig) {
    }

    public void setStaxEnabled(boolean enabled) {
        this.m_staxEnabled = enabled;
    }

    public boolean isStaxEnabled() {
        return this.m_staxEnabled;
    }
}

