/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.def.XQProcess;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.process.engine.ProcessInstanceSerializer;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.config.AddressUtility;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQTrackingDetailsConfig;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.util.BodyBuilder;
import com.sonicsw.xqimpl.util.SOAPUtils;
import com.sonicsw.xqimpl.util.SystemData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public class XQProcessInstanceSerializer
implements ProcessInstanceSerializer,
BodyBuilder {
    private String m_trackingId;
    private XQProcessInstance m_procInst;
    private XQProcessConfig m_procConfig;
    private boolean m_isCurrentProcInst;
    private boolean m_includeCurrentStep;

    @Override
    public void serialize(ActivityNode node, Token token) throws IOException, XQMessageException {
        assert (node != null);
        assert (node.getParentProcess() instanceof ESBProcess);
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        ProcessInstanceProps processProps = procInst.getProcessInstanceProperties();
        processProps.setStepName(node.getDisplayName(), procInst);
        XQMessage msg = ((EsbMessageExchange)token.getData()).getInputMessage();
        XQProcessInstanceSerializer.stripProcessState(msg);
        this.serializeProcessContents(msg, procInst, token);
    }

    public void setIncludeCurrentStep(boolean includeCurrentStep) {
        this.m_includeCurrentStep = includeCurrentStep;
    }

    private void serializeProcessContents(XQMessage originalMsg, XQProcessInstance procInst, Token token) throws XQMessageException, IOException {
        int partIndex = -1;
        partIndex = this.addProcessProps(procInst.getProcessInstanceProperties(), originalMsg, "Itinerary.ProcessProps", "application/x-sonicxq-bpheader; version=2.0", partIndex);
        partIndex = this.addProcessMetadataPart(originalMsg, procInst, partIndex, "Itinerary.CurrentProcess", true, false, "application/x-sonicxq-bpheader; version=2.0");
        partIndex = this.addParentProcessMetadataParts(originalMsg, procInst, partIndex, token, "Itinerary.ParentProcess-", "application/x-sonicxq-bpheader; version=2.0");
        this.addFaultHandlingMetadataParts(originalMsg, procInst, partIndex, token);
    }

    private int addProcessProps(ProcessInstanceProps processProps, XQMessage msg, String cid, String contentType, int partIndex) throws XQMessageException, IOException {
        String processPropsStr = processProps.getContentsAsString();
        XQPart propsPart = msg.createPart((Object)processPropsStr, contentType);
        propsPart.setContentId(cid);
        msg.addPartAt(propsPart, ++partIndex);
        return partIndex;
    }

    private int addParentProcessMetadataParts(XQMessage msg, XQProcessInstance procInst, int partIndex, Token token, String prefix, String contentType) throws IOException, XQMessageException {
        while (procInst != null && procInst.isSubProcess()) {
            XQProcessInstance parentInst = procInst.getParentProcessInstance(token, false);
            if (parentInst == null) {
                partIndex = XQProcessInstanceSerializer.copyParentProcessMetadataParts(msg, procInst, partIndex, prefix, contentType);
                break;
            }
            partIndex = this.addProcessMetadataPart(msg, parentInst, partIndex, prefix + partIndex, false, true, contentType);
            procInst = parentInst;
        }
        return partIndex;
    }

    private void addFaultHandlingMetadataParts(XQMessage originalMsg, XQProcessInstance procInst, int partIndex, Token token) throws ItineraryException, XQMessageException, IOException {
        if (procInst instanceof FaultProcessInstance) {
            FaultProcessInstance fhProcInst = (FaultProcessInstance)procInst;
            ProcessInstanceProps origProcProps = fhProcInst.getOriginalProcessInstanceProps();
            XQProcessInstance origProcInst = fhProcInst.getOriginalProcessInstance();
            if (origProcInst == null) {
                throw new ItineraryException("Cannot find process instance properties of the original process in the message", token);
            }
            if (origProcProps == null) {
                throw new ItineraryException("Cannot find process instance properties of the original process in the message", token);
            }
            partIndex = this.addProcessProps(origProcProps, originalMsg, "Orig.Itinerary.ProcessProps", "application/x-sonicxq-faultheader; version=2.0", partIndex);
            partIndex = this.addProcessMetadataPart(originalMsg, origProcInst, partIndex, "Orig.Itinerary.CurrentProcess", false, true, "application/x-sonicxq-faultheader; version=2.0");
            partIndex = this.addParentProcessMetadataParts(originalMsg, origProcInst, partIndex, token, "Orig.Itinerary.ParentProcess-", "application/x-sonicxq-faultheader; version=2.0");
            RMEMessage rmeMsg = fhProcInst.getOriginalRMEMsg();
            if (rmeMsg != null) {
                rmeMsg.addRMEPart(originalMsg, ++partIndex, "application/x-sonicxq-faultheader; version=2.0", "Orig.RMEMessage");
            }
        }
    }

    private int addProcessMetadataPart(XQMessage msg, XQProcessInstance procInst, int partIndex, String contentID, boolean isCurrentProcInst, boolean includeCurrentStep, String contentType) throws IOException, XQMessageException {
        this.m_procConfig = procInst.getProcessConfig();
        this.m_procInst = procInst;
        this.m_isCurrentProcInst = isCurrentProcInst;
        this.m_trackingId = "";
        float pmv = procInst.getProcessConfig().getProcessModelVersionAsFloat();
        if (!this.m_includeCurrentStep && includeCurrentStep && pmv >= 2.0f) {
            this.m_includeCurrentStep = includeCurrentStep;
        }
        StringWriter sw = new StringWriter();
        SOAPUtils.writeSOAPEnvelope((Writer)sw, (BodyBuilder)this);
        sw.flush();
        String processMetadata = sw.getBuffer().toString();
        sw.close();
        XQPart part = msg.createPart((Object)processMetadata, contentType);
        part.setContentId(contentID);
        if (partIndex < 0) {
            msg.addPart(part);
        } else {
            msg.addPartAt(part, ++partIndex);
        }
        return partIndex;
    }

    private static int copyParentProcessMetadataParts(XQMessage msg, XQProcessInstance procInst, int partIndex, String prefix, String contentType) throws XQMessageException {
        List<XQPart> processHeaders = procInst.getParentProcessMetadataParts();
        if (processHeaders != null && processHeaders.size() > 0) {
            for (int i = 0; i < processHeaders.size(); ++i) {
                XQPart part = processHeaders.get(i);
                if (!contentType.equals(part.getContentType())) {
                    XQPart newPart;
                    part = newPart = msg.createPart(part.getContent(), contentType);
                }
                part.setContentId(prefix + partIndex);
                if (partIndex < 0) {
                    msg.addPart(part);
                    continue;
                }
                msg.addPartAt(part, ++partIndex);
            }
        }
        return partIndex;
    }

    public static void stripProcessState(XQMessage msg) {
        try {
            int currIndex = 0;
            while (currIndex < msg.getPartCount()) {
                XQPart currPart = msg.getPart(currIndex);
                if (currPart != null && currPart.getContentType() != null && currPart.getContentType().equals("application/x-sonicxq-bpheader; version=2.0")) {
                    msg.removePart(currIndex);
                    continue;
                }
                ++currIndex;
            }
        }
        catch (XQMessageException xQMessageException) {
            // empty catch block
        }
    }

    public void writeBody(Writer sink) throws IOException {
        long timestamp;
        long ttl;
        XQAddress fh;
        XQAddress rme;
        XQAddress fault;
        XQProcessConfig config = this.m_procConfig;
        sink.write("<xq:process");
        this.marshallAttribute("xmlns:xq", "http://www.sonicsw.com/sonicxq", sink);
        this.marshallAttribute("name", config.getName(), sink);
        this.marshallAttribute("processModelVersion", config.getProcessModelVersion(), sink);
        this.marshallAttribute("processType", config.getProcessType(), sink);
        this.marshallEscapedAttribute("description", config.getDescription(), sink);
        sink.write(">");
        sink.write(SystemData.getLineSeparator() != null ? SystemData.getLineSeparator() : "\n");
        String qos = config.getQOS();
        this.marshallElement("qualityOfService", qos, sink);
        XQTrackingDetailsConfig details = config.getTrackingDetails();
        if (details != null && details.getTrackingLevel() > 0) {
            this.marshallTrackingDetails(details, sink);
        }
        if ((fault = config.getFaultEndpoint()) != null) {
            this.marshallAddress(fault, "faultEndpoint", sink);
        }
        if ((rme = config.getRejectedMessageEndpoint()) != null) {
            this.marshallAddress(rme, "rejectEndpoint", sink);
        }
        if ((fh = config.getFaultHandler()) != null) {
            this.marshallAddress(fh, "faultHandler", sink);
        }
        if ((ttl = config.getTimeToLive()) > 0L) {
            this.marshallElement("timeToLive", Long.toString(ttl), sink);
        }
        if ((timestamp = this.m_procInst.getTimestamp()) > 0L) {
            this.marshallElement("timestamp", Long.toString(timestamp), sink);
        }
        XQProcess.serialize(false, this.m_procInst.getActiveEsbNode(null), sink, this.m_isCurrentProcInst, this.m_includeCurrentStep);
        if (config.hasExitEndpoints()) {
            this.marshallExitEndpoints(config.getExitEndpoints(), sink);
        }
        sink.write("</xq:process>");
    }

    private void marshallExitEndpoints(Set<XQAddress> exitSet, Writer sink) throws IOException {
        if (exitSet == null) {
            return;
        }
        this.marshallOpenElement("exitEndpoint_list", sink);
        Iterator<XQAddress> exits = exitSet.iterator();
        while (exits.hasNext()) {
            this.marshallAddress(exits.next(), "exitEndpoint", sink);
        }
        this.marshallCloseElement("exitEndpoint_list", sink);
    }

    private void marshallTrackingDetails(XQTrackingDetailsConfig details, Writer sink) throws IOException {
        sink.write("<");
        sink.write("trackingDetails");
        this.marshallAttribute("trackingLevel", Integer.toString(details.getTrackingLevel()), sink);
        this.marshallAttribute("trackingId", this.m_trackingId, sink);
        sink.write(">");
        XQAddress eventEndpoint = details.getEventEndpoint();
        this.marshallAddress(eventEndpoint, "eventEndpoint", sink);
        sink.write("</");
        sink.write("trackingDetails");
        sink.write(">");
    }

    private void marshallAddress(XQAddress address, String tagName, Writer sink) throws IOException {
        sink.write("<");
        sink.write(tagName);
        this.marshallAttribute("type", AddressUtility.getAddressTypeAsString((int)address.getType()), sink);
        this.marshallAttribute("endpoint_ref", address.getName(), sink);
        sink.write("/>");
    }

    private void marshallElement(String element, String value, Writer sink) throws IOException {
        this.marshallOpenElement(element, sink);
        sink.write(value);
        this.marshallCloseElement(element, sink);
    }

    private void marshallOpenElement(String element, Writer sink) throws IOException {
        sink.write(60);
        sink.write(element);
        sink.write(62);
    }

    private void marshallCloseElement(String element, Writer sink) throws IOException {
        sink.write("</");
        sink.write(element);
        sink.write(62);
    }

    private void marshallAttribute(String attribute, String value, Writer sink) throws IOException {
        if (value != null) {
            sink.write(" ");
            sink.write(attribute);
            sink.write("=\"");
            sink.write(value);
            sink.write("\"");
        }
    }

    private void marshallEscapedAttribute(String attribute, String value, Writer sink) throws IOException {
        if (value != null) {
            sink.write(" ");
            sink.write(attribute);
            sink.write("=\"");
            StringEscapeUtils.escapeXml((Writer)sink, (String)value);
            sink.write("\"");
        }
    }
}

