/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.itinerary.model.RunDebugUtil;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.Scope;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultScope;
import com.sonicsw.esb.process.model.impl.DefaultTerminateNode;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;

public class TerminateStepNode
extends DefaultTerminateNode
implements EsbNode,
FlowTerminationNode {
    private XQAddress m_endpointRef;
    private Scope m_scope;

    public TerminateStepNode(String id, String stepName, ActivityGroup parent) {
        super(id, parent);
        this.m_endpointRef = new XQAbstractAddressImpl("InternalStep.Terminate", 1, stepName);
        this.m_scope = new DefaultScope(id);
    }

    @Override
    public void setEndpointRef(XQAddress endpointRef) {
        this.m_endpointRef = endpointRef;
    }

    @Override
    public boolean activate(Token token) {
        XQParameters params = ((EsbMessageExchange)token.getData()).getXQParameters();
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        params.setParameter("SonicXQ.ProcessStep", 1, procInst.getCompleteStepName(this.m_displayName));
        return super.activate(token);
    }

    @Override
    public Token execute(Token token) {
        if (XQContainer.isTestContainer()) {
            return this.handleTestMode(token);
        }
        return super.execute(token);
    }

    private Token handleTestMode(Token token) {
        boolean result;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        if (!mex.isExchangeImmediate() && (result = RunDebugUtil.execute(mex, token, this))) {
            XQMessageInternal msgInternal = (XQMessageInternal)((EsbMessageExchange)token.getData()).getInputMessage();
            return (Token)msgInternal.getSidebandProperty("TOKEN");
        }
        XQMessage msg = mex.getInputMessage();
        try {
            if (msg.getReplyTo() == null) {
                return token;
            }
            msg.removeAllParts();
            msg.addPart(msg.createPart((Object)"Process terminated successfully ... ", "text/plain"));
            XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
            mex.setDestinationAddress(XQAddressFactoryImpl.getReplyToStatic());
            ItineraryEndNode.dispatchMessageToExitorRME(token, procInst);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return token;
    }

    @Override
    public XQAddress getEndpointRef(Token token) {
        return this.m_endpointRef;
    }

    @Override
    public XQParameters getXQParameters() {
        return null;
    }

    @Override
    public void setXQParameters(XQParameters params) {
    }

    @Override
    public Scope getScope() {
        return this.m_scope;
    }

    @Override
    public MessageMapper getMessageMapper() {
        return null;
    }

    @Override
    public void setMessageMapper(MessageMapper msgMapper) {
    }
}

