/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.process.engine.StopTokenProcessing;
import com.sonicsw.esb.process.model.Action;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.ws.rm.IWSRMEngine;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import com.sonicsw.xqimpl.ws.addressing.WSAHeaders;
import com.sonicsw.xqimpl.ws.rm.handlers.InboundRMHandler;
import javax.jms.Destination;
import javax.jms.JMSException;
import progress.message.jimpl.Topic;

public class WsRmEntryAction
implements Action {
    @Override
    public void execute(Token token, Action.Type type, ActivityNode targetNode, ActivityEdge targetEdge) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQMessage message = mex.getInputMessage();
        boolean isWSA = false;
        try {
            isWSA = message.getHeaderValue("X-HTTP-SOAPVersion") != null;
        }
        catch (XQMessageException e1) {
            e1.printStackTrace();
        }
        if (!isWSA) {
            return;
        }
        if (targetNode != null && targetNode instanceof EsbNode) {
            try {
                XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
                InboundRMHandler rmHandler = new InboundRMHandler(message, procInst);
                if (rmHandler.hasRMState()) {
                    org.apache.axis.message.addressing.Action a;
                    WSAHeaders header = rmHandler.getWSAHeaders();
                    if (header != null && (a = header.getAction()) != null && AddressingUtils.isFaultURI(a.toString())) {
                        this.sendWSFaultMessage(message);
                        throw new StopTokenProcessing(token);
                    }
                    this.serializeRMParameters(mex.getXQParameters(), rmHandler, procInst.getProcessInstanceProperties());
                }
            }
            catch (Throwable e) {
                throw new ItineraryException(e, "Error while processing WS-RM information", token);
            }
        }
    }

    private void serializeRMParameters(XQParameters inParams, InboundRMHandler rmHandler, ProcessInstanceProps procInstProps) {
        WSAHeaders WSAHeaders2;
        if (inParams == null) {
            return;
        }
        IWSRMEngine rmEngine = rmHandler.getRMEngine();
        if (rmEngine != null) {
            String wsRMEngineStr = rmEngine.serialize();
            inParams.setParameterObject("SonicESB.RM.SequenceMap", 1, (Object)wsRMEngineStr);
            procInstProps.getAllProcessProps().setProperty("SonicESB.RM.SequenceMap", wsRMEngineStr);
        }
        if ((WSAHeaders2 = rmHandler.getWSAHeaders()) != null) {
            inParams.setParameterObject("SonicESB.RM.WSAHeaders", 3, (Object)WSAHeaders2);
            procInstProps.getAllProcessProps().setProperty("SonicESB.RM.WSAHeaders", WSAHeaders2.getSOAPEnvelope());
        }
    }

    private void sendWSFaultMessage(XQMessage message) throws XQEndpointException, JMSException {
        XQMessageInternal internalMsg = (XQMessageInternal)message;
        String entryEndpointName = (String)internalMsg.getSidebandProperty("SonicESB.OriginalEntryEndpoint");
        if (entryEndpointName != null) {
            EndpointManager mgr = EndpointManager.getInstance();
            Endpoint entryEndpoint = (Endpoint)mgr.getEndpoint(entryEndpointName);
            XQEndpointConfig endpointConfig = entryEndpoint.getConfig();
            String destinationName = "SonicESB.AsynchronousWSFault";
            try {
                String overrideDestinationName = System.getProperty("SonicESB.DefaultWSFaultTopic");
                if (overrideDestinationName != null) {
                    destinationName = overrideDestinationName;
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            endpointConfig = EndpointManager.getInstance().createEndpointConfig(endpointConfig, (Destination)new Topic(destinationName), false);
            Endpoint endpoint = EndpointManager.getInstance().createUnregisteredEndpoint(endpointConfig, true, null, null);
            endpoint.sendWithQoS(null, false, XQQualityofService.AT_LEAST_ONCE, message);
        }
    }
}

