/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.model.CompositeToken;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.process.model.Action;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.ForkNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.ws.rm.IWSRMEngine;
import com.sonicsw.esb.ws.rm.IWSRMSequenceContext;
import com.sonicsw.esb.ws.rm.WSRMException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.rm.SequenceContext;
import com.sonicsw.xqimpl.ws.rm.WSRMEngineFactory;

public class WsRmExitAction
implements Action {
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);
    private static XQLog s_RMLog = XQLogImpl.getCategoryLog((int)16384);

    @Override
    public void execute(Token token, Action.Type type, ActivityNode targetNode, ActivityEdge targetEdge) {
        XQParameters params = ((EsbMessageExchange)token.getData()).getXQParameters();
        Object serializedRMEngine = params.getParameterObject("SonicESB.RM.SequenceMap", 1);
        if (serializedRMEngine != null) {
            if (s_RMLog.isDebugLoggingEnabled()) {
                s_RMLog.logDebug("After process: RMEngine=" + serializedRMEngine);
            }
            if (targetNode != null && this.terminateSequences(token, targetNode)) {
                try {
                    IWSRMEngine rmEngine = WSRMEngineFactory.create((String)serializedRMEngine);
                    String currentProcessName = token.getProcessInstance().getProcessDefinition().getProcessName();
                    rmEngine.terminateAllSequences((IWSRMSequenceContext)new SequenceContext(currentProcessName));
                }
                catch (WSRMException e) {
                    throw new ItineraryException(e, "Error while terminating the RM sequence", token);
                }
                finally {
                    params.setParameterObject("SonicESB.RM.SequenceMap", 1, null);
                }
            }
        }
    }

    private boolean terminateSequences(Token token, ActivityNode targetNode) {
        boolean alreadyTerminated;
        boolean bTerminateSequences = false;
        boolean bl = alreadyTerminated = token.getProperty("RM_TERMINATED") != null;
        if (alreadyTerminated) {
            return false;
        }
        if (targetNode instanceof FlowTerminationNode) {
            bTerminateSequences = true;
        } else if (targetNode instanceof EsbStepNode) {
            if (token instanceof CompositeToken) {
                bTerminateSequences = true;
                s_log.logWarning("Terminating RM sequence due to multiple outgoing messages.");
            } else {
                String indexInCompositeToken;
                ActivityNode nextStep;
                ActivityEdge[] outEdges = targetNode.getOutgoingEdges();
                if (outEdges != null && outEdges.length > 0 && (nextStep = outEdges[0].getDestination()) != null && nextStep instanceof ForkNode) {
                    bTerminateSequences = true;
                    s_log.logWarning("Terminating RM sequence due to explicit fanout step.");
                }
                if (!bTerminateSequences && (indexInCompositeToken = (String)token.getProperty("COMPOSITE_TOKEN_INDEX")) != null) {
                    int index = -1;
                    try {
                        index = Integer.parseInt(indexInCompositeToken);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    boolean bl2 = bTerminateSequences = index == 0;
                    if (bTerminateSequences) {
                        s_log.logWarning("Terminating RM sequence due to multiple outgoing messages.");
                    }
                }
            }
        }
        if (bTerminateSequences) {
            token.setProperty("RM_TERMINATED", "true");
        }
        s_log.logDebug("terminateSequences() returning: " + bTerminateSequences);
        return bTerminateSequences;
    }
}

