/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.model.impl;

import com.sonicsw.esb.process.engine.EngineException;
import com.sonicsw.esb.process.engine.ProcessChangeEventManager;
import com.sonicsw.esb.process.engine.StopTokenProcessing;
import com.sonicsw.esb.process.model.ActionList;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultActivityEdge;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.List;

public abstract class DefaultActivityNode
implements ActivityNode {
    protected static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);
    protected static boolean s_debugLogEnabled = s_log.isDebugLoggingEnabled();
    protected ActivityEdge[] m_incomingEdges = new DefaultActivityEdge[0];
    protected ActivityEdge[] m_outgoingEdges = new DefaultActivityEdge[0];
    protected String m_id;
    protected String m_displayName;
    protected ActivityGroup m_parent;
    protected ActionList m_onEntry;
    protected ActionList m_onExit;
    protected MainProcess m_process;

    protected DefaultActivityNode(String id, ActivityGroup parent) {
        this.m_id = id;
        this.m_displayName = id;
        this.setParent(parent);
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public final void setDisplayName(String name) {
        this.m_displayName = name;
    }

    public final void setParent(ActivityGroup parent) {
        this.m_parent = parent;
        if (parent != null) {
            this.m_process = parent.getParentProcess();
        }
    }

    @Override
    public ActivityEdge[] getIncomingEdges() {
        return this.m_incomingEdges;
    }

    @Override
    public void addIncomingEdge(ActivityEdge activityEdge) {
        ActivityEdge[] existingEdges = this.m_incomingEdges;
        int exitingLength = existingEdges.length;
        this.m_incomingEdges = new ActivityEdge[exitingLength + 1];
        for (int i = 0; i < exitingLength; ++i) {
            this.m_incomingEdges[i] = existingEdges[i];
        }
        this.m_incomingEdges[exitingLength] = activityEdge;
    }

    @Override
    public void removeIncomingEdge(ActivityEdge edgeToRemove) {
        ArrayList<ActivityEdge> edges = new ArrayList<ActivityEdge>();
        for (int i = 0; i < this.m_incomingEdges.length; ++i) {
            ActivityEdge edge = this.m_incomingEdges[i];
            if (edge.getId().equals(edgeToRemove.getId())) continue;
            edges.add(edge);
        }
        this.m_incomingEdges = edges.toArray(new ActivityEdge[edges.size()]);
    }

    @Override
    public ActivityEdge[] getOutgoingEdges() {
        return this.m_outgoingEdges;
    }

    @Override
    public void addOutgoingEdge(ActivityEdge activityEdge) {
        ActivityEdge[] existingEdges = this.m_outgoingEdges;
        int existingLength = existingEdges.length;
        this.m_outgoingEdges = new ActivityEdge[existingLength + 1];
        for (int i = 0; i < existingLength; ++i) {
            this.m_outgoingEdges[i] = existingEdges[i];
        }
        this.m_outgoingEdges[existingLength] = activityEdge;
    }

    @Override
    public void removeOutgoingEdge(ActivityEdge edgeToRemove) {
        ArrayList<ActivityEdge> edges = new ArrayList<ActivityEdge>();
        for (int i = 0; i < this.m_outgoingEdges.length; ++i) {
            ActivityEdge edge = this.m_outgoingEdges[i];
            if (edge.getId().equals(edgeToRemove.getId())) continue;
            edges.add(edge);
        }
        this.m_outgoingEdges = edges.toArray(new ActivityEdge[edges.size()]);
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_displayName;
    }

    @Override
    public void offerIncoming(Token token) {
        if (s_debugLogEnabled) {
            s_log.logDebug("Token offered to: " + this.m_id + " for instance: " + token.getProcessInstance().getPID());
        }
        Token outputToken = null;
        try {
            if (!this.activate(token)) {
                throw new EngineException("Cannot activate node " + this);
            }
            outputToken = this.execute(token);
            if (outputToken != null) {
                outputToken.changeOwnership(this, false);
            }
            XQContainer.getProcessEngine().enqueueToken(outputToken);
        }
        catch (StopTokenProcessing stopTokenProcessing) {
            // empty catch block
        }
    }

    @Override
    public void passivate(Token token) {
    }

    @Override
    public boolean activate(Token token) {
        this.executeActionList(this.m_onEntry, this.m_process.getGlobalOnEntryAction(), token);
        token.getProcessInstance().setActiveNode(this, token);
        ProcessChangeEventManager processChangeMgr = XQContainer.getProcessEngine().getProcessChangeEventManager();
        processChangeMgr.activityStarted(token, this);
        return true;
    }

    @Override
    public abstract Token execute(Token var1);

    @Override
    public void offerOutgoing(Token token) {
        if (!this.deactivate(token)) {
            return;
        }
        List<ActivityEdge> fireableEdges = this.getFireableEdges(token);
        if (fireableEdges != null && fireableEdges.size() > 0) {
            if (token.isTokenOfType(Token.Type.RME, false) || token.isTokenOfType(Token.Type.FAULT, false)) {
                this.handleOutOfBandToken(token);
                return;
            }
            for (int i = 0; i < fireableEdges.size(); ++i) {
                ActivityEdge selectedEdge = fireableEdges.get(i);
                if (s_debugLogEnabled) {
                    s_log.logDebug("Token offered from: " + this.m_id + " to edge: " + selectedEdge.getId() + " for instance: " + token.getProcessInstance().getPID());
                }
                if (i > 0) {
                    selectedEdge.place((Token)token.clone());
                    continue;
                }
                selectedEdge.place(token);
            }
        } else {
            this.handleOutOfBandToken(token);
        }
    }

    public void handleOutOfBandToken(Token token) {
        if (this.m_process.getOutOfBandTokenHandler() != null) {
            this.m_process.getOutOfBandTokenHandler().handleOutOfBandToken(this, token);
        }
    }

    @Override
    public List<ActivityEdge> getFireableEdges(Token token) {
        ArrayList<ActivityEdge> fireableEdges = null;
        for (int i = 0; i < this.m_outgoingEdges.length; ++i) {
            if (this.m_outgoingEdges[i].evaluateGuard(token)) {
                if (s_debugLogEnabled) {
                    s_log.logDebug("The outgoing edge " + this.m_outgoingEdges[i].getId() + " can process message for instance " + token.getProcessInstance().getPID());
                }
                if (fireableEdges == null) {
                    fireableEdges = new ArrayList<ActivityEdge>();
                }
                fireableEdges.add(this.m_outgoingEdges[i]);
                continue;
            }
            if (!s_debugLogEnabled) continue;
            s_log.logDebug("The outgoing edge " + this.m_outgoingEdges[i].getId() + " rejected the token for instance: " + token.getProcessInstance().getPID());
        }
        return fireableEdges;
    }

    @Override
    public ActivityGroup getParentGroup() {
        return this.m_parent;
    }

    @Override
    public MainProcess getParentProcess() {
        return this.m_process;
    }

    @Override
    public void setOnEntryAction(ActionList onEntry) {
        this.m_onEntry = onEntry;
    }

    @Override
    public ActionList getOnEntryAction() {
        return this.m_onEntry;
    }

    @Override
    public void setOnExitAction(ActionList onExit) {
        this.m_onExit = onExit;
    }

    @Override
    public ActionList getOnExitAction() {
        return this.m_onExit;
    }

    @Override
    public boolean deactivate(Token token) {
        if (s_debugLogEnabled) {
            s_log.logDebug("Deactivate called on " + this.m_id);
        }
        this.executeActionList(this.m_onExit, this.m_process.getGlobalOnExitAction(), token);
        Object procInst = token.getProcessInstance();
        procInst.removeActiveNode(this, token);
        ProcessChangeEventManager processChangeMgr = XQContainer.getProcessEngine().getProcessChangeEventManager();
        processChangeMgr.activityClosed(token, this);
        return true;
    }

    public void executeActionList(ActionList actnList, ActionList globalActnList, Token token) {
        if (actnList != null) {
            actnList.execute(token, this, null);
        }
        if (globalActnList != null) {
            globalActnList.execute(token, this, null);
        }
    }

    public String toString() {
        return (this.m_parent == null ? "ProcessNameNotSpecified" : this.m_parent.getId()) + "." + this.m_displayName;
    }
}

