/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.impl;

import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.run.LocationContext;
import com.sonicsw.esb.run.RunException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Set;
import net.jini.export.Exporter;

public abstract class RemoteValue
implements com.sonicsw.esb.run.RemoteValue {
    protected final LocationContext m_locationContext;
    private Remote m_proxy = null;
    private Exporter m_exporter = null;
    private Set m_remoteValueSubObjects = new HashSet();

    public RemoteValue(LocationContext locationContext) {
        this.m_locationContext = locationContext;
    }

    public void close() {
        if (this.m_exporter != null) {
            this.m_exporter.unexport(true);
            this.m_exporter = null;
        }
        for (RemoteValue rv : this.m_remoteValueSubObjects) {
            rv.close();
        }
        this.m_remoteValueSubObjects.clear();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public Location getLocation() throws RemoteException {
        return this.m_locationContext.getLocation();
    }

    public Remote getProxy() throws RunException {
        try {
            if (this.m_proxy == null) {
                this.m_exporter = this.m_locationContext.getExporterFactory().createExporter();
                this.m_proxy = this.m_exporter.export((Remote)this);
            }
            return this.m_proxy;
        }
        catch (Exception e) {
            throw new RunException("Failed to create proxy for remote value", e);
        }
    }

    protected com.sonicsw.esb.run.RemoteValue exportSubObject(RemoteValue remoteValue) throws RunException {
        this.m_remoteValueSubObjects.add(remoteValue);
        return (com.sonicsw.esb.run.RemoteValue)remoteValue.getProxy();
    }
}

