/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQEndpointTimeoutException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.connector.jms.IConnectionRegistry;
import com.sonicsw.xq.connector.jms.JMSEndpointContext;
import com.sonicsw.xq.connector.jms.JMSEndpointStandalone;
import com.sonicsw.xq.connector.jms.XQContainerConnectionRegistry;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQConnectionTypeConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.endpoint.IJMSEntryEndpointState;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointContext;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQDispatcher;
import java.util.Hashtable;

public class JMSEndpoint
extends JMSEndpointStandalone
implements Endpoint {
    private IConnectionRegistry m_support;

    @Override
    public String toString() {
        return "JMSEndpoint[" + this.getName() + "]";
    }

    public JMSEndpoint(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQLog log) throws XQEndpointCreationException {
        this(config, typeConfig, log, null, null);
    }

    public JMSEndpoint(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQLog log, XQConnectionConfig connection, Hashtable<?, ?> props, boolean isTmpEP) throws XQEndpointCreationException {
        super(config, typeConfig, log, connection, props, isTmpEP);
    }

    public JMSEndpoint(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQLog log, XQConnectionConfig connection, Hashtable<?, ?> props) throws XQEndpointCreationException {
        this(config, typeConfig, log, connection, props, false);
    }

    public JMSEndpoint(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQConnectionConfig connectionConfig, XQConnectionTypeConfig connTypeConfig, XQLog log, boolean runOutsideContainer) throws XQEndpointCreationException {
        super(config, typeConfig, connectionConfig, connTypeConfig, log, runOutsideContainer);
    }

    @Override
    protected IConnectionRegistry getSupport() {
        if (this.m_support == null) {
            this.m_support = new XQContainerConnectionRegistry();
        }
        return this.m_support;
    }

    @Override
    public XQMessage call(XQMessage msg, long timeout) throws XQEndpointException, XQEndpointTimeoutException {
        XQContainer.EndpointCallBehaviour callBehaviour = XQContainer.getEndpointCallBehaviour();
        String poolToUse = null;
        if (callBehaviour == XQContainer.EP_CALL_FORCE_ALO) {
            poolToUse = "AT_LEAST_ONCE";
        } else if (callBehaviour == XQContainer.EP_CALL_FORCE_ALOF) {
            poolToUse = "AT_LEAST_ONCE_FAST";
        } else if (callBehaviour == XQContainer.EP_CALL_FORCE_BE) {
            poolToUse = "BEST_EFFORT";
        } else if (callBehaviour == XQContainer.EP_CALL_USE_EP_DEFINITION) {
            poolToUse = this.getConfig().getQOS();
        }
        return this.getConnection().call(msg, timeout, poolToUse);
    }

    @Override
    public EndpointContext createContext(String name, String qos, XQDispatcher dispatcher, String entryJMSEndpointConnection) {
        return new JMSEndpointContext(name, qos, dispatcher, entryJMSEndpointConnection);
    }

    public static IJMSEntryEndpointState getJMSEntryEndpointState() {
        return JMSEndpointStandalone.getJMSEntryEndpointState();
    }

    @Override
    protected boolean isStandalone() {
        return false;
    }
}

