/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.esb.visitor.ESBVisitorContext;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQEndpointTimeoutException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.connector.jms.BreakPointHelper;
import com.sonicsw.xq.connector.jms.IConnectionRegistry;
import com.sonicsw.xq.connector.jms.JMSBreakPointHelper;
import com.sonicsw.xq.connector.jms.JMSConnectionCfg;
import com.sonicsw.xq.connector.jms.JMSEndpointCfg;
import com.sonicsw.xq.connector.jms.JMSEndpointContainer;
import com.sonicsw.xq.connector.jms.JMSEndpointMessageListener;
import com.sonicsw.xq.connector.jms.JMSEndpointStandalone;
import com.sonicsw.xq.connector.jms.MessageMapper;
import com.sonicsw.xq.connector.jms.messagingbean.MessagingBean;
import com.sonicsw.xq.connector.jms.messagingbean.Session;
import com.sonicsw.xqimpl.endpoint.IJMSEntryEndpointState;
import com.sonicsw.xqimpl.service.IXQMessageListener;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.EndpointConstants;
import com.sonicsw.xqimpl.util.StringUtil;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Topic;
import progress.message.client.prAccessor;
import progress.message.jclient.DeliveryMode;
import progress.message.jclient.DestinationFactory;

public class JMSEndpointConnection
implements ExceptionListener {
    private static XQLog log = XQLogImpl.getCategoryLog((int)256);
    private static XQLog systemLog = XQLogImpl.getInstance();
    private MessagingBean m_bean = null;
    private final String m_connectionName;
    private final Set<String> m_msgListeners;
    private CloseHandler m_closeHandler = null;
    private static XQEndpoint s_busEndpoint;
    private MessageMapper m_msgMapper = null;
    private boolean m_refreshDestinationsOnCall = false;
    private boolean m_uniqueCorrelationIDOnCall = false;
    private static AtomicLong s_uniqueCorrelationIDCounter;
    private JMSEndpointCfg m_cfg = null;
    private JMSConnectionCfg m_connectionCfg = null;
    private boolean m_runOutsideContainer = false;
    private boolean m_isTmpEP = false;
    private JMSEndpointStandalone m_endpoint;
    private IConnectionRegistry m_backendEndpointSupport = null;

    public JMSEndpointConnection(String connectionName, JMSEndpointCfg cfg, JMSConnectionCfg connectionCfg, boolean isTmpEP, boolean runOutsideContainer, JMSEndpointStandalone endpoint, IConnectionRegistry support) {
        this.m_connectionName = connectionName;
        this.m_msgListeners = Collections.synchronizedSet(new HashSet());
        this.m_msgMapper = endpoint.getMessageMapper();
        this.m_cfg = cfg;
        this.m_connectionCfg = connectionCfg;
        this.m_runOutsideContainer = runOutsideContainer;
        this.m_isTmpEP = isTmpEP;
        this.m_endpoint = endpoint;
        this.m_backendEndpointSupport = support;
        try {
            this.m_refreshDestinationsOnCall = Boolean.getBoolean("SonicESB.RefreshDestinationsOnCall");
            this.m_uniqueCorrelationIDOnCall = Boolean.getBoolean("SonicESB.UniqueJMSCorrelationIDOnCall");
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    public String toString() {
        return "JMSEndpoint.EndpointConnection[" + this.getName() + "." + this.getConnectionName() + "]";
    }

    public String getConnectionName() {
        return this.m_connectionName;
    }

    public String getName() {
        return this.m_endpoint.getName();
    }

    MessagingBean getConnection() throws Exception {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": getConnection");
        }
        if (this.m_bean == null) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": getConnection: initializing bean for connection = " + this.getConnectionName());
            }
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": getConnection: creating connection");
            }
            this.createConnection();
        }
        return this.m_bean;
    }

    protected boolean connectionLost(Throwable e) {
        if (e instanceof JMSException) {
            String jmsErrorDetail = e.getMessage();
            String jmsErrorCode = ((JMSException)e).getErrorCode();
            if (jmsErrorDetail != null && jmsErrorDetail.equals(prAccessor.getString((String)"STR008"))) {
                return true;
            }
            if (jmsErrorCode != null) {
                try {
                    int error = Integer.parseInt(jmsErrorCode);
                    return error == -5 || error == -22;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        }
        return false;
    }

    public synchronized boolean reconnect(Throwable connectException) {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": reconnect");
        }
        boolean reconnected = false;
        int retries = 0;
        if (this.connectionLost(connectException) && this.m_connectionCfg.retry()) {
            int specifiedRetries = this.m_connectionCfg.retryCount();
            while (!reconnected && specifiedRetries > retries++) {
                try {
                    reconnected = this.createConnection();
                }
                catch (Throwable e) {
                    if (!log.isDebugLoggingEnabled()) continue;
                    log.logWarning("[JMSEndpoint.reconnect] exception from createConnection()");
                    log.logWarning(e);
                }
            }
        }
        return reconnected;
    }

    public synchronized boolean start() {
        boolean success;
        block5: {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": start");
            }
            success = false;
            try {
                if (this.m_bean != null || this.createConnection()) {
                    this.m_bean.startConnection();
                    success = true;
                }
            }
            catch (Exception e) {
                if (this.reconnect(e)) {
                    this.start();
                }
                if (!log.isDebugLoggingEnabled()) break block5;
                log.logInformation("[JMSEndpoint.start]: reconnect(e) false");
                log.logDebug((Throwable)e);
            }
        }
        return success;
    }

    public void destroy() {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": destroy");
        }
        if (this.m_closeHandler != null) {
            this.m_closeHandler.setDone();
            try {
                this.m_closeHandler.join(60000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.m_closeHandler = null;
        }
        if (this.m_bean != null) {
            try {
                this.m_bean.closeConnection();
            }
            catch (JMSException jmse) {
                // empty catch block
            }
            this.m_bean = null;
        }
        for (String listener : this.m_msgListeners) {
            try {
                this.stopMessageListener(listener);
            }
            catch (Exception e) {
                if (!this.reconnect(e)) continue;
                this.destroy();
            }
        }
        if (this.m_runOutsideContainer) {
            this.m_backendEndpointSupport.releaseConnection(this.getConnectionName());
        }
        this.m_backendEndpointSupport.removeConnection(this.getConnectionName());
    }

    public void onException(JMSException exception) {
        if (!this.connectionLost(exception)) {
            return;
        }
        CloseHandler closeHandler = this.m_closeHandler;
        if (closeHandler != null) {
            log.logInformation("Connection to endpoint '" + this.getName() + "' dropped: reconnecting ...\r\n");
            closeHandler.reconnect();
        }
    }

    private synchronized boolean createConnection() throws Exception {
        this.m_bean = this.createConnection(this.getConnectionName(), this.m_connectionCfg);
        return this.m_bean != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MessagingBean createConnection(String connName, JMSConnectionCfg connectionCfg) throws Exception {
        MessagingBean bean;
        Object object = this.m_backendEndpointSupport.getSynchronization();
        synchronized (object) {
            bean = this.m_backendEndpointSupport.getConnection(connName);
            if (bean != null) {
                if (log.isDebugLoggingEnabled()) {
                    log.logInformation("Connection to endpoint '" + this.getName() + "' reestablished.\r\n");
                }
                return bean;
            }
            try {
                HashMap<String, Object> cfMap = connectionCfg.getCFMap();
                bean = new MessagingBean();
                bean.setCFMap(cfMap);
                bean.setRunOutsideContainer(this.m_runOutsideContainer);
                bean.setConnectionName(connName);
                bean.setConnectionConfigName(connectionCfg.getConfig().getName());
                bean.setConfigManager(connectionCfg.getConfig().getParent());
                bean.setBrokerUserId(connectionCfg.getUser());
                bean.setBrokerPassword(connectionCfg.getPassword());
                int sessionPoolSize = connectionCfg.getMaxSessionsBestEffortPool();
                if (sessionPoolSize > 0) {
                    bean.setSessionPool("BEST_EFFORT", 3, false, sessionPoolSize);
                }
                if ((sessionPoolSize = connectionCfg.getMaxSessionsAtLeastOncePool()) > 0) {
                    bean.setSessionPool("AT_LEAST_ONCE", 1004, false, sessionPoolSize);
                }
                if ((sessionPoolSize = connectionCfg.getMaxSessionsAtLeastOnceFastPool()) > 0) {
                    bean.setSessionPool("AT_LEAST_ONCE_FAST", 1004, false, sessionPoolSize);
                }
                if ((sessionPoolSize = connectionCfg.getMaxSessionsExactlyOncePool()) > 0) {
                    bean.setSessionPool("EXACTLY_ONCE", 1004, true, sessionPoolSize);
                }
                if ((sessionPoolSize = connectionCfg.getMaxWebServiceSessionsPerConnection()) > 0) {
                    bean.setSessionPool("WSInvoke", 1004, false, sessionPoolSize);
                }
                if (JMSEndpointContainer.isTestContainer()) {
                    bean.setSessionPool("ESB_DEBUG_SESSION_POOL", 1, false, 5);
                    bean.setSessionPool("ESB_DEBUG_SERVER_SESSION_POOL", 1, false, 5);
                }
                if (this.m_closeHandler == null) {
                    this.m_closeHandler = new CloseHandler("CloseHandler Thread of " + connName);
                    this.m_closeHandler.start();
                    this.m_closeHandler.waitTillStarted();
                }
                this.m_closeHandler.connect();
                bean.setExceptionListener(this);
                this.m_backendEndpointSupport.addConnection(connName, bean);
            }
            catch (Throwable e) {
                bean = null;
                throw new XQEndpointException(e);
            }
        }
        return bean;
    }

    private void setUndeliveredProperties(Message msg, int deliveryMode) throws JMSException {
        if (deliveryMode == 2 || deliveryMode == DeliveryMode.NON_PERSISTENT_REPLICATED) {
            msg.setBooleanProperty("JMS_SonicMQ_preserveUndelivered", true);
            msg.setBooleanProperty("JMS_SonicMQ_notifyUndelivered", true);
        } else {
            msg.setObjectProperty("JMS_SonicMQ_preserveUndelivered", null);
            msg.setObjectProperty("JMS_SonicMQ_notifyUndelivered", null);
        }
    }

    public void send(String name, XQMessage msg) throws XQEndpointException {
        this.send(name + "producer", this.m_cfg.getDeliveryMode(), msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String sessionName, int deliveryMode, XQMessage msg) throws XQEndpointException {
        block11: {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": send: session = " + sessionName + " delivery mode = " + deliveryMode);
            }
            try {
                String draPrefix = (String)((XQMessageInternal)msg).getSidebandProperty("SonicESB.DRARouting.prefix");
                MessagingBean bean = this.getBusConnection(draPrefix);
                if (bean == null) {
                    bean = this.getConnection();
                }
                bean.waitTillConnected(this.m_cfg.getSendTimeout());
                Message jmsMessage = (Message)this.m_msgMapper.translateInput(msg, this.m_endpoint);
                this.setUndeliveredProperties(jmsMessage, deliveryMode);
                if (this.m_cfg.hasDestinationObject()) {
                    this.setSendingDestination(this.getName());
                    Map<String, Object> visitorParams = this.startSendToJMS(Boolean.TRUE, jmsMessage, msg);
                    try {
                        bean.produceMessage(this.getDRAPrefixedDestinationObject(draPrefix), jmsMessage, deliveryMode, this.getProducePriority(msg), this.m_cfg.getTimeToLive(), sessionName);
                        break block11;
                    }
                    finally {
                        this.setSendingDestination(null);
                        this.endSendToJMS(visitorParams, msg);
                    }
                }
                this.setSendingDestination(this.getName());
                Map<String, Object> visitorParams = this.startSendToJMS(Boolean.TRUE, jmsMessage, msg);
                try {
                    bean.produceMessage(this.getDRAPrefixedDestinationName(draPrefix), this.m_cfg.getType(), jmsMessage, deliveryMode, this.getProducePriority(msg), this.m_cfg.getTimeToLive(), sessionName);
                }
                finally {
                    this.setSendingDestination(null);
                    this.endSendToJMS(visitorParams, msg);
                }
            }
            catch (Throwable e) {
                String reason = e.getMessage() + ": DestinationName=" + this.m_cfg.getDestinationName();
                throw new XQEndpointException(reason, e);
            }
        }
    }

    private void endSendToJMS(Map<String, Object> visitorParams, XQMessage msg) {
        if (visitorParams != null) {
            visitorParams.put("End CI", "true");
            ESBVisitor visitor = ((XQMessageInternal)msg).getVisitor();
            visitor.sendToJMS(visitorParams);
        }
    }

    private Map<String, Object> startSendToJMS(Boolean isOneway, Message jmsMessage, XQMessage msg) {
        ESBVisitor visitor = ((XQMessageInternal)msg).getVisitor();
        HashMap<String, Object> visitorParams = null;
        if (visitor != null) {
            visitorParams = new HashMap<String, Object>();
            this.populateVisitorParams(isOneway, jmsMessage, msg, visitorParams);
            visitor.sendToJMS(visitorParams);
        }
        return visitorParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessagingBean getBusConnection(String node) throws Exception {
        if (this.m_runOutsideContainer) {
            return null;
        }
        if (node == null || node.trim().length() == 0) {
            return this.getBusConnection();
        }
        Class<JMSEndpointConnection> clazz = JMSEndpointConnection.class;
        synchronized (JMSEndpointConnection.class) {
            if (this.getBusEndpoint() == null) {
                this.setBusEndpoint(this.m_backendEndpointSupport.createBusEndpoint(this.getName(), this.m_cfg.getType()));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ((JMSEndpointStandalone)this.getBusEndpoint()).getConnection().getConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessagingBean getBusConnection() throws Exception {
        String destinationName = null;
        boolean isTemp = Boolean.valueOf(this.m_cfg.getParameters().getParameter("TemporaryEndpoint", 1));
        if (isTemp) {
            return null;
        }
        if (this.m_cfg.hasDestinationObject()) {
            Destination jmsDest = this.m_cfg.getDestination();
            String type = this.m_cfg.getType();
            destinationName = type.equalsIgnoreCase("QUEUE") ? ((Queue)jmsDest).getQueueName() : ((Topic)jmsDest).getTopicName();
        } else {
            destinationName = this.m_cfg.getDestinationName();
        }
        boolean useBusConn = this.useBusConnection(destinationName);
        if (useBusConn) {
            Class<JMSEndpointConnection> clazz = JMSEndpointConnection.class;
            synchronized (JMSEndpointConnection.class) {
                if (this.getBusEndpoint() == null) {
                    this.setBusEndpoint(this.m_backendEndpointSupport.createBusEndpoint(this.getName(), this.m_cfg.getType()));
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return ((JMSEndpointStandalone)this.getBusEndpoint()).getConnection().getConnection();
            }
        }
        return null;
    }

    private Destination getDRAPrefixedDestinationObject(String node) throws JMSException {
        Destination d = this.m_cfg.getDestination();
        if (node == null || node.trim().length() == 0) {
            return d;
        }
        if (d instanceof Topic) {
            return DestinationFactory.createTopic((String)(node + "::" + ((Topic)d).getTopicName()));
        }
        if (d instanceof Queue) {
            return DestinationFactory.createQueue((String)(node + "::" + ((Queue)d).getQueueName()));
        }
        return d;
    }

    private String getDRAPrefixedDestinationName(String node) {
        if (node == null || node.trim().length() == 0) {
            return this.m_cfg.getDestinationName();
        }
        return node + "::" + this.m_cfg.getDestinationName();
    }

    private boolean useBusConnection(String destinationName) {
        boolean nodeQualified;
        if (this.m_runOutsideContainer) {
            return false;
        }
        boolean bl = nodeQualified = destinationName.indexOf("::") != -1;
        if (!nodeQualified) {
            return false;
        }
        String urlPart = EndpointConstants.extractDestinationPart((String)destinationName);
        return !destinationName.startsWith("sonic.http") && !urlPart.startsWith("http://") && !urlPart.startsWith("https://");
    }

    private XQEndpoint getBusEndpoint() {
        return s_busEndpoint;
    }

    private String getBrokerURL() {
        String brokerURL = null;
        MessagingBean busBean = null;
        if (this.m_bean != null) {
            brokerURL = this.m_bean.getConnectionBrokerURL();
        } else if (this.m_connectionCfg != null) {
            brokerURL = this.m_connectionCfg.getURL();
        }
        if (brokerURL == null) {
            try {
                busBean = this.getBusConnection();
                if (busBean != null) {
                    brokerURL = busBean.getConnectionBrokerURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (brokerURL == null) {
            brokerURL = "Unknown-SonicMQ-Broker";
        }
        return brokerURL;
    }

    private String getBrokerHostName() {
        String brokerHostName = null;
        MessagingBean busBean = null;
        if (this.m_bean != null) {
            brokerHostName = this.m_bean.getBrokerHostName();
        }
        if (brokerHostName == null) {
            try {
                busBean = this.getBusConnection();
                if (busBean != null) {
                    brokerHostName = busBean.getBrokerHostName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (brokerHostName == null) {
            brokerHostName = "Unknown-SonicMQ-Broker";
        }
        return brokerHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBusEndpoint(XQEndpoint endpoint) {
        Class<JMSEndpointConnection> clazz = JMSEndpointConnection.class;
        synchronized (JMSEndpointConnection.class) {
            s_busEndpoint = endpoint;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void setSendingDestination(String destination) {
        JMSEndpointConnection jMSEndpointConnection = this;
        IJMSEntryEndpointState tl = jMSEndpointConnection.m_endpoint.getJMSEntryEndpointState();
        if (tl != null) {
            tl.setSendingDestination(destination);
        }
    }

    public Map<String, String> asyncWSInvokeWithQoS(XQMessage msg, XQQualityofService qos) throws XQEndpointException {
        if (qos.equals(XQQualityofService.EXACTLY_ONCE)) {
            qos = XQQualityofService.AT_LEAST_ONCE;
        }
        return this.sendWithQoS(null, false, qos, msg, "WSInvoke");
    }

    public HashMap<String, String> sendWithQoS(String sessionName, boolean commit, XQQualityofService qos, XQMessage msg) throws XQEndpointException {
        return this.sendWithQoS(sessionName, commit, qos, msg, qos.toString());
    }

    private HashMap<String, String> sendWithQoS(String sessionName, boolean commit, XQQualityofService qos, XQMessage msg, String sessionPoolName) throws XQEndpointException {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": sendWithQoS: qos = " + qos.toString());
        }
        MessagingBean bean = null;
        boolean releaseSession = qos != XQQualityofService.EXACTLY_ONCE || commit;
        try {
            bean = this.getBusConnection();
            if (bean == null) {
                bean = this.getConnection();
            }
            if (sessionName == null) {
                sessionName = bean.getSessionFromPool(sessionPoolName, this.m_cfg.getSendTimeout());
            }
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("sendWithQoS: Thread:Commit = " + Thread.currentThread() + ":" + commit);
            }
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("sendWithQoS: Connection name = " + this.getConnectionName());
            }
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("sendWithQoS: Thread:sessionName = " + Thread.currentThread() + ":" + sessionName);
            }
            if (sessionName == null) {
                throw new XQEndpointException("There is no session available. Ignore it if the system is trying reconnect.");
            }
            int deliveryMode = 2;
            if (qos.equals(XQQualityofService.BEST_EFFORT)) {
                deliveryMode = 1;
            } else if (qos.equals(XQQualityofService.AT_LEAST_ONCE_FAST)) {
                deliveryMode = DeliveryMode.NON_PERSISTENT_REPLICATED;
            }
            this.sendWithUnbound(sessionName, deliveryMode, msg);
            if (qos == XQQualityofService.EXACTLY_ONCE && commit) {
                bean.commit(sessionName);
            }
        }
        catch (Throwable excp) {
            if (qos == XQQualityofService.EXACTLY_ONCE) {
                try {
                    releaseSession = true;
                    if (log.isDebugLoggingEnabled()) {
                        log.logDebug("Async Send operation failed. Rolling back EXO session.");
                    }
                    if (bean != null) {
                        bean.rollback(sessionName);
                    }
                }
                catch (JMSException jmsExcp) {
                    systemLog.logError((Throwable)jmsExcp);
                }
            }
            throw new XQEndpointException(excp);
        }
        finally {
            if (releaseSession) {
                try {
                    if (bean != null) {
                        bean.returnSessionToPool(sessionName);
                    }
                }
                catch (Exception excp) {
                    throw new XQEndpointException((Throwable)excp);
                }
            }
        }
        HashMap<String, String> connectionSessionMap = new HashMap<String, String>();
        connectionSessionMap.put("sessionName", sessionName);
        connectionSessionMap.put("connectionName", this.getConnectionName());
        return connectionSessionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWithUnbound(String sessionName, int deliveryMode, XQMessage msg) throws XQEndpointException {
        block11: {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": sendWithUnbound: session = " + sessionName + " delivery mode = " + deliveryMode);
            }
            try {
                String draPrefix = (String)((XQMessageInternal)msg).getSidebandProperty("SonicESB.DRARouting.prefix");
                MessagingBean bean = this.getBusConnection(draPrefix);
                if (bean == null) {
                    bean = this.getConnection();
                }
                bean.waitTillConnected(this.m_cfg.getSendTimeout());
                Message jmsMessage = (Message)this.m_msgMapper.translateInput(msg, this.m_endpoint);
                this.setUndeliveredProperties(jmsMessage, deliveryMode);
                if (this.m_cfg.hasDestinationObject()) {
                    this.setSendingDestination(this.getName());
                    Map<String, Object> visitorParams = this.startSendToJMS(Boolean.TRUE, jmsMessage, msg);
                    try {
                        bean.produceMessageWithUnbound(this.getDRAPrefixedDestinationObject(draPrefix), jmsMessage, deliveryMode, this.getProducePriority(msg), this.m_cfg.getTimeToLive(), sessionName, msg.getReplyTo());
                        break block11;
                    }
                    finally {
                        this.setSendingDestination(null);
                        this.endSendToJMS(visitorParams, msg);
                    }
                }
                this.setSendingDestination(this.getName());
                Map<String, Object> visitorParams = this.startSendToJMS(Boolean.TRUE, jmsMessage, msg);
                try {
                    bean.produceMessageWithUnbound(this.getDRAPrefixedDestinationName(draPrefix), this.m_cfg.getType(), jmsMessage, deliveryMode, this.getProducePriority(msg), this.m_cfg.getTimeToLive(), sessionName, msg.getReplyTo());
                }
                finally {
                    this.setSendingDestination(null);
                    this.endSendToJMS(visitorParams, msg);
                }
            }
            catch (Throwable e) {
                String reason = e.getMessage() + ": DestinationName=" + this.m_cfg.getDestinationName();
                throw new XQEndpointException(reason, e);
            }
        }
    }

    private int getProducePriority(XQMessage xqMessage) throws JMSException {
        if (this.m_cfg.getPriority() == -1 && xqMessage instanceof XQMessageInternal) {
            XQMessageInternal msg = (XQMessageInternal)xqMessage;
            Object incomingPrio = msg.getSidebandProperty("SonicESB.JMSPriority.incoming");
            if (incomingPrio instanceof Integer) {
                int priority = (Integer)incomingPrio;
                if (priority < 0) {
                    return 0;
                }
                if (priority > 9) {
                    return 9;
                }
                return priority;
            }
            return 4;
        }
        return this.m_cfg.getPriority();
    }

    protected void debugCallback(String callbackId, String action, Session session, Message request) {
        if (BreakPointHelper.haveCallback(callbackId)) {
            ArrayList<Object> value = new ArrayList<Object>();
            value.add(request);
            value.add(session);
            value.add(this.m_cfg.getDestination());
            value.add(this.m_cfg.getDeliveryMode());
            value.add(this.m_cfg.getTimeToLive());
            BreakPointHelper.addBreakPoint(callbackId, action, action, value, true);
        }
    }

    public XQMessage call(XQMessage msg, long timeout, String poolToUse) throws XQEndpointException, XQEndpointTimeoutException {
        return this.callWithQoS(msg, timeout, null, poolToUse);
    }

    private Message verifyReplyMessageAndRetry(MessagingBean bean, String sessionName, String correlationID, long timeout, long startTime, MessageConsumer consumer, Message replyMessage, String sessionPoolName) throws XQEndpointException, Exception {
        if (replyMessage == null) {
            if (!this.m_refreshDestinationsOnCall) {
                bean.resetTempConsumer(sessionPoolName, sessionName);
            }
            throw new XQEndpointTimeoutException("Call timed-out");
        }
        if (this.m_uniqueCorrelationIDOnCall) {
            String responseCorrelationID = replyMessage.getJMSCorrelationID();
            if (responseCorrelationID == null) {
                throw new XQEndpointException("No correlation ID was found on the response");
            }
            if (!responseCorrelationID.equals(correlationID)) {
                long timeElapsed;
                long newTimeout;
                log.logWarning("The response message JMS Correlation ID `" + responseCorrelationID + "` does not match the request message JMS correlation ID `" + correlationID + "`");
                Session session = bean.getSession(sessionName);
                if (session.getAckMode() == 1004) {
                    replyMessage.acknowledge();
                }
                if ((newTimeout = timeout - (timeElapsed = System.currentTimeMillis() - startTime)) > 0L) {
                    log.logInformation("Listening for the next response from Endpoint.Call() with time out (in ms) of: " + newTimeout);
                    long newStartTime = System.currentTimeMillis();
                    Message newReplyMessage = consumer.receive(newTimeout);
                    return this.verifyReplyMessageAndRetry(bean, sessionName, correlationID, newTimeout, newStartTime, consumer, newReplyMessage, sessionPoolName);
                }
                log.logInformation("Not listening for the next response from Endpoint.Call() because time out " + newTimeout + " is not a positive value.");
            } else {
                log.logDebug("Correlation ID `" + correlationID + "` of the response from Endpoint.Call() matched that of the request ");
            }
        }
        return replyMessage;
    }

    public XQMessage syncWSInvokeWithQoS(XQMessage msg, long timeout, XQQualityofService qos) throws XQEndpointException, XQEndpointTimeoutException {
        return this.callWithQoS(msg, timeout, qos, "WSInvoke");
    }

    public XQMessage callWithQoS(XQMessage msg, long timeout, XQQualityofService qos) throws XQEndpointException, XQEndpointTimeoutException {
        return this.callWithQoS(msg, timeout, qos, qos.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XQMessage callWithQoS(XQMessage msg, long timeout, XQQualityofService qos, String sessionPoolName) throws XQEndpointException, XQEndpointTimeoutException {
        block52: {
            sessionName = null;
            bean = null;
            session = null;
            replyTo = null;
            reply = null;
            originalJMSReplyTo = null;
            replyMessage = null;
            try {
                clonedRequestMessage = (XQMessage)msg.clone();
                draPrefix = (String)((XQMessageInternal)msg).getSidebandProperty("SonicESB.DRARouting.prefix");
                bean = this.getBusConnection(draPrefix);
                if (bean == null) {
                    this.start();
                    bean = this.getConnection();
                }
                needCommit = false;
                sessionName = bean.getSessionFromPool(sessionPoolName, this.m_cfg.getSendTimeout());
                if (sessionName == null) {
                    throw new XQEndpointException("There is no session available. Ignore it if the system is trying reconnect.");
                }
                session = bean.getSession(sessionName);
                if (qos == null && "EXACTLY_ONCE".equals(sessionPoolName)) {
                    needCommit = true;
                }
                request = (Message)this.m_msgMapper.translateInput(clonedRequestMessage, this.m_endpoint);
                deliveryMode = 2;
                if (qos == null) {
                    deliveryMode = this.m_cfg.getDeliveryMode();
                } else if (qos.equals(XQQualityofService.BEST_EFFORT)) {
                    deliveryMode = 1;
                } else if (qos.equals(XQQualityofService.AT_LEAST_ONCE_FAST)) {
                    deliveryMode = DeliveryMode.NON_PERSISTENT_REPLICATED;
                }
                this.setUndeliveredProperties(request, deliveryMode);
                originalJMSReplyTo = request.getJMSReplyTo();
                consumer = null;
                if (this.m_refreshDestinationsOnCall) {
                    replyTo = session.addTemporaryDestination("QUEUE");
                    consumer = session.addConsumer(replyTo);
                } else {
                    replyTo = bean.getTempDestFromPool(sessionPoolName, sessionName);
                    consumer = bean.getTempConsumerFromPool(sessionPoolName, sessionName);
                    if (JMSEndpointConnection.log.isDebugLoggingEnabled()) {
                        JMSEndpointConnection.log.logDebug("callWithQos: Will reuse temporary destination " + Thread.currentThread());
                    }
                }
                request.setJMSReplyTo(replyTo);
                originalJMSCorrelationId = request.getJMSCorrelationID();
                correlationID = "";
                if (this.m_uniqueCorrelationIDOnCall) {
                    idCount = JMSEndpointConnection.s_uniqueCorrelationIDCounter.incrementAndGet();
                    correlationID = "ENDPOINT_CALL_ID:" + idCount + ":" + replyTo.toString();
                    if (JMSEndpointConnection.log.isDebugLoggingEnabled()) {
                        JMSEndpointConnection.log.logDebug("JMSEndpointConnection.callWithQoS(): Setting correlationID on request, correlationID=" + correlationID);
                    }
                    request.setJMSCorrelationID(correlationID);
                }
                if (qos == null) {
                    ttl = this.m_cfg.getTimeToLive();
                    priority = this.getProducePriority(msg);
                } else {
                    ttl = request.getObjectProperty("timeToLive") == null ? this.m_cfg.getTimeToLive() : ((Long)request.getObjectProperty("timeToLive")).longValue();
                    priority = request.getJMSPriority();
                }
                if (this.m_cfg.hasDestinationObject()) {
                    this.setSendingDestination(this.getName());
                    visitorParams = this.startSendToJMS(Boolean.FALSE, request, msg);
                    if (qos == null) {
                        this.debugCallback("endpointCall", "call", session, request);
                    }
                    try {
                        session.produceMessageWithUnbound(this.getDRAPrefixedDestinationObject(draPrefix), request, deliveryMode, priority, ttl);
                        if (qos != null || !needCommit) ** GOTO lbl88
                        this.debugCallback("endpointCallCommit", "commitOnSend", session, request);
                        session.commit();
                    }
                    finally {
                        this.setSendingDestination(null);
                        this.endSendToJMS(visitorParams, msg);
                    }
                } else {
                    this.setSendingDestination(this.getName());
                    visitorParams = this.startSendToJMS(Boolean.FALSE, request, msg);
                    if (qos == null) {
                        this.debugCallback("endpointCall", "call", session, request);
                    }
                    try {
                        session.produceMessageWithUnbound(this.getDRAPrefixedDestinationName(draPrefix), this.m_cfg.getType(), request, deliveryMode, priority, ttl);
                        if (qos == null && needCommit) {
                            this.debugCallback("endpointCallCommit", "commitOnSend", session, request);
                            session.commit();
                        }
                    }
                    finally {
                        this.setSendingDestination(null);
                        this.endSendToJMS(visitorParams, msg);
                    }
                }
                startTime = System.currentTimeMillis();
                if (qos == null) {
                    replyMessage = consumer.receive(timeout);
                    replyMessage = this.verifyReplyMessageAndRetry(bean, sessionName, correlationID, timeout, startTime, consumer, replyMessage, "AT_LEAST_ONCE");
                    if (needCommit) {
                        try {
                            this.debugCallback("endpointCallCommit", "beforeCommitOnReceive", session, request);
                            session.commit();
                        }
                        catch (Exception e) {
                            bean.resetTempConsumer(sessionPoolName, sessionName);
                            throw new XQEndpointException("failed to commit received message", (Throwable)e);
                        }
                    }
                } else {
                    replyMessage = timeout >= 0L ? consumer.receive(timeout) : consumer.receive();
                    replyMessage = this.verifyReplyMessageAndRetry(bean, sessionName, correlationID, timeout, startTime, consumer, replyMessage, sessionPoolName);
                }
                replyMessage.setJMSReplyTo(originalJMSReplyTo);
                replyMessage.setJMSCorrelationID(originalJMSCorrelationId);
                reply = this.m_msgMapper.translateOutput(replyMessage, this.m_endpoint, ((XQMessageInternal)msg).getEndpointRegistry());
                if (qos != null || (visitor = ((XQMessageInternal)msg).getVisitor()) == null) break block52;
                ((XQMessageInternal)reply).setVisitor(visitor);
                esbCtx = (ESBVisitorContext)((XQMessageInternal)msg).getSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT");
                if (esbCtx != null) {
                    ((XQMessageInternal)reply).addSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT", esbCtx);
                }
            }
            catch (XQEndpointTimeoutException e) {
                try {
                    throw e;
                    catch (Throwable e) {
                        throw new XQEndpointException(e);
                    }
                }
                catch (Throwable var28_33) {
                    try {
                        if (replyTo != null) {
                            if (session.getAckMode() == 1004 && replyMessage != null) {
                                replyMessage.acknowledge();
                            }
                            if (this.m_refreshDestinationsOnCall) {
                                session.closeConsumer(replyTo);
                                session.removeTemporaryDestination(replyTo);
                            }
                            replyTo = null;
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        if (sessionName == null) throw var28_33;
                        bean.returnSessionToPool(sessionName);
                        throw var28_33;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    throw var28_33;
                }
            }
        }
        try {
            if (replyTo != null) {
                if (session.getAckMode() == 1004 && replyMessage != null) {
                    replyMessage.acknowledge();
                }
                if (this.m_refreshDestinationsOnCall) {
                    session.closeConsumer(replyTo);
                    session.removeTemporaryDestination(replyTo);
                }
                replyTo = null;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (sessionName == null) return reply;
            bean.returnSessionToPool(sessionName);
            return reply;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return reply;
        }
    }

    public void setMessageListener(String name, IXQMessageListener msgListener, Map<String, Object> subscriptionSpec) throws Exception {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": setMessageListener: session = " + name);
        }
        String destinationName = "";
        int ackMode = (Integer)subscriptionSpec.get("ackMode");
        boolean transacted = (Boolean)subscriptionSpec.get("transacted");
        String mfContainerName = (String)subscriptionSpec.get("mfContainerName");
        String mfFailoverIdentity = (String)subscriptionSpec.get("mfFailoverIdentity");
        String serviceName = (String)subscriptionSpec.get("serviceName");
        String serviceAppName = (String)subscriptionSpec.get("serviceAppName");
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("### JMSEndpoint.setMessageListener:mfContainerName = " + mfContainerName);
            log.logDebug("### JMSEndpoint.setMessageListener:name = " + name);
            log.logDebug("### JMSEndpoint.setMessageListener:serviceName = " + serviceName);
            log.logDebug("### JMSEndpoint.setMessageListener:serviceAppName = " + serviceAppName);
        }
        try {
            JMSEndpointMessageListener listener = null;
            if (!this.m_msgListeners.contains(name)) {
                String selector;
                MessagingBean bean = this.getConnection();
                int flowToDisk4sess = this.m_cfg.getFlowToDisk();
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug("### JMSEndpoint.setMessageListener:flowToDisk4sess=" + flowToDisk4sess);
                }
                Session session = bean.addSession(name, ackMode, transacted, flowToDisk4sess, false);
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug("### JMSEndpoint.setMessageListener:session name = " + session.getSessionName() + "; Should be same as name = " + name);
                }
                if ((selector = this.m_cfg.getSelector(serviceAppName)) == null) {
                    selector = this.m_cfg.getMessageSelector();
                }
                destinationName = this.m_cfg.getDestinationName();
                if (this.m_cfg.getType().equalsIgnoreCase("QUEUE")) {
                    if (log.isDebugLoggingEnabled()) {
                        log.logDebug("+++++++++ QUEUE getSelector() = " + selector);
                    }
                    bean.addQueueConsumer(ackMode, transacted, destinationName, selector, false, this.m_cfg.getPrefetchCount(), this.m_cfg.getPrefetchThreshold(), name, flowToDisk4sess, false, this.m_isTmpEP);
                } else {
                    destinationName = this.changeDestinationName4SharedSub(destinationName, serviceName);
                    JMSBreakPointHelper.addBreakPoint("durable", "Durable subscriber", this.m_cfg.isDurable());
                    JMSBreakPointHelper.addBreakPoint("ConcurrentDurable", "Concurrent Durable subscriber", this.m_cfg.isConcurrentDurableSubscriber());
                    if (this.m_cfg.isDurable()) {
                        String durableSubName = null;
                        if (this.m_cfg.isConcurrentDurableSubscriber()) {
                            int sequenceNumberPosion = name.lastIndexOf("_") + 1;
                            String sequenceNumber = name.substring(sequenceNumberPosion);
                            durableSubName = (mfFailoverIdentity != null ? mfFailoverIdentity : mfContainerName) + ":" + serviceName + ":" + sequenceNumber + ":" + this.m_cfg.getDurableSubscriberName();
                        } else {
                            durableSubName = this.m_cfg.getDurableSubscriberName();
                        }
                        JMSBreakPointHelper.addBreakPoint("durableSubName", "Durable subscriber name", durableSubName);
                        if (log.isDebugLoggingEnabled()) {
                            if (log.isDebugLoggingEnabled()) {
                                log.logDebug("### JMSEndpoint.setMessageListener: durableSubName = " + durableSubName);
                            }
                            if (log.isDebugLoggingEnabled()) {
                                log.logDebug("+++++++++ DurSub getSelector() = " + selector);
                            }
                        }
                        bean.addDurableConsumer(ackMode, transacted, destinationName, durableSubName, selector, false, name, flowToDisk4sess, false);
                    } else {
                        if (log.isDebugLoggingEnabled()) {
                            log.logDebug("+++++++++ Sub getSelector() = " + selector);
                        }
                        bean.addNonDurableConsumer(ackMode, transacted, destinationName, selector, false, name, flowToDisk4sess, false, this.m_isTmpEP);
                    }
                }
                listener = new JMSEndpointMessageListener(this.m_cfg, this.m_endpoint, name, bean, msgListener, this.m_msgMapper);
                bean.setMessageListener(ackMode, transacted, listener, destinationName, this.m_cfg.getType(), name, flowToDisk4sess, false);
                this.start();
                this.m_msgListeners.add(name);
            }
        }
        catch (Throwable e) {
            throw new Exception("destination:" + destinationName, e);
        }
    }

    private String changeDestinationName4SharedSub(String destinationName, String serviceName) {
        if (!this.m_cfg.isSharedSubscriptions()) {
            return destinationName;
        }
        if (destinationName.startsWith("[[") && destinationName.indexOf("]]") > 0) {
            return destinationName;
        }
        destinationName = EndpointConstants.extractDestinationPart((String)destinationName);
        String lawfulServiceName = this.legitimateServiceName(serviceName);
        String newDestinationName = "[[" + lawfulServiceName + "]]" + destinationName;
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": newDestinationName=" + newDestinationName);
        }
        return newDestinationName;
    }

    private String legitimateServiceName(String serviceName) {
        if (serviceName == null) {
            return "nullServiceName";
        }
        String lawfulName = StringUtil.replaceAll((String)serviceName, (String)"$", (String)"_DS_");
        lawfulName = StringUtil.replaceAll((String)lawfulName, (String)"\\", (String)"_BS_");
        lawfulName = StringUtil.replaceAll((String)lawfulName, (String)".", (String)"_PD_");
        lawfulName = StringUtil.replaceAll((String)lawfulName, (String)"*", (String)"_AK_");
        lawfulName = StringUtil.replaceAll((String)lawfulName, (String)"#", (String)"_PS_");
        lawfulName = StringUtil.replaceAll((String)lawfulName, (String)"[", (String)"_LB_");
        lawfulName = StringUtil.replaceAll((String)lawfulName, (String)"]", (String)"_RB_");
        return lawfulName;
    }

    public void stopMessageListener(String name) throws Exception {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": stopMessageListener");
        }
        if (this.m_bean == null) {
            throw new Exception("No connection found. Could not stop " + name);
        }
        this.m_bean.closeSession(name);
        this.m_msgListeners.remove(name);
        this.m_backendEndpointSupport.releaseConnection(this.getConnectionName());
    }

    private void populateVisitorParams(Boolean isOneway, Message jmsMessage, XQMessage xqMsg, Map<String, Object> visitorParams) {
        visitorParams.put("ESBVisitor.PARAM_JMS_ENDPOINT_CFG", this.m_cfg);
        visitorParams.put("ESBVisitor.PARAM_MESSAGE", jmsMessage);
        visitorParams.put("ESBVisitor.PARAM_IS_ONEWAY", isOneway);
        visitorParams.put("ESBVisitor.PARAM_JMS_BROKER_URL", this.getBrokerURL());
        visitorParams.put("ESBVisitor.PARAM_JMS_BROKER_HOST", this.getBrokerHostName());
        visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", xqMsg);
    }

    private void syslogInformation(String msg) {
        if (this.m_runOutsideContainer) {
            if (log.isDebugLoggingEnabled()) {
                log.logInformation(msg);
            }
        } else {
            systemLog.logInformation(msg);
        }
    }

    private void syslogWarning(String msg) {
        if (this.m_runOutsideContainer) {
            log.logWarning(msg);
        } else {
            systemLog.logWarning(msg);
        }
    }

    private void syslogWarning(Throwable t) {
        if (this.m_runOutsideContainer) {
            log.logWarning(t);
        } else {
            systemLog.logWarning(t);
        }
    }

    static {
        s_uniqueCorrelationIDCounter = new AtomicLong(0L);
    }

    private class CloseHandler
    extends Thread {
        private boolean l_isStarted;
        private volatile boolean l_isDone;
        private final Object l_syncObject;

        CloseHandler(String threadName) {
            super(threadName);
            this.l_isStarted = false;
            this.l_isDone = false;
            this.l_syncObject = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setDone() {
            Object object = this.l_syncObject;
            synchronized (object) {
                this.l_isDone = true;
                this.l_syncObject.notify();
                this.notify();
                if (JMSEndpointConnection.this.m_bean != null && JMSEndpointConnection.this.m_bean.isNeedConnect()) {
                    this.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.l_isDone) {
                try {
                    CloseHandler closeHandler = this;
                    synchronized (closeHandler) {
                        if (!this.l_isDone) {
                            if (!this.l_isStarted) {
                                this.l_isStarted = true;
                                this.notify();
                            }
                            if (JMSEndpointConnection.this.m_bean != null && !JMSEndpointConnection.this.m_bean.isNeedConnect()) {
                                this.wait();
                            }
                        } else {
                            return;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                try {
                    if (JMSEndpointConnection.this.m_bean == null || !JMSEndpointConnection.this.m_bean.isNeedConnect()) continue;
                    this.handleConnectionLoss(null);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Exception e) {
                    log.logError((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitTillStarted() {
            CloseHandler closeHandler = this;
            synchronized (closeHandler) {
                while (!this.l_isStarted) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reconnect() {
            CloseHandler closeHandler = this;
            synchronized (closeHandler) {
                if (JMSEndpointConnection.this.m_bean != null) {
                    JMSEndpointConnection.this.m_bean.setNeedConnect(true);
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect() {
            CloseHandler closeHandler = this;
            synchronized (closeHandler) {
                if (JMSEndpointConnection.this.m_bean != null) {
                    JMSEndpointConnection.this.m_bean.setNeedConnect(true);
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleConnectionLoss(JMSException JMSException2) throws Exception {
            int attempt = 1;
            Throwable exception = JMSException2;
            while (!this.l_isDone) {
                if (exception != null && !JMSEndpointConnection.this.connectionLost(exception)) {
                    throw exception;
                }
                Object object = this.l_syncObject;
                synchronized (object) {
                    if (this.l_isDone) {
                        return;
                    }
                    try {
                        if (attempt > 30) {
                            this.l_syncObject.wait(30000L);
                        } else if (attempt > 0) {
                            this.l_syncObject.wait(attempt * 1000);
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw ie;
                    }
                    if (this.l_isDone) {
                        return;
                    }
                }
                try {
                    if (attempt == 1) {
                        JMSEndpointConnection.this.syslogInformation("Attempting to (re)establish connection: " + JMSEndpointConnection.this.getConnectionName());
                    }
                    if (JMSEndpointConnection.this.m_bean.reconnect()) {
                        JMSEndpointConnection.this.m_bean.startConnection();
                        String url = JMSEndpointConnection.this.m_bean.getConnectionBrokerURL();
                        if (url == null) {
                            JMSEndpointConnection.this.syslogInformation("Connection to endpoint '" + JMSEndpointConnection.this.getName() + "' (re)established for connection '" + JMSEndpointConnection.this.getConnectionName() + "' \r\n");
                            break;
                        }
                        JMSEndpointConnection.this.syslogInformation("Connection to endpoint '" + JMSEndpointConnection.this.getName() + "' (re)established for connection '" + JMSEndpointConnection.this.getConnectionName() + "' at " + url + "\r\n");
                        break;
                    }
                    JMSEndpointConnection.this.syslogWarning("Connection to endpoint `" + JMSEndpointConnection.this.getName() + "` for connection: " + JMSEndpointConnection.this.getConnectionName() + " failed.  Attempt: " + attempt);
                    ++attempt;
                }
                catch (Exception e) {
                    JMSEndpointConnection.this.syslogWarning("Connection to endpoint `" + JMSEndpointConnection.this.getName() + "` for connection: " + JMSEndpointConnection.this.getConnectionName() + " failed due to exception `" + e.getMessage() + "`.  Attempt: " + attempt);
                    JMSEndpointConnection.this.syslogWarning(e);
                    ++attempt;
                    exception = e;
                }
            }
        }
    }
}

