/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import com.sonicsw.esb.testcallback.ITestCallback;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.esb.visitor.ESBVisitorChain;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQRuntimeException;
import com.sonicsw.xq.connector.jms.AckDeliveryBreakPointHelper;
import com.sonicsw.xq.connector.jms.JMSBreakPointHelper;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xq.connector.jms.JMSEndpointCfg;
import com.sonicsw.xq.connector.jms.JMSEndpointStandalone;
import com.sonicsw.xq.connector.jms.MessageMapper;
import com.sonicsw.xq.connector.jms.messagingbean.IJMSEndpointListener;
import com.sonicsw.xq.connector.jms.messagingbean.MessagingBean;
import com.sonicsw.xq.connector.jms.messagingbean.Session;
import com.sonicsw.xqimpl.endpoint.IJMSEntryEndpointState;
import com.sonicsw.xqimpl.endpoint.container.QOSCallback;
import com.sonicsw.xqimpl.service.IXQMessageListener;
import com.sonicsw.xqimpl.service.TestCallbackManager;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.InvalidDestinationException;
import javax.jms.Message;

class JMSEndpointMessageListener
implements IJMSEndpointListener,
Cloneable {
    final String m_sessionName;
    final MessagingBean m_bean;
    final IXQMessageListener m_msgListener;
    final JMSQOSCallback m_qosCallback;
    private MessageMapper m_msgMapper = null;
    private JMSEndpointCfg m_cfg = null;
    private JMSEndpointStandalone m_endpoint;
    private static XQLog log = XQLogImpl.getCategoryLog((int)256);
    protected Session m_session;
    protected Message m_msg;

    JMSEndpointMessageListener(JMSEndpointCfg cfg, JMSEndpointStandalone endpoint, String sessionName, MessagingBean bean, IXQMessageListener msgListener, MessageMapper mapper) {
        this.m_cfg = cfg;
        this.m_endpoint = endpoint;
        this.m_sessionName = sessionName;
        this.m_bean = bean;
        this.m_msgListener = msgListener;
        this.m_qosCallback = new JMSQOSCallback();
        this.m_msgMapper = mapper;
    }

    JMSEndpointMessageListener(JMSEndpointMessageListener listener) {
        this.m_cfg = listener.m_cfg;
        this.m_endpoint = listener.m_endpoint;
        this.m_sessionName = listener.m_sessionName;
        this.m_bean = listener.m_bean;
        this.m_msgListener = listener.m_msgListener;
        this.m_qosCallback = new JMSQOSCallback();
        this.m_msgMapper = listener.m_msgMapper;
    }

    @Override
    public Object clone() {
        return new JMSEndpointMessageListener(this);
    }

    @Override
    public void setSession(Session session) {
        this.m_session = session;
    }

    public String toString() {
        return "JMSEndpoint.JMSEndpointListener[" + this.m_endpoint.getName() + "]";
    }

    private void addBreakPoint(Session myCurrentSession) {
        if (myCurrentSession == null) {
            return;
        }
        try {
            ITestCallback callback = TestCallbackManager.getCallback(JMSEndpoint.class.getName());
            if (callback == null) {
                return;
            }
            ArrayList<Object> stuff = new ArrayList<Object>();
            stuff.add(myCurrentSession.getSessionName() + ":" + myCurrentSession.getJMSSession().hashCode());
            stuff.add(myCurrentSession);
            callback.call("inboundSessionName", "currentSession name", stuff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        try {
            this.m_endpoint.setListenerInOnMessage(this.m_sessionName, true);
            IJMSEntryEndpointState ees = this.m_endpoint.createJMSEntryEndpointState();
            HashMap<String, Object> visitorParams = null;
            ESBVisitor visitor = ESBVisitorChain.getInstance().createVisitor();
            if (visitor != null) {
                visitorParams = new HashMap<String, Object>();
                visitorParams.put("ESBVisitor.PARAM_JMS_ENDPOINT_CFG", this.m_cfg);
                visitorParams.put("ESBVisitor.PARAM_MESSAGE", msg);
                visitorParams.put("ESBVisitor.PARAM_JMS_BROKER_URL", this.m_bean.getConnectionBrokerURL());
                visitorParams.put("ESBVisitor.PARAM_JMS_BROKER_HOST", this.m_bean.getBrokerHostName());
                visitor.receivedFromJMS(visitorParams);
            }
            this.m_endpoint.setJMSEntryEndpointState(ees);
            boolean isXOnce = false;
            String qos = this.m_msgListener.getQoS();
            if (qos.equals("EXACTLY_ONCE")) {
                isXOnce = true;
            }
            Session myCurrentSession = this.m_session;
            ees.setSession(myCurrentSession);
            if (isXOnce) {
                if (myCurrentSession == null) {
                    throw new RuntimeException("Cannot support XOnce semantics!");
                }
                this.addBreakPoint(myCurrentSession);
            }
            ArrayList<Object> stuff = new ArrayList<Object>();
            stuff.add(this.m_session);
            stuff.add(msg);
            stuff.add(this.m_cfg.getConfig().getQOS());
            AckDeliveryBreakPointHelper.addBreakPoint("getAckMode", this.getClass().getName() + ".onMessage", stuff);
            progress.message.jclient.Session jSession = (progress.message.jclient.Session)this.m_session.getJMSSession();
            if (jSession != null) {
                JMSBreakPointHelper.addBreakPoint("flowToDisk4sess", this.getClass().getName() + ".onMessage", jSession.getFlowToDisk());
            }
            try {
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug(this.toString() + ": onMessage: Message Received: m_bean = " + this.m_bean + " m_sessionName = " + this.m_sessionName);
                }
                this.m_msg = msg;
                try {
                    if (this.m_msgListener != null) {
                        XQMessageInternal xqMsg = (XQMessageInternal)this.m_msgMapper.translateOutput(msg, this.m_endpoint);
                        if (visitor != null) {
                            xqMsg.setVisitor(visitor);
                            if (visitorParams.get("ESBVisitor.PARAM_RUNTIME_CONTEXT") != null) {
                                xqMsg.addSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT", visitorParams.get("ESBVisitor.PARAM_RUNTIME_CONTEXT"));
                            }
                        }
                        this.m_msgListener.onMessage(xqMsg, this.m_qosCallback);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.m_msg = null;
            }
            finally {
                ees.setSession(null);
            }
            if (visitor != null) {
                visitor.end(visitorParams);
            }
        }
        finally {
            this.m_endpoint.setListenerInOnMessage(this.m_sessionName, false);
        }
    }

    class JMSQOSCallback
    implements QOSCallback {
        JMSQOSCallback() {
        }

        @Override
        public boolean acknowledge() {
            boolean success = false;
            try {
                if (JMSEndpointMessageListener.this.m_msg != null) {
                    JMSEndpointMessageListener.this.m_msg.acknowledge();
                    AckDeliveryBreakPointHelper.addBreakPoint("acknowledge", this.getClass().getName() + ".acknowledge", JMSEndpointMessageListener.this.m_msg);
                }
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return success;
        }

        @Override
        public boolean commit() {
            boolean success;
            block4: {
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug(this.toString() + ": commit");
                }
                success = false;
                try {
                    JMSEndpointMessageListener.this.m_bean.commit(JMSEndpointMessageListener.this.m_sessionName);
                    success = true;
                }
                catch (Exception e) {
                    if (log.isDebugLoggingEnabled()) {
                        log.logDebug(this.toString() + ": commit: Exception caught.");
                        log.logDebug((Throwable)e);
                    }
                    if (!(e instanceof InvalidDestinationException)) break block4;
                    throw new XQRuntimeException("Could not complete transaction for message, Invalid Destination Provided", (Throwable)e);
                }
            }
            return success;
        }

        @Override
        public boolean rollback() {
            boolean success = false;
            try {
                JMSEndpointMessageListener.this.m_bean.rollback(JMSEndpointMessageListener.this.m_sessionName);
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return success;
        }

        @Override
        public boolean recover() {
            boolean success = false;
            try {
                JMSEndpointMessageListener.this.m_bean.recover(JMSEndpointMessageListener.this.m_sessionName);
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return success;
        }
    }
}

