/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms.messagingbean;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.connector.jms.AckDeliveryBreakPointHelper;
import com.sonicsw.xq.connector.jms.BreakPointHelper;
import com.sonicsw.xq.connector.jms.JMSBreakPointHelper;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xq.connector.jms.RestrictedSession;
import com.sonicsw.xq.connector.jms.messagingbean.IJMSEndpointListener;
import com.sonicsw.xq.connector.jms.messagingbean.MessagingBean;
import com.sonicsw.xq.connector.jms.messagingbean.TempDestinationCache;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import progress.message.jclient.QueueReceiver;
import progress.message.jimpl.TemporaryQueue;

public class Session {
    private static XQLog m_log = XQLogImpl.getInstance();
    private final String m_sessionName;
    private final boolean m_bTransacted;
    private final int m_nAckMode;
    private final int m_flowToDisk;
    private final MessagingBean m_bean;
    protected final Connection m_connection;
    protected final Connection m_restrictedConnection;
    protected javax.jms.Session m_session;
    protected javax.jms.Session m_restrictedSession;
    protected final Hashtable<Object, MessageProducer> m_producers = new Hashtable();
    protected final Hashtable<Object, MessageConsumer> m_consumers = new Hashtable();
    protected MessageProducer m_unboundProducer = null;
    private static final Set<Destination> m_tempDests = Collections.synchronizedSet(new HashSet());
    private static ThreadLocal<JMSEndpoint> s_acquiescingEndpointThreadLocal = new ThreadLocal();

    public Session(String sessionName, MessagingBean bean, Connection connection, Connection restrictedConnection, int nAckMode, boolean bTransacted, int flowToDisk) {
        this.m_sessionName = sessionName;
        this.m_bean = bean;
        this.m_connection = connection;
        this.m_restrictedConnection = restrictedConnection;
        this.m_nAckMode = nAckMode;
        this.m_bTransacted = bTransacted;
        this.m_flowToDisk = flowToDisk;
    }

    public static void setAcquiescingEndpoint(JMSEndpoint ep) {
        s_acquiescingEndpointThreadLocal.set(ep);
    }

    public MessageConsumer addConsumer(String destinationName, String destinationType) throws JMSException {
        Object key = this.createDestinationKey(destinationName, destinationType);
        MessageConsumer consumer = this.m_consumers.get(key);
        if (consumer == null) {
            if (this.isConnected()) {
                consumer = this.m_session.createConsumer(this.createDestination(destinationName, destinationType));
            }
            if (consumer != null) {
                this.m_consumers.put(key, consumer);
            }
        }
        return consumer;
    }

    public MessageConsumer addConsumer(String destinationName, String destinationType, String messageSelector, boolean noLocal) throws JMSException {
        return this.addConsumer(destinationName, destinationType, messageSelector, noLocal, false);
    }

    MessageConsumer addConsumer(String destinationName, String destinationType, String messageSelector, boolean noLocal, boolean isTmpEP) throws JMSException {
        Object key = this.createDestinationKey(destinationName, destinationType);
        MessageConsumer consumer = this.m_consumers.get(key);
        if (consumer == null) {
            if (this.isConnected()) {
                Destination d = this.createDestination(destinationName, destinationType, isTmpEP);
                consumer = this.m_session.createConsumer(d, messageSelector, noLocal);
                if (isTmpEP) {
                    m_tempDests.add(d);
                }
                JMSBreakPointHelper.addBreakPoint("selector", this.getClass().getName() + ".addConsumer(...", messageSelector);
            }
            if (consumer != null) {
                this.m_consumers.put(key, consumer);
            }
        }
        return consumer;
    }

    public MessageConsumer addConsumer(Destination destination) throws JMSException {
        Object key = this.createDestinationKey(destination);
        MessageConsumer consumer = this.m_consumers.get(key);
        if (consumer == null) {
            if (this.isConnected()) {
                consumer = this.m_session.createConsumer(destination);
            }
            if (consumer != null) {
                this.m_consumers.put(key, consumer);
            }
        }
        return consumer;
    }

    public MessageConsumer addDurableConsumer(String destinationName, String name) throws JMSException {
        Object key = this.createDestinationKey(destinationName, "TOPIC");
        MessageConsumer consumer = this.m_consumers.get(key);
        if (consumer == null) {
            if (this.isConnected()) {
                consumer = this.m_session.createDurableSubscriber((Topic)this.createDestination(destinationName, "TOPIC"), name);
            }
            if (consumer != null) {
                this.m_consumers.put(key, consumer);
            }
            return consumer;
        }
        return null;
    }

    MessageConsumer addDurableConsumer(String destinationName, String name, String messageSelector, boolean noLocal) throws JMSException {
        Object key = this.createDestinationKey(destinationName, "TOPIC");
        MessageConsumer consumer = this.m_consumers.get(key);
        if (consumer == null) {
            if (this.isConnected()) {
                consumer = this.m_session.createDurableSubscriber((Topic)this.createDestination(destinationName, "TOPIC"), name, messageSelector, noLocal);
                JMSBreakPointHelper.addBreakPoint("durSelector", this.getClass().getName() + ".addDurableConsumer(...", messageSelector);
            }
            if (consumer != null) {
                this.m_consumers.put(key, consumer);
            }
        }
        return consumer;
    }

    public MessageProducer addProducer(String destinationName, String destinationType) throws JMSException {
        Object key = this.createDestinationKey(destinationName, destinationType);
        MessageProducer producer = this.m_producers.get(key);
        if (producer == null) {
            if (this.isConnected()) {
                producer = this.m_session.createProducer(this.createDestination(destinationName, destinationType));
            }
            if (producer != null) {
                this.m_producers.put(key, producer);
            }
        }
        return producer;
    }

    public MessageConsumer addConsumer(String destinationName, String destinationType, String messageSelector, boolean noLocal, int prefetchCount, int prefetchThreshold) throws JMSException {
        return this.addConsumer(destinationName, destinationType, messageSelector, noLocal, prefetchCount, prefetchThreshold, false);
    }

    MessageConsumer addConsumer(String destinationName, String destinationType, String messageSelector, boolean noLocal, int prefetchCount, int prefetchThreshold, boolean isTmpEP) throws JMSException {
        MessageConsumer mc = this.addConsumer(destinationName, destinationType, messageSelector, noLocal, isTmpEP);
        if (mc != null && mc instanceof QueueReceiver) {
            ((QueueReceiver)mc).setPrefetchCount(prefetchCount);
            ((QueueReceiver)mc).setPrefetchThreshold(prefetchThreshold);
            int prefetchCountSetting = ((QueueReceiver)mc).getPrefetchCount();
            int prefetchThresholdSetting = ((QueueReceiver)mc).getPrefetchThreshold();
            JMSBreakPointHelper.addBreakPoint("prefetchCount", this.getClass().getName() + ".addConsumer(...", prefetchCountSetting);
            JMSBreakPointHelper.addBreakPoint("prefetchThreshold", this.getClass().getName() + ".addConsumer(...", prefetchThresholdSetting);
        }
        return mc;
    }

    public MessageProducer addProducer(Destination destination) throws JMSException {
        Object key = this.createDestinationKey(destination);
        MessageProducer producer = this.m_producers.get(key);
        if (producer == null) {
            if (this.isConnected()) {
                producer = this.m_session.createProducer(destination);
            }
            if (producer != null) {
                this.m_producers.put(key, producer);
            }
        }
        return producer;
    }

    public Destination addTemporaryDestination(String destinationType) throws JMSException {
        if (!this.isConnected()) {
            return null;
        }
        if (destinationType.equalsIgnoreCase("QUEUE")) {
            return this.m_session.createTemporaryQueue();
        }
        return this.m_session.createTemporaryQueue();
    }

    public void removeTemporaryDestination(Destination d) throws JMSException {
        if (d instanceof javax.jms.TemporaryQueue) {
            ((javax.jms.TemporaryQueue)d).delete();
        } else if (d instanceof TemporaryTopic) {
            ((TemporaryTopic)d).delete();
        }
    }

    public void closeConsumers() {
        MessageConsumer[] consumers = this.m_consumers.values().toArray(new MessageConsumer[0]);
        for (int i = 0; i < consumers.length; ++i) {
            MessageConsumer consumer = consumers[i];
            try {
                consumer.close();
                continue;
            }
            catch (JMSException e) {
                m_log.logDebug((Throwable)e);
            }
        }
    }

    public void closeConsumer(Destination destination) throws JMSException {
        Object key = this.createDestinationKey(destination);
        MessageConsumer consumer = this.m_consumers.get(key);
        if (consumer != null) {
            consumer.close();
        }
        this.m_consumers.remove(key);
    }

    public void closeConsumer(String destinationName, String destinationType) throws JMSException {
        Object key = this.createDestinationKey(destinationName, destinationType);
        MessageConsumer consumer = this.m_consumers.get(key);
        if (consumer != null) {
            consumer.close();
        }
        this.m_consumers.remove(key);
    }

    public void closeProducer(String destinationName, String destinationType) throws JMSException {
        Object key = this.createDestinationKey(destinationName, destinationType);
        MessageProducer producer = this.m_producers.get(key);
        if (producer != null) {
            producer.close();
        }
        this.m_producers.remove(key);
    }

    public MessagingBean getMessagingBean() {
        return this.m_bean;
    }

    public void closeSession(boolean reconnect) {
        if (!reconnect) {
            try {
                this.endSession();
            }
            catch (JMSException e) {
                m_log.logDebug((Throwable)e);
            }
        }
        this.m_session = null;
        this.m_restrictedSession = null;
    }

    public void commit() throws JMSException {
        if (!this.isConnected()) {
            throw new JMSException("Session not connected.");
        }
        this.m_session.commit();
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    void createSession() throws JMSException {
        if (this.m_connection != null && !this.isConnected()) {
            this.m_session = this.m_connection instanceof progress.message.jclient.Connection ? ((progress.message.jclient.Connection)this.m_connection).createSession(this.getTransaction(), this.getAckMode(), this.getValidSessionName(this.m_sessionName)) : this.m_connection.createSession(this.getTransaction(), this.getAckMode());
            this.m_restrictedSession = new RestrictedSession(this.m_session);
            this.updateFlowToDisk();
        }
    }

    private String getValidSessionName(String sessionName) {
        return sessionName.replaceAll("[#$\\*\\.]", "_");
    }

    private void endSession() throws JMSException {
        for (Destination dest : m_tempDests) {
            try {
                this.removeTemporaryDestination(dest);
            }
            catch (JMSException jMSException) {}
        }
        if (this.isConnected()) {
            JMSEndpoint acquiescingEndpoint = s_acquiescingEndpointThreadLocal.get();
            if (acquiescingEndpoint != null) {
                long maxWaitTimeWhileListenerInOnMessage = 60000L;
                long timeWaitedWhileListenerInOnMessage = 0L;
                long timeSleepWhileListenerInOnMessage = 500L;
                this.closeConsumers();
                while (acquiescingEndpoint.isListenerInOnMessage(this.m_sessionName) && timeWaitedWhileListenerInOnMessage < maxWaitTimeWhileListenerInOnMessage) {
                    try {
                        Thread.sleep(timeSleepWhileListenerInOnMessage);
                        timeWaitedWhileListenerInOnMessage += timeSleepWhileListenerInOnMessage;
                    }
                    catch (InterruptedException ie) {
                        m_log.logDebug((Throwable)ie);
                    }
                }
            }
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
    }

    public int getAckMode() {
        if (this.m_nAckMode == 0) {
            return 1;
        }
        return this.m_nAckMode;
    }

    private MessageConsumer getConsumer(String destinationName, String destinationType) throws JMSException {
        Object key = this.createDestinationKey(destinationName, destinationType);
        MessageConsumer consumer = this.m_consumers.get(key);
        return consumer;
    }

    public MessageProducer getProducer(String destinationName, String destinationType) throws JMSException {
        Object key = this.createDestinationKey(destinationName, destinationType);
        MessageProducer producer = this.m_producers.get(key);
        if (producer == null) {
            producer = this.addProducer(destinationName, destinationType);
        }
        return producer;
    }

    public MessageProducer getProducer(Destination destination) throws JMSException {
        Object key = this.createDestinationKey(destination);
        MessageProducer producer = this.m_producers.get(key);
        if (producer == null) {
            producer = this.addProducer(destination);
        }
        return producer;
    }

    public boolean getTransaction() {
        return this.m_bTransacted;
    }

    private void updateFlowToDisk() {
        if (this.m_session instanceof progress.message.jclient.Session) {
            ((progress.message.jclient.Session)this.m_session).setFlowToDisk(this.m_flowToDisk);
        }
    }

    public void produceMessage(String destinationName, String destinationType, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        MessageProducer producer = this.getProducer(destinationName, destinationType);
        if (producer == null) {
            producer = this.addProducer(destinationName, destinationType);
        }
        if (producer != null) {
            AckDeliveryBreakPointHelper.addBreakPoint("deliveryMode", "deliveryMode in produceMessage(String destinationName...", deliveryMode);
            JMSBreakPointHelper.addBreakPoint("priority", this.getClass().getName() + ".produceMessage(String destinationName...", priority);
            JMSBreakPointHelper.addBreakPoint("timeToLive", this.getClass().getName() + ".produceMessage(String destinationName...", timeToLive);
            this.callbackOnSend("bound", producer.getDestination(), msg, deliveryMode, priority, timeToLive);
            producer.send(msg, deliveryMode, priority, timeToLive);
        }
    }

    public void produceMessage(Destination destination, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        MessageProducer producer = this.getProducer(destination);
        if (producer == null) {
            producer = this.addProducer(destination);
        }
        if (producer != null) {
            AckDeliveryBreakPointHelper.addBreakPoint("deliveryMode", "deliveryMode in produceMessage(Destination...", deliveryMode);
            JMSBreakPointHelper.addBreakPoint("priority", this.getClass().getName() + ".produceMessage(Destination...", priority);
            JMSBreakPointHelper.addBreakPoint("timeToLive", this.getClass().getName() + ".produceMessage(Destination...", timeToLive);
            this.callbackOnSend("bound", destination, msg, deliveryMode, priority, timeToLive);
            producer.send(msg, deliveryMode, priority, timeToLive);
        }
    }

    public void produceMessageWithUnbound(String destinationName, String destinationType, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (!this.isConnected()) {
            return;
        }
        Destination d = this.createDestination(destinationName, destinationType);
        this.produceMessageWithUnbound(d, msg, deliveryMode, priority, timeToLive);
    }

    public void produceMessageWithUnbound(Destination destination, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (!this.isConnected()) {
            return;
        }
        if (this.m_unboundProducer == null) {
            this.m_unboundProducer = this.m_session.createProducer(null);
        }
        AckDeliveryBreakPointHelper.addBreakPoint("deliveryMode", "deliveryMode in produceMessageWithUnbound", deliveryMode);
        JMSBreakPointHelper.addBreakPoint("priority", this.getClass().getName() + ".produceMessageWithUnbound", priority);
        JMSBreakPointHelper.addBreakPoint("timeToLive", this.getClass().getName() + ".produceMessageWithUnbound", timeToLive);
        this.callbackOnSend("unbound", destination, msg, deliveryMode, priority, timeToLive);
        this.m_unboundProducer.send(destination, msg, deliveryMode, priority, timeToLive);
    }

    private void callbackOnSend(String type, Destination destination, Message msg, int deliveryMode, int priority, long timeToLive) {
        if (!JMSBreakPointHelper.haveCallback("sessionSend")) {
            return;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(msg);
        l.add(this);
        l.add(destination);
        l.add(deliveryMode);
        l.add(timeToLive);
        l.add(type);
        BreakPointHelper.addBreakPoint("sessionSend", type, this.getClass().getName() + ".produceMessageWithUnbound", l);
    }

    public void recover() throws JMSException {
        if (!this.isConnected()) {
            throw new JMSException("Session not connected.");
        }
        this.m_session.recover();
    }

    public void rollback() throws JMSException {
        if (!this.isConnected()) {
            throw new JMSException("Session not connected.");
        }
        this.m_session.rollback();
    }

    public void setDeliveryMode(int deliveryMode, String destinationName, String destinationType) throws JMSException {
        MessageProducer producer = this.getProducer(destinationName, destinationType);
        if (producer != null) {
            producer.setDeliveryMode(deliveryMode);
        }
    }

    void setMessageListener(IJMSEndpointListener listener, String destinationName, String destinationType) throws JMSException {
        MessageConsumer consumer = this.getConsumer(destinationName, destinationType);
        listener.setSession(this);
        if (consumer != null) {
            consumer.setMessageListener((MessageListener)listener);
        } else if (this.isConnected()) {
            throw new JMSException("Unable to set message listener on consumer.  Consumer not found.");
        }
    }

    public String getSessionName() {
        return this.m_sessionName;
    }

    public Connection getRestrictedJMSConnection() {
        return this.m_restrictedConnection;
    }

    public javax.jms.Session getRestrictedJMSSession() {
        return this.m_restrictedSession;
    }

    public javax.jms.Session getJMSSession() {
        return this.m_session;
    }

    public Connection getJMSConnection() {
        return this.m_connection;
    }

    private Object createDestinationKey(String destinationName, String destinationType) {
        return destinationName + destinationType.toUpperCase();
    }

    private Object createDestinationKey(Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            return ((Topic)destination).getTopicName() + "TOPIC";
        }
        return ((Queue)destination).getQueueName() + "QUEUE";
    }

    private Destination createDestination(String destinationName, String destinationType) throws JMSException {
        return this.createDestination(destinationName, destinationType, false);
    }

    private Destination createDestination(String destinationName, String destinationType, boolean isTmpEP) throws JMSException {
        if (!this.isConnected()) {
            return null;
        }
        if (destinationType.equalsIgnoreCase("QUEUE")) {
            if (isTmpEP) {
                TemporaryQueue tempDest = new TemporaryQueue(destinationName, (progress.message.jimpl.Session)this.m_session, true);
                TempDestinationCache.instance().cacheTempDestination(destinationName, (Destination)tempDest);
                return tempDest;
            }
            return this.m_session.createQueue(destinationName);
        }
        return this.m_session.createTopic(destinationName);
    }

    public String toString() {
        return "Session[name=" + this.m_sessionName + ", connected=" + this.isConnected() + "]";
    }

    private boolean isConnected() {
        return this.m_session != null;
    }
}

