/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.common;

import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.rules.EvaluatorException;
import com.sonicsw.xq.rules.IRuleEvaluator;
import com.sonicsw.xq.rules.NoRuleFileException;
import com.sonicsw.xq.service.common.CacheableJavaScriptRule;
import com.sonicsw.xq.service.common.IJavaScriptRule;
import com.sonicsw.xq.service.common.NonCacheableJavaScriptRule;
import com.sonicsw.xq.service.common.RulesSpec;
import com.sonicsw.xqimpl.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.mozilla.javascript.Context;
import org.w3c.dom.Element;

public class ScriptEvaluator
implements IRuleEvaluator {
    public static final String ENABLE_CACHE = "ENABLED_CACHE";
    private BSFManager m_scriptMgr = null;
    private BSFEngine m_scriptEngine = null;
    private XQParameters m_params = null;
    private IJavaScriptRule m_rule = new CacheableJavaScriptRule();
    private boolean m_cacheEnabled = true;

    public void cacheEnabled(boolean enabled) {
        if (enabled != this.m_cacheEnabled) {
            this.m_rule = enabled ? new CacheableJavaScriptRule() : new NonCacheableJavaScriptRule();
        }
    }

    public void init(XQParameters params) throws EvaluatorException {
        String[] jsHelperFileUrls = null;
        try {
            this.m_params = params;
            if (this.m_params.containsParameter(ENABLE_CACHE, 1)) {
                this.cacheEnabled(this.m_params.getBooleanParameter(ENABLE_CACHE, 1));
            }
            if (this.m_scriptMgr == null) {
                this.m_scriptMgr = new BSFManager();
            }
            if (this.m_scriptEngine == null) {
                this.m_scriptEngine = this.m_scriptMgr.loadScriptingEngine("javascript");
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                BufferedInputStream bis = null;
                try {
                    bis = new BufferedInputStream(URLUtil.getInputStream((URL)new URL("sonicfs:///System/SonicESB/jsHelperFunctions.js")));
                    int read = bis.read(buffer, 0, 1024);
                    while (read != -1) {
                        bos.write(buffer, 0, read);
                        read = bis.read(buffer, 0, 1024);
                    }
                }
                catch (IOException io) {
                    throw new EvaluatorException("Unable to read sonicfs:///System/SonicESB/jsHelperFunctions.js." + io.getLocalizedMessage(), (Throwable)io);
                }
                finally {
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                    }
                    catch (IOException e) {}
                }
                this.executeJavascriptFile(new String(bos.toByteArray()));
                bos.reset();
                if (params != null) {
                    jsHelperFileUrls = this.getHelperFileURLs(params);
                }
                if (jsHelperFileUrls != null) {
                    for (int i = 0; i < jsHelperFileUrls.length; ++i) {
                        try {
                            bis = new BufferedInputStream(URLUtil.getInputStream((URL)new URL(jsHelperFileUrls[i])));
                            int read = bis.read(buffer, 0, 1024);
                            while (read != -1) {
                                bos.write(buffer, 0, read);
                                read = bis.read(buffer, 0, 1024);
                            }
                        }
                        catch (IOException io) {
                            throw new EvaluatorException("Unable to read " + jsHelperFileUrls[i] + "." + io.getLocalizedMessage(), (Throwable)io);
                        }
                        finally {
                            try {
                                if (bis != null) {
                                    bis.close();
                                }
                            }
                            catch (IOException e) {}
                        }
                        this.executeJavascriptFile(new String(bos.toByteArray()));
                        bos.reset();
                    }
                    bos.close();
                }
            } else {
                throw new EvaluatorException("No ScriptManager found to bind parameters.");
            }
            this.executeJavascriptFile(this.m_rule.getRule(this.m_params));
        }
        catch (NoRuleFileException nrfe) {
            throw nrfe;
        }
        catch (Exception e) {
            if (e instanceof EvaluatorException) {
                throw (EvaluatorException)e;
            }
            throw new EvaluatorException(e.getMessage(), (Throwable)e);
        }
    }

    private void executeJavascriptFile(String jsFile) throws EvaluatorException {
        try {
            if (jsFile == null) {
                return;
            }
            if (this.m_scriptEngine != null) {
                this.m_scriptEngine.exec(null, -1, -1, (Object)jsFile);
            }
        }
        catch (BSFException e) {
            throw new EvaluatorException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof EvaluatorException) {
                throw (EvaluatorException)e;
            }
            throw new EvaluatorException(e.getMessage(), (Throwable)e);
        }
    }

    public Object evaluateRule(XQParameters runtimeParams, XQServiceContext serviceContext, XQMessage message) throws EvaluatorException {
        Object result;
        block34: {
            result = null;
            String expression = "rule()";
            String runtimeRuleFile = null;
            String[] runtimeHelperFileUrls = null;
            try {
                Context.enter();
                if (serviceContext != null) {
                    this.m_scriptMgr.declareBean("XQServiceContext", (Object)serviceContext, serviceContext.getClass());
                }
                if (message != null) {
                    this.m_scriptMgr.declareBean("XQMessage", (Object)message, message.getClass());
                }
                if (runtimeParams != null) {
                    runtimeHelperFileUrls = this.getHelperFileURLs(runtimeParams);
                    runtimeRuleFile = new CacheableJavaScriptRule().getRule(runtimeParams);
                    if (this.m_scriptEngine != null) {
                        if (runtimeHelperFileUrls != null) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            byte[] buffer = new byte[1024];
                            BufferedInputStream bis = null;
                            for (int i = 0; i < runtimeHelperFileUrls.length; ++i) {
                                try {
                                    bis = new BufferedInputStream(URLUtil.getInputStream((URL)new URL(runtimeHelperFileUrls[i])));
                                    int read = bis.read(buffer, 0, 1024);
                                    while (read != -1) {
                                        bos.write(buffer, 0, read);
                                        read = bis.read(buffer, 0, 1024);
                                    }
                                }
                                catch (IOException io) {
                                    throw new EvaluatorException("Unable to read " + runtimeHelperFileUrls[i] + "." + io.getLocalizedMessage(), (Throwable)io);
                                }
                                finally {
                                    try {
                                        if (bis != null) {
                                            bis.close();
                                        }
                                    }
                                    catch (IOException e) {}
                                }
                                this.executeJavascriptFile(new String(bos.toByteArray()));
                                bos.reset();
                            }
                            bos.close();
                        }
                        if (runtimeRuleFile != null) {
                            this.executeJavascriptFile(runtimeRuleFile);
                            try {
                                result = this.m_scriptEngine.eval(runtimeRuleFile, 0, 0, (Object)expression);
                            }
                            catch (Exception e) {
                                throw new EvaluatorException("Desired evaluation could not be performed: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                if (this.m_scriptEngine == null || runtimeRuleFile != null) break block34;
                try {
                    result = this.m_scriptEngine.eval(this.m_rule.getRule(this.m_params), 0, 0, (Object)expression);
                }
                catch (Exception e) {
                    throw new EvaluatorException("Desired evaluation could not be performed: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable e) {
                throw new EvaluatorException(e.getMessage(), e);
            }
            finally {
                Context.exit();
                try {
                    if (serviceContext != null) {
                        this.m_scriptMgr.undeclareBean("XQServiceContext");
                    }
                    if (message != null) {
                        this.m_scriptMgr.undeclareBean("XQMessage");
                    }
                }
                catch (BSFException b) {}
            }
        }
        return result;
    }

    private String[] getHelperFileURLs(XQParameters params) {
        String[] helperFileUrls = null;
        Element xformHelperFilesNode = null;
        Element ruleInfoNode = null;
        ruleInfoNode = (Element)params.getParameterObject("ruleInfo", 2);
        if (ruleInfoNode != null) {
            Element ruleSpecNode = ruleInfoNode;
            RulesSpec ruleSpec = new RulesSpec(ruleSpecNode);
            if (ruleSpec != null) {
                helperFileUrls = ruleSpec.getHelperFileURLs();
            }
        } else {
            RulesSpec ruleSpec;
            xformHelperFilesNode = (Element)params.getParameterObject("helperFiles", 2);
            if (xformHelperFilesNode != null && (ruleSpec = new RulesSpec(xformHelperFilesNode)) != null) {
                helperFileUrls = ruleSpec.getHelperFileURLs();
            }
        }
        return helperFileUrls;
    }
}

