/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.configuration.impl;

import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.configuration.NamespacesConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.RoutingListConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.RoutingRuleConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.RoutingRulesConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.impl.NamespacesConfigurationImpl;
import com.sonicsw.xq.service.xcbr.configuration.impl.RoutingListConfigurationImpl;
import com.sonicsw.xq.service.xcbr.configuration.impl.RoutingRuleConfigurationImpl;
import com.sonicsw.xq.service.xcbr.schema.Destinations;
import com.sonicsw.xq.service.xcbr.schema.RoutingRules;
import java.util.ArrayList;
import java.util.List;

public class RoutingRulesConfigurationImpl
implements RoutingRulesConfiguration {
    private RoutingRules rules_;
    private List<RoutingRuleConfiguration> routingRules_ = new ArrayList<RoutingRuleConfiguration>();
    private RoutingListConfiguration defaultRoutingList_;
    private NamespacesConfiguration namespaces_;
    private static final String DEFAULT_NOTE = "";

    public RoutingRulesConfigurationImpl(RoutingRules argConfiguration) throws RoutingRuleException {
        this.rules_ = argConfiguration;
        for (int i = 0; i < this.rules_.getRoutingRuleCount(); ++i) {
            this.routingRules_.add(new RoutingRuleConfigurationImpl(this.rules_.getRoutingRule(i)));
        }
        Destinations defaultRoutingList = argConfiguration.getDestinations();
        if (defaultRoutingList != null) {
            this.defaultRoutingList_ = new RoutingListConfigurationImpl(defaultRoutingList);
        }
        this.namespaces_ = new NamespacesConfigurationImpl(argConfiguration.getNamespaces());
    }

    @Override
    public NamespacesConfiguration getNamespaces() throws RoutingRuleException {
        return this.namespaces_;
    }

    @Override
    public String getVersion() throws RoutingRuleException {
        return this.rules_.getXcbrVersion();
    }

    @Override
    public String getProcessType() throws RoutingRuleException {
        String processType = this.rules_.getProcessType();
        String xcbrEvaluationMode = this.rules_.getXcbrEvaluationMode();
        if (xcbrEvaluationMode != null) {
            return xcbrEvaluationMode;
        }
        if (processType != null) {
            return processType;
        }
        return "routeFirst";
    }

    @Override
    public String getNote() throws RoutingRuleException {
        String returnValue = this.rules_.getNote();
        if (returnValue == null) {
            returnValue = DEFAULT_NOTE;
        }
        return returnValue;
    }

    @Override
    public RoutingListConfiguration getDefaultRoutingList() throws RoutingRuleException {
        return this.defaultRoutingList_;
    }

    @Override
    public int getNumberofRoutingRules() throws RoutingRuleException {
        return this.routingRules_.size();
    }

    @Override
    public RoutingRuleConfiguration getRoutingRule(int argIndex) throws RoutingRuleException {
        RoutingRuleConfiguration returnValue = this.routingRules_.get(argIndex);
        return returnValue;
    }
}

