/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.actional.lg.visitor;

import com.actional.GeneralUtil;
import com.actional.lg.interceptor.sdk.ClientInteraction;
import com.actional.lg.interceptor.sdk.Interaction;
import com.actional.lg.interceptor.sdk.ServerInteraction;
import com.actional.lg.interceptor.sdk.SiteStub;
import com.actional.lg.interceptor.sdk.helpers.InterHelpBase;
import com.actional.lg.interceptor.sdk.helpers.InterHelpJms;
import com.actional.lg.interceptor.sdk.helpers.InterHelpTrust;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.esb.visitor.ESBVisitorContext;
import com.sonicsw.esb.ws.invocation.ESBWSCommand;
import com.sonicsw.esb.ws.invocation.ESBWSSoapInfo;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.connector.jms.JMSEndpointCfg;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalBasePart;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalMQPart;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalMQTextMessagePart;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalMQXMLMessagePart;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalProcessChangeListener;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalRuntimeContext;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalXQPart;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import progress.message.jclient.MultipartMessage;
import progress.message.jclient.Part;
import progress.message.jclient.XMLMessage;
import progress.message.jimpl.Message;
import progress.message.zclient.Envelope;

public class ActionalVisitor
implements ESBVisitor,
Cloneable {
    private static XQLog log = XQLogImpl.getInstance();
    public static final String NGSO_GROUP_ENDPOINT = "ESB-JMSEndpoint";
    public static final String NGSO_GROUP_PROCESS = "ESB-Process";
    public static final String NGSO_GROUP_SERVICE = "ESB-Service";
    public static final String NGSO_NO_OPERATION = "";
    public static final String MSGFIELD_ESB_CONTAINER = "ESB-Container";
    public static final String MSGFIELD_ESB_TOP_PROCESS_NAME = "ESB-Top-Process";
    public static final String MSGFIELD_ESB_PROCESS_NAME = "ESB-Process";
    public static final String MSGFIELD_ESB_SERVICE_NAME = "ESB-Service";
    public static final String MSGFIELD_ESB_REJECT_ADDRESS = "ESB-Reject-Address";
    public static final String MSGFIELD_ESB_FAULT_ADDRESS = "ESB-Fault-Address";
    public static final String MSGFIELD_ESB_FAULT_NAME = "ESB-Fault-Name";
    public static final String MSGFIELD_ESB_FAULT_STRING = "ESB-Fault-String";
    public static final String MSGFIELD_ESB_FAULT_CODE = "ESB-Fault-Code";
    public static final String MSGFIELD_ESB_FAULT_SUBCODE = "ESB-Fault-SubCode";
    public static final String VISITOR_TRACE = "com.sonicsw.xqimpl.actional.lg.visitor.trace";
    public static final String ENABLE_PAYLOAD_CAPTURE = "actional.interceptor.enablePayloadCapture";
    public static final String DISABLE_ENDPOINT_NGSO = "actional.interceptor.DisableEsbEndpointNGSO";
    public static final String ENABLE_REPLYTO_NGSO = "actional.interceptor.enableReplyToNGSO";
    public static final String DISABLE_TRUST_ENFORCEMENT = "actional.interceptor.DisableTrustZoneEnforcement";
    public static final String ENDPOINT_NGSO_RECEIVE_OP = "receive";
    public static final String ENDPOINT_NGSO_SEND_OP = "send";
    public static final String REPLYTO_NGSO_HEADER = "REPLY_TO_NGSO";
    private static final String TEMPORARY_DESTINATION = "TemporaryDestination";
    private static final String HTTPDIRECT_TEMP_DEST_IDENTIFIER = "HttpProtocolHandlerResponse";
    private static final String TEMP_DESTINATION_IDENTIFIER = "$ISYS";
    private static final String STANDALONE_SERVICE = "Standalone";
    public static final String FAULT_OP = "(Fault)";
    public static final String REJECT_OP = "(Reject)";
    public static final String RESUBMIT_OP = "(Resubmit)";
    public static final String RETHROW_OP = "(Rethrow)";
    public static final String TERMINATE_OP = "(Terminate)";
    public static final String FAULT_GROUP = "(InternalStep.Fault)";
    public static final String REJECT_GROUP = "(InternalStep.Reject)";
    public static final String RESUBMIT_GROUP = "(InternalStep.Resubmit)";
    public static final String RETHROW_GROUP = "(InternalStep.Rethrow)";
    public static final String TERMINATE_GROUP = "(InternalStep.Terminate)";
    public static final String TERMINAL_FAULT_GROUP = "(TerminalFaultGroup)";
    public static final String TERMINAL_REJECT_GROUP = "(TerminalRejectGroup)";
    private static final String PROCESS_ENTRY = "ProcessEntry";
    private static final String SUB_NODE_STR = XQContainer.getDomainName() + "." + XQContainer.getMFContainerName() + "." + XQContainer.getXQContainerName();
    public static final String ACTIONAL_FAILURE_HEADER = "Actional.Failure";
    private boolean m_capturePayload;
    private static boolean s_disableTrustEnforcement = Boolean.getBoolean("actional.interceptor.DisableTrustZoneEnforcement");
    private static boolean s_disableEndpointReporting = true;
    private static boolean s_enhancedStepReportingModeEnabled = XQContainer.isEnhancedStepReportingModeEnabled();
    private static boolean s_useReplyToNGSO = true;
    private static boolean s_isTracing = Boolean.getBoolean("com.sonicsw.xqimpl.actional.lg.visitor.trace");
    private static boolean s_displayUnmanagedNodesForJMS = XQContainer.isUnmanagedJmsNodesEnabled();
    private static String[] s_payloadCaptureMimes = XQContainer.getAdditionalPayloadCaptureMimeTypes();
    private static boolean s_enableLegacyPayloadReportingMode = XQContainer.isLegacyPayloadReportingModeEnabled();
    private static ThreadLocal s_runContext = new ThreadLocal(){

        protected Object initialValue() {
            return new ActionalContextStack();
        }
    };
    private static ActionalProcessChangeListener s_actionalProcessChangeListener;
    public static final String LG_HEADER_PROPERTY = "LG_Header";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionalVisitor() {
        String s = System.getProperty(ENABLE_PAYLOAD_CAPTURE);
        this.m_capturePayload = s != null ? Boolean.parseBoolean(s) : XQContainer.isPayloadCaptureEnabled();
        Class<ActionalVisitor> clazz = ActionalVisitor.class;
        synchronized (ActionalVisitor.class) {
            if (s_enhancedStepReportingModeEnabled && s_actionalProcessChangeListener == null) {
                s_actionalProcessChangeListener = new ActionalProcessChangeListener(this);
                XQContainer.getProcessEngine().getProcessChangeEventManager().registerProcessChangeListener(s_actionalProcessChangeListener);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void receivedFromJMS(Map params) {
        this.traceParameters("receivedFromJMS", params);
        String replyToDestination = (String)params.get("ESBVisitor.PARAM_REPLYTO");
        javax.jms.Message msg = (javax.jms.Message)params.get("ESBVisitor.PARAM_MESSAGE");
        JMSEndpointCfg endpointCfg = (JMSEndpointCfg)params.get("ESBVisitor.PARAM_JMS_ENDPOINT_CFG");
        String brokerURL = (String)params.get("ESBVisitor.PARAM_JMS_BROKER_URL");
        String brokerHost = (String)params.get("ESBVisitor.PARAM_JMS_BROKER_HOST");
        ServerInteraction si = null;
        try {
            si = ServerInteraction.begin();
            InterHelpJms.extractTransportHeaders((javax.jms.Message)msg, (ServerInteraction)si);
            ActionalRuntimeContext actCtx = this.createActionalRuntimeContext(params);
            this.setJMSInteractionAttributes((Interaction)si, msg, replyToDestination, endpointCfg, brokerURL, brokerHost, ENDPOINT_NGSO_RECEIVE_OP, actCtx, true, false);
            if (s_disableEndpointReporting) {
                actCtx.setReceivedFromJms(true);
                actCtx.setCurrentServerInteraction(si);
            } else {
                if (s_isTracing) {
                    this.traceInteraction("receivedFromJMS", (Interaction)si);
                }
                si.end();
                actCtx.setParentServerInteractionStub(si.split());
            }
        }
        catch (Exception e) {
            log.logWarning((Throwable)e);
        }
    }

    public void sendToJMS(Map params) {
        this.traceParameters("sendToJMS", params);
        XQMessage xqMsg = (XQMessage)params.get("ESBVisitor.PARAM_XQ_MESSAGE");
        ActionalRuntimeContext actCtx = this.getActionalRuntimeContext(xqMsg);
        if (params.remove("End CI") != null) {
            ClientInteraction ci;
            if (actCtx != null && (ci = actCtx.getCurrentClientInteraction()) != null) {
                ci.end();
                ci = null;
            }
            return;
        }
        String replyToDestination = (String)params.get("ESBVisitor.PARAM_REPLYTO");
        javax.jms.Message msg = (javax.jms.Message)params.get("ESBVisitor.PARAM_MESSAGE");
        JMSEndpointCfg endpointCfg = (JMSEndpointCfg)params.get("ESBVisitor.PARAM_JMS_ENDPOINT_CFG");
        String brokerURL = (String)params.get("ESBVisitor.PARAM_JMS_BROKER_URL");
        String brokerHost = (String)params.get("ESBVisitor.PARAM_JMS_BROKER_HOST");
        Boolean isOneway = (Boolean)params.get("ESBVisitor.PARAM_IS_ONEWAY");
        ServerInteraction si = null;
        ClientInteraction ci = null;
        try {
            String failureMessage;
            si = this.createServerInteraction(actCtx);
            ci = ClientInteraction.begin();
            boolean failure = this.getLGFailureMessage(xqMsg, false) != null;
            actCtx = this.createActionalContextIfNull(xqMsg, actCtx);
            this.setJMSInteractionAttributes((Interaction)ci, msg, replyToDestination, endpointCfg, brokerURL, brokerHost, null, actCtx, isOneway, failure);
            msg.setStringProperty(LG_HEADER_PROPERTY, InterHelpBase.writeHeader((ClientInteraction)ci, (boolean)true));
            actCtx.setCurrentClientInteraction(ci);
            if (s_disableEndpointReporting && !s_enhancedStepReportingModeEnabled && (failureMessage = this.getLGFailureMessage(xqMsg, true)) != null) {
                try {
                    xqMsg.setStringHeader(ACTIONAL_FAILURE_HEADER, failureMessage);
                }
                catch (XQMessageException e) {
                    // empty catch block
                }
                ci.setFailure(failureMessage);
            }
            if (s_isTracing) {
                this.traceInteraction("sendToJMS", (Interaction)ci);
            }
            ci.requestAnalyzed();
            if (si != null) {
                si.end();
            }
        }
        catch (Exception e) {
            log.logWarning((Throwable)e);
        }
    }

    public void receivedFromEndpointLegacy(Map params) {
        if (s_disableEndpointReporting) {
            return;
        }
        this.traceParameters("receivedFromEndpoint", params);
        javax.jms.Message msg = (javax.jms.Message)params.get("ESBVisitor.PARAM_MESSAGE");
        String endpointName = null;
        JMSEndpointCfg endpointCfg = (JMSEndpointCfg)params.get("ESBVisitor.PARAM_JMS_ENDPOINT_CFG");
        XQMessage xqMsg = (XQMessage)params.get("ESBVisitor.PARAM_XQ_MESSAGE");
        ActionalRuntimeContext actCtx = this.getActionalRuntimeContext(xqMsg);
        endpointName = endpointCfg != null ? this.formatServiceName(actCtx, endpointCfg.getConfig().getName()) : this.formatServiceName(actCtx, (String)params.get("ESBVisitor.PARAM_ENDPOINT_NAME"));
        ServerInteraction si = null;
        try {
            si = ServerInteraction.begin();
            this.setCorrelationHeader(si, actCtx);
            si.setPeerAddr(ActionalVisitor.getLocalHostName());
            String operation = msg == null ? ENDPOINT_NGSO_SEND_OP : ENDPOINT_NGSO_RECEIVE_OP;
            this.setInteractionAttributes((Interaction)si, xqMsg, NGSO_GROUP_ENDPOINT, endpointName, operation, false);
            this.setPayload((Interaction)si, xqMsg);
            this.setMessageFields((Interaction)si, params);
            String failureMessage = this.getLGFailureMessage(xqMsg, true);
            if (failureMessage != null) {
                si.setFailure(failureMessage);
            }
            if (s_isTracing) {
                this.traceInteraction("receivedFromEndpoint", (Interaction)si);
            }
            si.setOneWay(true);
            this.createActionalContextIfNull(xqMsg, actCtx).setParentServerInteractionStub(si.split());
            if (si != null) {
                si.end();
            }
        }
        catch (Exception e) {
            log.logWarning((Throwable)e);
        }
    }

    public void receivedFromEndpoint(Map params) {
        if (!s_disableEndpointReporting) {
            this.receivedFromEndpointLegacy(params);
            return;
        }
    }

    private void setCorrelationHeader(ServerInteraction si, ActionalRuntimeContext actCtx) {
        if (actCtx != null && actCtx.getActionalManifest() != null) {
            try {
                InterHelpBase.readHeader((String)actCtx.getActionalManifest(), (ServerInteraction)si);
            }
            catch (Exception e) {
                log.logWarning((Throwable)e);
                return;
            }
        }
    }

    private void getCorrelationHeader(ClientInteraction ci, ActionalRuntimeContext actCtx, XQMessage xqMessage) {
        try {
            actCtx = this.createActionalContextIfNull(xqMessage, actCtx);
            String correlationHeader = InterHelpBase.writeHeader((ClientInteraction)ci, (boolean)true);
            actCtx.setActionalManifest(correlationHeader);
        }
        catch (Exception e) {
            log.logWarning((Throwable)e);
        }
    }

    public void sentToEndpoint(Map params) {
        if (!s_disableEndpointReporting) {
            this.sentToEndpointLegacy(params);
            return;
        }
    }

    public void sentToEndpointLegacy(Map params) {
        if (s_disableEndpointReporting) {
            return;
        }
        this.traceParameters("sentToEndpoint", params);
        javax.jms.Message msg = (javax.jms.Message)params.get("ESBVisitor.PARAM_MESSAGE");
        String endpointName = null;
        JMSEndpointCfg endpointCfg = (JMSEndpointCfg)params.get("ESBVisitor.PARAM_JMS_ENDPOINT_CFG");
        XQMessage xqMsg = (XQMessage)params.get("ESBVisitor.PARAM_XQ_MESSAGE");
        ActionalRuntimeContext actCtx = this.getActionalRuntimeContext(xqMsg);
        endpointName = endpointCfg != null ? this.formatServiceName(actCtx, endpointCfg.getConfig().getName()) : this.formatServiceName(actCtx, (String)params.get("ESBVisitor.PARAM_ENDPOINT_NAME"));
        if (endpointName == null) {
            log.logDebug("sentToEndpoint: No endpoint name supplied, ignoring.");
            return;
        }
        ServerInteraction si = null;
        ClientInteraction ci = null;
        try {
            si = this.createServerInteraction(actCtx);
            ci = ClientInteraction.begin();
            String operation = msg == null ? ENDPOINT_NGSO_SEND_OP : ENDPOINT_NGSO_RECEIVE_OP;
            this.setInteractionAttributes((Interaction)ci, xqMsg, NGSO_GROUP_ENDPOINT, endpointName, operation, false);
            ci.setPeerAddr(ActionalVisitor.getLocalHostName());
            this.getCorrelationHeader(ci, actCtx, xqMsg);
            this.setPayload((Interaction)ci, xqMsg);
            this.setMessageFields((Interaction)ci, params);
            String failureMessage = this.getLGFailureMessage(xqMsg, false);
            if (failureMessage != null) {
                ci.setFailure(failureMessage);
            }
            if (s_isTracing) {
                this.traceInteraction("sentToEndpoint", (Interaction)ci);
            }
            ci.end();
            if (si != null) {
                si.end();
            }
        }
        catch (Exception e) {
            log.logWarning((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedByStep(Map params) {
        String serviceName;
        this.traceParameters("receivedByStep", params);
        XQMessage xqMessage = (XQMessage)params.get("ESBVisitor.PARAM_XQ_MESSAGE");
        ActionalRuntimeContext actCtx = this.getActionalRuntimeContext(xqMessage);
        if (params.remove("End SI") != null) {
            if (actCtx != null && actCtx.getCurrentServerInteraction() != null) {
                this.endStepServerInteraction(actCtx.getCurrentServerInteraction(), actCtx);
            }
            return;
        }
        XQParameters xqParams = (XQParameters)params.get("ESBVisitor.PARAM_XQ_PARAMETERS");
        String processName = (String)params.get("ESBVisitor.PARAM_PROCESS_NAME");
        if (processName == null) {
            processName = xqParams.getParameter("SonicXQ.ProcessName", 1);
        }
        this.getCorrelationHeaderFromMsg(xqMessage, actCtx);
        String stepName = (String)params.get("ESBVisitor.PARAM_STEP_NAME");
        if (stepName == null) {
            stepName = xqParams.getParameter("SonicXQ.ProcessStep", 1);
        }
        if ((serviceName = (String)params.get("ESBVisitor.PARAM_SERVICE_NAME")) == null && (serviceName = xqParams.getParameter("SonicXQ.ServiceName", 1)) == null) {
            log.logDebug("No service name supplied to receivedByStep");
            serviceName = "NotSpecified";
        }
        actCtx = this.createActionalContextIfNull(xqMessage, actCtx);
        String ngsoGroup = this.formatServiceName(actCtx, serviceName);
        String ngsoService = (String)params.get("ESBVisitor.PARAM_NGSO_SERVICE");
        String ngsoOperation = null;
        if (ngsoService == null) {
            if (processName == null) {
                String serviceType = xqParams.getParameter("SonicXQ.ServiceType", 1);
                ngsoService = serviceType.equals("BPEType") ? PROCESS_ENTRY : STANDALONE_SERVICE;
            } else {
                ngsoService = processName;
                ngsoOperation = stepName;
            }
        }
        ServerInteraction si = null;
        try {
            boolean receivedFromJms = actCtx.getReceivedFromJms();
            actCtx.setReceivedFromJms(false);
            if (receivedFromJms) {
                si = actCtx.getCurrentServerInteraction();
                actCtx.setCurrentServerInteraction(null);
            } else {
                si = ServerInteraction.begin();
                si.setPeerAddr(ActionalVisitor.getLocalHostName());
                this.setCorrelationHeader(si, actCtx);
            }
            this.setInteractionAttributes((Interaction)si, xqMessage, ngsoGroup, ngsoService, ngsoOperation, processName != null);
            if (!receivedFromJms) {
                this.setPayload((Interaction)si, xqMessage);
            }
            this.setMessageFields((Interaction)si, params);
            si.setOneWay(true);
            String failure = null;
            try {
                failure = (String)xqMessage.removeHeader(ACTIONAL_FAILURE_HEADER);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (failure == null && ngsoOperation != null && ngsoOperation.equals(FAULT_OP)) {
                failure = "Message has Faulted.";
            } else if (failure == null && ngsoOperation != null && ngsoOperation.equals(REJECT_OP)) {
                failure = "Message has RMEd.";
            }
            if (failure != null) {
                si.setFailure(failure);
            }
            try {
                boolean trusted = s_disableTrustEnforcement || !receivedFromJms || InterHelpTrust.checkTrust((ServerInteraction)si);
                actCtx.setTrustVerificationStatus(trusted);
                actCtx.setTrustCheckPerformed(!s_disableTrustEnforcement);
            }
            catch (Throwable throwable) {
                actCtx.setTrustCheckPerformed(!s_disableTrustEnforcement);
                throw throwable;
            }
            if (s_isTracing) {
                this.traceInteraction("receivedByStep", (Interaction)si);
            }
            if (params.remove("Actional.EndSI") != null) {
                this.endStepServerInteraction(si, actCtx);
            } else {
                actCtx.setCurrentServerInteraction(si);
                si.requestAnalyzed();
                actCtx.setParentServerInteractionStub(si.split());
            }
            ActionalVisitor.setCurrentVisitorContext(actCtx);
        }
        catch (Exception e) {
            log.logWarning((Throwable)e);
        }
    }

    private void endStepServerInteraction(ServerInteraction si, ActionalRuntimeContext actCtx) {
        try {
            SiteStub siStub = si.split();
            actCtx.setParentServerInteractionStub(siStub);
            if (si != null) {
                si.end();
            }
        }
        catch (Exception e) {
            log.logWarning((Throwable)e);
        }
    }

    public void sentToIntracontainer(Map params) {
    }

    public void receivedFromIntracontainer(Map params) {
    }

    public void sentToStep(Map params) {
        this.traceParameters("sentToStep", params);
        XQMessage xqMessage = (XQMessage)params.get("ESBVisitor.PARAM_XQ_MESSAGE");
        ActionalRuntimeContext actCtx = this.getActionalRuntimeContext(xqMessage);
        if (actCtx != null && actCtx.getReceivedFromJms()) {
            return;
        }
        String processName = (String)params.get("ESBVisitor.PARAM_PROCESS_NAME");
        XQParameters xqParams = (XQParameters)params.get("ESBVisitor.PARAM_XQ_PARAMETERS");
        String serviceName = (String)params.get("ESBVisitor.PARAM_SERVICE_NAME");
        if (serviceName == null) {
            serviceName = xqParams.getParameter("SonicXQ.ServiceName", 1);
        }
        if (serviceName == null) {
            serviceName = "Internal";
        }
        serviceName = this.formatServiceName(actCtx, serviceName);
        String stepName = (String)params.get("ESBVisitor.PARAM_STEP_NAME");
        if (stepName == null) {
            stepName = xqParams.getParameter("SonicXQ.ProcessStep", 1);
        }
        String ngsoGroup = serviceName;
        String ngsoService = null;
        String ngsoOperation = null;
        if (processName == null) {
            String serviceType = xqParams.getParameter("SonicXQ.ServiceType", 1);
            ngsoService = serviceType.equals("BPEType") ? PROCESS_ENTRY : STANDALONE_SERVICE;
        } else {
            ngsoService = processName;
            ngsoOperation = stepName;
        }
        ServerInteraction si = null;
        ClientInteraction ci = null;
        try {
            si = this.createServerInteraction(actCtx);
            ci = ClientInteraction.begin();
            ci.setPeerAddr(ActionalVisitor.getLocalHostName());
            this.setInteractionAttributes((Interaction)ci, xqMessage, ngsoGroup, ngsoService, ngsoOperation, processName != null);
            this.setPayload((Interaction)ci, xqMessage);
            this.setMessageFields((Interaction)ci, params);
            if (s_isTracing) {
                this.traceInteraction("sentToStep", (Interaction)ci);
            }
            this.getCorrelationHeader(ci, actCtx, xqMessage);
            this.setCorrelationInMessage(xqMessage, actCtx);
            ci.setOneWay(true);
            ci.end();
            if (si != null) {
                si.end();
            }
        }
        catch (Exception e) {
            log.logWarning((Throwable)e);
        }
    }

    public void sentToWebService(Map params) {
        this.traceParameters("sentToWebService", params);
        XQMessage xqMessage = (XQMessage)params.get("ESBVisitor.PARAM_XQ_MESSAGE");
        ESBWSCommand scriptCmd = (ESBWSCommand)params.get("ESBVisitor.PARAM_ESBWS_COMMAND");
        Boolean isRequestResponse = (Boolean)params.get("ESBVisitor.PARAM_IS_REQUEST_RESPONSE");
        boolean isFaultRequest = false;
        if (scriptCmd.getCommandType() == 3) {
            return;
        }
        if (scriptCmd.getCommandType() == 2) {
            ((XQMessageInternal)xqMessage).addSidebandProperty("SonicESB.LG_REPORT_FAILURE", "Fault ESBWS generated fault");
            isFaultRequest = true;
        }
        ESBWSSoapInfo soapInfo = scriptCmd.getSOAPInfo();
        String url = null;
        if (soapInfo != null) {
            url = soapInfo.getEndpointURL();
        }
        if (url == null) {
            return;
        }
        if ((scriptCmd.getCommandType() == 2 || scriptCmd.getCommandType() == 1) && url.equals("http://www.sonicsw.com/esb/replyto-destination-required")) {
            return;
        }
        ActionalRuntimeContext actCtx = this.getActionalRuntimeContext(xqMessage);
        ServerInteraction si = this.createServerInteraction(actCtx);
        ClientInteraction ci = ClientInteraction.begin();
        ci.setUrl(url);
        ci.setOneWay(isRequestResponse == false);
        ActionalVisitor.trace("Setting oneway flag in client interaction to: " + (isRequestResponse == false));
        String peerAddr = null;
        try {
            URL u = new URL(url);
            peerAddr = u.getHost();
        }
        catch (Exception e) {
            peerAddr = url;
        }
        if (peerAddr == null || NGSO_NO_OPERATION.equals(peerAddr.trim())) {
            peerAddr = ActionalVisitor.getLocalHostName();
        }
        ci.setPeerAddr(peerAddr);
        ci.setOpName(scriptCmd.getOperationName());
        if (isFaultRequest) {
            ci.setFailure(this.getLGFailureMessage(xqMessage, true));
        }
        this.setPayload((Interaction)ci, xqMessage);
        if (s_isTracing) {
            this.traceInteraction("callWebService", (Interaction)ci);
        }
        this.getCorrelationHeader(ci, actCtx, xqMessage);
        ci.requestAnalyzed();
        actCtx.setCurrentClientInteraction(ci);
        if (si != null) {
            si.end();
        }
        if (actCtx.getActionalManifest() != null) {
            params.put(LG_HEADER_PROPERTY, actCtx.getActionalManifest());
        }
    }

    public void receivedFromWebService(Map params) {
        this.traceParameters("receivedFromWebService", params);
        ClientInteraction ci = null;
        ActionalRuntimeContext actCtx = (ActionalRuntimeContext)params.get("ESBVisitor.PARAM_RUNTIME_CONTEXT");
        if (actCtx != null) {
            ci = actCtx.getCurrentClientInteraction();
        }
        if (ci == null) {
            return;
        }
        try {
            ESBWSCommand scriptCmd = (ESBWSCommand)params.get("ESBVisitor.PARAM_ESBWS_COMMAND");
            ESBWSSoapInfo soapInfo = scriptCmd.getSOAPInfo();
            if (soapInfo != null && soapInfo.getEndpointURL() != null) {
                XQMessage xqMessage;
                String faultResponse = (String)params.get("ESBVisitor.PARAM_WS_FAULT_RESPONSE");
                if (faultResponse != null) {
                    ci.setFailure(faultResponse);
                }
                if ((xqMessage = (XQMessage)params.get("ESBVisitor.PARAM_XQ_MESSAGE")) != null) {
                    this.setPayload((Interaction)ci, xqMessage);
                }
            }
            if (s_isTracing) {
                this.traceInteraction("receivedFromWebService", (Interaction)ci);
            }
            if (ci != null) {
                ci.end();
            }
        }
        catch (Exception e) {
            log.logWarning((Throwable)e);
        }
    }

    public void beforeDispatch(Map params) {
        ActionalContextStack contextStack = (ActionalContextStack)s_runContext.get();
        int stackDepth = contextStack.getStackDepth();
        contextStack.newSubFlowStarted();
        XQMessageInternal xqMessage = (XQMessageInternal)params.get("ESBVisitor.PARAM_XQ_MESSAGE");
        if (xqMessage != null) {
            ESBVisitorContext visitorContext = contextStack.getTopContext();
            if (visitorContext != null) {
                xqMessage.addSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT", visitorContext.clone());
                ActionalVisitor.trace("Setting visitor context in dispatched message. Actional context stack depth: " + stackDepth);
            }
            params.put("Current-Stack-Depth", new Integer(stackDepth));
        }
    }

    public void afterDispatch(Map params) {
        ActionalContextStack contextStack = (ActionalContextStack)s_runContext.get();
        Integer stackDepthInteger = (Integer)params.get("Current-Stack-Depth");
        if (stackDepthInteger != null) {
            int stackDepth = stackDepthInteger;
            contextStack.delete(stackDepth);
        }
    }

    public void end(Map params) {
        this.traceParameters("end", params);
        ServerInteraction si = ServerInteraction.get();
        if (s_isTracing) {
            this.traceInteraction("end", (Interaction)si);
        }
        if (si != null) {
            si.end();
        }
        ActionalContextStack contextStack = (ActionalContextStack)s_runContext.get();
        contextStack.clearAll();
    }

    private void setMessageFields(Interaction interaction, Map params) {
        XQParameters xqParams;
        XQAddress faultAddress;
        interaction.setMsgField(MSGFIELD_ESB_CONTAINER, XQContainer.getXQContainerName(), true);
        XQAddress rejAddress = (XQAddress)params.get("ESBVisitor.PARAM_REJECT_ADDRESS");
        if (rejAddress != null) {
            interaction.setMsgField(MSGFIELD_ESB_REJECT_ADDRESS, rejAddress.toString(), true);
        }
        if ((faultAddress = (XQAddress)params.get("ESBVisitor.PARAM_FAULT_ADDRESS")) != null) {
            interaction.setMsgField(MSGFIELD_ESB_FAULT_ADDRESS, faultAddress.toString(), true);
            XQMessage xqMsg = (XQMessage)params.get("ESBVisitor.PARAM_XQ_MESSAGE");
            this.setFaultMessageFields(interaction, xqMsg);
        }
        if ((xqParams = (XQParameters)params.get("ESBVisitor.PARAM_XQ_PARAMETERS")) != null) {
            String processName = xqParams.getParameter("SonicXQ.ProcessName", 1);
            interaction.setMsgField("ESB-Process", processName, true);
            String serviceName = (String)params.get("ESBVisitor.PARAM_SERVICE_NAME");
            if (serviceName != null) {
                interaction.setMsgField("ESB-Service", serviceName, true);
            }
            String topName = xqParams.getParameter("SonicXQ.TopLevelProcessName", 1);
            interaction.setMsgField(MSGFIELD_ESB_TOP_PROCESS_NAME, topName, true);
        }
        if (log.isDebugLoggingEnabled()) {
            Map fields = interaction._getMsgFieldValues();
            log.logDebug("Message fields: " + (fields == null ? "<none>" : fields.toString()));
        }
    }

    private void setFaultMessageFields(Interaction interaction, XQMessage xqMsg) {
        try {
            if (xqMsg.containsHeader("SonicESB.Fault.Name")) {
                interaction.setMsgField(MSGFIELD_ESB_FAULT_NAME, xqMsg.getStringHeader("SonicESB.Fault.Name"), true);
            }
            if (xqMsg.containsHeader("SonicESB.Fault.String")) {
                interaction.setMsgField(MSGFIELD_ESB_FAULT_STRING, xqMsg.getStringHeader("SonicESB.Fault.String"), true);
            }
            if (xqMsg.containsHeader("SonicESB.Fault.Code")) {
                interaction.setMsgField(MSGFIELD_ESB_FAULT_CODE, xqMsg.getStringHeader("SonicESB.Fault.Code"), true);
            }
            if (xqMsg.containsHeader("SonicESB.Fault.SubCode")) {
                interaction.setMsgField(MSGFIELD_ESB_FAULT_SUBCODE, xqMsg.getStringHeader("SonicESB.Fault.SubCode"), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setPayload(Interaction interaction, javax.jms.Message msg, boolean failure) {
        if (s_enableLegacyPayloadReportingMode) {
            this.setLegacyPayload(interaction, msg, failure);
            return;
        }
        if (msg == null) {
            return;
        }
        try {
            Envelope env = ((Message)msg).getEnvelope();
            interaction.setSize((long)env.getMgram().networkLength());
        }
        catch (Throwable e) {
            log.logDebug("Error while setting payload size" + e.getMessage());
            log.logDebug(e);
        }
        if (!this.m_capturePayload) {
            return;
        }
        try {
            if (msg instanceof MultipartMessage) {
                this.applyParts(interaction, (MultipartMessage)msg);
            } else if (msg instanceof XMLMessage) {
                this.applyPart(interaction, new ActionalMQXMLMessagePart((XMLMessage)msg));
            } else if (msg instanceof TextMessage) {
                this.applyPart(interaction, new ActionalMQTextMessagePart((TextMessage)msg));
            }
        }
        catch (Throwable e) {
            log.logDebug("Error while setting payload " + e.getMessage());
            log.logDebug(e);
        }
    }

    private void setLegacyPayload(Interaction interaction, javax.jms.Message msg, boolean failure) {
        if (!this.m_capturePayload) {
            return;
        }
        if (msg == null) {
            return;
        }
        String content = null;
        try {
            if (msg instanceof MultipartMessage) {
                int partCount = ((MultipartMessage)msg).getPartCount();
                if (partCount == 0) {
                    return;
                }
                Part part0 = ((MultipartMessage)msg).getPart(0);
                String contentType0 = part0.getHeader().getHeaderField("Content-Type");
                if (!ActionalVisitor.isPayloadCaptureEnabledForMime(contentType0)) {
                    return;
                }
                content = (String)part0.getContent();
            } else if (msg instanceof XMLMessage) {
                content = ((XMLMessage)msg).getText();
            } else if (msg instanceof TextMessage) {
                String contentType = msg.getStringProperty("Content-Type");
                if (!ActionalVisitor.isPayloadCaptureEnabledForMime(contentType)) {
                    return;
                }
                content = ((TextMessage)msg).getText();
            } else {
                return;
            }
            byte[] contentAsBytes = content.getBytes("UTF-8");
            interaction.setPayload(contentAsBytes);
        }
        catch (Throwable e) {
            log.logDebug("Error while setting payload " + e.getMessage());
            log.logDebug(e);
        }
    }

    private void applyParts(Interaction interaction, MultipartMessage m) throws JMSException, XQMessageException, UnsupportedEncodingException {
        ArrayList<ActionalBasePart> aparts = this.mqToActionalCaptureEnabledParts(m);
        for (ActionalBasePart part : aparts) {
            this.applyPart(interaction, part);
        }
    }

    private void applyParts(Interaction interaction, XQMessage m) throws XQMessageException, JMSException, UnsupportedEncodingException {
        ArrayList<ActionalBasePart> aparts = this.xqToActionalCaptureEnabledParts(m);
        for (ActionalBasePart part : aparts) {
            this.applyPart(interaction, part);
        }
    }

    private void applyPart(Interaction interaction, ActionalBasePart part) {
        if (interaction instanceof ServerInteraction) {
            ServerInteraction si = (ServerInteraction)interaction;
            if (!si.getOneWay() && si.getIsReply()) {
                si.addReplyPart((com.actional.lg.interceptor.sdk.Part)part);
            } else {
                si.addRequestPart((com.actional.lg.interceptor.sdk.Part)part);
            }
        } else if (interaction instanceof ClientInteraction) {
            ClientInteraction ci = (ClientInteraction)interaction;
            if (!ci.getOneWay() && ci.getIsReply()) {
                ci.addReplyPart((com.actional.lg.interceptor.sdk.Part)part);
            } else {
                ci.addRequestPart((com.actional.lg.interceptor.sdk.Part)part);
            }
        }
    }

    private ArrayList<ActionalBasePart> xqToActionalCaptureEnabledParts(XQMessage m) throws XQMessageException, JMSException, UnsupportedEncodingException {
        ArrayList<ActionalBasePart> al = new ArrayList<ActionalBasePart>();
        for (int p = 0; p < m.getPartCount(); ++p) {
            if (ActionalVisitor.isInternalSystemPart(m.getPart(p).getContentType())) continue;
            ActionalXQPart part = new ActionalXQPart(m.getPart(p));
            al.add(part);
            part.setIndexMetaData(al.size() - 1);
        }
        return al;
    }

    private ArrayList<ActionalBasePart> mqToActionalCaptureEnabledParts(MultipartMessage m) throws JMSException {
        ArrayList<ActionalBasePart> al = new ArrayList<ActionalBasePart>();
        for (int p = 0; p < m.getPartCount(); ++p) {
            if (ActionalVisitor.isInternalSystemPart(m.getPart(p).getHeader().getContentType())) continue;
            ActionalMQPart part = new ActionalMQPart(m.getPart(p));
            al.add(part);
            part.setIndexMetaData(al.size() - 1);
        }
        return al;
    }

    private void setPayload(Interaction interaction, XQMessage message) {
        if (s_enableLegacyPayloadReportingMode) {
            this.setLegacyPayload(interaction, message);
            return;
        }
        if (!this.m_capturePayload) {
            return;
        }
        if (message == null) {
            return;
        }
        try {
            this.applyParts(interaction, message);
        }
        catch (Throwable e) {
            log.logDebug("Error while setting payload " + e.getMessage());
            log.logDebug(e);
        }
    }

    private void setLegacyPayload(Interaction interaction, XQMessage message) {
        if (!this.m_capturePayload) {
            return;
        }
        if (message == null) {
            return;
        }
        XQPart part = null;
        try {
            if (message.getPartCount() > 0) {
                part = message.getPart(0);
            }
            if (part == null) {
                return;
            }
            String contentType = part.getContentType();
            if (!ActionalVisitor.isPayloadCaptureEnabledForMime(contentType)) {
                return;
            }
            Object partContent = part.getContent();
            String strContents = null;
            if (partContent instanceof String) {
                strContents = (String)partContent;
            } else if (partContent instanceof TextMessage) {
                strContents = ((TextMessage)partContent).getText();
            }
            if (strContents != null) {
                byte[] contentAsBytes = strContents.getBytes("UTF-8");
                interaction.setPayload(contentAsBytes);
            }
        }
        catch (Throwable e) {
            log.logDebug("Error while setting payload " + e.getMessage());
            log.logDebug(e);
        }
    }

    private static boolean isPayloadCaptureEnabledForMime(String docType) {
        boolean captureSuccessful = false;
        if (docType != null) {
            boolean bl = captureSuccessful = docType.regionMatches(true, 0, "text/xml", 0, 8) || docType.regionMatches(true, 0, "application/xml", 0, 15);
            if (!captureSuccessful && s_payloadCaptureMimes != null) {
                for (int i = 0; i < s_payloadCaptureMimes.length && !captureSuccessful; ++i) {
                    captureSuccessful = docType.regionMatches(true, 0, s_payloadCaptureMimes[i], 0, s_payloadCaptureMimes[i].length());
                }
            }
        }
        return captureSuccessful;
    }

    private static boolean isInternalSystemPart(String docType) {
        return docType != null && docType.startsWith("application/x-sonicxq");
    }

    private void traceParameters(String opName, Map params) {
        if (!s_isTracing) {
            return;
        }
        Iterator iter = params.keySet().iterator();
        ActionalVisitor.trace("Operation: " + opName);
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object val = params.get(key);
            if (val == null) {
                val = "(null)";
            }
            ActionalVisitor.trace("   param=" + key + "=" + val.toString());
        }
    }

    private void traceInteraction(String interactionName, Interaction interaction) {
        String intType = NGSO_NO_OPERATION;
        String intID = NGSO_NO_OPERATION;
        if (interaction != null) {
            intType = interaction instanceof ServerInteraction ? "SI" : "CI";
            intID = interaction.getInteractionID();
        }
        StringBuilder msgBuffer = new StringBuilder();
        msgBuffer.append(interactionName).append(" ").append(intType).append("(").append(intID).append(") on thread: ").append(Thread.currentThread().getName());
        if (interaction != null) {
            msgBuffer.append(" ==>");
            msgBuffer.append(" PeerAddr: [ " + interaction.getPeerAddr());
            msgBuffer.append(" ] URL: [ " + interaction.getUrl());
            msgBuffer.append(" ] Type: [ " + interaction.getSvcType());
            msgBuffer.append(" ] Flow ID: [ " + interaction.getFlowID());
            msgBuffer.append(" ] Op ID: [ " + interaction.getOpID());
            msgBuffer.append(" ] Locus ID: [ " + interaction.getParentID());
            msgBuffer.append(" ] Chain ID: [ " + interaction.getChainID());
            msgBuffer.append(" ] OneWay: [ " + interaction.getOneWay());
            msgBuffer.append(" ] isFault: [ " + (interaction.getFailure() != null));
            msgBuffer.append(" ] G: " + interaction.getGroupName());
            msgBuffer.append(" S: " + interaction.getServiceName());
            msgBuffer.append(" O: " + interaction.getOpName());
            msgBuffer.append(" ST: " + interaction.getSvcType());
            msgBuffer.append(" AT: " + interaction.getAppType());
            msgBuffer.append(" OT: " + interaction.getOpType());
        }
        ActionalVisitor.trace(msgBuffer.toString());
    }

    static void trace(String msg) {
        if (s_isTracing) {
            log.logInformation(msg);
        } else if (log.isDebugLoggingEnabled()) {
            log.logDebug(msg);
        }
    }

    private void setJMSInteractionAttributes(Interaction interaction, javax.jms.Message msg, String replyToDestination, JMSEndpointCfg endpointCfg, String brokerURL, String brokerHost, String opName, ActionalRuntimeContext actCtx, boolean isOneway, boolean failure) {
        String jmsDestination = this.getDestinationURL(actCtx, brokerURL, endpointCfg, replyToDestination);
        String peerAddress = brokerHost;
        if (s_displayUnmanagedNodesForJMS) {
            peerAddress = jmsDestination;
            String jmsDestType = endpointCfg.getType();
            if (jmsDestType.equals("QUEUE")) {
                interaction.setPeerType((short)-256);
            } else if (jmsDestType.equals("TOPIC")) {
                interaction.setPeerType((short)-250);
            }
        }
        if (interaction instanceof ServerInteraction) {
            interaction.setPeerAddr(null);
            try {
                InterHelpJms.extractProducerPeerAddress((javax.jms.Message)msg, (ServerInteraction)((ServerInteraction)interaction));
            }
            catch (Exception e) {
                ActionalVisitor.trace("Error while extracting producer peer address");
            }
            if (interaction.getPeerAddr() == null) {
                interaction.setPeerAddr(peerAddress);
            }
            this.readReplyToNGSO(actCtx, msg, jmsDestination);
        } else if (interaction instanceof ClientInteraction) {
            interaction.setPeerAddr(peerAddress);
            if (s_displayUnmanagedNodesForJMS) {
                try {
                    InterHelpJms.writeProducerPeerAddress((javax.jms.Message)msg, (String)peerAddress);
                }
                catch (Exception e) {
                    ActionalVisitor.trace("Error while populating producer peer address in the message");
                }
            }
            this.setReplyToNGSO(actCtx, msg);
        }
        ActionalVisitor.trace((interaction instanceof ServerInteraction ? "Server" : "Client") + " Interaction --> " + interaction.getPeerAddr());
        if (!s_disableEndpointReporting) {
            String serviceName = this.getDestinationURL(actCtx, null, endpointCfg, replyToDestination);
            String url = "/ESB-JMSEndpoint/" + serviceName.replace('.', '-');
            interaction.setUrl(url);
            interaction.setGroupName(NGSO_GROUP_ENDPOINT);
            interaction.setServiceName(serviceName);
            if (opName != null) {
                interaction.setOpName(opName);
            }
        } else {
            String url = "/JMS-Destination/" + jmsDestination.replace('.', '-');
            interaction.setUrl(url);
        }
        interaction.setOneWay(isOneway);
        this.setPayload(interaction, msg, failure);
    }

    private void setFaultRMEInteractionAttributes(Interaction interaction, ActionalRuntimeContext actCtx, XQMessage xqMsg, String outputCategory) {
        boolean typeAsProcess = true;
        String grpName = outputCategory + "Step";
        String svcName = null;
        String opName = null;
        SiteStub parent = actCtx.getParentServerInteractionStub();
        if (parent.getSvcType() == GeneralUtil.DISPLAY_TYPE_PROCESS.shortValue()) {
            svcName = parent.getServiceName();
            opName = "(" + outputCategory + ")";
        } else if (parent.getSvcType() == GeneralUtil.DISPLAY_TYPE_ESB_SERVICE.shortValue()) {
            svcName = STANDALONE_SERVICE;
            opName = "(" + outputCategory + ")";
        }
        this.setInteractionAttributes(interaction, xqMsg, grpName, svcName, opName, typeAsProcess);
    }

    private void readReplyToNGSO(ActionalRuntimeContext actCtx, javax.jms.Message message, String endpointName) {
        if (!s_useReplyToNGSO || actCtx == null) {
            return;
        }
        String replyToNGSO = actCtx.getReplyToNGSO();
        if (replyToNGSO == null) {
            try {
                replyToNGSO = message.getStringProperty(REPLYTO_NGSO_HEADER);
                if (replyToNGSO == null && ActionalVisitor.isReplyToTemp(message)) {
                    replyToNGSO = endpointName;
                }
            }
            catch (JMSException e) {
                // empty catch block
            }
            actCtx.setReplyToNGSO(replyToNGSO);
        }
    }

    private void setReplyToNGSO(ActionalRuntimeContext actCtx, javax.jms.Message message) {
        if (!s_useReplyToNGSO || actCtx == null) {
            return;
        }
        String replyToNGSO = actCtx.getReplyToNGSO();
        if (replyToNGSO != null) {
            try {
                message.setStringProperty(REPLYTO_NGSO_HEADER, replyToNGSO);
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
    }

    private void setInteractionAttributes(Interaction interaction, XQMessage msg, String groupName, String serviceName, String opName, boolean isProcess) {
        ActionalVisitor.setInteractionAttributes(interaction, groupName, serviceName, opName, isProcess);
    }

    private static void setInteractionAttributes(Interaction interaction, String groupName, String serviceName, String opName, boolean isProcess) {
        String url = "/" + groupName + "/" + serviceName.replace('.', '-');
        interaction.setUrl(url.replace(' ', '-'));
        interaction.setGroupName(groupName);
        interaction.setServiceName(serviceName);
        if (opName != null && !NGSO_NO_OPERATION.equals(opName)) {
            interaction.setOpName(opName);
        }
        interaction.setSubnode(SUB_NODE_STR);
        if (groupName.equals(NGSO_GROUP_ENDPOINT)) {
            interaction.setSvcType(GeneralUtil.DISPLAY_TYPE_SERVICE.shortValue());
        } else if (isProcess) {
            interaction.setAppType(GeneralUtil.DISPLAY_TYPE_ESB_SERVICE.shortValue());
            interaction.setSvcType(GeneralUtil.DISPLAY_TYPE_PROCESS.shortValue());
            interaction.setOpType(GeneralUtil.DISPLAY_TYPE_STEP.shortValue());
        } else {
            interaction.setAppType(GeneralUtil.DISPLAY_TYPE_ESB_SERVICE.shortValue());
            interaction.setSvcType(GeneralUtil.DISPLAY_TYPE_STANDALONE.shortValue());
        }
    }

    private String formatServiceName(ActionalRuntimeContext actCtx, String service) {
        if (ActionalVisitor.isDestinationTemp(service)) {
            String replyToNGSO = null;
            if (actCtx != null) {
                replyToNGSO = actCtx.getReplyToNGSO();
            }
            service = replyToNGSO != null && s_useReplyToNGSO ? replyToNGSO + ".REPLY" : TEMPORARY_DESTINATION;
        }
        return service;
    }

    private static boolean isDestinationTemp(String destination) {
        if (destination != null) {
            return destination.indexOf(HTTPDIRECT_TEMP_DEST_IDENTIFIER) != -1 || destination.indexOf(TEMP_DESTINATION_IDENTIFIER) != -1;
        }
        return false;
    }

    private static boolean isReplyToTemp(javax.jms.Message message) throws JMSException {
        Destination replyToDest = message.getJMSReplyTo();
        return replyToDest != null && ActionalVisitor.isDestinationTemp(replyToDest.toString());
    }

    private static String getLocalHostName() {
        return "localhost";
    }

    private static String normalizeURL(String url) {
        if (url == null || url.length() == 0) {
            return null;
        }
        if (url.indexOf("://") == -1) {
            url = "tcp://" + url;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private String getDestinationURL(ActionalRuntimeContext actCtx, String brokerURL, JMSEndpointCfg endpointCfg, String replyToDestination) {
        String destinationName = replyToDestination;
        if (destinationName == null) {
            destinationName = brokerURL != null ? endpointCfg.getDestinationName() : endpointCfg.getConfig().getName();
        }
        return this.formatServiceName(actCtx, destinationName);
    }

    private void setCorrelationInMessage(XQMessage xqMsg, ActionalRuntimeContext actCtx) {
        try {
            if (actCtx != null && actCtx.getActionalManifest() != null) {
                xqMsg.setStringHeader(LG_HEADER_PROPERTY, actCtx.getActionalManifest());
            }
        }
        catch (XQMessageException e) {
            log.logWarning("Error while setting actional manifest header in the message");
        }
    }

    private void getCorrelationHeaderFromMsg(XQMessage xqMessage, ActionalRuntimeContext actCtx) {
        try {
            String lgCorrelationHeader = xqMessage.getStringHeader(LG_HEADER_PROPERTY);
            if (lgCorrelationHeader != null) {
                log.logDebug("getLGCorrelationHeader=" + lgCorrelationHeader);
                this.createActionalContextIfNull(xqMessage, actCtx).setActionalManifest(lgCorrelationHeader);
            }
        }
        catch (XQMessageException e) {
            log.logWarning((Throwable)e);
        }
    }

    private String getLGFailureMessage(XQMessage message, boolean removeProperty) {
        if (message == null) {
            return null;
        }
        XQMessageInternal xqInternalMsg = (XQMessageInternal)message;
        String failureMessage = null;
        failureMessage = removeProperty ? (String)xqInternalMsg.removeSidebandProperty("SonicESB.LG_REPORT_FAILURE") : (String)xqInternalMsg.getSidebandProperty("SonicESB.LG_REPORT_FAILURE");
        return failureMessage;
    }

    private ActionalRuntimeContext createActionalRuntimeContext(Map params) {
        ActionalRuntimeContext actCtx = (ActionalRuntimeContext)params.get("ESBVisitor.PARAM_RUNTIME_CONTEXT");
        if (actCtx == null) {
            actCtx = new ActionalRuntimeContext();
            params.put("ESBVisitor.PARAM_RUNTIME_CONTEXT", actCtx);
        }
        return actCtx;
    }

    private ActionalRuntimeContext getActionalRuntimeContext(XQMessage xqMsg) {
        ActionalRuntimeContext arc = null;
        if (xqMsg != null) {
            arc = (ActionalRuntimeContext)((XQMessageInternal)xqMsg).getSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT");
        }
        return arc;
    }

    private ActionalRuntimeContext createActionalContextIfNull(XQMessage message, ActionalRuntimeContext actCtx) {
        if (actCtx == null) {
            actCtx = new ActionalRuntimeContext();
            ((XQMessageInternal)message).addSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT", actCtx);
        }
        return actCtx;
    }

    private ServerInteraction createServerInteraction(ActionalRuntimeContext actCtx) {
        if (actCtx != null && actCtx.getParentServerInteractionStub() != null) {
            return ServerInteraction.begin((SiteStub)actCtx.getParentServerInteractionStub());
        }
        return null;
    }

    public static void setCurrentVisitorContext(ESBVisitorContext visitorCtx) {
        ActionalContextStack contextStack = (ActionalContextStack)s_runContext.get();
        contextStack.pushContext(visitorCtx);
    }

    static {
        String s = System.getProperty(DISABLE_ENDPOINT_NGSO);
        if (s != null) {
            s_disableEndpointReporting = Boolean.parseBoolean(s);
        }
        if ((s = System.getProperty(ENABLE_REPLYTO_NGSO)) != null) {
            s_useReplyToNGSO = Boolean.parseBoolean(s);
        }
    }

    private static class ActionalContextStack {
        private Stack contextStack = new Stack();
        private boolean newSubFlowStarted_;

        private ActionalContextStack() {
        }

        private void newSubFlowStarted() {
            this.newSubFlowStarted_ = true;
        }

        public void clearAll() {
            this.contextStack.clear();
        }

        private void pushContext(ESBVisitorContext visitorCtx) {
            if (this.contextStack.size() == 0 || this.newSubFlowStarted_) {
                ActionalVisitor.trace("Pushing context in to Actional context stack. Stack depth before this operation: " + this.contextStack.size());
                this.contextStack.push(visitorCtx);
                if (this.newSubFlowStarted_) {
                    this.newSubFlowStarted_ = false;
                }
            } else {
                ActionalVisitor.trace("Replacing context in Actional context stack. Stack depth before this operation: " + this.contextStack.size());
                this.contextStack.pop();
                this.contextStack.push(visitorCtx);
            }
        }

        private ESBVisitorContext getTopContext() {
            return this.contextStack.size() > 0 ? (ESBVisitorContext)this.contextStack.peek() : null;
        }

        private int getStackDepth() {
            return this.contextStack.size();
        }

        private void delete(int stackDepth) {
            ActionalVisitor.trace("About to prune Actional context stack from : " + this.contextStack.size() + " to: " + stackDepth);
            if (this.contextStack.size() - stackDepth > 0) {
                for (int i = 0; i < this.contextStack.size() - stackDepth; ++i) {
                    this.contextStack.remove(i + stackDepth);
                }
            }
        }
    }
}

