/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container;

import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.adapter.XQMessageAdapter;
import com.sonicsw.xq.adapter.XQMessageListener;
import com.sonicsw.xq.adapter.XQMessageListenerFactory;
import com.sonicsw.xq.adapter.XQNotDeliveredException;
import com.sonicsw.xq.adapter.XQUnavailableException;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.endpoint.container.QOSCallback;
import com.sonicsw.xqimpl.service.IXQMessageListener;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.EndpointConstants;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Document;

public class DispatcherMessageListenerFactory
implements XQMessageListenerFactory {
    private static XQLog log = XQLogImpl.getCategoryLog((int)512);
    private static XQLog systemLog = XQLogImpl.getInstance();
    private IXQMessageListener m_listener;
    private XQMessageAdapter m_messageAdapter;

    public DispatcherMessageListenerFactory(IXQMessageListener listener, XQMessageAdapter messageAdapter) {
        this.m_listener = listener;
        this.m_messageAdapter = messageAdapter;
    }

    public XQMessageListener createListener() throws XQUnavailableException {
        return new DispatcherMessageListener();
    }

    public void destroy() {
    }

    private class DispatcherMessageListener
    implements XQMessageListener {
        private int m_qos;

        DispatcherMessageListener() {
            this.m_qos = EndpointConstants.getQoSAsInt((String)DispatcherMessageListenerFactory.this.m_listener.getQoS());
        }

        public Object onMessage(Object msg, ManagedConnection mc) throws XQNotDeliveredException {
            try {
                if (mc != null) {
                    mc.setLogWriter(systemLog.getPrintWriter());
                }
            }
            catch (ResourceException re) {
                log.logWarning("The ResourceAdapter is failing when setting the log...No ResourceAdapter logging enabled");
                log.logWarning((Throwable)re);
            }
            XQMessage xqMessage = null;
            try {
                xqMessage = DispatcherMessageListenerFactory.this.m_messageAdapter.createMessage(msg);
            }
            catch (XQEndpointException ee) {
                log.logError("Can't convert received message to XQMessage");
                log.logError((Throwable)ee);
                XQNotDeliveredException nde = new XQNotDeliveredException("Can't convert received message to XQMessage");
                nde.setLinkedException((Exception)((Object)ee));
                throw nde;
            }
            QOSCallbackForQuery callback = new QOSCallbackForQuery();
            XQMessageInternal internalMsg = null;
            internalMsg = xqMessage instanceof XQMessageInternal ? (XQMessageInternal)xqMessage : new XQMessageImplWrapper(xqMessage);
            DispatcherMessageListenerFactory.this.m_listener.onMessage(internalMsg, callback);
            if (!(this.m_qos != 1 && this.m_qos != 4 || callback.isAcknowledged())) {
                throw new XQNotDeliveredException("The Message was not processed correctly.  Check the rejected message endpoint for details.");
            }
            return null;
        }

        private class QOSCallbackForQuery
        implements QOSCallback {
            private boolean m_acknowledged;

            private QOSCallbackForQuery() {
            }

            @Override
            public boolean acknowledge() {
                this.m_acknowledged = true;
                return true;
            }

            @Override
            public boolean commit() {
                return true;
            }

            @Override
            public boolean rollback() {
                return true;
            }

            @Override
            public boolean recover() {
                return true;
            }

            boolean isAcknowledged() {
                return this.m_acknowledged;
            }
        }

        private class XQMessageImplWrapper
        implements XQMessageInternal {
            private XQMessage m_msg = null;
            private HashMap<String, Object> m_sidebandProperties = new HashMap();
            private ESBVisitor m_visitor = null;

            XQMessageImplWrapper(XQMessage msg) {
                this.m_msg = msg;
            }

            @Override
            public void setVisitor(ESBVisitor v) {
                this.m_visitor = v;
            }

            @Override
            public ESBVisitor getVisitor() {
                return this.m_visitor;
            }

            public void addPart(XQPart part) throws XQMessageException {
                this.m_msg.addPart(part);
            }

            public void addPartAt(XQPart part, int index) throws XQMessageException {
                this.m_msg.addPartAt(part, index);
            }

            public boolean containsHeader(String name) throws XQMessageException {
                return this.m_msg.containsHeader(name);
            }

            public XQPart createPart() throws XQMessageException {
                return this.m_msg.createPart();
            }

            public XQPart createPart(Object content, String contentType) throws XQMessageException {
                return this.m_msg.createPart(content, contentType);
            }

            public boolean doesPartExist(String cid) {
                return this.m_msg.doesPartExist(cid);
            }

            public boolean equals(Object obj) {
                return this.m_msg.equals(obj);
            }

            public boolean getBooleanHeader(String name) throws XQMessageException {
                return this.m_msg.getBooleanHeader(name);
            }

            public byte getByteHeader(String name) throws XQMessageException {
                return this.m_msg.getByteHeader(name);
            }

            public String getCorrelationId() throws XQMessageException {
                return this.m_msg.getCorrelationId();
            }

            public double getDoubleHeader(String name) throws XQMessageException {
                return this.m_msg.getDoubleHeader(name);
            }

            public float getFloatHeader(String name) throws XQMessageException {
                return this.m_msg.getFloatHeader(name);
            }

            public Iterator<String> getHeaderNames() throws XQMessageException {
                return this.m_msg.getHeaderNames();
            }

            public Object getHeaderValue(String name) throws XQMessageException {
                return this.m_msg.getHeaderValue(name);
            }

            public int getIntHeader(String name) throws XQMessageException {
                return this.m_msg.getIntHeader(name);
            }

            public long getLongHeader(String name) throws XQMessageException {
                return this.m_msg.getLongHeader(name);
            }

            public XQPart getPart(int index) throws XQMessageException {
                return this.m_msg.getPart(index);
            }

            public XQPart getPart(String cid) throws XQMessageException {
                return this.m_msg.getPart(cid);
            }

            public Document getPartAsDocument(int index, boolean validate) throws XQMessageException {
                return this.m_msg.getPartAsDocument(index, validate);
            }

            public Document getPartAsDocument(String cid, boolean validate) throws XQMessageException {
                return this.m_msg.getPartAsDocument(cid, validate);
            }

            public int getPartCount() throws XQMessageException {
                return this.m_msg.getPartCount();
            }

            public XQAddress getReplyTo() throws XQMessageException {
                return this.m_msg.getReplyTo();
            }

            public short getShortHeader(String name) throws XQMessageException {
                return this.m_msg.getShortHeader(name);
            }

            public String getStringHeader(String name) throws XQMessageException {
                return this.m_msg.getStringHeader(name);
            }

            @Override
            public IEndpointRegistry getEndpointRegistry() {
                return null;
            }

            public int hashCode() {
                return this.m_msg.hashCode();
            }

            public void removeAllParts() throws XQMessageException {
                this.m_msg.removeAllParts();
            }

            public Object removeHeader(String name) throws XQMessageException {
                return this.m_msg.removeHeader(name);
            }

            public void removePart(int index) throws XQMessageException {
                this.m_msg.removePart(index);
            }

            public void removePart(String contentID) throws XQMessageException {
                this.m_msg.removePart(contentID);
            }

            public void replacePart(XQPart part, int index) throws XQMessageException {
                this.m_msg.replacePart(part, index);
            }

            public void replacePart(XQPart part, String cid) throws XQMessageException {
                this.m_msg.replacePart(part, cid);
            }

            public void setBooleanHeader(String name, boolean value) throws XQMessageException {
                this.m_msg.setBooleanHeader(name, value);
            }

            public void setByteHeader(String name, byte value) throws XQMessageException {
                this.m_msg.setByteHeader(name, value);
            }

            public void setCorrelationId(String id) throws XQMessageException {
                this.m_msg.setCorrelationId(id);
            }

            public void setDoubleHeader(String name, double value) throws XQMessageException {
                this.m_msg.setDoubleHeader(name, value);
            }

            public void setFloatHeader(String name, float value) throws XQMessageException {
                this.m_msg.setFloatHeader(name, value);
            }

            public void setHeaderValue(String name, Object value) throws XQMessageException {
                this.m_msg.setHeaderValue(name, value);
            }

            public void setHeaderValues(Map<String, Object> headers) throws XQMessageException {
                this.m_msg.setHeaderValues(headers);
            }

            public void setIntHeader(String name, int value) throws XQMessageException {
                this.m_msg.setIntHeader(name, value);
            }

            public void setLongHeader(String name, long value) throws XQMessageException {
                this.m_msg.setLongHeader(name, value);
            }

            public void setPartFromDocument(int index, Document doc) throws XQMessageException {
                this.m_msg.setPartFromDocument(index, doc);
            }

            public void setPartFromDocument(String cid, Document doc) throws XQMessageException {
                this.m_msg.setPartFromDocument(cid, doc);
            }

            public void setReplyTo(XQAddress replyTo) throws XQMessageException {
                this.m_msg.setReplyTo(replyTo);
            }

            public void setShortHeader(String name, short value) throws XQMessageException {
                this.m_msg.setShortHeader(name, value);
            }

            public void setStringHeader(String name, String value) throws XQMessageException {
                this.m_msg.setStringHeader(name, value);
            }

            public String toString() {
                return this.m_msg.toString();
            }

            @Override
            public void setEndpointRegistry(IEndpointRegistry endpointRegistry) {
            }

            @Override
            public void setupSourceEndpoint(IEndpointRegistry mgr) {
            }

            @Override
            public void setupReplyTo(IEndpointRegistry mgr) {
            }

            public Object clone() {
                try {
                    XQMessageImplWrapper wrapper = (XQMessageImplWrapper)super.clone();
                    wrapper.m_msg = (XQMessage)this.m_msg.clone();
                    return wrapper;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public Object protectedClone() {
                try {
                    XQMessageImplWrapper wrapper = (XQMessageImplWrapper)super.clone();
                    wrapper.m_msg = (XQMessage)this.m_msg.clone();
                    return wrapper;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public void addSidebandProperty(String name, Object value) {
                if (this.m_sidebandProperties == null) {
                    this.m_sidebandProperties = new HashMap();
                }
                this.m_sidebandProperties.put(name, value);
            }

            @Override
            public Object removeSidebandProperty(String name) {
                Object property = null;
                if (this.m_sidebandProperties != null) {
                    property = this.m_sidebandProperties.remove(name);
                }
                return property;
            }

            @Override
            public Object getSidebandProperty(String name) {
                if (this.m_sidebandProperties != null) {
                    return this.m_sidebandProperties.get(name);
                }
                return null;
            }

            @Override
            public void setSidebandProperties(HashMap<String, Object> properties) {
                this.m_sidebandProperties = properties;
            }

            @Override
            public HashMap<String, Object> getSidebandProperties() {
                return this.m_sidebandProperties;
            }

            @Override
            public NodeInfo getPartAsNodeInfo(String cid, boolean validate) throws XQMessageException {
                return ((XQMessageInternal)this.m_msg).getPartAsNodeInfo(cid, validate);
            }

            @Override
            public NodeInfo getPartAsNodeInfo(int index, boolean validate) throws XQMessageException {
                return ((XQMessageInternal)this.m_msg).getPartAsNodeInfo(index, validate);
            }
        }
    }
}

