/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.mgmtapi.config.IJMSConnectionConfig;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQRuntimeException;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xq.connector.jms.messagingbean.Session;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointCleaner;
import com.sonicsw.xqimpl.endpoint.container.EndpointContext;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.endpoint.container.EndpointUtils;
import com.sonicsw.xqimpl.endpoint.container.IEndpointCleanerFuture;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.endpoint.container.InvocationEndpointManager;
import com.sonicsw.xqimpl.endpoint.container.QOSCallback;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.service.IXQMessageListener;
import com.sonicsw.xqimpl.service.InvalidStateException;
import com.sonicsw.xqimpl.service.MessageCouldNotBeRejected;
import com.sonicsw.xqimpl.service.RejectedMessageDispatcher;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQDispatcher;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.EndpointConstants;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.Queue;
import javax.jms.Topic;

public class EndpointContextContainer
implements IXQMessageListener {
    private static XQLog log = XQLogImpl.getCategoryLog((int)512);
    private static ThreadLocal<IEndpointRegistry> s_invocationEndpointManager = new ThreadLocal();
    private String m_name;
    private String m_qos;
    private int m_qosInt;
    private String m_entryEndpointConnection;
    private int m_maxRedeliveries;
    private Endpoint m_entryEndpoint;
    private String m_entryEndpointName;
    private boolean m_entryEndpointIsTransient = false;
    private XQDispatcher m_dispatcher;
    private HashMap<String, EndpointContext> m_endpointContexts;
    private HashMap<String, EndpointContext> m_endpointContextTypes;
    private InvocationEndpointManager m_endpointRegistry;

    public EndpointContextContainer(String name, String entryEndpointName, XQDispatcher dispatcher) {
        this.m_name = name;
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": creating context with entry point = " + entryEndpointName);
        }
        this.m_endpointContexts = new HashMap();
        this.m_endpointContextTypes = new HashMap();
        this.m_endpointRegistry = new InvocationEndpointManager();
        this.m_dispatcher = dispatcher;
        this.m_entryEndpointName = entryEndpointName;
    }

    static IEndpointRegistry getInvocationEndpointRegistry() {
        IEndpointRegistry reg = s_invocationEndpointManager.get();
        if (reg == null) {
            return EndpointManager.getInstance();
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(XQMessageInternal msg, QOSCallback callback) {
        if (this.m_dispatcher == null) {
            return;
        }
        XQDispatcher dispatcher = this.m_dispatcher;
        dispatcher.incremementListenerStatistics(this.m_name);
        try {
            if (this.m_entryEndpointIsTransient) {
                this.m_endpointRegistry.registerEndpoint(this.m_entryEndpointName, this.m_entryEndpoint);
            }
            s_invocationEndpointManager.set(this.m_endpointRegistry);
            msg.setupSourceEndpoint(this.m_endpointRegistry);
            msg.setupReplyTo(this.m_endpointRegistry);
            msg.setEndpointRegistry(this.m_endpointRegistry);
            boolean messageDispatched = false;
            int deliveryCount = 1;
            if (this.m_maxRedeliveries > -1 && (deliveryCount = this.deliveryCountExceedsMax(msg, callback)) == -1) {
                return;
            }
            EsbMessageExchange mex = null;
            try {
                mex = EsbMessageExchange.create(msg, this.m_dispatcher.getServiceAddress(), null, null, null, this, null);
                ItineraryEngine itinEngine = (ItineraryEngine)XQContainer.getProcessEngine();
                if (itinEngine.getProcessInstanceGenerator().hasProcessState(mex)) {
                    itinEngine.handleMessage(mex);
                } else {
                    this.m_dispatcher.onMessage(mex);
                }
                messageDispatched = true;
            }
            catch (InvalidStateException invalidStateExcp) {
                log.logWarning(invalidStateExcp.getMessage() + " " + this.getQosSpecificMessage());
            }
            catch (MessageCouldNotBeRejected rmeFailed) {
                messageDispatched = this.handleMessageCouldNotBeRejected(rmeFailed, msg, mex, deliveryCount);
            }
            catch (Throwable thrown) {
                log.logError("Failed to process message. " + this.getQosSpecificMessage());
                log.logError(thrown);
            }
            if (messageDispatched) {
                this.callbackSuccess(callback);
            } else {
                this.callbackFailure(callback);
            }
        }
        finally {
            block22: {
                dispatcher.decrementListenerStatistics(this.m_name);
                try {
                    this.cleanup();
                }
                catch (Throwable cleanupErr) {
                    if (!log.isDebugLoggingEnabled()) break block22;
                    log.logDebug(this.toString() + ": cleanup failed: ");
                    log.logDebug(cleanupErr);
                }
            }
        }
    }

    private void callbackSuccess(QOSCallback callback) {
        if (this.m_qosInt == 2) {
            try {
                callback.commit();
            }
            catch (XQRuntimeException e) {
                log.logError("Exception during callback success");
                log.logError((Throwable)e);
                if (e.getCause() != null && e.getCause() instanceof InvalidDestinationException) {
                    log.logError("Invalid destination provided, will callback failure.");
                    this.callbackFailure(callback);
                }
            }
        } else if (this.m_qosInt == 1) {
            callback.acknowledge();
        } else if (this.m_qosInt == 4) {
            callback.acknowledge();
        }
    }

    private void callbackFailure(QOSCallback callback) {
        if (this.m_qosInt == 0) {
            return;
        }
        if (this.m_qosInt == 2) {
            callback.rollback();
        } else if (this.m_qosInt == 1) {
            callback.recover();
        } else if (this.m_qosInt == 4) {
            callback.recover();
        }
    }

    private int deliveryCountExceedsMax(XQMessage msg, QOSCallback callback) {
        int currentDeliveryCount = 1;
        try {
            currentDeliveryCount = msg.getIntHeader("JMSXDeliveryCount");
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (currentDeliveryCount > this.m_maxRedeliveries + 1) {
            StringBuffer errorMsgBuffer = new StringBuffer();
            errorMsgBuffer.append(EndpointContextContainer.displayStr(msg)).append("has a delivery count of `").append(currentDeliveryCount).append("` that is greater than the connection's max re-delivery count setting `").append(this.m_maxRedeliveries);
            XQAddress globalRME = XQAddressFactoryImpl.getGlobalRME();
            if (globalRME == null) {
                errorMsgBuffer.append("`. The global RME destination is set to null so this message will be consumed and ignored. ");
                log.logInformation(errorMsgBuffer.toString());
            } else {
                errorMsgBuffer.append("`. This message will be sent to the global RME destination: ").append(globalRME);
                log.logInformation(errorMsgBuffer.toString());
                IllegalStateException e = new IllegalStateException(errorMsgBuffer.toString());
                RejectedMessageDispatcher.sendMessageToGlobalRME(e, msg, globalRME, "MESSAGE_RECEIPT_FAILURE", "XQ_MAXREDELIVERY_EXCEEDED", errorMsgBuffer.toString(), null, XQQualityofService.valueOf((String)this.m_qos), this.m_endpointRegistry, null, this.m_name);
            }
            this.callbackSuccess(callback);
            return -1;
        }
        return currentDeliveryCount;
    }

    private boolean handleMessageCouldNotBeRejected(MessageCouldNotBeRejected rmeFailed, XQMessage msg, EsbMessageExchange mex, int deliveryCount) {
        boolean status = true;
        if (this.m_maxRedeliveries == -1 || this.m_maxRedeliveries >= deliveryCount) {
            log.logError(EndpointContextContainer.displayStr(msg) + "was processed but could not be sent to the RME. " + "Check that the RME is configured correctly (or unset it to ignore rejected messages). " + this.getQosSpecificMessage());
            log.logError((Throwable)rmeFailed);
            status = false;
        } else {
            try {
                StringBuffer errorMsgBuffer = new StringBuffer();
                errorMsgBuffer.append(EndpointContextContainer.displayStr(msg)).append("has a delivery count of `").append(deliveryCount).append("` that is greater than the connection's max re-delivery count setting `").append(this.m_maxRedeliveries);
                XQAddress globalRME = XQAddressFactoryImpl.getGlobalRME();
                if (globalRME != null) {
                    errorMsgBuffer.append("`. The message is being sent to the global RME destination: " + globalRME);
                    log.logInformation(errorMsgBuffer.toString());
                    RejectedMessageDispatcher.sendMessageToGlobalRME(rmeFailed.getRMEMessage(), globalRME, "XQ_MAXREDELIVERY_EXCEEDED", "Delivery Count " + deliveryCount + " equals max delivery count " + this.m_maxRedeliveries + 1, "EndpointContextContainer", XQQualityofService.valueOf((String)this.m_qos), this.m_endpointRegistry);
                } else {
                    errorMsgBuffer.append("`. Since the global RME destination is not set the incoming message will be consumed.");
                    log.logInformation(errorMsgBuffer.toString());
                }
            }
            catch (Throwable e) {
                log.logError("Error while sending the " + EndpointContextContainer.displayStr(msg) + "to the global RME. The message will be consumed.");
            }
        }
        return status;
    }

    private static String displayStr(XQMessage msg) {
        try {
            return "Message `" + msg.getHeaderValue("JMSMessageID") + "` ";
        }
        catch (XQMessageException e) {
            return "Message ";
        }
    }

    public boolean isTransientEntryEndpoint() {
        return this.m_entryEndpointIsTransient;
    }

    private String getQosSpecificMessage() {
        switch (this.m_qosInt) {
            case 2: {
                return "The incoming message will be rolled back (QoS = Exactly Once).";
            }
            case 1: {
                return "The incoming message will not be acknowledged (QoS = At Least Once).";
            }
            case 4: {
                return "The incoming message will not be acknowledged (QoS = At Least Once Fast).";
            }
        }
        return "The incoming message may be lost (QoS = Best Effort).";
    }

    public String getName() {
        return this.m_name;
    }

    public String getEntryEndpointName() {
        return this.m_entryEndpointName;
    }

    @Override
    public String getQoS() {
        return this.m_qos;
    }

    public XQQualityofService getQualityofService() {
        return XQQualityofService.valueOf((String)this.m_qos);
    }

    public void init() {
    }

    public boolean start() throws Exception {
        if (this.m_entryEndpointName != null) {
            if (this.m_entryEndpointIsTransient && this.m_entryEndpoint != null) {
                this.m_endpointRegistry.registerEndpoint(this.m_entryEndpointName, this.m_entryEndpoint);
            }
            EndpointContext endpointContext = this.getEndpointContext(this.m_entryEndpointName, true);
            endpointContext.setMessageListener(this.m_entryEndpointName, this);
        }
        return true;
    }

    public boolean stop() throws Exception {
        return this.stop(false);
    }

    public boolean stop(boolean nowait) throws Exception {
        if (this.m_entryEndpoint != null) {
            EndpointCleaner ec = new EndpointCleaner(new EntryEndpointStopper(this.m_entryEndpoint, this.m_name));
            ec.cleanEndpoint(nowait ? "StopNoWait" : "Stop");
            if (ec.getException() != null) {
                throw ec.getException();
            }
        }
        return true;
    }

    public boolean destroy() {
        this.m_entryEndpoint = null;
        this.m_dispatcher = null;
        return true;
    }

    public void send(String endpointName, XQMessage msg) throws Exception {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": send: sending message to " + endpointName);
        }
        if (endpointName != null) {
            this.getEndpointContext(endpointName, false).send(endpointName, msg);
        }
    }

    public void registerTransientSendEndpoint(String endpointName, Endpoint endpoint) {
        this.m_endpointRegistry.registerEndpoint(endpointName, endpoint);
    }

    public void unregisterTransientSendEndpoint(String endpointName) {
        this.m_endpointContexts.remove(endpointName);
        this.m_endpointRegistry.unregisterEndpoint(endpointName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws Exception {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": cleanup");
        }
        Iterator<EndpointContext> contexts = this.m_endpointContextTypes.values().iterator();
        try {
            while (contexts.hasNext()) {
                contexts.next().cleanup();
            }
        }
        finally {
            this.m_endpointRegistry = new InvocationEndpointManager();
            this.removeEndpoints();
        }
    }

    public void addEndpoint(String epName) throws Exception {
        this.getEndpointContext(epName, false);
    }

    protected void removeEndpoints() {
        Iterator<EndpointContext> contexts = this.m_endpointContextTypes.values().iterator();
        try {
            while (contexts.hasNext()) {
                contexts.next().removeEndpoints();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_endpointContexts.clear();
    }

    private EndpointContext getEndpointContext(String endpointName, boolean setEntryEndpoint) throws Exception {
        EndpointContext context;
        String destinationName = null;
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": getEndpointContext: getting endpoint " + endpointName);
        }
        if ((context = this.m_endpointContexts.get(endpointName)) == null && endpointName != null) {
            String endpointType;
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": getEndpointContext: associating endpoint " + endpointName + " with context");
            }
            Endpoint endpoint = (Endpoint)this.m_endpointRegistry.getEndpoint(endpointName);
            if (setEntryEndpoint) {
                this.m_qos = endpoint.getConfig().getQOS();
                this.m_qosInt = EndpointConstants.getQoSAsInt((String)this.m_qos);
                this.m_entryEndpointConnection = endpoint.getConnectionName();
                this.m_maxRedeliveries = ((IJMSConnectionConfig)endpoint.getConfig().getConnectionConfig().getAdapter()).getMaxRedeliveryCount();
            }
            if (!setEntryEndpoint && this.m_qos.equals("EXACTLY_ONCE")) {
                if (endpoint == null) {
                    throw new Exception("Endpoint Context with EXACTLY_ONCE QoS can not span multiple connections. endpoint is null");
                }
                boolean isTemp = Boolean.parseBoolean(endpoint.getConfig().getParameters().getParameter("TemporaryEndpoint", 1));
                if (endpoint.isJMS() && (destinationName = endpoint.getConfig().getParameters().getParameter("destination", 1)) == null) {
                    Destination jmsDest = (Destination)endpoint.getConfig().getParameters().getParameterObject("destinationObject", 3);
                    destinationName = jmsDest instanceof Queue ? ((Queue)jmsDest).getQueueName() : ((Topic)jmsDest).getTopicName();
                }
                if (endpoint.getConnectionName() == null) {
                    throw new Exception("Endpoint Context with EXACTLY_ONCE QoS can not span multiple connections. endpoint connectionName is null");
                }
                if (this.m_entryEndpoint == null) {
                    throw new Exception("Endpoint Context with EXACTLY_ONCE QoS can not span multiple connections. entryEndpoint is null");
                }
                if (!(isTemp || destinationName == null || destinationName.indexOf("::") == -1 || destinationName.startsWith("sonic.http") || EndpointConstants.extractDestinationPart((String)destinationName).startsWith("http://") || EndpointConstants.extractDestinationPart((String)destinationName).startsWith("https://") || this.m_entryEndpoint.getConnectionName().equals(XQContainer.getJMSDefaultConnection()))) {
                    throw new Exception("Endpoint Context with EXACTLY_ONCE QoS cannot span multiple node connections. entryEndpoint connectionName: " + this.m_entryEndpoint.getConnectionName() + "; Bus connectionName = " + XQContainer.getJMSDefaultConnection());
                }
                if (!endpoint.getConnectionName().equals(this.m_entryEndpoint.getConnectionName())) {
                    throw new Exception("Endpoint Context with EXACTLY_ONCE QoS can not span multiple connections. endpoint connectionName: " + endpoint.getConnectionName() + "; entryEndpoint connectionName = " + this.m_entryEndpoint.getConnectionName());
                }
            }
            if ((context = this.m_endpointContextTypes.get(endpointType = endpoint.getConfig().getEndpointType())) == null) {
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug(this.toString() + ": getEndpointContext: adding context type " + endpointType + " to context");
                }
                if (this.m_dispatcher == null) {
                    throw new Exception("EndpointContextContainer: dispatcher is null!");
                }
                context = endpoint.createContext(this.m_name, this.m_qos, this.m_dispatcher, this.m_entryEndpointConnection);
                this.m_endpointContextTypes.put(endpointType, context);
            }
            context.addEndpoint(endpoint);
            this.m_endpointContexts.put(endpointName, context);
            if (setEntryEndpoint) {
                this.m_entryEndpoint = endpoint;
                context.setEntryEndpoint(endpoint);
                this.m_entryEndpointIsTransient = EndpointUtils.isTransientEndpoint(this.m_entryEndpoint);
            }
        }
        return context;
    }

    public IEndpointRegistry getEndpointRegistry() {
        return this.m_endpointRegistry;
    }

    public XQEndpoint getEndpoint(String name) throws XQEndpointCreationException {
        return this.m_endpointRegistry.getEndpoint(name);
    }

    public final String toString() {
        return super.toString();
    }

    private static class EntryEndpointStopper
    implements IEndpointCleanerFuture {
        private final Endpoint m_stoppingEndpoint;
        private final String m_stoppingName;

        EntryEndpointStopper(Endpoint ep, String name) {
            this.m_stoppingEndpoint = ep;
            this.m_stoppingName = name;
        }

        @Override
        public Endpoint getCurrentEndpoint() {
            return this.m_stoppingEndpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clean() throws Exception {
            try {
                if (this.m_stoppingEndpoint.isJMS()) {
                    Session.setAcquiescingEndpoint((JMSEndpoint)this.m_stoppingEndpoint);
                }
                this.m_stoppingEndpoint.stopMessageListener(this.m_stoppingName);
            }
            finally {
                if (this.m_stoppingEndpoint.isJMS()) {
                    Session.setAcquiescingEndpoint(null);
                }
            }
        }
    }
}

