/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.esb.itinerary.def.MessageMapperSerializer;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.envelope.XQProcessAddressImpl;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractAddressImpl
extends XQProcessAddressImpl {
    private String m_artifactName;
    private Document m_document;
    private Element m_itineraryElement;
    private Element m_artifactElement;
    private Element m_paramElement;
    private Set<String> m_stringParamList = new HashSet<String>();
    private Set<String> m_xmlParamList = new HashSet<String>();
    private MessageMapper m_msgMapper;
    private Element m_msgMapperElem;

    public AbstractAddressImpl(String artifactName) throws XQAddressNotFoundException {
        this(artifactName, XQQualityofService.BEST_EFFORT);
    }

    public AbstractAddressImpl(String artifactName, XQQualityofService qos) throws XQAddressNotFoundException {
        super("TMP$PROCESS$" + artifactName);
        this.initHandler(artifactName, qos);
    }

    private void initHandler(String artifactName, XQQualityofService qos) throws XQAddressNotFoundException {
        this.init(artifactName);
        this.m_artifactName = artifactName;
        try {
            this.m_document = DOMUtils.createDocument();
            Element artifactElement = DOMUtils.createXQElement((Document)this.m_document, (String)"step");
            artifactElement.setAttribute("endpoint_ref", artifactName);
            artifactElement.setAttribute("type", this.getStepType());
            String name = this.getSingleStepName();
            if (name != null) {
                artifactElement.setAttribute("name", name);
            }
            this.m_artifactElement = artifactElement;
            this.m_itineraryElement = DOMUtils.createXQElement((Document)this.m_document, (String)"itinerary");
            this.m_document.appendChild(this.m_itineraryElement);
            this.m_itineraryElement.appendChild(artifactElement);
            this.m_process.setItineraryElement(this.m_itineraryElement);
        }
        catch (Exception e) {
            throw new XQAddressNotFoundException("Cannot create Service Address for " + this.m_artifactName, e);
        }
        this.m_process.setName("TMP$PROCESS$" + artifactName);
        this.m_process.setFaultEndpoint(this.getStepFaultEndpoint());
        this.m_process.setExitEndpoints(this.getStepExitEndpoints());
        this.m_exitEndpoints = this.m_process.getExitEndpoints();
        this.m_process.setRejectedMessageEndpoint(this.getStepRejectedMessageEndpoint());
        this.m_process.setQOS(qos.toString());
    }

    protected AbstractAddressImpl(String processName, XQQualityofService qos, XQProcessConfig processConfig) throws XQAddressNotFoundException {
        super(processName, processConfig);
        this.initHandler(processName, qos, processConfig);
    }

    private void initHandler(String processName, XQQualityofService qos, XQProcessConfig processConfig) throws XQAddressNotFoundException {
        this.init(processName);
        this.m_artifactName = processName;
        this.m_itineraryElement = this.m_process.getItineraryElement();
        this.m_document = this.m_itineraryElement.getOwnerDocument();
        this.m_artifactElement = DOMUtils.getElementByTagName((Element)this.m_itineraryElement, (String)"step");
        this.m_process.setFaultEndpoint(this.getStepFaultEndpoint());
        this.m_process.setExitEndpoints(this.getStepExitEndpoints());
        this.m_exitEndpoints = this.m_process.getExitEndpoints();
        this.m_process.setRejectedMessageEndpoint(this.getStepRejectedMessageEndpoint());
        this.m_process.setQOS(qos.toString());
    }

    protected abstract void init(String var1) throws XQAddressNotFoundException;

    protected abstract String getStepType();

    protected abstract String getSingleStepName();

    protected abstract XQAddress getStepFaultEndpoint();

    protected abstract Set<XQAddress> getStepExitEndpoints();

    protected abstract XQAddress getStepRejectedMessageEndpoint();

    public void setMessageMapper(MessageMapper msgMapper) {
        if (msgMapper != null) {
            this.m_msgMapper = msgMapper;
            this.m_msgMapperElem = MessageMapperSerializer.marshallAsDOM(this.m_msgMapper, this.m_artifactElement);
        }
    }

    public MessageMapper getMessageMapper() {
        return this.m_msgMapper;
    }

    public void resetItineraryElement() throws XQConfigurationException {
        this.m_process.setItineraryElement(this.m_itineraryElement);
    }

    @Override
    public void setStepName(String step) throws XQAddressNotFoundException {
        if (step != null) {
            throw new XQAddressNotFoundException("The specified step named " + step + " does not exist in the process " + this.getName());
        }
    }

    public Element getItineraryElement() {
        return this.m_itineraryElement;
    }

    public void addXMLParameter(String name, Element value) {
        if (this.m_xmlParamList.contains(name)) {
            return;
        }
        if (this.m_paramElement == null) {
            this.m_paramElement = DOMUtils.createXQElement((Document)this.m_document, (String)"params");
        }
        Element xmlElement = DOMUtils.createXQElement((Document)this.m_document, (String)"xmlParam");
        xmlElement.appendChild(value);
        xmlElement.setAttribute("name", name);
        this.m_paramElement.appendChild(xmlElement);
        this.m_artifactElement.appendChild(this.m_paramElement);
        this.m_xmlParamList.add(name);
    }

    public void addXMLParameterURL(String name, String url) {
        if (this.m_xmlParamList.contains(name)) {
            return;
        }
        if (this.m_paramElement == null) {
            this.m_paramElement = DOMUtils.createXQElement((Document)this.m_document, (String)"params");
        }
        Element xmlElement = DOMUtils.createXQElement((Document)this.m_document, (String)"xmlParam");
        xmlElement.setAttribute("url", url);
        xmlElement.setAttribute("name", name);
        this.m_paramElement.appendChild(xmlElement);
        this.m_artifactElement.appendChild(this.m_paramElement);
        this.m_xmlParamList.add(name);
    }

    public void addParameter(String name, String value) {
        if (this.m_stringParamList.contains(name)) {
            return;
        }
        if (this.m_paramElement == null) {
            this.m_paramElement = DOMUtils.createXQElement((Document)this.m_document, (String)"params");
        }
        Element stringElement = DOMUtils.createXQElement((Document)this.m_document, (String)"stringParam");
        Text stringValue = this.m_document.createTextNode(value);
        stringElement.appendChild(stringValue);
        stringElement.setAttribute("name", name);
        this.m_paramElement.appendChild(stringElement);
        this.m_artifactElement.appendChild(this.m_paramElement);
        this.m_stringParamList.add(name);
    }

    public void addParameterURL(String name, String url) {
        if (this.m_stringParamList.contains(name)) {
            return;
        }
        if (this.m_paramElement == null) {
            this.m_paramElement = DOMUtils.createXQElement((Document)this.m_document, (String)"params");
        }
        Element stringElement = DOMUtils.createXQElement((Document)this.m_document, (String)"stringParam");
        stringElement.setAttribute("name", name);
        stringElement.setAttribute("url", url);
        this.m_paramElement.appendChild(stringElement);
        this.m_artifactElement.appendChild(this.m_paramElement);
        this.m_stringParamList.add(name);
    }

    public void addRuntimeParams(Element params) {
        Object value;
        String url;
        String name;
        List elements = DOMUtils.getImmediateChildElementsByName((Element)params, (String)"xmlParam");
        for (Element child : elements) {
            name = child.getAttribute("name");
            url = child.getAttribute("url");
            if (url == null) {
                value = DOMUtils.getFirstChildElement((Element)child);
                this.addXMLParameter(name, (Element)value);
                continue;
            }
            this.addXMLParameterURL(name, url);
        }
        elements = DOMUtils.getImmediateChildElementsByName((Element)params, (String)"stringParam");
        for (Element child : elements) {
            name = child.getAttribute("name");
            url = child.getAttribute("url");
            if (url == null || url.length() == 0) {
                value = DOMUtils.getFirstTextChildValue((Element)child);
                this.addParameter(name, (String)value);
                continue;
            }
            this.addParameterURL(name, url);
        }
    }
}

