/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.envelope.AbstractAddressImpl;
import java.util.HashSet;
import java.util.Set;

public class EndpointAddressImpl
extends AbstractAddressImpl {
    public EndpointAddressImpl(String endpointName) throws XQAddressNotFoundException {
        this(endpointName, XQQualityofService.BEST_EFFORT);
    }

    public EndpointAddressImpl(String endpointName, XQQualityofService qos) throws XQAddressNotFoundException {
        super(endpointName, qos);
    }

    @Override
    protected void init(String endpointName) throws XQAddressNotFoundException {
        try {
            XQConfigManager configManager = XQConfigManager.getInstance(null);
            configManager.lookupEndpointConfig(endpointName);
        }
        catch (Exception e) {
            throw new XQAddressNotFoundException("Cannot create Endpoint Address for " + endpointName, e);
        }
    }

    @Override
    protected String getSingleStepName() {
        return null;
    }

    @Override
    protected String getStepType() {
        return "ENDPOINT";
    }

    @Override
    protected XQAddress getStepFaultEndpoint() {
        return null;
    }

    @Override
    protected Set<XQAddress> getStepExitEndpoints() {
        return new HashSet<XQAddress>();
    }

    @Override
    protected XQAddress getStepRejectedMessageEndpoint() {
        return null;
    }
}

