/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.invk.ESBException;
import com.sonicsw.xqimpl.invk.ESBInvkException;
import com.sonicsw.xqimpl.invk.ESBMessage;
import com.sonicsw.xqimpl.invk.ESBMessageContext;
import com.sonicsw.xqimpl.invk.ESBOperation;
import com.sonicsw.xqimpl.invkimpl.ESBMessageContextImpl;
import com.sonicsw.xqimpl.invkimpl.ESBMessageImpl;
import com.sonicsw.xqimpl.invkimpl.WSESBInvkException;
import com.sonicsw.xqimpl.invkimpl.WSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.RawSoapWSInvocationException;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;

public class ESBOperationImpl
implements ESBOperation {
    protected WSIFOperation m_wsifOperation;
    protected String m_inputName;
    String m_outputName;
    private static XQLog m_log = XQLogImpl.getCategoryLog((int)32);

    public ESBOperationImpl(String operationName, WSIFPort wsifPort) throws ESBException {
        try {
            if (operationName == null) {
                throw new ESBException("operation-name-null", 2);
            }
            this.m_wsifOperation = wsifPort.createOperation(operationName);
        }
        catch (WSIFException ex) {
            throw new ESBException(ex);
        }
    }

    public ESBOperationImpl(String operationName, String inputName, String outputName, WSIFPort wsifPort) throws ESBException {
        try {
            if (operationName == null) {
                throw new ESBException("operation-name-null", 2);
            }
            this.m_inputName = inputName;
            this.m_outputName = outputName;
            this.m_wsifOperation = wsifPort.createOperation(operationName, inputName, outputName);
        }
        catch (WSIFException ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public ESBMessageContext createESBMessageContext() throws ESBException {
        return new ESBMessageContextImpl(this.m_wsifOperation, this.m_inputName, this.m_outputName);
    }

    @Override
    public void send(ESBMessageContext context) throws ESBException, ESBInvkException {
        boolean faultAsSoap = false;
        try {
            ESBMessage input = context.getInputMessage(this.m_inputName);
            if (input == null) {
                throw new ESBException("input-message-null", 2);
            }
            context.setBooleanProperty("IsSyncRequestReply", false);
            context.setBooleanProperty("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FORCE_REQUEST_RESPONSE_OP", false);
            faultAsSoap = this.isFaultAsSoap(context);
            this.m_wsifOperation.executeInputOnlyOperation(((ESBMessageImpl)input).getWsifMessage());
        }
        catch (RawSoapWSInvocationException exception) {
            throw new WSESBInvkException(exception);
        }
        catch (WSInvocationException exception) {
            exception.printStackTrace();
            if (faultAsSoap) {
                throw new WSESBInvkException(new RawSoapWSInvocationException(exception));
            }
            throw new WSESBInvkException(exception);
        }
        catch (WSIFException exception) {
            throw new ESBException(exception);
        }
    }

    private boolean isFaultAsSoap(ESBMessageContext context) throws ESBException {
        boolean faultAsSoap = false;
        try {
            Boolean faultAsSoapObject = (Boolean)context.getProperty("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FAULT_AS_SOAP");
            if (faultAsSoapObject != null) {
                faultAsSoap = faultAsSoapObject;
            }
        }
        catch (ESBException eSBException) {
            // empty catch block
        }
        return faultAsSoap;
    }

    @Override
    public void call(ESBMessageContext context) throws ESBException, ESBInvkException {
        boolean faultAsSoap = false;
        try {
            ESBMessage input = context.getInputMessage(this.m_inputName);
            if (input == null) {
                throw new ESBException("input-message-null", 2);
            }
            ESBMessage output = context.getOutputMessage(this.m_outputName);
            context.setBooleanProperty("IsSyncRequestReply", true);
            faultAsSoap = this.isFaultAsSoap(context);
            boolean success = this.m_wsifOperation.executeRequestResponseOperation(((ESBMessageImpl)input).getWsifMessage(), output == null ? null : ((ESBMessageImpl)output).getWsifMessage(), null);
            if (!success) {
                throw new GeneralWSInvocationException("call-unsuccessful", null);
            }
            context.addOutputMessage(output.getName(), output);
        }
        catch (RawSoapWSInvocationException exception) {
            throw new WSESBInvkException(exception);
        }
        catch (WSInvocationException exception) {
            m_log.logDebug("ESBOperationImpl: faultAsSoap=" + faultAsSoap);
            m_log.logDebug((Throwable)((Object)exception));
            if (faultAsSoap) {
                throw new WSESBInvkException(new RawSoapWSInvocationException(exception));
            }
            throw new WSESBInvkException(exception);
        }
        catch (WSIFException exception) {
            GeneralWSInvocationException xmlableException = new GeneralWSInvocationException(exception.getMessage(), null, exception);
            throw new WSESBInvkException(xmlableException);
        }
    }
}

