/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.esb;

import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.invkimpl.ESBReturnParamImpl;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseEsbWsifOperation;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseWsifPort;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.esb.ESBExceptionCreator;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.esb.ESBWSIFJMSDestination;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.esb.ESBWSIFPort;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ESBWSIFOperation
extends BaseEsbWsifOperation {
    private ESBExceptionCreator m_exceptionCreator;
    private boolean m_loadDTDs = false;
    private static final int s_messageLength = 20;

    public ESBWSIFOperation(BaseWsifPort wsifPort, Operation bindingOperation, WSIFDynamicTypeMap typeMap) throws WSIFException {
        super(wsifPort, bindingOperation, typeMap);
    }

    @Override
    protected void initializeCall(WSIFMessage context) throws WSIFException {
        super.initializeCall(context);
        try {
            this.m_loadDTDs = this.getContextNoClone().getBooleanPart("load_external_dtds");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_exceptionCreator = new ESBExceptionCreator(this.m_loadDTDs, this.m_scriptCommand);
    }

    public ESBWSIFOperation copy() throws WSIFException {
        ESBWSIFOperation op = new ESBWSIFOperation(this.m_wsifPort, this.m_portTypeOperation, this.m_typeMap);
        this.commonCopy(op);
        return op;
    }

    @Override
    public boolean invokeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg) throws WSIFException {
        ESBWSIFJMSDestination dest = ((ESBWSIFPort)this.m_wsifPort).getDestination();
        this.addInputJmsPropertyValues(this.m_wsifPort.getJmsAddressPropVals());
        if (this.inJmsPropVals != null && this.inJmsPropVals.size() > 0) {
            dest.setProperties(this.inJmsPropVals);
        }
        this.setAddressingProperties(dest);
        this.setDestinationContext(dest);
        if (this.getContextNoClone().getBooleanPart("IsSyncRequestReply")) {
            return this.doRequestResponse(dest, inMsg, outMsg);
        }
        dest.send(inMsg);
        return true;
    }

    private void setAddressingProperties(ESBWSIFJMSDestination dest) throws WSIFException {
        try {
            String actionProp;
            Element eprElem = this.m_scriptCommand.getEndpointReference();
            if (eprElem != null) {
                List params;
                EndpointReference epr = new EndpointReference(eprElem);
                ReferencePropertiesType properties = epr.getProperties();
                if (properties != null) {
                    for (int i = 0; i < properties.size(); ++i) {
                        MessageElement me = (MessageElement)properties.get(i);
                        QName qn = new QName(me.getNamespaceURI(), me.getLocalName());
                        dest.setProperty(qn.toString(), me.getAsString());
                    }
                }
                if ((params = epr.getParameters()) != null) {
                    for (int i = 0; i < params.size(); ++i) {
                        MessageElement me = (MessageElement)params.get(i);
                        QName qn = new QName(me.getNamespaceURI(), me.getLocalName());
                        dest.setProperty(qn.toString(), me.getAsString());
                    }
                }
            }
            if (!dest.inProps.containsKey(actionProp = new QName(AddressingUtils.getDefaultNS(), "Action").toString())) {
                dest.setProperty(actionProp, this.calculateDefaultAction());
            }
            dest.setProperty("X-WS-Operation", this.m_scriptCommand.getOperationName());
            dest.setProperty("X-WS-PortType", this.m_scriptCommand.getPortType().getLocalPart());
        }
        catch (Exception e) {
            throw new WSIFException("Error retrieving addressing properties for EPR", (Throwable)e);
        }
    }

    private boolean doRequestResponse(ESBWSIFJMSDestination dest, WSIFMessage inMsg, WSIFMessage outMsg) throws WSIFException {
        if (outMsg == null) {
            throw new GeneralWSInvocationException("esb-binding-no-output-message", null);
        }
        XQMessage xqResponseMsg = dest.call(inMsg);
        if (xqResponseMsg == null) {
            throw new GeneralWSInvocationException("esb-binding-port-returned-null", new Object[]{this.m_wsifPort.getPort().getName()});
        }
        String contentString = null;
        try {
            int partCount = xqResponseMsg.getPartCount();
            List partsDef = this.getPortTypeOperation().getOutput().getMessage().getOrderedParts(null);
            int definedPartCount = partsDef.size();
            for (int pidx = 0; pidx < partCount; ++pidx) {
                ESBReturnParamImpl returnParam;
                Document doc;
                Part pOutDef;
                block22: {
                    XQPart responsePart = xqResponseMsg.getPart(pidx);
                    Object content = responsePart.getContent();
                    if (content == null || !(content instanceof String)) {
                        if (content == null) {
                            throw new GeneralWSInvocationException("esb-binding-null-output");
                        }
                        throw new GeneralWSInvocationException("esb-binding-invalid-output-type", new Object[]{content.getClass().getName()});
                    }
                    contentString = (String)content;
                    if (pidx == 0 && responsePart.getContentId() != null && responsePart.getContentId().equals("SonicESB.Fault")) {
                        throw this.m_exceptionCreator.createException(contentString);
                    }
                    if (pidx > definedPartCount - 1) break;
                    pOutDef = null;
                    String cid = responsePart.getContentId();
                    pOutDef = cid == null || partCount == 1 ? (Part)partsDef.get(pidx) : this.getPortTypeOperation().getOutput().getMessage().getPart(cid);
                    DocumentBuilder builder = DOMUtils.getDocumentBuilder((boolean)false, (boolean)this.m_loadDTDs);
                    doc = null;
                    returnParam = null;
                    try {
                        doc = builder.parse(new InputSource(new StringReader(contentString)));
                    }
                    catch (SAXException sae) {
                        if (pOutDef == null || pOutDef.getElementName() != null) {
                            throw sae;
                        }
                        if ("anyType".equals(pOutDef.getTypeName().getLocalPart())) break block22;
                        int jType = 16;
                        try {
                            jType = XMLTypeUtils.getJavaType(pOutDef.getTypeName().getLocalPart());
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        if (jType != 16) break block22;
                        throw sae;
                    }
                }
                if (doc != null) {
                    Element detail = this.checkRME(doc.getDocumentElement());
                    if (detail != null) {
                        throw this.m_exceptionCreator.createException(detail);
                    }
                    returnParam = new ESBReturnParamImpl(false, doc.getDocumentElement(), contentString);
                } else {
                    returnParam = new ESBReturnParamImpl(false, null, contentString);
                }
                if (pOutDef == null) {
                    outMsg.setObjectPart("part" + pidx, (Object)returnParam);
                    continue;
                }
                outMsg.setObjectPart(pOutDef.getName(), (Object)returnParam);
            }
            if (partCount != definedPartCount) {
                throw new GeneralWSInvocationException("esb-binding-parts-mismatch", new Object[]{new Integer(definedPartCount), new Integer(partCount)});
            }
            return true;
        }
        catch (WSIFException ex) {
            throw ex;
        }
        catch (XQMessageException ex) {
            throw new GeneralWSInvocationException(ex.getMessage(), null, ex);
        }
        catch (ParserConfigurationException ex) {
            throw new GeneralWSInvocationException(ex.getMessage(), null, ex);
        }
        catch (SAXException ex) {
            throw this.createParserException(ex, contentString);
        }
        catch (IOException ex) {
            throw new GeneralWSInvocationException(ex.getMessage(), null, ex);
        }
    }

    private GeneralWSInvocationException createParserException(Exception e, String contentString) {
        String message = e.getMessage();
        if (message != null && e.getMessage().startsWith("Content is not allowed in prolog")) {
            message = "esb-binding-non-xml-value-found-in-url";
            if (contentString.length() > 20) {
                contentString = contentString.substring(0, 20);
                contentString = contentString + "...";
            }
            GeneralWSInvocationException ge = new GeneralWSInvocationException(message, new Object[]{contentString}, e);
            return ge;
        }
        GeneralWSInvocationException ge = new GeneralWSInvocationException(e.getMessage(), null, e);
        return ge;
    }

    private Element checkRME(Element response) {
        Node child;
        NodeList rmeChildren;
        NodeList children;
        String localName;
        String namespaceURI = response.getNamespaceURI();
        QName responseQName = new QName(namespaceURI, localName = response.getLocalName());
        if (responseQName.equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope")) && (children = response.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")) != null && children.getLength() > 0 && (rmeChildren = ((Element)(child = children.item(0))).getElementsByTagNameNS("http://www.sonicsw.com/sonicxq", "rejectedMessageInfo")) != null && rmeChildren.getLength() > 0) {
            return (Element)rmeChildren.item(0);
        }
        return null;
    }

    @Override
    protected void setDefaultProps(Map jmsProps) {
        if (!jmsProps.containsKey("X-HTTP-ReplyAsSOAP")) {
            jmsProps.put("X-HTTP-ReplyAsSOAP", new Boolean(false));
        }
    }
}

