/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xqimpl.script.ParameterValue;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.util.Base64;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Element;

public class Base64ByteArrayParameterValue
extends ParameterValue {
    private String m_stringValue;
    private byte[] m_byteArrayValue = null;

    public Base64ByteArrayParameterValue(String paramName, byte[] value) {
        super(paramName);
        if (value == null) {
            this.m_stringValue = "";
        } else {
            this.m_byteArrayValue = value;
        }
    }

    public Base64ByteArrayParameterValue(String paramName, String value) throws ScriptEngineException {
        super(paramName);
        if (value != null) {
            try {
                this.m_byteArrayValue = Base64.decode((byte[])value.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ScriptEngineException(e.getMessage(), null, 1);
            }
            if (this.m_byteArrayValue == null) {
                throw new ScriptEngineException("parameter-not-base64-encoded", new Object[]{paramName}, 1);
            }
        } else {
            value = "";
        }
        this.m_stringValue = value;
    }

    @Override
    public byte[] getAsByteArray() throws ScriptEngineException {
        return this.m_byteArrayValue;
    }

    @Override
    public String getAsString() {
        if (this.m_stringValue != null) {
            return this.m_stringValue;
        }
        if (this.m_byteArrayValue != null) {
            byte[] base64encoded = Base64.encode((byte[])this.m_byteArrayValue);
            this.m_stringValue = new String(base64encoded);
            return this.m_stringValue;
        }
        return null;
    }

    @Override
    public Element getAsElement() throws ScriptEngineException {
        throw new ScriptEngineException("byte-array-element-mismatch", 2);
    }

    @Override
    public boolean isByteArray() {
        return true;
    }

    @Override
    public boolean isXML() {
        return false;
    }
}

