/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.IVariableValue;
import com.sonicsw.xqimpl.script.ParameterDirection;
import com.sonicsw.xqimpl.script.ScriptEngine;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.TestFSDSRef;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.service.wsinvk.WSExecutionFaultException;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ScriptUtil {
    public static boolean TRACE = System.getProperty("TRACE") != null;
    private boolean m_ranUntilOutput = false;
    private Map m_outputVariables = null;
    private String m_result;
    protected ScriptEngine m_engine;
    public static final int RUN_TO_INPUT = 1;
    public static final int RUN_TO_EXECUTE = 2;
    public static final int RUN_TO_OUTPUT = 3;

    public final DirectoryServiceProxy getDSProxy() throws Exception {
        IDirectoryFileSystemService ds = TestFSDSRef.getDS();
        if (ds == null) {
            throw new Exception("A Directory Service has not been specified.");
        }
        return (DirectoryServiceProxy)ds;
    }

    public void Execute(String command, int runTo) throws Exception {
        if (TRACE) {
            System.out.println("TRACE(ScriptUtil): Execute(" + runTo + ")");
        }
        this.m_result = "";
        Element result = null;
        try {
            Document doc = DOMUtils.createDocument();
            switch (runTo) {
                case 1: {
                    this.m_ranUntilOutput = false;
                    this.m_outputVariables = null;
                    List params = this.m_engine.getInputParameters(command);
                    result = doc.createElementNS(null, "inputParams");
                    if (params == null || params.isEmpty()) break;
                    this.formatParams(params, true, result, doc);
                    break;
                }
                case 2: {
                    this.m_ranUntilOutput = false;
                    this.m_outputVariables = null;
                    List params = this.m_engine.executeCommand(command);
                    result = doc.createElementNS(null, "outputParams");
                    if (params == null || params.isEmpty()) break;
                    this.formatParams(params, false, result, doc);
                    break;
                }
                case 3: {
                    Map variables;
                    List params = this.m_engine.executeCommand(command);
                    this.m_ranUntilOutput = true;
                    result = doc.createElementNS(null, "outputVariables");
                    if (params == null || params.isEmpty()) break;
                    if (TRACE) {
                        System.out.println("TRACE(ScriptUtil): Number of params = " + params.size());
                    }
                    this.m_outputVariables = variables = this.m_engine.getOutputVariableValues(command, params);
                    if (variables == null || variables.isEmpty()) break;
                    this.formatVariables(variables, result, doc);
                    break;
                }
                default: {
                    throw new Exception("Unrecognized run mode(" + runTo + ")");
                }
            }
            this.m_result = Util.getElementAsString(result, true);
        }
        catch (WSExecutionFaultException wsefe) {
            this.m_result = wsefe.getAsXML();
        }
        catch (Exception e) {
            throw new ScriptUtilException((Throwable)e);
        }
    }

    public byte[] getVariableContent(String variableName) throws Exception {
        if (!this.m_ranUntilOutput) {
            throw new ScriptUtilException("No output variables are available.  The last execute was not run until outputs.");
        }
        Object result = null;
        if (this.m_outputVariables != null) {
            result = this.m_outputVariables.get(variableName);
        }
        if (result != null) {
            IVariableValue value = result;
            if (value.isByteArray()) {
                return value.getAsByteArray();
            }
            return value.getAsString().getBytes("UTF-8");
        }
        throw new ScriptUtilException("Output variable: " + variableName + " is not a known variable value");
    }

    public String getResults() {
        if (TRACE) {
            System.out.println("TRACE(ScriptUtil): getResults() returning:");
            System.out.println(this.m_result);
        }
        return this.m_result;
    }

    public final void setEngine(ScriptEngine engine) {
        if (TRACE) {
            System.out.println("TRACE(ScriptUtil): setEngine '" + engine + "'");
        }
        this.m_engine = engine;
    }

    private void formatParams(List params, boolean input, Element parentElement, Document parentDoc) throws ScriptEngineException {
        if (TRACE) {
            System.out.println("TRACE(ScriptUtil): formatParams - number of params = " + params.size());
        }
        for (IParameterValue val : params) {
            if (val == null) continue;
            ParameterDirection direction = val.getDirection();
            if (input && direction == ParameterDirection.OUT) {
                if (!TRACE) continue;
                System.out.println("TRACE(ScriptUtil): formatParams - skipping !IN param (" + val.getParamName() + "=" + direction + ")");
                continue;
            }
            if (!input && direction == ParameterDirection.IN) {
                if (!TRACE) continue;
                System.out.println("TRACE(ScriptUtil): formatParams - skipping !OUT param (" + val.getParamName() + "=" + direction + ")");
                continue;
            }
            Element parameterElement = parentDoc.createElementNS(null, "parameter");
            parameterElement.setAttribute("name", val.getParamName());
            parameterElement.setAttribute("type", val.getDisplayType());
            parameterElement.setAttribute("direction", direction.toString());
            parentElement.appendChild(parameterElement);
            if (!val.isXML()) {
                String strValue = null;
                try {
                    strValue = val.getAsString();
                }
                catch (Exception e) {
                    strValue = "Exception: " + e.getMessage();
                }
                if (strValue == null) continue;
                Text textNode = parentDoc.createTextNode(strValue);
                parameterElement.appendChild(textNode);
                continue;
            }
            Element elemValue = val.getAsElement();
            Node childNode = parentDoc.importNode(elemValue, true);
            parameterElement.appendChild(childNode);
        }
    }

    private void formatVariables(Map map, Element result, Document parentDoc) throws ScriptEngineException {
        if (TRACE) {
            System.out.println("TRACE(ScriptUtil): formatVariables - number of variables = " + map.size());
        }
        for (String key : map.keySet()) {
            if (key == null) continue;
            IVariableValue val = (IVariableValue)map.get(key);
            Element variableElement = parentDoc.createElementNS(null, "variable");
            variableElement.setAttribute("name", val.getVariableName());
            variableElement.setAttribute("type", val.getDisplayType());
            result.appendChild(variableElement);
            if (!val.isXML()) {
                String strValue = null;
                try {
                    strValue = val.getAsString();
                }
                catch (Exception e) {
                    strValue = "Exception: " + e.getMessage();
                }
                Text textNode = parentDoc.createTextNode(strValue);
                variableElement.appendChild(textNode);
                continue;
            }
            Element elemValue = val.getAsElement();
            Node childNode = parentDoc.importNode(elemValue, true);
            variableElement.appendChild(childNode);
        }
    }

    class ScriptUtilException
    extends Exception {
        private Throwable m_throwable;
        private String m_message;

        public ScriptUtilException(Throwable th) {
            this.m_throwable = th;
        }

        public ScriptUtilException(String message) {
            this.m_message = message;
        }

        private String getThrowableMessage(Throwable throwable) {
            if (throwable != null) {
                String message = throwable.getMessage();
                if (message == null) {
                    message = throwable.toString();
                }
                return message;
            }
            return null;
        }

        @Override
        public String getMessage() {
            String message = this.getThrowableMessage(this.m_throwable);
            Throwable current = this.m_throwable;
            if (this.m_throwable != null) {
                while (current instanceof ScriptEngineException) {
                    if ((current = ((ScriptEngineException)current).getLinkedException()) == null) continue;
                    message = message + "\r\nCaused by...\r\n" + this.getThrowableMessage(current);
                }
                return message;
            }
            return this.m_message;
        }
    }
}

