/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.xq.XQAccessor;
import com.sonicsw.xq.XQAccessorException;
import com.sonicsw.xq.XQAccessorFactory;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.config.XQAccessorConfig;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.service.XQInitServiceContextImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.Hashtable;

public class AccessorFactory
implements XQAccessorFactory {
    private static AccessorFactory m_instance = null;
    private Hashtable<String, Class> m_classCache = new Hashtable();
    private XQLog m_log;
    private XQEndpointManager m_epManager = null;

    private AccessorFactory() {
    }

    public static synchronized AccessorFactory getInstance() {
        if (m_instance == null) {
            m_instance = new AccessorFactory();
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XQAccessor getAccessor(String accessorName) throws XQAccessorException {
        XQAccessor accessor = null;
        if (accessorName != null) {
            try {
                XQConfigManager configManager = XQConfigManager.getInstance(null);
                XQAccessorConfig config = configManager.lookupAccessorConfig(accessorName);
                String classname = config.getFactoryClass();
                Class accessorClass = null;
                Hashtable<String, Class> hashtable = this.m_classCache;
                synchronized (hashtable) {
                    if (this.m_classCache.containsKey(classname)) {
                        accessorClass = this.m_classCache.get(classname);
                    } else {
                        try {
                            accessorClass = Class.forName(classname);
                            this.m_classCache.put(classname, accessorClass);
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.m_log.logError((Throwable)cnfe);
                            throw new XQAccessorException("Accessor class not found:" + classname);
                        }
                    }
                }
                if (!XQAccessor.class.isAssignableFrom(accessorClass)) {
                    throw new XQAccessorException("Accessors must implement XQAccesor");
                }
                accessor = (XQAccessor)accessorClass.newInstance();
                XQInitServiceContextImpl initContext = new XQInitServiceContextImpl((XQParameters)config.getParameters(), null, this.m_epManager, null, null, null);
                accessor.init((XQInitContext)initContext);
            }
            catch (XQConfigurationException ne) {
                this.m_log.logError((Throwable)ne);
                throw new XQAccessorException("Accessor not found:" + accessorName);
            }
            catch (Exception e) {
                this.m_log.logError((Throwable)e);
                throw new XQAccessorException("Exception creating accessor:" + accessorName);
            }
        }
        throw new XQAccessorException("Accessor Name cannot be null");
        return accessor;
    }

    public void init(XQEndpointManager epManager) {
        this.m_epManager = epManager;
        this.m_log = XQLogImpl.getInstance();
    }
}

