/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQState;

public abstract class LifeCycleManagerBase
implements XQLifeCycleManager {
    protected XQLog m_log;
    public static final int START_ACTION = 0;
    public static final int STOP_ACTION = 1;
    public static final int ABORT_ACTION = 2;
    protected static String[] OPS = new String[]{"Start", "Stop", "Abort"};

    protected LifeCycleManagerBase(XQLog log) {
        this.m_log = log;
    }

    public boolean isServiceAborting() {
        return false;
    }

    public boolean isContainerAborting() {
        return false;
    }

    protected void throwInvalidState(XQState currentState, String artifact, int operation) {
        throw new IllegalStateException("Cannot " + OPS[operation] + " " + artifact + " as it is in" + " the " + currentState + " state");
    }

    protected void ignoreSameState(XQState currentState, String artifact, int operation) {
        this.m_log.logDebug(artifact + " is already in the " + currentState + " state. So this request" + " to " + OPS[operation] + " the " + artifact + " will be ignored.");
    }

    protected void ignoreTransientState(XQState currentState, String artifact, int operation) {
        this.m_log.logDebug(artifact + " is in the " + currentState + " state. So this request" + " to " + OPS[operation] + " the " + artifact + " will be ignored.");
    }
}

