/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.message.rme.IRMEMessage;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.service.RejectedMessageDispatcher;
import com.sonicsw.xqimpl.service.SOAPEventMessage;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.BodyBuilder;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.SOAPUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class RMEMessage
extends SOAPEventMessage
implements IRMEMessage {
    private Throwable m_throwable;
    private String m_rejectedCode = "XQ_SERVICE_EXCEPTION";
    private String m_rmeMessage;
    private String m_processName;
    private String m_topLevelProcessName;
    private String m_stepName;
    private String m_hostName;
    private String m_containerName;
    private String m_svcAppName;
    private String m_rmeMsgContents;
    private String m_globalRejectedCode;
    private String m_globalRejectedDetails;
    private XQParameters m_environment;
    public static final String RME_BODY_NAME = "rejectedMessageInfo";
    private static final String REJECTED_CODE_NAME = "rejectedCode";
    private static final String REJECTED_LOCATION_NAME = "rejectedLocation";
    private static final String REJECTED_DETAILS_NAME = "rejectedDetails";
    private static final String GLOBAL_REJECTED_CODE_NAME = "globalRejectedCode";
    private static final String GLOBAL_REJECTED_DETAILS = "globalRejectedDetails";
    public static final String HEADER_REJECTED_PROCESS = "SonicESB.RME.Process";
    public static final String HEADER_REJECTED_TOP_PROCESS = "SonicESB.RME.TopProcess";
    public static final String HEADER_REJECTED_STEP = "SonicESB.RME.Step";
    public static final String HEADER_REJECTED_HOST = "SonicESB.RME.Host";
    public static final String HEADER_REJECTED_CONTAINER = "SonicESB.RME.XQContainer";
    public static final String HEADER_REJECTED_SERVICE = "SonicESB.RME.XQService";
    public static final String HEADER_REJECTED_DETAILS = "SonicESB.RME.Message";
    public static final String HEADER_REJECTED_CODE = "SonicESB.RME.Code";
    public static final String RME_CONTENT_ID = "SonicESB.RME";

    public RMEMessage(Throwable throwable, XQAddress address, XQMessageFactory messageFactory, XQMessage message, XQParameters environment, String rejectedCode) {
        super(address, messageFactory, message);
        this.m_throwable = throwable;
        this.m_environment = environment;
        this.m_rejectedCode = rejectedCode;
        this.extractFromParams(environment);
    }

    private void extractFromParams(XQParameters environment) {
        if (environment != null) {
            this.m_containerName = environment.getParameter("SonicXQ.ContainerName", 1);
            this.m_svcAppName = environment.getParameter("SonicXQ.ApplicationName", 1);
            this.m_topLevelProcessName = environment.getParameter("SonicXQ.TopLevelProcessName", 1);
            this.m_processName = environment.getParameter("SonicXQ.ProcessName", 1);
            this.m_stepName = environment.getParameter("SonicXQ.ProcessStep", 1);
        }
        this.m_hostName = XQContainer.getLocation();
    }

    public RMEMessage(String rmeData, XQAddress address, XQMessageFactory messageFactory, XQMessage message, XQParameters environment, String rejectedCode) throws XQMessageException {
        super(address, messageFactory, message);
        if (address == null) {
            throw new XQMessageException("Error creating RME message as the RME address is null");
        }
        this.m_rmeMessage = rmeData;
        this.m_environment = environment;
        this.m_rejectedCode = rejectedCode;
        this.extractFromParams(environment);
    }

    public RMEMessage(XQPart rmePart, XQMessage message) throws XQMessageException {
        super(null, null, message);
        this.init(rmePart, message);
    }

    protected final void init(XQPart rmePart, XQMessage message) throws XQMessageException {
        this.m_rmeMsgContents = (String)rmePart.getContent();
        this.m_processName = message.getStringHeader(HEADER_REJECTED_PROCESS);
        this.m_topLevelProcessName = message.getStringHeader(HEADER_REJECTED_TOP_PROCESS);
        this.m_stepName = message.getStringHeader(HEADER_REJECTED_STEP);
        this.m_hostName = message.getStringHeader(HEADER_REJECTED_HOST);
        this.m_containerName = message.getStringHeader(HEADER_REJECTED_CONTAINER);
        this.m_svcAppName = message.getStringHeader(HEADER_REJECTED_SERVICE);
        this.m_rmeMessage = message.getStringHeader(HEADER_REJECTED_DETAILS);
        this.m_rejectedCode = message.getStringHeader(HEADER_REJECTED_CODE);
    }

    @Override
    protected Element buildBody() {
        Text text;
        Element bodyElement = this.m_document.createElementNS("http://www.sonicsw.com/sonicxq", "xq:rejectedMessageInfo");
        Element rejectedCodeElement = this.m_document.createElement(REJECTED_CODE_NAME);
        Text rejectedCode = this.m_document.createTextNode(this.m_rejectedCode);
        rejectedCodeElement.appendChild(rejectedCode);
        bodyElement.appendChild(rejectedCodeElement);
        Element rejectedLocation = this.m_document.createElement(REJECTED_LOCATION_NAME);
        this.buildLocation(rejectedLocation);
        bodyElement.appendChild(rejectedLocation);
        Element rejectedDetails = this.m_document.createElement(REJECTED_DETAILS_NAME);
        if (this.m_throwable != null) {
            text = this.m_document.createTextNode(this.getStackTrace(this.m_throwable));
            rejectedDetails.appendChild(text);
        } else if (this.m_rmeMessage != null) {
            text = this.m_document.createTextNode(this.m_rmeMessage);
            rejectedDetails.appendChild(text);
        }
        bodyElement.appendChild(rejectedDetails);
        if (this.m_globalRejectedCode != null) {
            Element globalRejectedCodeElement = this.m_document.createElement(GLOBAL_REJECTED_CODE_NAME);
            Text globalRejectedCode = this.m_document.createTextNode(this.m_globalRejectedCode);
            globalRejectedCodeElement.appendChild(globalRejectedCode);
            bodyElement.appendChild(globalRejectedCodeElement);
        }
        if (this.m_globalRejectedDetails != null) {
            Element globalRejectedDetailsElement = this.m_document.createElement(GLOBAL_REJECTED_DETAILS);
            Text globalRejectedDetails = this.m_document.createTextNode(this.m_globalRejectedDetails);
            globalRejectedDetailsElement.appendChild(globalRejectedDetails);
            bodyElement.appendChild(globalRejectedDetailsElement);
        }
        return bodyElement;
    }

    private void buildLocation(Element location) {
        location.setAttribute("host", XQContainer.getLocation());
        if (this.m_containerName != null) {
            location.setAttribute("container", this.m_containerName);
        }
        if (this.m_svcAppName != null) {
            location.setAttribute("serviceApplication", this.m_svcAppName);
        }
        if (this.m_topLevelProcessName != null) {
            location.setAttribute("topLevelProcess", this.m_topLevelProcessName);
        }
        if (this.m_processName != null) {
            location.setAttribute("process", this.m_processName);
        }
        if (this.m_stepName != null) {
            location.setAttribute("step", this.m_stepName);
        }
    }

    @Override
    public void send(String sender, XQParameters environment, XQQualityofService qos, IEndpointRegistry er) throws IOException, XQEndpointException, Exception, Throwable {
        this.buildMessage();
        RejectedMessageDispatcher.send(this.m_message, this.m_address, environment, qos, er, this.m_messageFactory, sender, null);
    }

    @Override
    protected String getContentId() {
        return RME_CONTENT_ID;
    }

    public static boolean isRME(XQMessage message) throws XQMessageException {
        NodeList children;
        Element RMEPart = RMEMessage.getSoapPart(message);
        return RMEPart != null && (children = RMEPart.getElementsByTagNameNS("http://www.sonicsw.com/sonicxq", RME_BODY_NAME)) != null && children.getLength() > 0;
    }

    public String getProcessName() {
        return this.m_processName;
    }

    public String getToplevelProcessName() {
        return this.m_topLevelProcessName;
    }

    public String getStepName() {
        return this.m_stepName;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public String getContainerName() {
        return this.m_containerName;
    }

    public String getServiceApplicationName() {
        return this.m_svcAppName;
    }

    public String getRejectedDetails() {
        return this.m_rmeMessage;
    }

    public void setRejectedDetails(String details) {
        this.m_rmeMessage = details;
    }

    public String getRejectedCode() {
        return this.m_rejectedCode;
    }

    public void setRejectedCode(String code) {
        this.m_rejectedCode = code;
    }

    public void addRMEPart(XQMessage message, int partIndex, String contentType, String contentID) throws IOException {
        String rmePartContents = this.m_rmeMsgContents;
        if (rmePartContents == null) {
            StringWriter writer = new StringWriter();
            SOAPUtils.writeSOAPEnvelope((Writer)writer, (BodyBuilder)this);
            rmePartContents = writer.toString();
        }
        try {
            if (this.m_bodyElement == null && this.m_rmeMsgContents == null) {
                throw new IllegalArgumentException("Message body is null!");
            }
            XQPart rmePart = message.createPart((Object)rmePartContents, contentType);
            rmePart.setContentId(contentID);
            message.addPartAt(rmePart, partIndex);
        }
        catch (XQException cte) {
            throw new IllegalArgumentException("Error creating RME message: " + cte.getMessage());
        }
    }

    public void setMessage(XQMessage inputMessage) {
        this.m_message = inputMessage;
    }

    public void serializeHeaders(XQMessage message) {
        try {
            message.setStringHeader(HEADER_REJECTED_PROCESS, this.m_processName);
            message.setStringHeader(HEADER_REJECTED_TOP_PROCESS, this.m_topLevelProcessName);
            message.setStringHeader(HEADER_REJECTED_STEP, this.m_stepName);
            message.setStringHeader(HEADER_REJECTED_HOST, this.m_hostName);
            message.setStringHeader(HEADER_REJECTED_CONTAINER, this.m_containerName);
            message.setStringHeader(HEADER_REJECTED_SERVICE, this.m_svcAppName);
            message.setStringHeader(HEADER_REJECTED_DETAILS, this.m_rmeMessage != null ? this.m_rmeMessage : this.m_throwable.toString());
            message.setStringHeader(HEADER_REJECTED_CODE, this.m_rejectedCode);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public void removeHeaders(XQMessage message) {
        try {
            message.removeHeader(HEADER_REJECTED_PROCESS);
            message.removeHeader(HEADER_REJECTED_TOP_PROCESS);
            message.removeHeader(HEADER_REJECTED_STEP);
            message.removeHeader(HEADER_REJECTED_HOST);
            message.removeHeader(HEADER_REJECTED_CONTAINER);
            message.removeHeader(HEADER_REJECTED_SERVICE);
            message.removeHeader(HEADER_REJECTED_DETAILS);
            message.removeHeader(HEADER_REJECTED_CODE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public XQParameters getParams() {
        return this.m_environment;
    }

    public void setGlobalRMEDetails(String globalRMECode, String globalRMEDetails) {
        this.m_globalRejectedCode = globalRMECode;
        this.m_globalRejectedDetails = globalRMEDetails;
    }

    public void resetContents(XQAddress address) {
        this.m_document = DOMUtils.createDocument();
        this.m_address = address;
    }
}

